/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelTraverserEx
extends DdlPreview.ModelTraverser {
    private static final Condition<DasObject> NORMAL_EXPAND = object -> ((DeObject)object).lightExported;
    private final Condition<DasObject> myModifiedChildExpand;
    private final TableDialogSettings.Settings mySettings;
    private final EditorModelBase myModelBase;
    private final DeModel myModel;

    public ModelTraverserEx(@NotNull TableDialogSettings.Settings settings, @NotNull EditorModelBase modelBase, @NotNull DeModel model, final @Nullable DbDataSource dataSource) {
        if (settings == null) {
            ModelTraverserEx.$$$reportNull$$$0(0);
        }
        if (modelBase == null) {
            ModelTraverserEx.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ModelTraverserEx.$$$reportNull$$$0(2);
        }
        super(modelBase.getModel());
        this.mySettings = settings;
        this.myModelBase = modelBase;
        this.myModel = model;
        this.myModifiedChildExpand = new Condition<DasObject>(){

            public boolean value(DasObject object) {
                Collection<DeObject> ignoreChildren2;
                DeTable table = (DeTable)ObjectUtils.tryCast((Object)object, DeTable.class);
                if (table == null || !(table.editedObject instanceof DeObject)) {
                    return NORMAL_EXPAND.value((Object)object);
                }
                DeTable deEdited = (DeTable)ObjectUtils.tryCast((Object)table.editedObject, DeTable.class);
                Collection<DeObject> ignoreChildren1 = this.getIgnoredChildren(table);
                return !table.isAlteredIgnoringChild((DeObject)table.editedObject, ignoreChildren1, ignoreChildren2 = this.getIgnoredChildren(deEdited));
            }

            @NotNull
            private Collection<DeObject> getIgnoredChildren(@Nullable DeTable deEdited) {
                Set set = deEdited != null ? JBIterable.from(deEdited.indices).append(deEdited.foreignKeys).append((Iterable)deEdited.keys).filter(this::filterInternalDeclarations).toSet() : Collections.emptySet();
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private boolean filterInternalDeclarations(DeObject object) {
                SqlElement child = DbRenamePsiElementProcessor.getSqlElement(object, dataSource);
                SqlElement parent = DbRenamePsiElementProcessor.getSqlElement(object.getParent(), dataSource);
                return child == null || parent == null || !PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)child, (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ModelTraverserEx$1", "getIgnoredChildren"));
            }
        };
    }

    @Override
    @NotNull
    public JBIterable<SchemaEditorHelper.ObjectAction> traverse() {
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)this.model.traverser().withRoots(this.getRoots())).expandAndSkip(this.getExpansionMethod())).filter(DeObject.class).intercept(this.getActionGenerator());
        if (jBIterable == null) {
            ModelTraverserEx.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    private Function<Iterator<DeObject>, Iterator<SchemaEditorHelper.ObjectAction>> getActionGenerator() {
        Function function = iterator -> JBIterable.once((Iterator)iterator).flatten((Function)new GenericEditingResultProcessor.AppendDroppedSiblings(this.mySettings)).iterator();
        if (function == null) {
            ModelTraverserEx.$$$reportNull$$$0(4);
        }
        return function;
    }

    @NotNull
    private JBIterable<? extends DeObject> getRoots() {
        JBIterable jBIterable = this.mySettings.codeType == TableDialogSettings.Settings.CodeType.ALTER_CODE ? this.myModel.getModelRoots().filter(DeObject.class) : this.myModelBase.getEditedObjects();
        if (jBIterable == null) {
            ModelTraverserEx.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    private Condition<DasObject> getExpansionMethod() {
        boolean isReplace = this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL;
        boolean isAppend = this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.APPEND_DDL;
        boolean isCreateNewCode = this.mySettings.codeType == TableDialogSettings.Settings.CodeType.CREATE_NEW_CODE;
        Condition<DasObject> condition = isReplace || isAppend && isCreateNewCode ? this.myModifiedChildExpand : NORMAL_EXPAND;
        if (condition == null) {
            ModelTraverserEx.$$$reportNull$$$0(6);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ModelTraverserEx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ModelTraverserEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpansionMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

