/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.util.ClassInheritorsScanner;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DriverClasspathPanel;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.database.view.ui.StringRowTableModel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverGeneralPanel {
    private JComponent myTemplatesComponent;
    private JComponent myTxModeBar;
    private JCheckBox myAutoSyncCheckBox;
    private JPanel myClasspathComponent;
    private JPanel myPanel;
    private JBScrollPane myScrollPane;
    private JComboBox myClassName;
    private JComboBox myDialect;
    private JCheckBox mySendAppInfo;
    private ComboBox<DatabaseDriver.SchemaControl> mySwitchControlBox;
    private TemplatesTable myTemplatesTable;
    private final DatabaseDriverConfigurable myConfigurable;
    private final DatabaseDriver myTempDriver;
    private DriverClasspathPanel myClasspathPanel;
    private final ClassInheritorsScanner myScanner;
    private final DescriptionPopup.TxPopup.TxSelector mySelector;

    public DatabaseDriverGeneralPanel(@NotNull DatabaseDriverConfigurable configurable, @NotNull DatabaseDriver tempDriver) {
        if (configurable == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(0);
        }
        if (tempDriver == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(1);
        }
        this.myConfigurable = configurable;
        this.myTempDriver = tempDriver;
        this.mySelector = new DescriptionPopup.TxPopup.TxSelectorImpl();
        this.myScanner = new ClassInheritorsScanner(this.myConfigurable.getProject(), Driver.class);
        Disposer.register((Disposable)this.myConfigurable, (Disposable)this.myScanner);
        this.$$$setupUI$$$();
        ((JComponent)this.myScrollPane.getViewport().getView()).setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myScrollPane.setBorder(null);
        this.myTemplatesComponent.add((Component)this.createUrlTemplatesPanel(), "Center");
        this.myTemplatesComponent.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        this.myClasspathComponent.add((Component)this.myClasspathPanel.createComponent(), "Center");
        this.mySwitchControlBox.setModel((ComboBoxModel)new EnumComboBoxModel(DatabaseDriver.SchemaControl.class));
        this.mySwitchControlBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DatabaseDriver.SchemaControl>(){

            public void customize(JList list, DatabaseDriver.SchemaControl value, int index, boolean selected, boolean hasFocus) {
                this.setText(StringUtil.capitalize((String)StringUtil.toLowerCase((String)((DatabaseDriver.SchemaControl)((Object)ObjectUtils.chooseNotNull((Object)((Object)value), (Object)((Object)DatabaseDriver.SchemaControl.AUTOMATIC)))).name())));
            }
        });
        this.setUrlTemplates((DatabaseDriverImpl)this.myTempDriver);
    }

    private JComponent createUrlTemplatesPanel() {
        this.myTemplatesTable = new TemplatesTable(new StringRowTableModel(new String[]{"Name", "Template"}, true));
        this.myTemplatesTable.setPreferredScrollableViewportSize(new Dimension(this.myTemplatesTable.getPreferredScrollableViewportSize().width, this.myTemplatesTable.getRowHeight() * 6));
        return ToolbarDecorator.createDecorator((JTable)((Object)this.myTemplatesTable)).createPanel();
    }

    private void createUIComponents() {
        this.myClassName = new ComboBox();
        this.myDialect = new ComboBox();
        this.myDialect.setEditable(false);
        this.myTxModeBar = TransactionAction.StandaloneTxModeAction.createToolbar(this.mySelector).getComponent();
        DbImplUtil.initLanguageComboBox(this.myDialect, true);
        this.myClassName.setEditable(false);
        this.myClasspathPanel = new DriverClasspathPanel(this.myConfigurable.getProject(), (Configurable)this.myConfigurable, this.myTempDriver, null, this.myConfigurable.getController());
        Disposer.register((Disposable)this.myConfigurable, (Disposable)this.myClasspathPanel);
        this.myClasspathPanel.setOnUpdate(() -> {
            Set names = ContainerUtil.newConcurrentSet();
            this.myScanner.scanClasses(SimpleClasspathElementFactory.convertToFiles(this.myClasspathPanel.getClasspathFull()), (Consumer<String>)((Consumer)names::add)).doWhenProcessed(() -> ApplicationManager.getApplication().invokeLater(() -> {
                String cls = this.myTempDriver.getDriverClass();
                this.myClassName.setModel(DatabaseDriverGeneralPanel.createModel(names, cls));
            }));
        });
        this.myClassName.setModel(DatabaseDriverGeneralPanel.createModel(Collections.emptyList(), this.myTempDriver.getDriverClass()));
    }

    public void focusDriverClassSelector() {
        UIUtil.requestFocus((JComponent)this.myClassName);
    }

    @NotNull
    private static CollectionComboBoxModel<String> createModel(@NotNull Collection<String> items, @Nullable String item) {
        if (items == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(2);
        }
        ArrayList res = ContainerUtil.newArrayList(items);
        if (!items.contains(item)) {
            res.add(item);
        }
        ContainerUtil.sort((List)res);
        CollectionComboBoxModel collectionComboBoxModel = new CollectionComboBoxModel((List)res, (Object)item);
        if (collectionComboBoxModel == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(3);
        }
        return collectionComboBoxModel;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    public String getDriverClass() {
        String string = String.valueOf(this.myClassName.getSelectedItem());
        if (string == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private List<String> currentClasses() {
        ArrayList res = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < this.myClassName.getItemCount(); ++i2) {
            res.add(String.valueOf(this.myClassName.getItemAt(i2)));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public void reset(DatabaseDriverImpl driver) {
        this.myClassName.setModel(DatabaseDriverGeneralPanel.createModel(this.currentClasses(), driver.getDriverClass()));
        this.setUrlTemplates(driver);
        String driverDialect = driver.getSqlDialect();
        this.myDialect.setSelectedItem(Language.findLanguageByID((String)driverDialect));
        this.mySelector.toggle(null, driver.getOption(DatabaseDriver.OPTION_AUTO_COMMIT));
        this.myAutoSyncCheckBox.setSelected(driver.getOption(DatabaseDriver.OPTION_AUTO_SYNC));
        this.mySwitchControlBox.setSelectedItem((Object)driver.getOption(DatabaseDriver.OPTION_SCHEMA_CONTROL));
        this.mySendAppInfo.setSelected(driver.getOption(DatabaseDriver.OPTION_SEND_APP_INFO));
        ((DatabaseDriverImpl)this.myTempDriver).loadState(driver.getState(null), false, false, Integer.MAX_VALUE);
        this.myClasspathPanel.setDriver(driver);
    }

    private void setUrlTemplates(DatabaseDriverImpl driver) {
        ArrayList templates = ContainerUtil.newArrayList();
        for (UrlTemplate t : driver.getUrlTemplates()) {
            templates.add(new String[]{t.getName(), t.getTemplate()});
        }
        this.myTemplatesTable.getModel().setRows(templates);
    }

    public void saveDriver(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(7);
        }
        driver.setDriverClass(this.getDriverClass());
        ArrayList<UrlTemplate> templates = new ArrayList<UrlTemplate>(this.myTemplatesTable.getModel().getRowCount());
        for (String[] r : this.myTemplatesTable.getModel().getRows()) {
            if (StringUtil.isEmpty((String)r[0])) continue;
            templates.add(new UrlTemplate(r[0], r[1]));
        }
        driver.setURLTemplates(templates);
        Object dialect = this.myDialect.getSelectedItem();
        driver.setSqlDialect(dialect instanceof Language ? ((Language)dialect).getID() : null);
        driver.setOption(DatabaseDriver.OPTION_AUTO_COMMIT, this.mySelector.isAuto());
        driver.setOption(DatabaseDriver.OPTION_AUTO_SYNC, this.myAutoSyncCheckBox.isSelected());
        driver.setOption(DatabaseDriver.OPTION_SEND_APP_INFO, this.mySendAppInfo.isSelected());
        driver.setOption(DatabaseDriver.OPTION_SCHEMA_CONTROL, (DatabaseDriver.SchemaControl)((Object)this.mySwitchControlBox.getSelectedItem()));
        driver.setAdditionalClasspathElements(this.myClasspathPanel.getClasspath());
        driver.setArtifact(this.myClasspathPanel.getArtifactName(), this.myClasspathPanel.getArtifactVersion(), this.myClasspathPanel.isRolling());
        driver.setUseArtifact(this.myClasspathPanel.isUseArtifact());
    }

    public void addNewUrlTemplate(@NotNull String template) {
        if (template == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(8);
        }
        this.myTemplatesTable.getModel().addNewRow(new String[]{"new", template});
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTemplatesTable), true));
        IdeFocusManager.findInstanceByComponent((Component)((Object)this.myTemplatesTable)).doWhenFocusSettlesDown(() -> this.myTemplatesTable.editCellAt(this.myTemplatesTable.getModel().getRowCount() - 1, this.myTemplatesTable.getModel().getColumnCount() - 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDriver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "currentClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveDriver";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addNewUrlTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JBScrollPane jBScrollPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel2.add((Component)jBScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        JLabel jLabel = new JLabel();
        jLabel.setText("Class:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.myClassName;
        jPanel3.add((Component)jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Dialect:");
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = this.myDialect;
        jPanel3.add((Component)jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("URL templates");
        jPanel4.add((Component)titledSeparator, "North");
        JPanel jPanel5 = new JPanel();
        this.myTemplatesComponent = jPanel5;
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, "Center");
        this.myClasspathComponent = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 5, 0));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 0, null, null, null));
        JComponent jComponent = this.myTxModeBar;
        Component component = jPanel7.add(jComponent);
        this.myAutoSyncCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Auto sync");
        Component component2 = jPanel7.add(jCheckBox2);
        this.mySendAppInfo = jCheckBox = new JCheckBox();
        jCheckBox.setText("Send application info");
        Component component3 = jPanel7.add(jCheckBox);
        this.mySwitchControlBox = comboBox = new ComboBox();
        jPanel6.add((Component)comboBox, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Schema control:");
        jPanel6.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class MyTableCellEditor
    extends AbstractTableCellEditor {
        private final FieldPanel myEditor = new FieldPanel(null, "Edit template", null, null);

        private MyTableCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column2) {
            this.myEditor.setText(StringUtil.notNullize((String)String.valueOf(value)));
            this.myEditor.getTextField().setBorder(new LineBorder((Color)JBColor.BLACK));
            this.myEditor.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    myEditor.getTextField().requestFocusInWindow();
                }
            });
            return this.myEditor;
        }

        public Object getCellEditorValue() {
            return this.myEditor.getText();
        }
    }

    private static class TemplatesTable
    extends JBTable {
        public TemplatesTable(@NotNull StringRowTableModel model) {
            if (model == null) {
                TemplatesTable.$$$reportNull$$$0(0);
            }
            super((TableModel)model);
            this.setRowHeight(new MyTableCellEditor().getTableCellEditorComponent((JTable)((Object)this), (Object)"", (boolean)true, (int)1, (int)1).getMinimumSize().height + this.getRowMargin());
            this.getColumnModel().getColumn(0).setMinWidth(100);
            this.getColumnModel().getColumn(1).setPreferredWidth(10000);
            this.setAutoResizeMode(3);
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            this.getInputMap(1).put(enter, "stopEditing");
            this.getActionMap().put("stopEditing", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableUtil.stopEditing((JTable)((Object)this));
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && this.rowAtPoint(e.getPoint()) == -1) {
                        TableUtil.stopEditing((JTable)((Object)this));
                        this.getModel().addRow();
                        int index = this.getModel().getRowCount() - 1;
                        this.setRowSelectionInterval(index, index);
                        this.setColumnSelectionInterval(0, 0);
                        this.editCellAt(index, 0);
                    }
                }
            });
            this.getEmptyText().setText("No URL templates");
        }

        @NotNull
        public StringRowTableModel getModel() {
            StringRowTableModel stringRowTableModel = (StringRowTableModel)super.getModel();
            if (stringRowTableModel == null) {
                TemplatesTable.$$$reportNull$$$0(1);
            }
            return stringRowTableModel;
        }

        public TableCellEditor getCellEditor(int row, int column2) {
            return column2 == 0 ? super.getCellEditor(row, column2) : new MyTableCellEditor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$TemplatesTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$TemplatesTable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

