/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ModelTraverserEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.TextRanges;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericEditingResultProcessor
implements AbstractDbRefactoringDialog.ResultProcessor {
    private final ResultProcessorProvider myProvider;
    protected final TableDialogSettings.Settings mySettings;
    private final RangeMarker myInsertPos;
    private final TableDialogSettings myGenSettings;

    public GenericEditingResultProcessor(@NotNull ResultProcessorProvider provider, @NotNull TableDialogSettings.Settings settings, @Nullable RangeMarker insertPos) {
        if (provider == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(1);
        }
        this.mySettings = new TableDialogSettings.Settings(settings);
        this.mySettings.renameInStorage = DbRenamePsiElementProcessor.getSearchReferencesInStorage(provider.getProject());
        this.myProvider = provider;
        this.myInsertPos = insertPos;
        this.myGenSettings = new TableDialogSettings((Consumer<TableDialogSettings.Settings>)((Consumer)settings1 -> {
            if (provider == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(47);
            }
            DbRenamePsiElementProcessor.setSearchReferencesInStorage(provider.getProject(), settings1.renameInStorage);
            this.mySettings.assign((TableDialogSettings.Settings)settings1);
            this.myProvider.settingsChanged();
        }), this.mySettings);
    }

    @NotNull
    private DbDataSource getDataSource() {
        DbDataSource dbDataSource = (DbDataSource)ObjectUtils.assertNotNull((Object)this.myProvider.getContext().getDataSource());
        if (dbDataSource == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(2);
        }
        return dbDataSource;
    }

    @NotNull
    private Project getProject() {
        Project project = (Project)ObjectUtils.assertNotNull((Object)this.myProvider.getContext().getProject());
        if (project == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(3);
        }
        return project;
    }

    private static void fillContext(@NotNull DeModel model, @NotNull LoaderContext context, @Nullable DbDataSource dataSource) {
        JBIterable modifiedRoots;
        if (model == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(5);
        }
        if ((modifiedRoots = ((JBTreeTraverser)model.traverser().expandAndSkip(object -> {
            if (model == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(46);
            }
            boolean isUpdateRoot = false;
            for (DeObject child : DasUtil.getTraversableChildren((DasObject)object, (DasModel)model).filter(DeObject.class)) {
                if (child.editedObject != null) continue;
                isUpdateRoot = true;
                break;
            }
            if (!isUpdateRoot) {
                DeObject obj = (DeObject)ObjectUtils.tryCast((Object)object, DeObject.class);
                isUpdateRoot = obj != null && !obj.lightExported && obj.editedObject instanceof DeObject && obj.isAltered((DeObject)obj.editedObject);
            }
            SqlElement element = DbRenamePsiElementProcessor.getSqlElement(object, dataSource);
            return !isUpdateRoot || element != null;
        })).bfsTraversal()).isEmpty()) {
            context.includeAllSchemas();
        } else {
            for (DasObject root2 : modifiedRoots) {
                context.include(root2);
            }
        }
        GenericEditingResultProcessor.scheduleIntrospectionScopeUpdate(model, context);
    }

    private static void scheduleIntrospectionScopeUpdate(@NotNull DeModel model, @NotNull LoaderContext context) {
        JBIterable namespaces;
        if (model == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(7);
        }
        if (!(namespaces = ((JBTreeTraverser)model.traverser().expand(n -> n.getKind() == ObjectKind.DATABASE)).filter(DeNamespace.class).filter(n -> n.editedObject == null)).isEmpty()) {
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(context.getDataSource());
            for (DeNamespace namespace : namespaces) {
                ObjectKind kind = namespace.getKind();
                if (kind == ObjectKind.DATABASE) {
                    context.getScopeUpdater().toAdd(GenericEditingResultProcessor.create(dialect, namespace), null);
                    continue;
                }
                if (kind != ObjectKind.SCHEMA) continue;
                ObjectName schema = GenericEditingResultProcessor.create(dialect, namespace);
                DeObject database = namespace.getParent();
                if (database != null && database.getKind() != ObjectKind.DATABASE) {
                    database = null;
                }
                context.getScopeUpdater().toAdd(GenericEditingResultProcessor.create(dialect, database), schema);
            }
        }
    }

    @Nullable
    private static ObjectName create(@NotNull DatabaseDialect dialect, @Nullable DasObject obj) {
        if (dialect == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(8);
        }
        if (obj == null) {
            return null;
        }
        String name = obj.getName();
        boolean quoted = dialect.isQuotedIdentifier(name);
        name = dialect.unquoteIdentifier(name);
        return new ObjectName(name, quoted);
    }

    @Override
    @Nullable
    public JComponent getPreviewWidget() {
        return null;
    }

    @Override
    public boolean process() {
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.EXEC_IN_DB) {
            return this.processDb();
        }
        return this.processSql();
    }

    private boolean processSql() {
        List<RangeMarker> ranges = this.getRanges();
        if (ranges.isEmpty()) {
            return false;
        }
        JBIterable<Pair<PsiElement, String>> renames = this.myProvider.collectRenames();
        if (!renames.isEmpty()) {
            this.processWithRenames(renames, ranges);
        } else {
            this.processWithoutRenames(ranges);
        }
        return true;
    }

    private void processWithRenames(@NotNull JBIterable<Pair<PsiElement, String>> renames, final @NotNull List<RangeMarker> ranges) {
        if (renames == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(9);
        }
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(10);
        }
        Pair pair = (Pair)ObjectUtils.assertNotNull((Object)renames.first());
        renames = renames.skip(1);
        RenameProcessor processor = new RenameProcessor(this.myProvider.getContext().getProject(), (PsiElement)pair.first, (String)pair.second, true, true){

            protected void execute(@NotNull UsageInfo[] usages) {
                if (usages == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.execute(usages);
                WriteCommandAction.runWriteCommandAction((Project)GenericEditingResultProcessor.this.getProject(), () -> {
                    if (ranges == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    GenericEditingResultProcessor.this.insertStatement(ranges);
                });
                GenericEditingResultProcessor.this.open(ranges);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usages";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ranges";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/view/ui/GenericEditingResultProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$execute$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (Pair rename : renames) {
            processor.addElement((PsiElement)rename.first, (String)rename.second);
        }
        processor.setPreviewUsages(this.myProvider.isPreviewUsages());
        processor.setPrepareSuccessfulSwingThreadCallback(this.myProvider::success);
        processor.run();
    }

    private void processWithoutRenames(@NotNull List<RangeMarker> ranges) {
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(11);
        }
        if (!this.insertStatement(ranges)) {
            return;
        }
        this.open(ranges);
        this.myProvider.success();
    }

    private void open(@NotNull List<RangeMarker> ranges) {
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(12);
        }
        Project project = this.myProvider.getContext().getProject();
        VirtualFile file = FileDocumentManager.getInstance().getFile(ranges.get(0).getDocument());
        if (project != null && file != null) {
            FileEditorManager.getInstance((Project)project).openFile(file, true, true);
        }
    }

    private boolean insertStatement(@NotNull List<RangeMarker> ranges) {
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(13);
        }
        if (ranges.isEmpty()) {
            return false;
        }
        HashSet visited = ContainerUtil.newHashSet();
        for (RangeMarker marker : ranges) {
            if (visited.add(marker.getDocument())) {
                PsiDocumentManager.getInstance((Project)((Project)ObjectUtils.assertNotNull((Object)this.myProvider.getContext().getProject()))).doPostponedOperationsAndUnblockDocument(marker.getDocument());
            }
            if (marker.isValid()) continue;
            return false;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProvider.getContext().getProject(), () -> {
            if (ranges == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(45);
            }
            String statement = this.myProvider.statement();
            statement = StringUtil.trimEnd((String)statement, (String)";");
            RangeMarker main = (RangeMarker)ranges.get(0);
            boolean insertBreak = false;
            if (ranges.size() == 1 && main.getEndOffset() == main.getEndOffset()) {
                int lineStart = main.getDocument().getLineStartOffset(main.getDocument().getLineNumber(main.getStartOffset()));
                insertBreak = !main.getDocument().getText(TextRange.create((int)lineStart, (int)main.getStartOffset())).matches("\\s*");
            }
            main.getDocument().replaceString(main.getStartOffset(), main.getEndOffset(), (CharSequence)((insertBreak ? "\n" : "") + statement));
            for (RangeMarker marker : ranges.subList(1, ranges.size())) {
                marker.getDocument().replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)"");
            }
        });
        return true;
    }

    @NotNull
    public List<RangeMarker> getRanges() {
        RangeMarker corrected;
        List<RangeMarker> ranges;
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL && !(ranges = this.getModifiedElementsRanges()).isEmpty()) {
            List<RangeMarker> list = ranges;
            if (list == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (this.myInsertPos != null && this.myInsertPos.isValid() && this.myInsertPos.getDocument().isWritable() && (corrected = this.correctOffset(this.myInsertPos)) != null) {
            List<RangeMarker> list = Collections.singletonList(corrected);
            if (list == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(15);
            }
            return list;
        }
        RangeMarker afterParentRange = this.getAfterParentRange();
        if (afterParentRange != null) {
            List<RangeMarker> list = Collections.singletonList(afterParentRange);
            if (list == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(16);
            }
            return list;
        }
        RangeMarker endOfFile = this.getEndOfFile();
        List<Object> list = endOfFile != null ? Collections.singletonList(endOfFile) : Collections.emptyList();
        if (list == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private List<RangeMarker> getModifiedElementsRanges() {
        EditorModelBase editorModel = this.myProvider.getEditor().getModel();
        Map<PsiFile, TextRanges> rangesPerFile = this.collectRanges((JBIterable<? extends DasObject>)this.createTraverser(editorModel).traverse().transform(action -> action.object), editorModel.getModel());
        Project project = this.myProvider.getContext().getProject();
        if (project == null || rangesPerFile.isEmpty()) {
            List<RangeMarker> list = Collections.emptyList();
            if (list == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(18);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Map.Entry<PsiFile, TextRanges> entry : rangesPerFile.entrySet()) {
            this.patch(entry.getKey(), entry.getValue());
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(entry.getKey());
            if (document == null || !document.isWritable() || entry.getValue().isEmpty()) continue;
            for (TextRange range : entry.getValue()) {
                result2.add(document.createRangeMarker(range));
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Nullable
    private RangeMarker getAfterParentRange() {
        EditorModelBase editorModel = this.myProvider.getEditor().getModel();
        Project project = this.myProvider.getContext().getProject();
        if (project == null) {
            return null;
        }
        Map<PsiFile, TextRanges> rangesPerFile = this.collectRanges(editorModel.getModel().getModelRoots(), editorModel.getModel());
        for (Map.Entry<PsiFile, TextRanges> entry : rangesPerFile.entrySet()) {
            this.patch(entry.getKey(), entry.getValue());
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(entry.getKey());
            if (document == null || !document.isWritable() || entry.getValue().isEmpty()) continue;
            TextRange range = (TextRange)entry.getValue().iterator().next();
            int offset = range.getEndOffset();
            return document.createRangeMarker(offset, offset);
        }
        return null;
    }

    private Map<PsiFile, TextRanges> collectRanges(@NotNull JBIterable<? extends DasObject> modifiedObjects, @NotNull DasModel model) {
        if (modifiedObjects == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(20);
        }
        if (model == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(21);
        }
        LinkedHashMap rangesPerFile = ContainerUtil.newLinkedHashMap();
        for (DasObject modifiedObject : modifiedObjects) {
            for (DasObject object : (JBTreeTraverser)model.traverser().withRoot((Object)modifiedObject)) {
                SqlElement element = DbRenamePsiElementProcessor.getSqlElement(object, this.myProvider.getContext().getDataSource());
                PsiFile file = element == null ? null : element.getContainingFile();
                if (file == null) continue;
                TextRanges ranges = (TextRanges)rangesPerFile.get(file);
                if (ranges == null) {
                    ranges = new TextRanges();
                    rangesPerFile.put(file, ranges);
                }
                ranges.union(element.getTextRange());
            }
        }
        return rangesPerFile;
    }

    @Nullable
    private RangeMarker getEndOfFile() {
        VirtualFile file = this.myProvider.getContext().getOrCreateVirtualFile();
        if (file == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        int length = document.getTextLength();
        return document.createRangeMarker(length, length);
    }

    @Nullable
    private RangeMarker correctOffset(@NotNull RangeMarker pos) {
        ParserDefinition definition;
        Project project;
        PsiFile file;
        if (pos == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(22);
        }
        if ((file = PsiDocumentManager.getInstance((Project)(project = (Project)ObjectUtils.assertNotNull((Object)this.myProvider.getContext().getProject()))).getPsiFile(pos.getDocument())) == null) {
            return null;
        }
        PsiElement element = file.findElementAt(pos.getStartOffset());
        if (element == null) {
            return null;
        }
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class)) == null) {
            return null;
        }
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(element);
        ParserDefinition parserDefinition = definition = dialect == null ? null : (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)dialect);
        if (definition != null) {
            PsiElement next;
            TokenSet skip = TokenSet.orSet((TokenSet[])new TokenSet[]{dialect.getStatementSeparators(), definition.getCommentTokens(), definition.getWhitespaceTokens()});
            while ((next = PsiTreeUtil.nextVisibleLeaf((PsiElement)element)) != null && skip.contains(GenericEditingResultProcessor.getNodeType(next))) {
                element = next;
            }
        }
        int offset = element.getTextRange().getEndOffset();
        return pos.getDocument().createRangeMarker(offset, offset);
    }

    @Nullable
    private static IElementType getNodeType(@Nullable PsiElement el) {
        return el == null || el.getNode() == null ? null : el.getNode().getElementType();
    }

    private void patch(@NotNull PsiFile file, @NotNull TextRanges ranges) {
        TextRange lastPatch;
        if (file == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(23);
        }
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(24);
        }
        TokenSet separators = this.myProvider.getContext().getSqlDialect().getStatementSeparators();
        ArrayList patches = ContainerUtil.newArrayList();
        for (TextRange range : JBIterable.once((Iterator)ranges.gapIterator())) {
            if (GenericEditingResultProcessor.shouldPlumb(file, range, separators)) {
                patches.add(range);
                continue;
            }
            TextRange expanded = GenericEditingResultProcessor.expand(file, range, separators);
            if (expanded == null) continue;
            patches.add(expanded);
        }
        patches.forEach(arg_0 -> ((TextRanges)ranges).union(arg_0));
        TextRange last = (TextRange)JBIterable.once((Iterator)ranges.revIterator()).first();
        if (last != null && (lastPatch = GenericEditingResultProcessor.expand(file, TextRange.create((int)last.getEndOffset(), (int)file.getTextLength()), separators)) != null) {
            ranges.union(lastPatch);
        }
    }

    private static boolean shouldPlumb(@NotNull PsiFile file, @NotNull TextRange range, @NotNull TokenSet seps) {
        if (file == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(25);
        }
        if (range == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(26);
        }
        if (seps == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(27);
        }
        PsiElement element = file.findElementAt(range.getStartOffset());
        while (element != null && element.getTextOffset() < range.getEndOffset()) {
            IElementType type;
            IElementType iElementType = type = element.getNode() == null ? null : element.getNode().getElementType();
            if (!seps.contains(type) && !StringUtil.isEmptyOrSpaces((String)element.getText())) {
                return false;
            }
            element = PsiTreeUtil.nextVisibleLeaf((PsiElement)element);
        }
        return true;
    }

    @Nullable
    private static TextRange expand(@NotNull PsiFile file, @NotNull TextRange range, @NotNull TokenSet seps) {
        if (file == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(28);
        }
        if (range == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(29);
        }
        if (seps == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(30);
        }
        PsiElement element = file.findElementAt(range.getStartOffset());
        int expanded = range.getStartOffset();
        while (element != null && element.getTextOffset() < range.getEndOffset()) {
            IElementType type;
            IElementType iElementType = type = element.getNode() == null ? null : element.getNode().getElementType();
            if (!seps.contains(type) && (!StringUtil.isEmptyOrSpaces((String)element.getText()) || element.getText().contains("\n"))) break;
            expanded = element.getTextRange().getEndOffset();
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        if (expanded == range.getStartOffset()) {
            return null;
        }
        return TextRange.create((int)range.getStartOffset(), (int)expanded);
    }

    private boolean processDb() {
        DatabaseEditorContext context = this.myProvider.getContext();
        if (!DbImplUtil.canConnectToAndModify((DbElement)context.getDataSource())) {
            return false;
        }
        DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(this.getDataSource(), context.getSearchPath()).setStatement(this.myProvider.statement());
        GenericEditingResultProcessor.fillContext(this.myProvider.getModel(), handler.getContext(), this.myProvider.getContext().getDataSource());
        DasObject edited = (DasObject)this.myProvider.getEditor().getModel().getEditedObjects().first();
        handler.getContext().setElementToFocus(edited);
        JBIterable<Pair<PsiElement, String>> renames = this.myProvider.collectRenames();
        if (!renames.isEmpty()) {
            this.processWithRenames(renames, handler);
        } else {
            this.processWithoutRenames(handler);
        }
        return true;
    }

    @Override
    @NotNull
    public DdlPreview.ModelTraverser createTraverser(@NotNull EditorModelBase model) {
        if (model == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(31);
        }
        ModelTraverserEx modelTraverserEx = new ModelTraverserEx(this.mySettings, model, this.myProvider.getModel(), this.myProvider.getContext().getDataSource());
        if (modelTraverserEx == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(32);
        }
        return modelTraverserEx;
    }

    @Override
    @Nullable
    public JComponent getSettingsPanel() {
        return this.myGenSettings.getComponent();
    }

    @Override
    public String getCurrentAction() {
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.APPEND_DDL) {
            return "To Editor";
        }
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL) {
            return "Replace";
        }
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.EXEC_IN_DB) {
            return "Execute";
        }
        return null;
    }

    @Override
    public void update() {
        JBIterable<? extends DeObject> editedObjects = this.myProvider.getEditor().getModel().getEditedObjects();
        JBIterable allObjects = ((JBTreeTraverser)this.myProvider.getModel().traverser().withRoots(editedObjects)).traverse();
        boolean hasNonSql = !editedObjects.filter(o -> !this.isSql((DasObject)o)).isEmpty();
        boolean hasSql = !allObjects.filter(o -> this.isSql((DasObject)o)).isEmpty();
        JBIterable<Pair<PsiElement, String>> renames = this.myProvider.collectRenames();
        this.myGenSettings.setAvailability(this.myProvider.getContext().getDataSource() != null && (hasNonSql || GenericEditingResultProcessor.newObjects(editedObjects)), hasSql, !renames.isEmpty());
    }

    @Override
    public ValidationInfo validate() {
        JBIterable modified;
        boolean allSql;
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL && !(allSql = (modified = this.createTraverser(this.myProvider.getEditor().getModel()).traverse().transform(action -> action.object)).filter(o -> !this.isSql((DasObject)o)).isEmpty())) {
            return new ValidationInfo("Unable to replace DDL for some objects (they are in DB)");
        }
        return null;
    }

    private boolean isSql(@NotNull DasObject object) {
        if (object == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(33);
        }
        return DbRenamePsiElementProcessor.getSqlElement(object, this.myProvider.getContext().getDataSource()) != null;
    }

    private static boolean newObjects(JBIterable<? extends DasObject> objects) {
        return objects.filter(o -> o instanceof DeObject && ((DeObject)o).editedObject != null).isEmpty();
    }

    protected void processWithRenames(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler) {
        if (renames == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(34);
        }
        if (handler == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(35);
        }
        RenameProcessor processor = this.createRenameProcessor(renames, handler);
        processor.setPrepareSuccessfulSwingThreadCallback(this.myProvider::success);
        processor.setPreviewUsages(this.myProvider.isPreviewUsages());
        processor.run();
    }

    @NotNull
    protected RenameProcessor createRenameProcessor(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler) {
        Pair r;
        if (renames == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(36);
        }
        if (handler == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(37);
        }
        if ((r = (Pair)renames.first()) == null) {
            throw new AssertionError((Object)"No renames");
        }
        DbRenamePsiElementProcessor.MyRenameProcessor myRenameProcessor = new DbRenamePsiElementProcessor.MyRenameProcessor(this.getProject(), (PsiElement)r.first, handler, (String)r.second, (Iterable<Pair<PsiElement, String>>)renames.skip(1), this.mySettings.renameInCommentsAndLiterals, this.mySettings.renameTextOccurrences);
        if (myRenameProcessor == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(38);
        }
        return myRenameProcessor;
    }

    @NotNull
    protected CompletionStage<Void> processWithoutRenames(@NotNull DatabaseRefactoringHandler handler) {
        if (handler == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(39);
        }
        CompletionStage<Void> completionStage = handler.runStatements(true).handleAsync((r, e) -> {
            if (handler == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(44);
            }
            if (e != null) {
                AsyncUtil.addUnhandledError(handler.getErrorHandler(), e, handler.getDataSource().getName(), DbImplUtil.getDatabaseDialect((DbElement)handler.getDataSource()).getFamilyId());
                this.myProvider.error(handler.getErrorHandler().getSummary("Cancelled"));
                throw new ProcessCanceledException();
            }
            this.myProvider.success();
            return null;
        }, AsyncUtil.EDT_EXECUTOR);
        if (completionStage == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(40);
        }
        return completionStage;
    }

    public static boolean isModified(@NotNull DeObject object) {
        if (object == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(41);
        }
        return !(object.editedObject instanceof DeObject) || object.isAltered((DeObject)object.editedObject);
    }

    @NotNull
    public static SchemaEditorHelper.ObjectAction assignAction(@NotNull DeObject object) {
        if (object == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(42);
        }
        SchemaEditorHelper.ObjectAction objectAction = new SchemaEditorHelper.ObjectAction(object.editedObject == null ? SchemaEditorHelper.ObjectAction.Action.CREATE : SchemaEditorHelper.ObjectAction.Action.ALTER, object);
        if (objectAction == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(43);
        }
        return objectAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 32: 
            case 38: 
            case 40: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 32: 
            case 38: 
            case 40: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 32: 
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/GenericEditingResultProcessor";
                break;
            }
            case 4: 
            case 6: 
            case 21: 
            case 31: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 9: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renames";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedObjects";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seps";
                break;
            }
            case 33: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 35: 
            case 37: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/GenericEditingResultProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedElementsRanges";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTraverser";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameProcessor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "processWithoutRenames";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "assignAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 32: 
            case 38: 
            case 40: 
            case 43: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIntrospectionScopeUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 10: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processWithRenames";
                break;
            }
            case 11: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processWithoutRenames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertStatement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectRanges";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "correctOffset";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "patch";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldPlumb";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTraverser";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSql";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createRenameProcessor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "assignAction";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processWithoutRenames$11";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$insertStatement$4";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillContext$1";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 32: 
            case 38: 
            case 40: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AppendDroppedSiblings
    implements Function<DeObject, Iterable<SchemaEditorHelper.ObjectAction>> {
        private final Set<DeObject> myProcessedParents;
        private final TableDialogSettings.Settings mySettings;

        public AppendDroppedSiblings(@NotNull TableDialogSettings.Settings settings) {
            if (settings == null) {
                AppendDroppedSiblings.$$$reportNull$$$0(0);
            }
            this.myProcessedParents = ContainerUtil.newHashSet();
            this.mySettings = settings;
        }

        public Iterable<SchemaEditorHelper.ObjectAction> fun(DeObject object) {
            JBIterable res = this.processParent(object.getParent());
            if (GenericEditingResultProcessor.isModified(object) || this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.APPEND_DDL && this.mySettings.codeType == TableDialogSettings.Settings.CodeType.CREATE_ALL_CODE) {
                res = this.mySettings.codeType == TableDialogSettings.Settings.CodeType.ALTER_CODE ? res.append((Object)GenericEditingResultProcessor.assignAction(object)) : res.append((Object)new SchemaEditorHelper.ObjectAction(SchemaEditorHelper.ObjectAction.Action.CREATE, object));
            }
            return res;
        }

        @NotNull
        private JBIterable<SchemaEditorHelper.ObjectAction> processParent(@Nullable DeObject object) {
            if (!(object instanceof DeTable) || object.editedObject == null || this.myProcessedParents.contains(object)) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    AppendDroppedSiblings.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }
            this.myProcessedParents.add(object);
            Set modified = object.getDasChildren(null).map(o -> (DeObject)ObjectUtils.tryCast((Object)o.editedObject, DeObject.class)).toSet();
            JBIterable jBIterable = object.editedObject.getDasChildren(null).filter(o -> !modified.contains((DeObject)o)).map(o -> new SchemaEditorHelper.ObjectAction(SchemaEditorHelper.ObjectAction.Action.DROP, (DeObject)o));
            if (jBIterable == null) {
                AppendDroppedSiblings.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/GenericEditingResultProcessor$AppendDroppedSiblings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/GenericEditingResultProcessor$AppendDroppedSiblings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

