/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.ide.FileEditorSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlDocumentationProvider;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.Nullable;

public class SqlSelectInDbView
implements NullableFunction<SelectInContext, DbElement> {
    @Nullable
    private static DbDataSource findDataSource(Project project, VirtualFile vFile) {
        for (DbDataSource element : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            SqlDataSource dataSource;
            if (!(element.getDelegate() instanceof SqlDataSource) || !(dataSource = (SqlDataSource)element.getDelegate()).containsFile(vFile)) continue;
            return element;
        }
        return null;
    }

    public DbElement fun(SelectInContext context) {
        DbElement result2 = null;
        if (context instanceof FileEditorSelectInContext) {
            PsiElement element = ((FileEditorSelectInContext)context).getElementAtCaret(true);
            result2 = (DbElement)SqlDocumentationProvider.findRelatedDbElements(element).first();
        }
        Object selector = context.getSelectorInFile();
        if (result2 == null && selector instanceof PsiElement) {
            result2 = (DbElement)SqlDocumentationProvider.findRelatedDbElements((PsiElement)selector).first();
        }
        return result2 != null ? result2 : SqlSelectInDbView.findDataSource(context.getProject(), context.getVirtualFile());
    }
}

