/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveMappings;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlImportUtil {
    public static final ObjectKind DATA_SOURCE = ObjectKind.ROOT;
    public static final ObjectName NON_MATCHING_NAME = ObjectName.quoted((String)"SOME NON MATCHING NAME");
    public static final ObjectName[] NON_MATCHING_NAMES = (ObjectName[])ContainerUtil.ar((Object[])new ObjectName[]{NON_MATCHING_NAME});

    @Nullable
    private static TreePatternNode.Group[] removeNulls(@Nullable TreePatternNode.Group[] groups) {
        if (groups == null) {
            return null;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group group2 : groups) {
            if (group2 == null) continue;
            ++nonNulls;
        }
        if (nonNulls == 0) {
            return TreePatternNode.NO_GROUPS;
        }
        if (nonNulls == groups.length) {
            return groups;
        }
        TreePatternNode.Group[] newGroups = new TreePatternNode.Group[nonNulls];
        int i2 = 0;
        for (TreePatternNode.Group group3 : groups) {
            if (group3 == null) continue;
            newGroups[i2++] = group3;
        }
        return newGroups;
    }

    @NotNull
    public static TreePattern createPattern(@NotNull List<?> names, @NotNull List<ObjectKind> kinds, @Nullable TreePatternNode.Group[] tail) {
        if (names == null) {
            SqlImportUtil.$$$reportNull$$$0(0);
        }
        if (kinds == null) {
            SqlImportUtil.$$$reportNull$$$0(1);
        }
        TreePatternNode.Group[] children = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)SqlImportUtil.removeNulls(tail), (Object)TreePatternNode.NO_GROUPS);
        for (int i2 = 0; i2 < names.size(); ++i2) {
            TreePatternNode[] treePatternNodeArray;
            Object name = names.get(i2);
            ObjectKind kind = kinds.get(i2);
            TreePatternNode<TreePatternNode.PositiveNaming> p = null;
            TreePatternNode<TreePatternNode.NegativeNaming> n = null;
            if (name == null) {
                n = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children);
            } else {
                TreePatternNode.PositiveNaming naming;
                if (name instanceof ObjectName) {
                    naming = new TreePatternNode.PositiveNaming((ObjectName)name);
                } else if (name instanceof ObjectName[]) {
                    naming = new TreePatternNode.PositiveNaming((ObjectName[])name);
                } else if (name instanceof Iterable) {
                    naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)((Iterable)name)));
                } else {
                    throw new AssertionError((Object)("Unexpected: " + name.getClass().getSimpleName()));
                }
                p = new TreePatternNode<TreePatternNode.PositiveNaming>(naming, children);
            }
            TreePatternNode.Group[] groupArray = new TreePatternNode.Group[1];
            if (p == null) {
                treePatternNodeArray = null;
            } else {
                TreePatternNode[] treePatternNodeArray2 = new TreePatternNode[1];
                treePatternNodeArray = treePatternNodeArray2;
                treePatternNodeArray2[0] = p;
            }
            groupArray[0] = new TreePatternNode.Group(kind, treePatternNodeArray, n);
            children = groupArray;
        }
        TreePattern treePattern = new TreePattern(children);
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(2);
        }
        return treePattern;
    }

    @Nullable
    public static List<ObjectKind> getSingleRootPath(@NotNull ObjectKind kind, @NotNull DatabaseDialectEx dialect) {
        JBIterable roots;
        List root2;
        if (kind == null) {
            SqlImportUtil.$$$reportNull$$$0(3);
        }
        if (dialect == null) {
            SqlImportUtil.$$$reportNull$$$0(4);
        }
        if ((root2 = (List)(roots = dialect.getMetaModel().getPathsToRoot(kind)).first()) == null || root2.isEmpty() || !roots.skip(1).isEmpty()) {
            Logger.getInstance(dialect.getClass()).warn("To many roots from " + kind);
            return null;
        }
        root2 = ContainerUtil.newArrayList((Iterable)root2);
        assert (!root2.isEmpty());
        assert (root2.get(root2.size() - 1) == ObjectKind.ROOT);
        root2.set(root2.size() - 1, DATA_SOURCE);
        return root2;
    }

    @Nullable
    public static TreePattern createRefPattern(@NotNull SqlReferenceExpression ref, @NotNull DatabaseDialectEx dialect) {
        ObjectKind refKind;
        List<ObjectKind> kinds;
        if (ref == null) {
            SqlImportUtil.$$$reportNull$$$0(5);
        }
        if (dialect == null) {
            SqlImportUtil.$$$reportNull$$$0(6);
        }
        if ((kinds = SqlImportUtil.getSingleRootPath(refKind = ref.getReferenceElementType().getTargetKind(), dialect)) == null) {
            return null;
        }
        List names = ContainerUtil.newSmartList();
        names.add(new ObjectName(ref.getName(), !ref.isPlainIdentifier()));
        SqlReferenceExpression qual = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getQualifierExpression(), SqlReferenceExpression.class);
        while (names.size() < kinds.size()) {
            names.add(qual == null ? null : new ObjectName(qual.getName(), !qual.isPlainIdentifier()));
            qual = qual == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)qual.getQualifierExpression(), SqlReferenceExpression.class);
        }
        return SqlImportUtil.createPattern(names, kinds, null);
    }

    @NotNull
    static TreePattern createDefaultScopePattern(@Nullable DbDataSource ds, @NotNull SqlLanguageDialectEx language) {
        if (language == null) {
            SqlImportUtil.$$$reportNull$$$0(7);
        }
        TreePattern treePattern = language.getDefaultImports(ds);
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(8);
        }
        return treePattern;
    }

    @Nullable
    static TreePattern getResolveScopePattern(@NotNull SqlFile file) {
        if (file == null) {
            SqlImportUtil.$$$reportNull$$$0(9);
        }
        SqlResolveMappings mapping = SqlResolveMappings.getInstance(file.getProject());
        VirtualFile vFile = SqlImplUtil.getTopLevelFile((PsiFile)file);
        return (TreePattern)mapping.getMapping(vFile);
    }

    public static TreePattern processResolveScopePattern(TreePattern resolvePattern, TreePattern defaultPattern) {
        return new TreePatternUtils.GroupedGroupFactory(){
            private boolean myAccept = false;
            private TreePatternNode.Group myUnAccept = null;

            @Override
            protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
                TreePatternNode.Group second;
                TreePatternNode.Group first;
                if (this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it = groups.iterator();
                TreePatternNode.Group group2 = first = it.hasNext() ? it.next() : null;
                if (first != null) {
                    return;
                }
                TreePatternNode.Group group3 = second = it.hasNext() ? it.next() : null;
                if (second == null) {
                    return;
                }
                this.myAccept = true;
                this.myUnAccept = second;
            }

            @Override
            protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
                TreePatternNode.Group second;
                if (!this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it = groups.iterator();
                if (it.hasNext()) {
                    it.next();
                }
                TreePatternNode.Group group2 = second = it.hasNext() ? it.next() : null;
                if (second != this.myUnAccept) {
                    return;
                }
                this.myAccept = false;
                this.myUnAccept = null;
            }

            @Override
            protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                Iterator<TreePatternNode.Group> it = value.iterator();
                return this.myAccept || it.hasNext() && it.next() != null;
            }

            @Override
            protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value) {
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                Iterator<TreePatternNode<?>> it = value.iterator();
                return this.myAccept || it.hasNext() && it.next() != null;
            }

            @Override
            public boolean mergeChildren() {
                return false;
            }

            @Override
            public boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> value) {
                return !1.containsNotNull(value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.merge(Arrays.asList(resolvePattern, defaultPattern));
    }

    @Nullable
    public static TreePatternNode.Group createNodeIfNotNull(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... groups) {
        if (kind == null) {
            SqlImportUtil.$$$reportNull$$$0(10);
        }
        return name == null ? null : TreePatternUtils.create(name, kind, groups);
    }

    @NotNull
    public static TreePatternNode.Group createPositiveDatabase(@NotNull ObjectName name, TreePatternNode.Group ... groups) {
        if (name == null) {
            SqlImportUtil.$$$reportNull$$$0(11);
        }
        TreePatternNode.Group group2 = TreePatternUtils.create(name, ObjectKind.DATABASE, groups);
        if (group2 == null) {
            SqlImportUtil.$$$reportNull$$$0(12);
        }
        return group2;
    }

    @Nullable
    public static TreePatternNode.Group createPositiveDatabase(boolean useNonMatching, @Nullable ObjectName name, TreePatternNode.Group ... groups) {
        return name == null && !useNonMatching ? null : TreePatternUtils.create((ObjectName)ObjectUtils.chooseNotNull((Object)name, (Object)NON_MATCHING_NAME), ObjectKind.DATABASE, groups);
    }

    @NotNull
    public static TreePatternNode.Group createDataSources(@Nullable ObjectName[] names, TreePatternNode.Group ... groups) {
        TreePatternNode.Group group2 = TreePatternUtils.create(names == null ? NON_MATCHING_NAMES : names, DATA_SOURCE, groups);
        if (group2 == null) {
            SqlImportUtil.$$$reportNull$$$0(13);
        }
        return group2;
    }

    @NotNull
    public static ObjectName getDataSourceName(@NotNull DatabaseSystem dataSource) {
        String id;
        if (dataSource == null) {
            SqlImportUtil.$$$reportNull$$$0(14);
        }
        ObjectName objectName = ObjectName.quoted((String)(StringUtil.isEmpty((String)(id = dataSource.getUniqueId())) ? dataSource.getName() : id));
        if (objectName == null) {
            SqlImportUtil.$$$reportNull$$$0(15);
        }
        return objectName;
    }

    @Nullable
    public static ObjectName[] getRealDsNames(@Nullable DbDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        if (!(dataSource.getDelegate() instanceof SqlDataSource)) {
            return (ObjectName[])ContainerUtil.ar((Object[])new ObjectName[]{SqlImportUtil.getDataSourceName((DatabaseSystem)dataSource)});
        }
        List res = ContainerUtil.newSmartList();
        do {
            res.add(SqlImportUtil.getDataSourceName((DatabaseSystem)dataSource));
        } while ((dataSource = dataSource.getDelegate() instanceof SqlDataSource ? ((SqlDataSource)dataSource.getDelegate()).getParentDataSource() : null) != null);
        return ObjectName.toArray((Iterable)res);
    }

    @NotNull
    public static TreePattern createAddPattern(@Nullable ObjectName[] ds, @NotNull ObjectKind[] kinds) {
        if (kinds == null) {
            SqlImportUtil.$$$reportNull$$$0(16);
        }
        TreePatternNode.Group[] children = TreePatternNode.NO_GROUPS;
        for (int i2 = kinds.length - 1; i2 >= 0; --i2) {
            children = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{kinds[i2] == DATA_SOURCE && ds != null ? SqlImportUtil.createDataSources(ds, children) : TreePatternUtils.create((ObjectName)null, kinds[i2], children)});
        }
        TreePattern treePattern = new TreePattern(children);
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(17);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern addObjectsByPath(@NotNull TreePattern pattern, @Nullable ObjectName[] dsNames, @NotNull List<ObjectName> names, boolean atBegin, ObjectKind ... path) {
        if (pattern == null) {
            SqlImportUtil.$$$reportNull$$$0(18);
        }
        if (names == null) {
            SqlImportUtil.$$$reportNull$$$0(19);
        }
        if (path == null) {
            SqlImportUtil.$$$reportNull$$$0(20);
        }
        ObjectKind targetKind = path[path.length - 1];
        TreePattern treePattern = TreePatternUtils.patternProcessor(pattern, SqlImportUtil.createAddPattern(dsNames, path), (g, parent, parentKind) -> {
            if (names == null) {
                SqlImportUtil.$$$reportNull$$$0(22);
            }
            if (parent instanceof TreePatternNode.NegativeNaming) {
                return TreePatternUtils.SKIP_PROCESSING;
            }
            if (g.kind != targetKind) {
                return g;
            }
            List notFound = ContainerUtil.newSmartList();
            for (ObjectName name : names) {
                if (g.matchedChildren(name, null, null)) continue;
                notFound.add(name);
            }
            if (notFound.isEmpty()) {
                return g;
            }
            TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)notFound));
            TreePatternUtils.GroupBuilder builder = TreePatternUtils.GroupBuilder.from(g);
            builder.positives.add(atBegin ? 0 : builder.positives.size(), new TreePatternNode<TreePatternNode.PositiveNaming>(naming, TreePatternNode.NO_GROUPS));
            return builder.build(g.kind);
        });
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(21);
        }
        return treePattern;
    }

    @Nullable
    public static RawConnectionConfig getConnectionConfig(@Nullable DbDataSource ds) {
        return ds == null ? null : ds.getConnectionConfig();
    }

    @Nullable
    public static TreePatternNode.Group getRootGroup(boolean schemaRoot, MultiMap<String, String> databases, boolean integrateStar) {
        return schemaRoot ? SqlImportUtil.getSchemaGroup(databases) : SqlImportUtil.getDbGroup(databases, integrateStar);
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroup(MultiMap<String, String> databases) {
        if (!databases.containsKey((Object)"*")) {
            return null;
        }
        return SqlImportUtil.getSchemaGroups(databases.get((Object)"*"));
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroups(Collection<String> schemas) {
        if (schemas.contains("*")) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
        }
        if (schemas.isEmpty()) {
            return null;
        }
        return TreePatternUtils.create(JBIterable.from(schemas).transform(n -> ObjectName.quoted((String)n)).toList(), ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
    }

    @Nullable
    public static TreePatternNode.Group getDbGroup(MultiMap<String, String> databases, boolean integrateStar) {
        if (databases.containsKey((Object)"*") && !integrateStar) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.DATABASE, TreePatternNode.NO_GROUPS);
        }
        if (databases.size() == 0) {
            return null;
        }
        ArrayList gr = ContainerUtil.newArrayList();
        for (Map.Entry entry : databases.entrySet()) {
            TreePatternNode.Group sgr = SqlImportUtil.getSchemaGroups((Collection)entry.getValue());
            gr.add(TreePatternUtils.create(((String)entry.getKey()).equals("*") ? null : ObjectName.quoted((String)((String)entry.getKey())), ObjectKind.DATABASE, SqlImportUtil.optAr(sgr)));
        }
        return TreePatternUtils.UNION_PROCESSOR.mergeGroups(ObjectKind.DATABASE, gr);
    }

    public static TreePatternNode.Group[] optAr(TreePatternNode.Group x) {
        return x == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{x});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlImportUtil";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPattern";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultScopePattern";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPositiveDatabase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSources";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddPattern";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "addObjectsByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPattern";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSingleRootPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultScopePattern";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopePattern";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNodeIfNotNull";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPositiveDatabase";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createAddPattern";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addObjectsByPath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addObjectsByPath$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

