/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.functions;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.FunToken;
import com.intellij.sql.dialects.functions.FunctionLexer;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.NanoXmlUtil;
import gnu.trove.THashMap;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionDefinitionParser {
    private static final Logger LOG = Logger.getInstance((String)SqlFunctionDefinitionParser.class.getName());
    private static final String NAME_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"functions", "function", "name"});
    private static final String NAME_ATTR_LOCATION1 = NanoXmlUtil.createLocation((String[])new String[]{"functions", "function"});
    private static final String NAME_ATTR_LOCATION2 = NanoXmlUtil.createLocation((String[])new String[]{"functions", "macro"});
    private static final String PROTOTYPE_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"functions", "function", "prototype"});
    private static final String PROTOTYPE_MACRO_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"functions", "macro"});
    private final FunctionLexer myLexer;
    private final SqlLanguageDialectEx myDialect;
    private final Map<String, SqlFunctionDefinition.Parameter[]> myCustomMap;
    private final Map<String, SqlFunctionDefinition.Type> myExtraTypes;

    public SqlFunctionDefinitionParser(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(0);
        }
        this.myCustomMap = new THashMap();
        this.myExtraTypes = new THashMap();
        this.myDialect = dialect;
        this.myLexer = new FunctionLexer();
    }

    public List<SqlFunctionDefinition> parse(String text) {
        return this.parseXmlFormat(text);
    }

    private List<SqlFunctionDefinition> parseXmlFormat(String text) {
        final ArrayList list = ContainerUtil.newArrayList();
        NanoXmlUtil.parse((Reader)new StringReader(text), (IXMLBuilder)new NanoXmlUtil.BaseXmlBuilder(){
            final List<SqlFunctionDefinition.Prototype> myPrototypes = ContainerUtil.newArrayList();
            final List<String> myNames = ContainerUtil.newArrayList();
            final HashMap<String, String> myDialectAttrs = ContainerUtil.newHashMap();
            final HashMap<String, String> myPrototypeAttrs = ContainerUtil.newHashMap();
            int myPrototypeId = 0;
            String myCurPCDataLocation;
            StringBuilder myCurPCData = new StringBuilder();

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                super.startElement(name, nsPrefix, nsURI, systemID, lineNr);
                if ("function".equals(name) || "macro".equals(name)) {
                    this.myPrototypes.clear();
                    this.myNames.clear();
                    this.myDialectAttrs.clear();
                    this.myPrototypeId = 0;
                } else if ("prototype".equals(name)) {
                    this.myPrototypeAttrs.clear();
                }
            }

            public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                boolean macro = false;
                String functionName = (String)ContainerUtil.getFirstItem(this.myNames);
                if (NAME_LOCATION.equals(this.myCurPCDataLocation)) {
                    this.myNames.add(this.myCurPCData.toString());
                } else if (PROTOTYPE_LOCATION.equals(this.myCurPCDataLocation) || (macro = PROTOTYPE_MACRO_LOCATION.equals(this.myCurPCDataLocation))) {
                    SqlFunctionDefinition.Type returnType;
                    SqlFunctionDefinition.Parameter[] params2;
                    SqlFunctionDefinitionParser.this.myLexer.start(this.myCurPCData, 0, this.myCurPCData.length(), 2);
                    if (!macro && !SqlFunctionDefinitionParser.this.consumeToken(true, FunToken.LEFT_PAREN)) {
                        SqlFunctionDefinitionParser.this.error(functionName, "( expected");
                    }
                    if ((params2 = SqlFunctionDefinitionParser.this.parseParameterList(this.myPrototypeId, functionName, SqlFunctionDefinition.ParameterBlockType.SEQUENCE)) == null) {
                        SqlFunctionDefinitionParser.this.error(functionName, "params not parsed");
                    }
                    if (!macro && !SqlFunctionDefinitionParser.this.consumeToken(true, FunToken.RIGHT_PAREN)) {
                        SqlFunctionDefinitionParser.this.error(functionName, ") expected");
                    }
                    SqlFunctionDefinition.ParameterBlock tailBlock = null;
                    if (!macro && SqlFunctionDefinitionParser.this.consumeToken(true, FunToken.COLON)) {
                        returnType = (SqlFunctionDefinition.Type)ObjectUtils.chooseNotNull((Object)SqlFunctionDefinitionParser.this.parseType(functionName), (Object)SqlFunctionDefinition.ANY);
                        SqlFunctionDefinition.Parameter[] tail = SqlFunctionDefinitionParser.this.parseParameterList(this.myPrototypeId, functionName, SqlFunctionDefinition.ParameterBlockType.SEQUENCE);
                        if (tail != null && tail.length > 0) {
                            tailBlock = new SqlFunctionDefinition.ParameterBlock(this.myPrototypeId, SqlFunctionDefinition.ParameterBlockType.SEQUENCE, tail, false);
                        }
                    } else {
                        if (!macro) {
                            SqlFunctionDefinitionParser.this.error(functionName, ":<type> expected");
                        }
                        returnType = SqlFunctionDefinition.ANY;
                    }
                    if (params2 != null) {
                        SmartFMap attributes = SmartFMap.emptyMap().plusAll(this.myPrototypeAttrs);
                        this.myPrototypes.add(new SqlFunctionDefinition.Prototype(null, returnType, this.myPrototypeId++, params2, tailBlock, (Map<String, String>)attributes));
                    }
                }
                this.myCurPCData.setLength(0);
                this.myCurPCDataLocation = null;
                if (name.equals("function") || (macro = name.equals("macro"))) {
                    String primaryName = DbUtil.intern2((String)((String)ContainerUtil.getFirstItem(this.myNames)));
                    if (macro) {
                        if (primaryName == null) {
                            SqlFunctionDefinitionParser.this.error(functionName, "macro name not found");
                        } else if (this.myPrototypes.isEmpty()) {
                            IElementType nodeType = SqlFunctionDefinitionParser.this.myDialect.getFunctionParserExtension(StringUtil.toUpperCase((String)primaryName));
                            if (nodeType == null) {
                                SqlFunctionDefinitionParser.this.error(functionName, "external macro " + primaryName + " not found");
                            } else {
                                SqlFunctionDefinitionParser.this.myCustomMap.put(primaryName, new SqlFunctionDefinition.Parameter[]{new SqlFunctionDefinition.ExternalParameter(this.myPrototypeId++, nodeType, this.myNames.size() < 2 ? primaryName : this.myNames.get(1))});
                            }
                        } else {
                            SqlFunctionDefinitionParser.this.myCustomMap.put(primaryName, this.myPrototypes.get(0).getParams());
                        }
                    } else {
                        LinkedHashMap<String, String> dialectAttrs = this.myDialectAttrs.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, String>(this.myDialectAttrs);
                        for (String alias : this.myNames) {
                            list.add(new SqlFunctionDefinition(DbUtil.intern((String)alias), primaryName, dialectAttrs, this.myPrototypes));
                        }
                    }
                }
                super.endElement(name, nsPrefix, nsURI);
            }

            public void addAttribute(String key2, String nsPrefix, String nsURI, String value, String type) {
                String location = this.getLocation();
                if (PROTOTYPE_LOCATION.equals(location) && "id".equals(key2)) {
                    this.myPrototypeId = Integer.parseInt(value);
                } else if ("name".equals(key2) && (NAME_ATTR_LOCATION1.equals(location) || NAME_ATTR_LOCATION2.equals(location)) || "display-name".equals(key2) && NAME_ATTR_LOCATION2.equals(location)) {
                    this.myNames.add(DbUtil.intern((String)value));
                } else if (NAME_ATTR_LOCATION1.equals(location)) {
                    this.myDialectAttrs.put(DbUtil.intern((String)key2), DbUtil.intern((String)value));
                } else if (PROTOTYPE_LOCATION.equals(location)) {
                    this.myPrototypeAttrs.put(DbUtil.intern((String)key2), DbUtil.intern((String)value));
                }
            }

            public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
                String location = this.getLocation();
                String text = 1.readText((Reader)reader);
                if (!location.equals(this.myCurPCDataLocation)) {
                    this.myCurPCData.setLength(0);
                    this.myCurPCData.append(text);
                    this.myCurPCDataLocation = location;
                } else {
                    this.myCurPCData.append(text);
                }
            }
        });
        return list;
    }

    @Nullable
    private <T> T error(String functionName, @NonNls String message) {
        CharSequence seq;
        try {
            seq = this.myLexer.getBufferSequence();
        }
        catch (RuntimeException ignore) {
            seq = "";
        }
        int SPACE = 20;
        int pos = this.myLexer.getTokenStart();
        int offset = Math.max(0, pos - SPACE);
        String context = seq.subSequence(offset, Math.min(this.myLexer.getTokenEnd() + SPACE, this.myLexer.getBufferEnd())).toString();
        LOG.error(functionName + " [" + pos + "]: " + message + "\n    curToken = " + this.getTokenType() + "\n    curTokenText = '" + this.getTokenText() + "'\n    context = '" + context + "'\n    ___________" + StringUtil.repeat((String)"_", (int)(pos - offset)) + "^");
        return null;
    }

    @Nullable
    private SqlFunctionDefinition.Parameter[] parseParameterList(int prototypeId, String functionName, SqlFunctionDefinition.ParameterBlockType currentBlockType) {
        IElementType curType;
        FunToken separator;
        ArrayList result2 = ContainerUtil.newArrayList();
        FunToken funToken = separator = currentBlockType == SqlFunctionDefinition.ParameterBlockType.CHOICE ? FunToken.BAR : FunToken.COMMA;
        while ((curType = this.getTokenType()) != FunToken.RIGHT_PAREN && curType != FunToken.RIGHT_BRACKET && curType != FunToken.RIGHT_BRACE) {
            if (currentBlockType == SqlFunctionDefinition.ParameterBlockType.CHOICE) {
                SqlFunctionDefinition.Parameter[] parameters = this.parseParameterList(prototypeId, functionName, SqlFunctionDefinition.ParameterBlockType.SEQUENCE);
                if (parameters == null || parameters.length == 0) {
                    return (SqlFunctionDefinition.Parameter[])this.error(functionName, "no parameters");
                }
                if (parameters.length == 1) {
                    result2.add(parameters[0]);
                } else {
                    result2.add(new SqlFunctionDefinition.ParameterBlock(prototypeId, SqlFunctionDefinition.ParameterBlockType.SEQUENCE, parameters, false));
                }
            } else if (curType == FunToken.LEFT_PAREN || curType == FunToken.LEFT_BRACKET || curType == FunToken.LEFT_BRACE) {
                FunToken closingType;
                this.advanceLexer();
                SqlFunctionDefinition.ParameterBlockType parameterBlockType = curType == FunToken.LEFT_PAREN ? SqlFunctionDefinition.ParameterBlockType.SEQUENCE : (curType == FunToken.LEFT_BRACKET ? SqlFunctionDefinition.ParameterBlockType.OPTIONAL_SEQUENCE : SqlFunctionDefinition.ParameterBlockType.CHOICE);
                SqlFunctionDefinition.Parameter[] parameters = this.parseParameterList(prototypeId, functionName, parameterBlockType);
                if (parameters == null) {
                    return (SqlFunctionDefinition.Parameter[])this.error(functionName, "no parameters");
                }
                FunToken funToken2 = curType == FunToken.LEFT_PAREN ? FunToken.RIGHT_PAREN : (closingType = curType == FunToken.LEFT_BRACKET ? FunToken.RIGHT_BRACKET : FunToken.RIGHT_BRACE);
                if (!this.consumeToken(true, closingType)) {
                    return (SqlFunctionDefinition.Parameter[])this.error(functionName, (Object)((Object)closingType) + " expected");
                }
                result2.add(new SqlFunctionDefinition.ParameterBlock(prototypeId, parameterBlockType, parameters, this.consumeToken(true, FunToken.ELLIPSIS)));
            } else if (curType == FunToken.COMMA) {
                this.advanceLexer();
                result2.add(SqlFunctionDefinition.COMMA);
            } else if (curType == FunToken.SYNTAX) {
                String tokenText = this.getTokenText();
                assert (tokenText != null);
                result2.add(new SqlFunctionDefinition.SyntaxParameter(prototypeId, tokenText.startsWith("\\") ? tokenText.substring(1) : tokenText));
                this.advanceLexer();
            } else {
                SqlFunctionDefinition.Type type;
                if (curType != FunToken.IDENT) break;
                String name = this.consumeTokenText(true, FunToken.IDENT);
                boolean colon = this.consumeToken(true, FunToken.COLON);
                SqlFunctionDefinition.Type type2 = type = colon ? this.parseType(functionName) : null;
                if (type == null) {
                    SqlFunctionDefinition.Parameter[] parameters = this.myCustomMap.get(name);
                    if (parameters != null) {
                        for (SqlFunctionDefinition.Parameter parameter : parameters) {
                            result2.add(parameter.copyWithPrototype(prototypeId));
                        }
                    } else {
                        result2.add(new SqlFunctionDefinition.Keyword(prototypeId, name));
                    }
                } else {
                    String refTypeName = type == SqlFunctionDefinition.REF && this.consumeToken(true, FunToken.SLASH) ? this.consumeTokenText(false, FunToken.IDENT) : null;
                    boolean many = this.consumeToken(true, FunToken.ELLIPSIS);
                    if (type == SqlFunctionDefinition.REF && refTypeName == null) {
                        this.error(functionName, "/refType required");
                    }
                    result2.add(refTypeName == null ? new SqlFunctionDefinition.SimpleParameter(prototypeId, name, type, many) : new SqlFunctionDefinition.ReferenceParameter(prototypeId, name, type, refTypeName, many));
                }
            }
            if (!this.consumeToken(true, separator) || separator != FunToken.COMMA) continue;
            result2.add(SqlFunctionDefinition.COMMA);
        }
        return result2.isEmpty() ? SqlFunctionDefinition.Parameter.EMPTY_ARRAY : result2.toArray(SqlFunctionDefinition.Parameter.EMPTY_ARRAY);
    }

    @NotNull
    private String parseTypeArgs(@NotNull String functionName) {
        if (functionName == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(1);
        }
        if (this.getTokenType() == FunToken.RIGHT_PAREN) {
            if ("" == null) {
                SqlFunctionDefinitionParser.$$$reportNull$$$0(2);
            }
            return "";
        }
        StringBuilder res = new StringBuilder();
        while (true) {
            if (res.length() != 0) {
                res.append(", ");
            }
            String name = this.consumeTokenText(false, FunToken.IDENT);
            this.consumeToken(false, FunToken.COLON);
            SqlFunctionDefinition.Type arg = this.parseType(functionName);
            if (arg == null) {
                this.error(functionName, "Table type arguments, type expected");
                break;
            }
            res.append("\"").append(name).append("\" ").append(arg.getDataType().getSpecification());
            if (this.getTokenType() == FunToken.RIGHT_PAREN) break;
            this.consumeToken(false, FunToken.COMMA);
        }
        String string = res.toString();
        if (string == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private SqlFunctionDefinition.Type createTableType(@NotNull String args2) {
        String key2;
        SqlFunctionDefinition.Type res;
        if (args2 == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(4);
        }
        if ((res = this.myExtraTypes.get(key2 = "(" + args2 + ")")) == null) {
            DataType dataType = SqlTypeFactory.createTableDataType(args2);
            res = new SqlFunctionDefinition.Type(dataType.getSpecification(), dataType);
            this.myExtraTypes.put(key2, res);
        }
        SqlFunctionDefinition.Type type = res;
        if (type == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(5);
        }
        return type;
    }

    @NotNull
    private SqlFunctionDefinition.Type createArrayType(@NotNull SqlFunctionDefinition.Type base) {
        String key2;
        SqlFunctionDefinition.Type res;
        if (base == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(6);
        }
        if ((res = this.myExtraTypes.get(key2 = base.getName() + "[]")) == null) {
            DataType dataType = DataTypeFactory.of(base.getDataType().getSpecification() + "[]");
            res = new SqlFunctionDefinition.Type(key2, dataType);
            this.myExtraTypes.put(key2, res);
        }
        SqlFunctionDefinition.Type type = res;
        if (type == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(7);
        }
        return type;
    }

    @Nullable
    private SqlFunctionDefinition.Type parseType(String functionName) {
        String typeName = this.consumeTypeName();
        if (typeName == null) {
            return (SqlFunctionDefinition.Type)this.error(functionName, "Type expected");
        }
        SqlFunctionDefinition.Type type = this.findType(typeName);
        if (type == null) {
            return (SqlFunctionDefinition.Type)this.error(functionName, typeName + " type not found");
        }
        if (this.myLexer.getTokenType() == FunToken.LEFT_BRACKET) {
            int s = this.myLexer.getTokenStart();
            int e = Math.min(this.myLexer.getBufferEnd(), s + 2);
            if ("[]".contentEquals(this.myLexer.getBufferSequence().subSequence(s, e))) {
                this.consumeToken(false, FunToken.LEFT_BRACKET);
                this.consumeToken(false, FunToken.RIGHT_BRACKET);
                return this.createArrayType(type);
            }
        } else {
            if (type == SqlFunctionDefinition.TABLE && this.myLexer.getTokenType() == FunToken.LEFT_PAREN) {
                this.consumeToken(false, FunToken.LEFT_PAREN);
                if (this.consumeToken(true, FunToken.ELLIPSIS)) {
                    this.consumeToken(false, FunToken.IDENT);
                    return SqlFunctionDefinition.UNNEST;
                }
                String args2 = this.parseTypeArgs(functionName);
                this.consumeToken(false, FunToken.RIGHT_PAREN);
                return this.createTableType(args2);
            }
            if (type == SqlFunctionDefinition.SETOF && this.myLexer.getTokenType() == FunToken.LEFT_PAREN) {
                this.consumeToken(false, FunToken.LEFT_PAREN);
                SqlFunctionDefinition.Type item = (SqlFunctionDefinition.Type)ObjectUtils.chooseNotNull((Object)this.parseType(functionName), (Object)SqlFunctionDefinition.ANY);
                this.consumeToken(false, FunToken.RIGHT_PAREN);
                return this.createTableType(functionName + " " + item.getDataType().getSpecification());
            }
        }
        return type;
    }

    private String consumeTypeName() {
        return this.consumeTokenText(true, FunToken.IDENT);
    }

    @Nullable
    private SqlFunctionDefinition.Type findType(@Nullable String type) {
        if (type == null) {
            return null;
        }
        SqlFunctionDefinition.Type builtInType = this.myDialect.getBuiltInTypes().get(type);
        if (builtInType != null) {
            return builtInType;
        }
        if (type.startsWith("P")) {
            String s = type.substring("P".length());
            try {
                return new SqlFunctionDefinition.ParamType(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private void advanceLexer() {
        this.myLexer.advance();
    }

    private void skipCommentsAndWhiteSpaces() {
        IElementType type = this.myLexer.getTokenType();
        while (type == FunToken.COMMENT || type == FunToken.WHITE_SPACE) {
            this.myLexer.advance();
            type = this.myLexer.getTokenType();
        }
    }

    @Nullable
    private IElementType getTokenType() {
        this.skipCommentsAndWhiteSpaces();
        return this.myLexer.getTokenType();
    }

    @Nullable
    private String getTokenText() {
        if (this.myLexer.getTokenType() == null) {
            return null;
        }
        String s = this.myLexer.getBufferSequence().subSequence(this.myLexer.getTokenStart(), this.myLexer.getTokenEnd()).toString();
        return DbUtil.intern((String)s);
    }

    private boolean consumeToken(boolean optional, IElementType type) {
        if (this.getTokenType() == type) {
            this.advanceLexer();
            return true;
        }
        if (!optional) {
            throw new AssertionError((Object)(type.toString() + " expected"));
        }
        return false;
    }

    @Nullable
    private String consumeTokenText(boolean optional, IElementType type) {
        if (this.getTokenType() == type) {
            String result2 = this.getTokenText();
            this.advanceLexer();
            return result2;
        }
        if (!optional) {
            throw new AssertionError((Object)(type + " expected, found " + this.getTokenType()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/functions/SqlFunctionDefinitionParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionDefinitionParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeArgs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeArgs";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTableType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

