/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.functions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionDefinitionParser;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlCompletionUtil;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionsUtil {
    private static final Key<SqlFunctionDefinition.Prototype> EXPLICIT_FUNCTION_PROTOTYPE = Key.create((String)"EXPLICIT_FUNCTION_PROTOTYPE");

    public static Map<String, SqlFunctionDefinition> loadFunctionDefinition(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(0);
        }
        THashMap map = ContainerUtil.newTroveMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            Class<?> dialectClass = ((Object)((Object)dialect)).getClass();
            SqlFunctionDefinitionParser parser = new SqlFunctionDefinitionParser(dialect);
            for (SqlFunctionDefinition definition : parser.parse(SqlFunctionsUtil.getDialectFunctionDefinitions(dialectClass))) {
                SqlFunctionDefinition def2 = map.put(StringUtil.toUpperCase((String)definition.getName()), definition);
                assert (def2 == null) : definition.getName() + " already exists";
            }
        }
        catch (IOException e) {
            SqlDialectImplUtil.LOG.error((Throwable)e);
        }
        return map;
    }

    @NotNull
    public static String getDialectFunctionDefinitions(Class dialectClass) throws IOException {
        String string = SqlDialectImplUtil.loadDialectResource(dialectClass, "functions.xml");
        if (string == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static SqlReferenceElementType getReferenceType(SqlFunctionDefinition.ReferenceParameter parameter) {
        return (SqlReferenceElementType)SqlTokenRegistry.findCompositeType((String)("SQL_" + parameter.getRefTypeName() + "_REFERENCE"));
    }

    public static boolean isAssignable(SqlFunctionDefinition.Parameter parameter, SqlExpression expression, SqlType exprType) {
        if (parameter instanceof SqlFunctionDefinition.ReferenceParameter) {
            SqlReferenceElementType refType = SqlFunctionsUtil.getReferenceType((SqlFunctionDefinition.ReferenceParameter)parameter);
            return refType == null || SqlScopeProcessor.acceptsElement(expression, SqlImplUtil.getSqlDialectSafe((PsiElement)expression), refType.getTargetKind(), false, false, null);
        }
        if (parameter instanceof SqlFunctionDefinition.SimpleParameter) {
            SqlFunctionDefinition.Type type = ((SqlFunctionDefinition.SimpleParameter)parameter).getType();
            if (type == SqlFunctionDefinition.ANY) {
                return true;
            }
            DataType dataType = type.getDataType();
            if (dataType == null || "table".equalsIgnoreCase(dataType.typeName) && exprType instanceof SqlTableType) {
                return true;
            }
            SqlType sqlType = SqlTypeFactory.of(dataType, SqlImplUtil.getSqlDialectSafe((PsiElement)expression));
            return SqlFunctionsUtil.isAssignable(sqlType, exprType);
        }
        return false;
    }

    public static void setExplicitPrototype(@Nullable SqlExpression expr, SqlFunctionDefinition.Prototype prototype) {
        if (expr != null) {
            expr.putUserData(EXPLICIT_FUNCTION_PROTOTYPE, (Object)prototype);
        }
    }

    @Nullable
    public static SqlFunctionDefinition.Prototype chooseTheBestPrototype(SqlFunctionCallExpression expression, boolean returnTypeOnly) {
        SqlFunctionDefinition.Prototype explicitPrototype = (SqlFunctionDefinition.Prototype)expression.getUserData(EXPLICIT_FUNCTION_PROTOTYPE);
        if (explicitPrototype != null) {
            return explicitPrototype;
        }
        SqlFunctionDefinition definition = (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)expression.getFunctionDefinition(), SqlFunctionDefinition.class));
        if (definition == null) {
            return null;
        }
        if (returnTypeOnly) {
            SqlFunctionDefinition.Prototype cur = null;
            for (SqlFunctionDefinition.Prototype p : definition.getPrototypes()) {
                if (cur == null) {
                    cur = p;
                    continue;
                }
                if (Comparing.equal((Object)cur.getReturnType(), (Object)p.getReturnType())) continue;
                cur = null;
                break;
            }
            if (cur != null) {
                return cur;
            }
        }
        Map<SqlFunctionDefinition.Prototype, Map<PsiElement, SqlFunctionDefinition.Parameter>> map = SqlFunctionsUtil.getAcceptedPrototypes(definition, expression.getParameterList());
        SqlFunctionDefinition.Prototype maxMatched = null;
        int maxMatchedCount = -1;
        Map cache2 = FactoryMap.create(SqlExpression::getSqlType);
        for (SqlFunctionDefinition.Prototype prototype : map.keySet()) {
            Map<PsiElement, SqlFunctionDefinition.Parameter> mapping = map.get(prototype);
            int count2 = 0;
            for (PsiElement element : mapping.keySet()) {
                if (!(element instanceof SqlExpression) || !SqlFunctionsUtil.isAssignable(mapping.get(element), (SqlExpression)element, (SqlType)cache2.get(element))) continue;
                ++count2;
            }
            if (maxMatchedCount >= count2) continue;
            maxMatchedCount = count2;
            maxMatched = prototype;
        }
        return maxMatched;
    }

    @NotNull
    private static Map<SqlFunctionDefinition.Prototype, Map<PsiElement, SqlFunctionDefinition.Parameter>> getAcceptedPrototypes(@NotNull SqlFunctionDefinition definition, @Nullable SqlExpressionList parameterList) {
        if (definition == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(2);
        }
        ASTNode[] nodes2 = SqlFunctionsUtil.getArgNodes(parameterList);
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
            LinkedHashMap map = ContainerUtil.newLinkedHashMap();
            SqlFunctionsUtil.mapArguments(prototype, nodes2, (PairProcessor<PsiElement, SqlFunctionDefinition.Parameter>)((PairProcessor)(psi, param) -> {
                map.put(psi, param);
                return true;
            }));
            if (map.isEmpty() && prototype.getParams().length != 0) continue;
            result2.put(prototype, map);
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    public static boolean mapArguments(@NotNull SqlFunctionDefinition.Prototype prototype, @Nullable SqlExpressionList parameterList, @NotNull PairProcessor<PsiElement, SqlFunctionDefinition.Parameter> processor) {
        if (prototype == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(5);
        }
        return SqlFunctionsUtil.mapArguments(prototype, SqlFunctionsUtil.getArgNodes(parameterList), processor);
    }

    private static ASTNode[] getArgNodes(@Nullable SqlExpressionList parameterList) {
        ASTNode astNode = parameterList == null ? null : parameterList.getNode();
        return astNode == null ? ASTNode.EMPTY_ARRAY : astNode.getChildren(null);
    }

    private static boolean mapArguments(@NotNull SqlFunctionDefinition.Prototype prototype, @NotNull ASTNode[] paramNodes, @NotNull PairProcessor<PsiElement, SqlFunctionDefinition.Parameter> processor) {
        if (prototype == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(6);
        }
        if (paramNodes == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(8);
        }
        if (paramNodes.length == 0) {
            return true;
        }
        PsiElement prev = null;
        for (ASTNode node : paramNodes) {
            SqlFunctionDefinition.Parameter value = SqlInfoElementType.getValue(node, SqlFunctionDefinition.Parameter.class);
            if (value == null) {
                PsiElement psi = node.getPsi();
                if (psi instanceof PsiWhiteSpace || psi instanceof PsiComment) continue;
                prev = psi;
                continue;
            }
            int prototypeId = value.getPrototypeId();
            if (prev == null || prototypeId != prototype.getPrototypeId() && prototypeId != -1 || processor.process((Object)prev, (Object)value)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Number getSignatureNumber(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(9);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApiReversed();
        SqlExpressionList params2 = o.getParameterList();
        return params2 == null ? (Number)null : (Number)((Number)api.children((Object)params2).transform(p -> SqlInfoElementType.getValue(p, Number.class)).filter(Conditions.notNull()).first());
    }

    @NotNull
    public static List<DasRoutine> getNonPredefSignatures(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(10);
        }
        List nonPredefSigs = ContainerUtil.newSmartList();
        SqlReferenceExpression nameElement = o.getNameElement();
        if (nameElement != null) {
            for (ResolveResult resolve : nameElement.multiResolve(false)) {
                if (resolve.getElement() == o) continue;
                ContainerUtil.addIfNotNull((Collection)nonPredefSigs, (Object)ObjectUtils.tryCast((Object)resolve.getElement(), DasRoutine.class));
            }
        }
        List list = nonPredefSigs;
        if (list == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    public static SqlFunctionDefinition.Prototype findExactPredefinedFunction(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(12);
        }
        SqlReferenceExpression nameElement = o.getNameElement();
        SqlFunctionDefinition def2 = (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)o.getFunctionDefinition(), SqlFunctionDefinition.class));
        if (nameElement == null || nameElement.getQualifierExpression() != null || def2 == null) {
            return null;
        }
        Number sigNum = SqlFunctionsUtil.getSignatureNumber(o);
        if (sigNum == null) {
            return null;
        }
        int idx = sigNum.intValue();
        SqlFunctionDefinition.Prototype[] prototypes = def2.getPrototypes();
        return idx >= 0 && idx < prototypes.length ? prototypes[idx] : null;
    }

    @Nullable
    public static DasRoutine findSignature(@Nullable SqlExpressionList args2, @NotNull List<DasRoutine> protos) {
        if (protos == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(13);
        }
        return (DasRoutine)ContainerUtil.getFirstItem(protos);
    }

    public static boolean isAssignable(DasTypedObject obj, SqlType candidate, SqlLanguageDialectEx dialect) {
        return SqlFunctionsUtil.isAssignable(obj.getDataType(), candidate, dialect);
    }

    public static boolean isAssignable(DataType dataType, SqlType candidate, SqlLanguageDialectEx dialect) {
        return SqlFunctionsUtil.isAssignable(dialect.getTypeCategory(dataType), candidate);
    }

    public static boolean isAssignable(SqlType target, SqlType candidate) {
        return SqlFunctionsUtil.isAssignable(target.getCategory(), candidate);
    }

    public static boolean isAssignable(SqlType.Category target, SqlType candidate) {
        if (target == candidate.getCategory()) {
            return true;
        }
        if (target == SqlType.Category.REAL && candidate.getCategory() == SqlType.Category.INTEGER) {
            return true;
        }
        return target == SqlType.Category.DATE_TIME && (candidate.getCategory() == SqlType.Category.DATE || candidate.getCategory() == SqlType.Category.TIME || candidate.getCategory() == SqlType.Category.TIMESTAMP);
    }

    public static boolean isSingleArgumentRoutine(@Nullable DasObject target) {
        if (target instanceof DbElement) {
            target = (DasObject)ObjectUtils.tryCast((Object)((DbElement)target).getDelegate(), DasRoutine.class);
        }
        if (target instanceof DasRoutine) {
            return SqlFunctionsUtil.getAcceptedArguments(target).single() != null;
        }
        if (target instanceof SqlFunctionDefinition) {
            SqlFunctionDefinition.Prototype[] prototypes;
            for (SqlFunctionDefinition.Prototype prototype : prototypes = ((SqlFunctionDefinition)target).getPrototypes()) {
                if (prototype.getParams().length != 1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isNoArgumentRoutine(@Nullable DasObject target) {
        if (target instanceof DbElement) {
            target = (DasObject)ObjectUtils.tryCast((Object)((DbElement)target).getDelegate(), DasRoutine.class);
        }
        if (target instanceof DasRoutine) {
            return SqlFunctionsUtil.getAcceptedArguments(target).first() == null;
        }
        if (target instanceof SqlFunctionDefinition) {
            SqlFunctionDefinition.Prototype[] prototypes;
            for (SqlFunctionDefinition.Prototype prototype : prototypes = ((SqlFunctionDefinition)target).getPrototypes()) {
                if (prototype.getParams().length != 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static JBIterable<DasArgument> getAcceptedArguments(@Nullable DasObject target) {
        target = target instanceof DbElement ? (DasObject)ObjectUtils.tryCast((Object)((DbElement)target).getDelegate(), DasObject.class) : target;
        return target == null ? JBIterable.empty() : target.getDasChildren(ObjectKind.ARGUMENT).filter(DasArgument.class).filter(a -> !a.getArgumentDirection().isReturnOrResult());
    }

    @NotNull
    public static ExpressionList[] getOverloads(@NotNull SqlFunctionCallExpression call) {
        SqlReferenceExpression element;
        if (call == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(14);
        }
        boolean notBuiltin = (element = call.getNameElement()) != null && element.getQualifierExpression() != null;
        ArrayList prototypes = ContainerUtil.newArrayList();
        SqlFunctionDefinition def2 = notBuiltin ? null : (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)call.getFunctionDefinition(), SqlFunctionDefinition.class));
        boolean anyMatched = false;
        if (def2 != null) {
            Number number = SqlFunctionsUtil.getSignatureNumber(call);
            for (SqlFunctionDefinition.Prototype proto : def2.getPrototypes()) {
                boolean matched = number != null && number.intValue() == proto.getPrototypeId();
                anyMatched |= matched;
                prototypes.add(new BuiltinPrototypeWrapper(call, proto, matched));
            }
        }
        for (DasRoutine routine : SqlFunctionsUtil.getNonPredefSignatures(call)) {
            prototypes.add(new RoutineWrapper(call, routine, !anyMatched));
        }
        ExpressionList[] expressionListArray = prototypes.toArray(new ExpressionList[0]);
        if (expressionListArray == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(15);
        }
        return expressionListArray;
    }

    @NotNull
    public static ExpressionList[] getInsertVariants(@NotNull SqlDmlInstruction instruction, @NotNull SqlExpressionList expr) {
        if (instruction == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(16);
        }
        if (expr == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(17);
        }
        ArrayList lists = ContainerUtil.newArrayList();
        SqlTableType targetType = instruction.getTargetType();
        lists.add(new ArrayList());
        for (int i2 = 0; i2 < targetType.getColumnCount(); ++i2) {
            String columnType = null;
            boolean skip = false;
            if (StringUtil.isNotEmpty((String)targetType.getColumnType(i2).getDisplayName())) {
                PsiElement resolve;
                PsiElement columnElement = targetType.getColumnElement(i2);
                PsiElement psiElement = resolve = columnElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)columnElement).resolve() : null;
                if (resolve instanceof DasColumn) {
                    columnType = ((DasColumn)resolve).getDataType().getSpecification();
                } else if (columnElement instanceof DasColumn) {
                    columnType = ((DasColumn)columnElement).getDataType().getSpecification();
                    skip = DasUtil.isAuto((DasColumn)((DasColumn)columnElement));
                } else {
                    columnType = targetType.getColumnType(i2).getDisplayName();
                }
            }
            if (skip) {
                lists.add(ContainerUtil.newArrayList((Iterable)((Iterable)lists.get(lists.size() - 1))));
            }
            Pair pair = Pair.create((Object)targetType.getColumnName(i2), columnType);
            for (int j = 0; j < lists.size(); ++j) {
                if (j == lists.size() - 1 && skip) continue;
                ((List)lists.get(j)).add(pair);
            }
        }
        ArrayList res = ContainerUtil.newArrayListWithCapacity((int)lists.size());
        for (List list : lists) {
            res.add(new ColumnListWrapper(list, expr));
        }
        ExpressionList[] expressionListArray = res.toArray(new ExpressionList[0]);
        if (expressionListArray == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(18);
        }
        return expressionListArray;
    }

    @NotNull
    public static ExpressionList[] getCreateTable(@NotNull SqlCreateStatement createStatement2, @NotNull SqlExpressionList expr) {
        ExpressionList[] expressionListArray;
        if (createStatement2 == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(19);
        }
        if (expr == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(20);
        }
        ArrayList pairs = ContainerUtil.newArrayList();
        for (DasColumn column2 : DasUtil.getColumns((DasObject)createStatement2)) {
            String type = column2.getDataType().getSpecification();
            pairs.add(Pair.create((Object)column2.getName(), (Object)(StringUtil.isNotEmpty((String)type) ? type : null)));
        }
        if (pairs.isEmpty()) {
            expressionListArray = new ExpressionList[]{};
        } else {
            ExpressionList[] expressionListArray2 = new ExpressionList[1];
            expressionListArray = expressionListArray2;
            expressionListArray2[0] = new ColumnListWrapper(pairs, expr);
        }
        if (expressionListArray == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(21);
        }
        return expressionListArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramNodes";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protos";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectFunctionDefinitions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedPrototypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonPredefSignatures";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloads";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertVariants";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFunctionDefinition";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptedPrototypes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mapArguments";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureNumber";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNonPredefSignatures";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findExactPredefinedFunction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSignature";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOverloads";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInsertVariants";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCreateTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ColumnListWrapper
    implements ExpressionList {
        private final List<Pair<String, String>> myColumns;
        private final SqlExpressionList myList;

        public ColumnListWrapper(@NotNull List<Pair<String, String>> columns2, @NotNull SqlExpressionList list) {
            if (columns2 == null) {
                ColumnListWrapper.$$$reportNull$$$0(0);
            }
            if (list == null) {
                ColumnListWrapper.$$$reportNull$$$0(1);
            }
            this.myColumns = columns2;
            this.myList = list;
        }

        @Override
        public boolean isMatched() {
            return this.myColumns.size() == this.myList.getExpressionList().size();
        }

        @Override
        public boolean isValid() {
            return this.myList.isValid();
        }

        @Override
        public boolean buildText(@NotNull StringBuilder sb, int paramIdx, int[] paramRange) {
            if (sb == null) {
                ColumnListWrapper.$$$reportNull$$$0(2);
            }
            for (int i2 = 0; i2 < this.myColumns.size(); ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                if (i2 == paramIdx) {
                    paramRange[0] = sb.length();
                }
                Pair<String, String> pair = this.myColumns.get(i2);
                sb.append((String)pair.first);
                if (StringUtil.isNotEmpty((String)((String)pair.second))) {
                    sb.append(":").append((String)pair.second);
                }
                if (i2 != paramIdx) continue;
                paramRange[1] = sb.length();
            }
            if (sb.length() == 0) {
                sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
            }
            return true;
        }

        @Override
        public boolean processArgumentTypes(@NotNull ExpressionList.ParameterProcessor processor) {
            if (processor == null) {
                ColumnListWrapper.$$$reportNull$$$0(3);
            }
            List expressions = this.myList.getExpressionList();
            Iterator psiIt = expressions.iterator();
            Iterator<Pair<String, String>> typeIt = this.myColumns.iterator();
            while (typeIt.hasNext() && psiIt.hasNext()) {
                SqlExpression psi = (SqlExpression)psiIt.next();
                Pair<String, String> type = typeIt.next();
                if (processor.process((PsiElement)psi, (String)type.first, (String)type.second)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil$ColumnListWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processArgumentTypes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RoutineWrapper
    implements ExpressionList {
        private final SqlFunctionCallExpression myCallExpression;
        private final DasRoutine myRoutine;
        private final boolean myMatched;

        public RoutineWrapper(@NotNull SqlFunctionCallExpression callExpression, @NotNull DasRoutine routine, boolean matched) {
            if (callExpression == null) {
                RoutineWrapper.$$$reportNull$$$0(0);
            }
            if (routine == null) {
                RoutineWrapper.$$$reportNull$$$0(1);
            }
            this.myCallExpression = callExpression;
            this.myRoutine = routine;
            this.myMatched = matched;
        }

        @Override
        public boolean isMatched() {
            return this.myMatched;
        }

        @Override
        public boolean isValid() {
            return this.myCallExpression.isValid();
        }

        @Override
        public boolean buildText(@NotNull StringBuilder sb, int paramIdx, int[] paramRange) {
            if (sb == null) {
                RoutineWrapper.$$$reportNull$$$0(2);
            }
            ASTNode[] astNodes = SqlFunctionsUtil.getArgNodes(this.myCallExpression.getParameterList());
            int selectedIndex = paramIdx == -1 ? (astNodes.length == 0 ? 0 : astNodes.length - 1) : paramIdx;
            DasArgument returnArg = this.myRoutine.getReturnArgument();
            PsiFile file = this.myCallExpression.getContainingFile();
            GenericDialect dialect = file instanceof SqlFile ? ((SqlFile)file).getSqlLanguage().getDatabaseDialect() : GenericDialect.INSTANCE;
            DdlBuilder ddlBuilder = new DdlBuilder(sb).applyCodeStyle(this.myCallExpression.getProject()).withDialect(dialect);
            int i2 = 0;
            JBIterable parameters = DasUtil.getParameters((DasRoutine)this.myRoutine);
            for (DasArgument o : parameters) {
                if (o.getArgumentDirection() == DasArgument.Direction.OUT && dialect.getFamilyId().isPostgres()) continue;
                if (i2 > 0) {
                    sb.append(", ");
                }
                if (i2 == selectedIndex) {
                    paramRange[0] = sb.length();
                }
                ddlBuilder.identifier((String)ObjectUtils.notNull((Object)o.getName(), (Object)"")).symbol(":").keyword(o.getDataType().getSpecification());
                if (i2 == selectedIndex) {
                    paramRange[1] = sb.length();
                }
                ++i2;
            }
            if (returnArg != null) {
                sb.append(":");
                SqlCompletionUtil.addParametersPresentableText(ddlBuilder, Collections.singleton(returnArg), true, false);
            }
            return true;
        }

        @Override
        public boolean processArgumentTypes(@NotNull ExpressionList.ParameterProcessor processor) {
            SqlExpressionList list;
            if (processor == null) {
                RoutineWrapper.$$$reportNull$$$0(3);
            }
            List expressions = (list = this.myCallExpression.getParameterList()) == null ? Collections.emptyList() : list.getExpressionList();
            Iterator psiIt = expressions.iterator();
            Iterator parIt = DasUtil.getParameters((DasRoutine)this.myRoutine).iterator();
            while (parIt.hasNext() && psiIt.hasNext()) {
                DasArgument par;
                SqlExpression psi = (SqlExpression)psiIt.next();
                if (processor.process((PsiElement)psi, (par = (DasArgument)parIt.next()).getName(), par.getDataType().typeName)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil$RoutineWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processArgumentTypes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BuiltinPrototypeWrapper
    implements ExpressionList {
        private final SqlFunctionCallExpression myCallExpression;
        private final SqlFunctionDefinition.Prototype myPrototype;
        private final boolean myMatched;

        public BuiltinPrototypeWrapper(@NotNull SqlFunctionCallExpression callExpression, @NotNull SqlFunctionDefinition.Prototype prototype, boolean matched) {
            if (callExpression == null) {
                BuiltinPrototypeWrapper.$$$reportNull$$$0(0);
            }
            if (prototype == null) {
                BuiltinPrototypeWrapper.$$$reportNull$$$0(1);
            }
            this.myCallExpression = callExpression;
            this.myPrototype = prototype;
            this.myMatched = matched;
        }

        @Override
        public boolean isValid() {
            return this.myCallExpression.isValid();
        }

        @Override
        public boolean isMatched() {
            return this.myMatched;
        }

        @Override
        public boolean buildText(@NotNull StringBuilder sb, final int paramIdx, int[] paramRange) {
            if (sb == null) {
                BuiltinPrototypeWrapper.$$$reportNull$$$0(2);
            }
            HashMap map = ContainerUtil.newHashMap();
            final Ref selectedParam = Ref.create((Object)ArrayUtil.getFirstElement((Object[])this.myPrototype.getParams()));
            SqlFunctionsUtil.mapArguments(this.myPrototype, this.myCallExpression.getParameterList(), new PairProcessor<PsiElement, SqlFunctionDefinition.Parameter>(){
                int i = 0;

                public boolean process(PsiElement element, SqlFunctionDefinition.Parameter parameter) {
                    selectedParam.set((Object)parameter);
                    return this.i++ != paramIdx;
                }
            });
            this.myPrototype.toString(sb, (PairConsumer<SqlFunctionDefinition.Parameter, Boolean>)((PairConsumer)(parameter, start) -> {
                if (sb == null) {
                    BuiltinPrototypeWrapper.$$$reportNull$$$0(5);
                }
                if (parameter == selectedParam.get() && selectedParam.get() != SqlFunctionDefinition.COMMA) {
                    paramRange[start.booleanValue() ? 0 : 1] = sb.length();
                }
            }));
            sb.append(":").append(this.myPrototype.getReturnType());
            return !map.isEmpty() || this.myPrototype.getParams().length == 0;
        }

        @Override
        public boolean processArgumentTypes(@NotNull ExpressionList.ParameterProcessor processor) {
            if (processor == null) {
                BuiltinPrototypeWrapper.$$$reportNull$$$0(3);
            }
            return SqlFunctionsUtil.mapArguments(this.myPrototype, this.myCallExpression.getParameterList(), (PairProcessor<PsiElement, SqlFunctionDefinition.Parameter>)((PairProcessor)(psi, param) -> {
                SqlFunctionDefinition.SimpleParameter sparam;
                if (processor == null) {
                    BuiltinPrototypeWrapper.$$$reportNull$$$0(4);
                }
                if ((sparam = (SqlFunctionDefinition.SimpleParameter)ObjectUtils.tryCast((Object)param, SqlFunctionDefinition.SimpleParameter.class)) != null) {
                    return processor.process((PsiElement)psi, sparam.getName(), sparam.getType().getDisplayName());
                }
                return true;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prototype";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinPrototypeWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processArgumentTypes";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$processArgumentTypes$1";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$buildText$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ExpressionList {
        public boolean isMatched();

        public boolean isValid();

        public boolean buildText(@NotNull StringBuilder var1, int var2, int[] var3);

        public boolean processArgumentTypes(@NotNull ParameterProcessor var1);

        @FunctionalInterface
        public static interface ParameterProcessor {
            public boolean process(@NotNull PsiElement var1, @Nullable String var2, @Nullable String var3);
        }
    }
}

