/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.oracle.OraDdlParsing;
import com.intellij.sql.dialects.oracle.OraDmlParsing;
import com.intellij.sql.dialects.oracle.OraExpressionParsing;
import com.intellij.sql.dialects.oracle.OraGeneratedParser;
import com.intellij.sql.dialects.oracle.OraPlParsing;
import com.intellij.sql.dialects.oracle.OracleDialect;
import com.intellij.sql.dialects.oracle.OracleElementTypes;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;
import org.jetbrains.annotations.Nullable;

public class OracleParser
extends SqlParser {
    public static final SqlSuggestedInjection ORACLE_INJECTION = new SqlSuggestedInjection("Oracle");

    public OracleParser() {
        super(OracleDialect.INSTANCE);
    }

    protected OracleParser(SqlLanguageDialectEx language) {
        super(language);
    }

    @Override
    protected boolean parseSpecificRoots(IElementType root2, PsiBuilder builder, int level) {
        if (root2 == SqlCompositeElementTypes.SQL_JSON_COLUMNS_CLAUSE) {
            OraDmlParsing.json_columns_clause(builder, level);
            return true;
        }
        if (root2 == SqlCompositeElementTypes.SQL_XML_COLUMNS_CLAUSE) {
            OraDmlParsing.xml_columns_clause(builder, level);
            return true;
        }
        if (root2 == SqlCompositeElementTypes.SQL_XML_NAMESPACES_CLAUSE) {
            OraDmlParsing.xml_namespaces_clause(builder, level);
            return true;
        }
        return super.parseSpecificRoots(root2, builder, level);
    }

    @Override
    public boolean parseReferenceExpression(PsiBuilder builder, SqlReferenceElementType refType) {
        if (refType == OracleElementTypes.ORA_PACKAGE_BODY_REFERENCE) {
            OraGeneratedParser.package_body_ref(builder, 0);
            return true;
        }
        if (refType == OracleElementTypes.ORA_TYPE_BODY_REFERENCE) {
            OraGeneratedParser.type_body_ref(builder, 0);
            return true;
        }
        return super.parseReferenceExpression(builder, refType);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return OraGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return OraGeneratedParser.statement(builder, level);
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return OraDmlParsing.any_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? OraPlParsing.type_element_ext(builder, level) : OraDdlParsing.type_element(builder, level);
    }

    @Override
    protected boolean parseStatementInsideJdbcCall(PsiBuilder builder, int level) {
        return OraPlParsing.statement_inside_jdbc_call(builder, level);
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    @Nullable
    protected IElementType getVariableType(PsiBuilder builder) {
        if (builder.getTokenType() == SQL_COLON && SqlGeneratedParserUtil.isOn(builder, 0, "TRIGGER_BODY")) {
            return SQL_VARIABLE_REFERENCE;
        }
        return super.getVariableType(builder);
    }

    @Override
    public void parseJdbcProcedureCallBody(PsiBuilder builder, int level, boolean refAlreadyParsed) {
        this.parseJdbcProcedureCallBody(builder, level, refAlreadyParsed, SQL_OP_EQ, SQL_OP_ASSIGN);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, OraExpressionParsing::evaluable_expression);
    }

    @Override
    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType resultType) {
        PsiBuilder.Marker mark = builder.mark();
        this.consumeParameterReferenceInner(builder);
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD)) {
            mark.done((IElementType)SQL_VARIABLE_REFERENCE);
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_PERIOD);
            this.parseIdentifier(builder, false);
            mark.precede().done((IElementType)SQL_COLUMN_REFERENCE);
        } else {
            mark.done(resultType);
        }
        return true;
    }

    @Override
    public boolean isReservedKeywordHere(PsiBuilder builder, IElementType type) {
        SqlLanguageDialectEx language = this.getLanguage();
        return type instanceof SqlKeywordTokenType && SqlGeneratedParserUtil.isOn(builder, 0, "PL_DIALECT") ? language.isReservedKeywordPL(type) : language.isReservedKeyword(type);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2;
        boolean bl = result2 = !allowBoolean ? OraExpressionParsing.root_expr(builder, level, 2) : OraExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean plain) {
        if (super.parseFunctionParametersAndParens(builder, level, functionName, definition, plain)) {
            OracleParser.parseAnalyticAggregateFunctionTail(builder, level, definition);
            return true;
        }
        return false;
    }

    @Override
    protected boolean parsePrototypeTail(PsiBuilder builder, int level, SqlFunctionDefinition.Prototype parameter, SqlParser.FunctionParsingContext context) {
        if ("true".equals(parameter.getAttributes().get("aggregate"))) {
            OraGeneratedParser.aggregate_clause(builder, level);
        }
        if ("true".equals(parameter.getAttributes().get("analytic"))) {
            OraGeneratedParser.keep_clause(builder, level);
            OraGeneratedParser.analytic_clause(builder, level);
        }
        return super.parsePrototypeTail(builder, level, parameter, context);
    }

    @Override
    public boolean parseNamedFunctionArgumentPrefix(PsiBuilder builder, int level) {
        return this.parseNamedFunctionArgumentPrefixImpl(builder, (IElementType)SqlTokens.ORA_OP_NAMED_PARAM_BINDING);
    }

    @Override
    public boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return OraGeneratedParser.statement_recover_prefix(builder, level);
    }

    @Override
    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return ORACLE_INJECTION;
    }

    public static void parseAnalyticAggregateFunctionTail(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        if (definition == null) {
            return;
        }
        if ("true".equals(definition.getDialectAttribute("aggregate"))) {
            OraGeneratedParser.aggregate_clause(builder, level);
        }
        if ("true".equals(definition.getDialectAttribute("analytic"))) {
            OraGeneratedParser.keep_clause(builder, level);
            OraGeneratedParser.analytic_clause(builder, level);
        }
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        OraGeneratedParser.keep_clause(builder, level);
        OraGeneratedParser.analytic_clause(builder, level);
        return OraExpressionParsing.opt_dblink_ref(builder, level);
    }

    public boolean convertToUseStatement(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame.elementType = SQL_USE_SCHEMA_STATEMENT;
        return true;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, OraExpressionParsing::parenthesized_values_expr, OraDmlParsing::any_query_expression, OracleParser::parseTopQueryExpressionTail, OraExpressionParsing::row_element_list, (b, l) -> OraExpressionParsing.root_expr_0(b, l, -1) && OraExpressionParsing.row_element_list_separator(b, l) && OraExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, OraDmlParsing::parenthesized_aliased_join_expression, OraDmlParsing::any_query_expression, OracleParser::parseTopQueryExpressionTail, (b, l) -> OraDmlParsing.join_expression(b, l, -1), (b, l) -> OraDmlParsing.join_expression_0(b, l, -1));
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        OraDmlParsing.query_expression_0(builder, level, -1);
        return OraDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

