/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.plus;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.OracleParser;
import com.intellij.sql.dialects.oracle.plus.OrapDialect;
import com.intellij.sql.dialects.oracle.plus.OrapElementTypes;
import com.intellij.sql.dialects.oracle.plus.OrapGeneratedParser;
import com.intellij.sql.dialects.oracle.plus.OrapTokens;
import com.intellij.sql.dialects.oracle.plus.OrapTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.parser.BidirectionalTokenMapper;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;
import java.util.regex.Pattern;

public class OrapParser
extends OracleParser {
    private static final Pattern PARAM_PATTERN = Pattern.compile("&\\d+");
    private static final BidirectionalTokenMapper TOKEN_MAPPER = BidirectionalTokenMapper.builder().add((IElementType)OrapTokens.ORAP_WS_DELIMITER_TOKEN, (IElementType)ORAP_DELIMITER_TOKEN).build();
    private boolean myPlusContext = true;

    public OrapParser() {
        super(OrapDialect.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        this.setPlusContext(builder, true);
        if (OrapGeneratedParser.root_statement(builder, level)) {
            return true;
        }
        try {
            this.setPlusContext(builder, false);
            boolean bl = super.parseSqlStatement(builder, level);
            return bl;
        }
        finally {
            this.setPlusContext(builder, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseJdbcProcedureCall(PsiBuilder builder, int level) {
        boolean prev = this.myPlusContext;
        try {
            this.setPlusContext(builder, false);
            boolean bl = super.parseJdbcProcedureCall(builder, level);
            return bl;
        }
        finally {
            this.setPlusContext(builder, prev);
        }
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        SqlReferenceElementType result2;
        String tokenText = builder.getTokenText();
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT) && PARAM_PATTERN.matcher(tokenText).matches()) {
            this.consumeIdentifier(builder);
            result2 = SQL_PARAMETER_REFERENCE;
        } else if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_OP_BITWISE_AND)) {
            PsiBuilder.Marker variableMarker = builder.mark();
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_OP_BITWISE_AND);
            this.parseIdentifier(builder, false);
            this.consumeAppend(builder);
            variableMarker.done((IElementType)SQL_VARIABLE_REFERENCE);
            result2 = SQL_PARAMETER_REFERENCE;
        } else if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_OP_LOGICAL_AND)) {
            PsiBuilder.Marker variableMarker = builder.mark();
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_OP_LOGICAL_AND);
            this.parseIdentifier(builder, false);
            variableMarker.done((IElementType)SQL_VARIABLE_REFERENCE);
            result2 = SQL_PARAMETER_REFERENCE;
        } else {
            result2 = super.consumeCustomParameterReference(builder);
        }
        return result2;
    }

    @Override
    protected boolean isWhitespace(IElementType type) {
        return type == SqlTokens.ORAP_DELIMITER_TOKEN || OrapElementTypes.WHITE_SPACE_TOKENS.contains(type);
    }

    @Override
    public boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return super.statementRecoverPrefixParser(builder, level) || OrapGeneratedParser.statement_recover_prefix(builder, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean statementRecover(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser prefixParser) {
        boolean prev = this.myPlusContext;
        try {
            this.setPlusContext(builder, true);
            boolean bl = super.statementRecover(builder, level, prefixParser);
            return bl;
        }
        finally {
            this.setPlusContext(builder, prev);
        }
    }

    private void consumeAppend(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (SqlParserUtil.consumeOneOfTokens(builder, OraTypes.ORA_DOT_DOT, OrapTypes.ORAP_DOT) != null && this.consumeIdentifier(builder)) {
            marker.drop();
        } else {
            marker.rollbackTo();
        }
    }

    @Override
    public boolean parseReferenceExpressionOrVariable(PsiBuilder builder, SqlReferenceElementType refType) {
        if (OrapParser.isSqlPlusVariableReference(builder)) {
            return this.parseParameterOrVariableReference(builder, false);
        }
        return super.parseReferenceExpressionOrVariable(builder, refType);
    }

    private static boolean isSqlPlusVariableReference(PsiBuilder builder) {
        return StringUtil.startsWithChar((CharSequence)builder.getTokenText(), (char)'&');
    }

    private void setPlusContext(PsiBuilder builder, boolean plus) {
        this.myPlusContext = plus;
        builder.setTokenTypeRemapper(plus ? TOKEN_MAPPER.getDirect() : TOKEN_MAPPER.getReverse());
    }
}

