/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.ChooseConsoleAction;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveConfigurable;
import com.intellij.sql.highlighting.SqlAnnotator;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGrantStatement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlRevokeStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.resolve", new Object[0]);
        if (string == null) {
            SqlResolveInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlResolveInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlResolveInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlResolveInspection.$$$reportNull$$$0(3);
        }
        final SyntaxTraverser traverser2 = (SyntaxTraverser)SqlImplUtil.sqlTraverser().filter(Conditions.instanceOf(SqlReferenceExpression.class));
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){
            final Map<PsiFile, List<DbDataSource>> dataSources;
            {
                super(manager, dialect2, results);
                this.dataSources = FactoryMap.create(o -> SqlImplUtil.getDataSources((PsiElement)o));
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression re) {
                if (re == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiElement element : (SyntaxTraverser)traverser2.withRoot((Object)re)) {
                    SqlReferenceExpression o = (SqlReferenceExpression)element;
                    if (this.shouldNotCheckElement((SqlElement)o)) {
                        return;
                    }
                    ObjectKind type = o.getReferenceElementType().getTargetKind();
                    if (!this.myDialect.shallResolve(o, type)) {
                        return;
                    }
                    SqlExpression qualifier = o.getQualifierExpression();
                    SqlIdentifier identifier = o.getIdentifier();
                    boolean afterIfExists = this.afterIfExistsClause(o);
                    if (qualifier instanceof SqlReferenceExpression) {
                        if (((SqlReferenceExpression)qualifier).resolve() == null) continue;
                        this.checkIdentifier(identifier, afterIfExists);
                        break;
                    }
                    this.checkIdentifier(identifier, afterIfExists);
                }
            }

            private void checkIdentifier(@Nullable SqlIdentifier identifier, boolean afterIfExists) {
                if (identifier == null || afterIfExists) {
                    return;
                }
                this.checkResolve(identifier);
            }

            private boolean afterIfExistsClause(@NotNull SqlReferenceExpression o) {
                PsiElement parent;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ((parent = o.getParent()) instanceof SqlDropStatement || parent instanceof SqlAlterStatement || parent instanceof SqlAlterInstruction) && FormatterUtil.hasPrecedingSiblingOfType((ASTNode)o.getNode(), (IElementType)SqlCompositeElementTypes.SQL_IF_EXISTS_CLAUSE, (IElementType[])new IElementType[0]);
            }

            public void visitSqlIdentifier(@NotNull SqlIdentifier o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (o.getParent() instanceof SqlRenameToClause) {
                    return;
                }
                this.checkResolve(o);
            }

            public void visitSqlParameter(SqlParameter o) {
            }

            private boolean checkResolve(@Nullable SqlIdentifier o) {
                SqlFunctionCallExpression foo;
                boolean isFunction;
                PsiElement grandPa;
                if (o == null || o.getTextLength() == 0) {
                    return false;
                }
                IElementType firstChildType = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
                if (firstChildType == SqlTokens.SQL_EXTERNAL_PARAM || firstChildType == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || firstChildType == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE) {
                    return true;
                }
                if (o.getFirstChild() instanceof SqlParameter) {
                    return true;
                }
                if (o.getLastChild() instanceof SqlParameter) {
                    return true;
                }
                PsiElement parent = o.getParent();
                PsiElement psiElement = grandPa = parent == null ? null : parent.getParent();
                if (parent instanceof SqlReferenceExpression && grandPa instanceof SqlDefinition && grandPa instanceof SqlAlterStatement) {
                    return this.checkAlterResolve(o, (SqlDefinition)grandPa);
                }
                PsiElement target = SqlAnnotator.getTargetElement(o);
                if (target == parent && "*".equals(o.getText()) && (!(parent instanceof SqlExpression) || SqlType.UNKNOWN == ((SqlExpression)parent).getSqlType())) {
                    SqlStatement st = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)o, SqlStatement.class);
                    if (st instanceof SqlGrantStatement || st instanceof SqlRevokeStatement) {
                        return true;
                    }
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, "Unable to resolve * in this context", true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, new LocalQuickFix[0]));
                    return false;
                }
                if (target != null) {
                    return true;
                }
                ObjectKind expectedType = parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                boolean bl = isFunction = expectedType == ObjectKind.ROUTINE;
                if (isFunction && parent.getParent().getParent() instanceof JdbcProcedureCall) {
                    return true;
                }
                SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
                if (expectedType == ObjectKind.ARGUMENT && (foo = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)api.parents((Object)parent).skip(3).first(), SqlFunctionCallExpression.class)) != null) {
                    if (foo.getParent() instanceof JdbcProcedureCall) {
                        return true;
                    }
                    SqlReferenceExpression name = foo.getNameElement();
                    if (name == null || name.resolve() == null) {
                        return true;
                    }
                }
                String kindName = DbPresentation.getPresentableName(expectedType, SqlImplUtil.getSqlDialectSafe((PsiElement)o).getDatabaseDialect());
                String message = isFunction ? SqlMessages.message("unknown.function", o.getName()) : (expectedType != SqlDbElementType.ANY ? SqlMessages.message("unable.to.resolve.symbol.0.1", kindName, o.getName()) : SqlMessages.message("unable.to.resolve.symbol.0", o.getName()));
                List<LocalQuickFix> fixes = this.createQuickFixesFor(o, parent, expectedType);
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, onTheFly ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY));
                return false;
            }

            private boolean checkAlterResolve(SqlIdentifier o, SqlDefinition def2) {
                boolean resolved;
                Object[] elements = SqlImplUtil.getRelatedElements(def2);
                boolean bl = resolved = elements.length != 0;
                if (resolved) {
                    PsiElement res = (PsiElement)JBIterable.of((Object[])elements).filter(x -> !(x instanceof SqlAlterStatement)).first();
                    boolean bl2 = resolved = res != null;
                }
                if (!resolved) {
                    String message = SqlMessages.message("unable.to.resolve.symbol.0.1", def2.getKind(), o.getName());
                    List<LocalQuickFix> fixes = this.createQuickFixesFor(o, o.getParent(), def2.getKind());
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, onTheFly ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY));
                }
                return resolved;
            }

            @NotNull
            private List<LocalQuickFix> createQuickFixesFor(@NotNull SqlIdentifier o, @Nullable PsiElement parent, @NotNull ObjectKind expectedType) {
                boolean addGenericFixes;
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (expectedType == null) {
                    1.$$$reportNull$$$0(4);
                }
                ArrayList result2 = ContainerUtil.newArrayList();
                if (expectedType == ObjectKind.TABLE) {
                    result2.add(new AddSqlTableFix(o));
                    result2.add(new AddDbTableFix(o));
                } else if (expectedType == ObjectKind.COLUMN) {
                    if (parent instanceof SqlReferenceExpression) {
                        Object reference;
                        SqlExpression qualifierExpression = ((SqlReferenceExpression)parent).getQualifierExpression();
                        if (qualifierExpression instanceof SqlReferenceExpression) {
                            SqlExpression expression;
                            PsiElement resolve;
                            reference = qualifierExpression.getReference();
                            PsiElement psiElement = resolve = reference != null ? reference.resolve() : null;
                            if (resolve instanceof DbTable && ((DbTable)resolve).getKind() == ObjectKind.TABLE) {
                                result2.add(new AddDbColumnFix(o, (DbTable)resolve));
                            } else if (resolve instanceof SqlAsExpression && (expression = ((SqlAsExpression)resolve).getExpression()) instanceof SqlReferenceExpression) {
                                PsiElement resolveResult;
                                PsiReference psiReference = expression.getReference();
                                PsiElement psiElement2 = resolveResult = psiReference != null ? psiReference.resolve() : null;
                                if (resolveResult instanceof DbTable && ((DbTable)resolveResult).getKind() == ObjectKind.TABLE) {
                                    result2.add(new AddDbColumnFix(o, (DbTable)resolveResult));
                                } else if (resolveResult instanceof SqlCreateTableStatement) {
                                    result2.add(new AddSqlColumnFix(o, (SqlCreateTableStatement)resolveResult));
                                }
                            }
                        } else {
                            reference = (SqlReferenceImpl)ObjectUtils.tryCast((Object)((SqlReferenceExpression)parent).getReference(), SqlReferenceImpl.class);
                            if (reference != null) {
                                MyResolveContextProcessor processor = new MyResolveContextProcessor(((SqlReferenceImpl)reference).getReferenceName(), this.myDialect, (Iterable<DbDataSource>)this.dataSources.get(parent.getContainingFile()), parent);
                                if (((SqlReferenceImpl)reference).initExpectedTargetTypes(processor)) {
                                    ((SqlReferenceImpl)reference).processResolveVariants(processor);
                                }
                                for (DbTable dbTable : processor.dbTables) {
                                    if (dbTable.getKind() != ObjectKind.TABLE) continue;
                                    result2.add(new AddDbColumnFix(o, dbTable));
                                }
                                for (SqlCreateTableStatement sqlCreateTableStatement : processor.sqlTables) {
                                    result2.add(new AddSqlColumnFix(o, sqlCreateTableStatement));
                                }
                            }
                        }
                    }
                } else {
                    SqlReferenceImpl ref;
                    SqlReferenceImpl sqlReferenceImpl = ref = parent instanceof SqlReferenceExpression ? (SqlReferenceImpl)ObjectUtils.tryCast((Object)parent.getReference(), SqlReferenceImpl.class) : null;
                    if (ref != null) {
                        MyResolveContextProcessor processor = new MyResolveContextProcessor(ref.getReferenceName(), this.myDialect, (Iterable<DbDataSource>)this.dataSources.get(parent.getContainingFile()), parent);
                        ref.initExpectedTargetTypes(processor);
                        boolean schemaExpected = processor.isExpected(ObjectKind.SCHEMA);
                        boolean dbExpected = processor.isExpected(ObjectKind.DATABASE);
                        if (schemaExpected || dbExpected) {
                            String name;
                            List candidates;
                            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)((SqlReferenceExpression)parent).getQualifierExpression(), SqlReferenceExpression.class);
                            Object[] resolved = sqlReferenceExpression == null ? ResolveResult.EMPTY_ARRAY : sqlReferenceExpression.multiResolve(false);
                            JBIterable namespaces = JBIterable.empty();
                            if (resolved.length == 0) {
                                SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)o.getContainingFile(), SqlFile.class);
                                if (file != null) {
                                    SqlImportState checker = SqlDialectImplUtil.getImportCheckerAt(file, (PsiElement)o);
                                    for (DbDataSource source : processor.dataSources) {
                                        BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)source.getDelegate().getModel(), BasicModel.class);
                                        if (model == null) continue;
                                        namespaces = namespaces.append((Iterable)((JBTreeTraverser)model.traverser(true).expand(SqlFileImpl.importedCondition(checker, source))).filter(BasicMateNamespace.class).transform(n -> Pair.create((Object)source, (Object)n)));
                                    }
                                }
                            } else {
                                namespaces = JBIterable.of((Object[])resolved).map(ResolveResult::getElement).filter(DbElement.class).flatten(e -> {
                                    BasicElement object = (BasicElement)ObjectUtils.tryCast((Object)e.getDelegate(), BasicElement.class);
                                    DbDataSource source = e.getDataSource();
                                    return object == null ? JBIterable.empty() : object.getChildren().filter(BasicMateNamespace.class).map(n -> Pair.create((Object)source, (Object)n));
                                });
                            }
                            if (!(candidates = namespaces.filter(arg_0 -> 1.lambda$createQuickFixesFor$5(name = ref.getReferenceName(), dialect, schemaExpected, dbExpected, arg_0)).toList()).isEmpty()) {
                                ObjectKind kind = dbExpected && schemaExpected ? ObjectKind.NONE : (dbExpected ? ObjectKind.DATABASE : ObjectKind.SCHEMA);
                                result2.add(new IntrospectSchemaFix(candidates, kind));
                            }
                        }
                    }
                }
                VirtualFile file = SqlImplUtil.getTopLevelFile(o.getContainingFile());
                boolean bl = addGenericFixes = expectedType != ObjectKind.COLUMN && file != null && !(file.getFileSystem() instanceof NonPhysicalFileSystem) && !DbSrcUtils.isDbSrcFile(file) && !DbConsoleRootType.isConsoleFile(file);
                if (addGenericFixes) {
                    result2.add(new GoToResolutionScopesFix());
                    if (onTheFly && JdbcConsoleProvider.getAttachedConsole(o.getProject(), file) == null) {
                        result2.add(new AttachConsoleFix());
                    }
                }
                ArrayList arrayList = result2;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(5);
                }
                return arrayList;
            }

            private static /* synthetic */ boolean lambda$createQuickFixesFor$5(String name, @NotNull SqlLanguageDialectEx dialect2, boolean schemaExpected, boolean dbExpected, Pair n) {
                if (dialect2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                return !((BasicMateNamespace)n.second).isVisible() && DasUtil.nameEqual((DasObject)((DasObject)n.second), (String)name, (CasingProvider)dialect2) && (((BasicMateNamespace)n.second).getKind() == ObjectKind.SCHEMA && schemaExpected || ((BasicMateNamespace)n.second).getKind() == ObjectKind.DATABASE && dbExpected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "re";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$1";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dialect";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$1";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createQuickFixesFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSqlReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "afterIfExistsClause";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSqlIdentifier";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createQuickFixesFor";
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$createQuickFixesFor$5";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private static Collection<String> collectColumnNames(@NotNull SqlIdentifier element, @NotNull SqlStatement statement) {
        if (element == null) {
            SqlResolveInspection.$$$reportNull$$$0(4);
        }
        if (statement == null) {
            SqlResolveInspection.$$$reportNull$$$0(5);
        }
        SqlLanguageDialectEx sqlLanguage = SqlImplUtil.getSqlDialectSafe((PsiElement)statement);
        CasingProvider casingProvider = SqlImplUtil.getCasingProvider(sqlLanguage, SqlImplUtil.getDataSources((PsiElement)statement));
        SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlAsExpression.class);
        LinkedHashSet columnsNames = ContainerUtil.newLinkedHashSet();
        JBIterable iterable = SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlReferenceExpression.class);
        for (SqlReferenceExpression e : iterable) {
            ObjectKind type = e.getReferenceElementType().getTargetKind();
            PsiPolyVariantReference reference = e.getReference();
            SqlIdentifier identifier = e.getIdentifier();
            if (type != ObjectKind.COLUMN || identifier == null || reference.resolve() != null) continue;
            SqlReferenceExpression qualifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)e.getQualifierExpression(), SqlReferenceExpression.class);
            if (asExpression != null && qualifier != null && !asExpression.equals(qualifier.resolve()) && !new NameChecker(qualifier, sqlLanguage, casingProvider).checkName(element.getParent(), false)) continue;
            columnsNames.add(identifier.getText());
        }
        LinkedHashSet linkedHashSet = columnsNames;
        if (linkedHashSet == null) {
            SqlResolveInspection.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectColumnNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectColumnNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolveContextProcessor
    extends SqlScopeProcessor {
        final Set<DbTable> dbTables;
        final Set<SqlCreateTableStatement> sqlTables;

        MyResolveContextProcessor(@NotNull String referenceName, @NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<DbDataSource> dataSources2, @Nullable PsiElement place) {
            if (referenceName == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(1);
            }
            if (dataSources2 == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(2);
            }
            super(referenceName, dialect, dataSources2, place);
            this.dbTables = new HashSet<DbTable>();
            this.sqlTables = new HashSet<SqlCreateTableStatement>();
        }

        @Override
        public boolean isResultEmpty() {
            return this.dbTables.isEmpty() && this.sqlTables.isEmpty();
        }

        @Override
        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object context) {
            if (event == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(3);
            }
            super.handleEvent(event, context);
            if (event != SqlScopeProcessor.RESOLVE_CONTEXT) {
                return;
            }
            if (!(context instanceof PsiElement)) {
                return;
            }
            if (context instanceof SqlDmlInstruction) {
                SqlExpression targetExpression = ((SqlDmlInstruction)context).getTargetExpression();
                this.processReference(targetExpression == null ? null : targetExpression.getReference());
            }
            PsiElement contextParent = ((PsiElement)context).getParent();
            PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement o) {
                    if (o instanceof SqlReferenceExpression) {
                        this.processReference(o.getReference());
                        return;
                    }
                    super.visitElement(o);
                }
            };
            if (contextParent instanceof SqlQueryExpression) {
                SqlTableExpression tableExpression = ((SqlQueryExpression)contextParent).getTableExpression();
                if (tableExpression != null) {
                    tableExpression.accept((PsiElementVisitor)visitor);
                }
            } else if (contextParent instanceof SqlTableColumnsList) {
                SqlReferenceExpression tableReference = ((SqlTableColumnsList)contextParent).getTableReference();
                this.processReference((PsiReference)(tableReference == null ? null : tableReference.getReference()));
            } else if (contextParent instanceof SqlTableExpression) {
                contextParent.accept((PsiElementVisitor)visitor);
            } else if (contextParent instanceof SqlAlterStatement) {
                SqlReferenceExpression reference = ((SqlAlterStatement)contextParent).getAlterTargetReference();
                this.processReference((PsiReference)(reference == null ? null : reference.getReference()));
            } else if (context instanceof PsiObject) {
                this.processObject((PsiElement)context);
            }
        }

        private void processReference(@Nullable PsiReference ref) {
            this.processObject(ref != null ? ref.resolve() : null);
        }

        private void processObject(PsiElement resolve) {
            if (resolve instanceof DbTable) {
                this.dbTables.add((DbTable)resolve);
            } else if (resolve instanceof SqlCreateTableStatement) {
                this.sqlTables.add((SqlCreateTableStatement)resolve);
            }
        }

        @Override
        public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
            if (element == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(4);
            }
            if (state == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(5);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleEvent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeTarget";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddDbColumnFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        final ObjectPath myTable;
        final String myColumnName;

        AddDbColumnFix(@NotNull SqlIdentifier o, @NotNull DbTable table) {
            if (o == null) {
                AddDbColumnFix.$$$reportNull$$$0(0);
            }
            if (table == null) {
                AddDbColumnFix.$$$reportNull$$$0(1);
            }
            super(o);
            this.myColumnName = o.getName();
            this.myTable = ObjectPaths.of((DasObject)table);
        }

        @Override
        @NotNull
        public String getText() {
            String string = "Add '" + this.myColumnName + "' to '" + this.myTable.getName() + "' table";
            if (string == null) {
                AddDbColumnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element, @Nullable Editor editor) {
            DbDataSourceImpl dataSource;
            if (project == null) {
                AddDbColumnFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                AddDbColumnFix.$$$reportNull$$$0(4);
            }
            if ((dataSource = (DbDataSourceImpl)DbImplUtil.getForcedDataSource(element.getContainingFile())) == null) {
                return;
            }
            DasObject object = DbSrcUtils.findObject(this.myTable, dataSource.getModel(), DasObject.class);
            DbElement table = dataSource.findElement(object);
            if (table == null || table.getKind() != ObjectKind.TABLE) {
                return;
            }
            TransactionGuard.getInstance().submitTransactionLater((Disposable)project, () -> {
                if (element == null) {
                    AddDbColumnFix.$$$reportNull$$$0(5);
                }
                DdlActions.AddColumnAction.perform((DbTable)table, null, element.getText());
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddDbTableFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        AddDbTableFix(@Nullable SqlIdentifier o) {
            super(o);
        }

        @Override
        @NotNull
        public String getText() {
            if ("Add table to data source" == null) {
                AddDbTableFix.$$$reportNull$$$0(0);
            }
            return "Add table to data source";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element, @Nullable Editor editor) {
            List strings;
            if (project == null) {
                AddDbTableFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AddDbTableFix.$$$reportNull$$$0(2);
            }
            DbDataSource dataSource = DbImplUtil.getForcedDataSource(element.getContainingFile());
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
            Collection collection = strings = statement == null ? ContainerUtil.emptyList() : SqlResolveInspection.collectColumnNames(element, statement);
            if (dataSource != null) {
                AddDbTableFix.showDialog(dataSource, element, strings);
            } else if (editor != null) {
                ArrayList runners = ContainerUtil.newArrayList();
                for (DbDataSource source : DbPsiFacade.getInstance((Project)project).getDataSources()) {
                    runners.add(JdbcConsoleProvider.newRunner(source, () -> {
                        if (element == null) {
                            AddDbTableFix.$$$reportNull$$$0(12);
                        }
                        AddDbTableFix.showDialog(source, element, strings);
                    }));
                }
                RunQueryInConsoleIntentionAction.chooseAndRunRunners("Data Sources", runners, editor, null);
            }
        }

        private static void showDialog(@NotNull DbDataSource source, @NotNull SqlIdentifier element, @NotNull Collection<String> strings) {
            if (source == null) {
                AddDbTableFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                AddDbTableFix.$$$reportNull$$$0(4);
            }
            if (strings == null) {
                AddDbTableFix.$$$reportNull$$$0(5);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (source == null) {
                    AddDbTableFix.$$$reportNull$$$0(6);
                }
                if (element == null) {
                    AddDbTableFix.$$$reportNull$$$0(7);
                }
                if (strings == null) {
                    AddDbTableFix.$$$reportNull$$$0(8);
                }
                TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                    if (source == null) {
                        AddDbTableFix.$$$reportNull$$$0(9);
                    }
                    if (element == null) {
                        AddDbTableFix.$$$reportNull$$$0(10);
                    }
                    if (strings == null) {
                        AddDbTableFix.$$$reportNull$$$0(11);
                    }
                    DdlActions.AddTableAction.showAddTableDialogAndRun(source, null, element.getText(), strings);
                });
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showDialog";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$showDialog$2";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$1";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddSqlTableFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        public AddSqlTableFix(SqlIdentifier o) {
            super(o);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlMessages.message("quickfix.name.create.table.definition", new Object[0]);
            if (string == null) {
                AddSqlTableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element, @Nullable Editor editor) {
            if (project == null) {
                AddSqlTableFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AddSqlTableFix.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                return;
            }
            SqlStatement placeForInsertBefore = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, SqlStatement.class);
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
            if (statement == null || placeForInsertBefore == null) {
                return;
            }
            Collection columnsNames = SqlResolveInspection.collectColumnNames(element, statement);
            int offset = placeForInsertBefore.getTextRange().getStartOffset();
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = AddSqlTableFix.getTemplate(templateManager, (PsiElement)element, columnsNames);
            if (template == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(offset);
            templateManager.startTemplate(editor, template);
        }

        @Nullable
        private static Template getTemplate(@NotNull TemplateManager templateManager, @NotNull PsiElement element, @NotNull Collection<String> columnsNames) {
            if (templateManager == null) {
                AddSqlTableFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                AddSqlTableFix.$$$reportNull$$$0(4);
            }
            if (columnsNames == null) {
                AddSqlTableFix.$$$reportNull$$$0(5);
            }
            if (columnsNames.isEmpty()) {
                TemplateImpl template = TemplateSettings.getInstance().getTemplate("tab", "SQL");
                if (template == null) {
                    return null;
                }
                TemplateImpl copy = template.copy();
                Variable variable = (Variable)copy.getVariables().get(0);
                assert ("table".equals(variable.getName()));
                variable.setDefaultValueString("\"" + element.getText() + "\"");
                variable.setAlwaysStopAt(false);
                return copy;
            }
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            template.addTextSegment("create table " + element.getText() + " (\n");
            int size = columnsNames.size();
            int i2 = 0;
            for (String name : columnsNames) {
                template.addTextSegment(name);
                template.addTextSegment(" ");
                template.addVariable("type" + i2, (Expression)new ConstantNode("int"), true);
                template.addTextSegment(" ");
                template.addVariable("not_null" + i2, (Expression)new ConstantNode("not null"), true);
                if (i2 != size - 1) {
                    template.addTextSegment(",");
                }
                template.addTextSegment("\n");
                ++i2;
            }
            template.addTextSegment(");\n");
            return template;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnsNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddSqlColumnFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        final SmartPsiElementPointer<SqlCreateTableStatement> myTable;
        final String myTableName;
        final String myColumnName;

        AddSqlColumnFix(@NotNull SqlIdentifier o, @NotNull SqlCreateTableStatement table) {
            if (o == null) {
                AddSqlColumnFix.$$$reportNull$$$0(0);
            }
            if (table == null) {
                AddSqlColumnFix.$$$reportNull$$$0(1);
            }
            super(o);
            this.myTable = SmartPointerManager.getInstance((Project)o.getProject()).createSmartPsiElementPointer((PsiElement)table);
            this.myTableName = table.getName();
            this.myColumnName = o.getName();
        }

        @Override
        @NotNull
        public String getText() {
            String string = "Add column '" + this.myColumnName + "'to '" + this.myTableName + "' table";
            if (string == null) {
                AddSqlColumnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element, @Nullable Editor editor) {
            if (project == null) {
                AddSqlColumnFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                AddSqlColumnFix.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                return;
            }
            SqlCreateTableStatement table = (SqlCreateTableStatement)this.myTable.getElement();
            if (table == null) {
                return;
            }
            PsiColumn last = (PsiColumn)ContainerUtil.getLastItem((List)table.getColumns());
            int offset = -1;
            boolean insertComma = true;
            if (last == null) {
                ASTNode lParen = table.getNode().findChildByType((IElementType)SqlTokens.SQL_LEFT_PAREN);
                if (lParen != null) {
                    offset = lParen.getTextRange().getEndOffset();
                    insertComma = false;
                }
            } else {
                offset = last.getTextRange().getEndOffset();
            }
            if (offset == -1) {
                return;
            }
            TemplateManager instance = TemplateManager.getInstance((Project)project);
            TemplateImpl template = TemplateSettings.getInstance().getTemplate("col", "SQL");
            if (template == null) {
                return;
            }
            TemplateImpl copy = template.copy();
            Variable variable = (Variable)copy.getVariables().get(0);
            assert ("col".equals(variable.getName()));
            variable.setDefaultValueString("\"" + element.getText() + "\"");
            variable.setAlwaysStopAt(false);
            editor.getCaretModel().moveToOffset(offset);
            String newLine = (insertComma ? "," : "") + "\n";
            editor.getDocument().insertString(offset, (CharSequence)newLine);
            editor.getCaretModel().moveToOffset(offset + newLine.length());
            instance.startTemplate(editor, (Template)copy);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IntrospectSchemaFix
    extends IntentionAndQuickFixAction {
        final List<Pair<DbDataSource, BasicMateNamespace>> myCandidates;
        final String myKindName;

        IntrospectSchemaFix(@NotNull List<Pair<DbDataSource, BasicMateNamespace>> candidates, @NotNull ObjectKind kind) {
            if (candidates == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates;
            this.myKindName = StringUtil.capitalize((String)DbPresentation.getPresentableName(kind, GenericDialect.INSTANCE));
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = "Introspect " + this.myKindName;
            if (string == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(4);
            }
            if (this.myCandidates.size() <= 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                IntrospectSchemaFix.setVisible(this.myCandidates);
            } else {
                final Set ds = JBIterable.from(this.myCandidates).transform(p -> (DbDataSource)p.first).toSet();
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<Pair<DbDataSource, BasicMateNamespace>>("Add to View", this.myCandidates){

                    public Icon getIconFor(Pair<DbDataSource, BasicMateNamespace> value) {
                        return DbPresentation.getIcon((DasObject)value.second);
                    }

                    @NotNull
                    public String getTextFor(Pair<DbDataSource, BasicMateNamespace> value) {
                        BasicElement parent = (BasicElement)ObjectUtils.notNull((Object)((BasicMateNamespace)value.second).getParent());
                        StringBuilder text = new StringBuilder();
                        if (ds.size() > 1) {
                            text.append(((DbDataSource)value.first).getName()).append("\u2006.\u2006");
                        }
                        if (parent.getKind() != ObjectKind.ROOT) {
                            text.append(parent.getName()).append("\u2006.\u2006");
                        }
                        text.append(((BasicMateNamespace)value.second).getName());
                        String string = text.toString();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public PopupStep<?> onChosen(List<Pair<DbDataSource, BasicMateNamespace>> selectedValues, boolean finalChoice) {
                        IntrospectSchemaFix.setVisible(selectedValues);
                        return FINAL_CHOICE;
                    }

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix$1", "getTextFor"));
                    }
                }).showCenteredInCurrentWindow(project);
            }
        }

        private static void setVisible(List<Pair<DbDataSource, BasicMateNamespace>> selectedValues) {
            MultiMap byDs = MultiMap.create();
            selectedValues.forEach(e -> byDs.putValue(e.first, e.second));
            for (Map.Entry entry : byDs.entrySet()) {
                BasicNamespace item = (BasicNamespace)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue()));
                if (item == null) continue;
                DataSourceUiUtil.setNamespacesVisible((DbDataSource)entry.getKey(), (Iterable)entry.getValue(), true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AttachConsoleFix
    extends IntentionAndQuickFixAction {
        private AttachConsoleFix() {
        }

        @NotNull
        public String getName() {
            if ("Attach console" == null) {
                AttachConsoleFix.$$$reportNull$$$0(0);
            }
            return "Attach console";
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                AttachConsoleFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                AttachConsoleFix.$$$reportNull$$$0(2);
            }
            if (editor == null || !EditorUtil.isRealFileEditor((Editor)editor)) {
                return;
            }
            ChooseConsoleAction action = new ChooseConsoleAction();
            action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext((Component)editor.getContentComponent())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AttachConsoleFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AttachConsoleFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GoToResolutionScopesFix
    extends IntentionAndQuickFixAction {
        private GoToResolutionScopesFix() {
        }

        @NotNull
        public String getName() {
            if ("Go to SQL Resolution Scopes" == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(0);
            }
            return "Go to SQL Resolution Scopes";
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(2);
            }
            SqlResolveConfigurable.openResolveScopesConfigurable(project, SqlImplUtil.getTopLevelFile(file));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

