/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.type", new Object[0]);
        if (string == null) {
            SqlTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlTypeInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlTypeInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlTypeInspection.$$$reportNull$$$0(3);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlAsExpression(SqlAsExpression o) {
                super.visitSqlAsExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlExpression expression = o.getExpression();
                SqlType type = expression.getSqlType();
                SqlType asType = o.getSqlType();
                List aliases = o.getColumnAliasList();
                boolean checkType = true;
                if (dialect.getFamilyId().isPostgres() && !aliases.isEmpty()) {
                    checkType = PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)aliases.get(0)), SqlTypeElement.class) == null;
                }
                if (checkType &= !(expression instanceof SqlTableExpression) || type != SqlTableTypeBase.EMPTY_TABLE) {
                    this.checkTypesMatching(type, asType, (PsiElement)o.getNameElement());
                }
                this.checkNamesUnique(aliases, null);
                if (asType instanceof SqlTableType) {
                    this.checkColumnAliasesRequired((SqlTableType)asType, o.getNameElement());
                }
            }

            private void checkColumnAliasesRequired(SqlTableType type, SqlIdentifier elementToHighlight) {
                DatabaseFamilyId familyId = dialect.getFamilyId();
                if (!(familyId.isDerby() || familyId.isH2() || familyId.isMysql() || familyId.isMicrosoft() || familyId == DatabaseFamilyId.UNKNOWN)) {
                    return;
                }
                THashSet s = new THashSet();
                for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
                    String name = type.getColumnName(i2);
                    if (!StringUtil.isNotEmpty((String)name) || s.add((Object)name)) continue;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)elementToHighlight, SqlMessages.message("column.aliases.required", type.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    break;
                }
            }

            public void visitSqlCreateViewStatement(SqlCreateViewStatement o) {
                SqlType type;
                super.visitSqlCreateViewStatement(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlExpression expression = o.getQueryExpression();
                SqlType sqlType = type = expression != null ? expression.getSqlType() : null;
                if (type != null && type != SqlTableTypeBase.EMPTY_TABLE) {
                    this.checkTypesMatching(type, (SqlType)SqlTableTypeBase.createType((PsiTable)o, null), (PsiElement)o.getNameElement());
                }
                this.checkNamesUnique(Arrays.asList(o.getColumnAliases()), (SqlCreateStatement)o);
            }

            public void visitSqlCreateTableStatement(SqlCreateTableStatement o) {
                super.visitSqlCreateTableStatement(o);
                this.checkNamesUnique(ContainerUtil.filter((Collection)o.getColumns(), (Condition)new FilteringIterator.InstanceOf(SqlDefinition.class)), (SqlCreateStatement)o);
            }

            public void visitSqlUnaryExpression(SqlUnaryExpression o) {
                super.visitSqlUnaryExpression(o);
                IElementType sign = o.getOpSign();
                if (!SqlTypeInspection.isOperatorSupported(sign, this.myDialect)) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(o.getOpSignElement(), SqlMessages.message("operator.0.not.supported.by.dialect.1", sign.toString(), this.myDialect.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            public void visitSqlBinaryExpression(SqlBinaryExpression o) {
                super.visitSqlBinaryExpression(o);
                IElementType sign = o.getOpSign();
                if (!SqlTypeInspection.isOperatorSupported(sign, this.myDialect)) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(o.getOpSignElement(), SqlMessages.message("operator.0.not.supported.by.dialect.1", sign.toString(), this.myDialect.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private void checkNamesUnique(List<? extends SqlDefinition> definitions, @Nullable SqlCreateStatement qualifyingStatement) {
                if (definitions.isEmpty()) {
                    return;
                }
                THashMap toMark = ContainerUtil.newTroveMap();
                THashMap toMark2 = ContainerUtil.newTroveMap();
                THashMap map = ContainerUtil.newTroveMap();
                for (SqlDefinition sqlDefinition : definitions) {
                    SqlElement oldElement;
                    boolean isPlain = !DbSqlUtil.isQuoted((DasObject)sqlDefinition);
                    String name = this.myDialect.getCasing(sqlDefinition.getKind(), (DasObject)sqlDefinition).choose(isPlain).apply(sqlDefinition.getName());
                    SqlNameElement nameElement = StringUtil.isNotEmpty((String)name) ? sqlDefinition.getNameElement() : null;
                    if (nameElement == null || (oldElement = (SqlElement)map.put(name, nameElement)) == null) continue;
                    boolean added = false;
                    if (PsiTreeUtil.isAncestor((PsiElement)qualifyingStatement, (PsiElement)oldElement, (boolean)true)) {
                        toMark.put(oldElement, name);
                        added = true;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)qualifyingStatement, (PsiElement)nameElement, (boolean)true)) {
                        toMark.put(nameElement, name);
                        added = true;
                    }
                    if (added || qualifyingStatement == null) continue;
                    SqlNameElement element = qualifyingStatement.getNameElement();
                    ContainerUtil.putIfNotNull((Object)element, (Object)name, (Map)toMark2);
                }
                for (PsiElement psiElement : toMark.keySet()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(psiElement, SqlMessages.message("already.exists", toMark.get(psiElement)), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
                for (PsiElement psiElement : toMark2.keySet()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(psiElement, SqlMessages.message("duplicate.column", toMark2.get(psiElement)), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private void checkTypesMatching(@NotNull SqlType type1, @NotNull SqlType type2, PsiElement anchor2) {
                int count2;
                if (type1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type1 == SqlType.UNKNOWN || type2 == SqlType.UNKNOWN) {
                    return;
                }
                if (this.isUninspectable(type1) || this.isUninspectable(type2)) {
                    return;
                }
                int count1 = type1 instanceof SqlTableType ? ((SqlTableType)type1).getColumnCount() : 1;
                int n = count2 = type2 instanceof SqlTableType ? ((SqlTableType)type2).getColumnCount() : 1;
                if (count1 != count2 && anchor2 != null && anchor2.isPhysical()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, SqlMessages.message("incompatible.types", type2.getDisplayName(), type1.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private boolean isUninspectable(@NotNull SqlType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (type instanceof SqlTableTypeBase.UnresolvedRefType) {
                    return true;
                }
                SqlTableType tableType = (SqlTableType)ObjectUtils.tryCast((Object)type, SqlTableType.class);
                if (tableType != null) {
                    int c = tableType.getColumnCount();
                    for (int i2 = 0; i2 < c; ++i2) {
                        SqlType columnType = tableType.getColumnType(i2);
                        if (!this.isUnknownRecordType(columnType)) continue;
                        return true;
                    }
                    return false;
                }
                return this.isUnknownRecordType(type);
            }

            private boolean isUnknownRecordType(SqlType columnType) {
                return columnType instanceof SqlPrimitiveType && columnType.getCategory() == SqlType.Category.RECORD;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/inspections/SqlTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypesMatching";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isUninspectable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isOperatorSupported(IElementType sign, SqlLanguageDialectEx dialect) {
        DatabaseFamilyId familyId = dialect.getFamilyId();
        return familyId != DatabaseFamilyId.UNKNOWN || dialect.isOperatorSupported(sign);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlTypeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

