/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLanguageSubstitutor
extends LanguageSubstitutor {
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(1);
        }
        return (Language)ObjectUtils.chooseNotNull((Object)SqlLanguageSubstitutor.getConfiguredSqlLanguageDialect(file, project), (Object)SqlDialectMappings.getDefaultSqlDialect());
    }

    @NotNull
    public static SqlLanguageDialect getSqlLanguageDialect(@Nullable VirtualFile file, @Nullable Project project) {
        Language language;
        FileType fileType = file == null ? null : file.getFileType();
        SqlLanguage fileLang = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : SqlLanguage.INSTANCE;
        Language language2 = language = file == null || project == null ? null : LanguageSubstitutors.INSTANCE.substituteLanguage((Language)fileLang, file, project);
        if (language instanceof SqlLanguageDialect) {
            SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)language;
            if (sqlLanguageDialect == null) {
                SqlLanguageSubstitutor.$$$reportNull$$$0(2);
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getMapping(project, file);
        if (sqlLanguageDialect == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(3);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect getConfiguredSqlLanguageDialect(@Nullable VirtualFile file, @NotNull Project project) {
        Language language;
        VirtualFile originalFile;
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(4);
        }
        while (file instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file).getOriginalFile()) != null) {
            file = originalFile;
        }
        if (file instanceof LightVirtualFile) {
            language = ((LightVirtualFile)file).getLanguage();
        } else if (file instanceof DatabaseElementVirtualFileImpl) {
            language = DbSqlUtil.getSqlDialect((DbElement)((DatabaseElementVirtualFileImpl)file).findDataSource(project));
        } else {
            if (DbSrcUtils.isDbSrcFile(file)) {
                LocalDataSource source = DbSrcUtils.findDataSource(file);
                return source == null ? null : DbSqlUtil.getSqlDialect(source);
            }
            language = (Language)SqlDialectMappings.getInstance(project).getConfiguredMapping(file);
        }
        if (language instanceof SqlLanguageDialect) {
            return (SqlLanguageDialect)language;
        }
        VirtualFile hostFile = file instanceof VirtualFileWindow ? ((VirtualFileWindow)file).getDelegate() : null;
        return (SqlLanguageDialect)SqlDialectMappings.getInstance(project).getConfiguredMapping(hostFile);
    }

    static {
        DbSqlUtil.ensureSqlDialectsLoaded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/SqlLanguageSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/SqlLanguageSubstitutor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlLanguageDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredSqlLanguageDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

