/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStringLiteralManipulator
extends AbstractElementManipulator<SqlStringLiteralExpressionImpl> {
    public SqlStringLiteralExpressionImpl handleContentChange(@NotNull SqlStringLiteralExpressionImpl psi, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (psi == null) {
            SqlStringLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SqlStringLiteralManipulator.$$$reportNull$$$0(1);
        }
        String oldText = psi.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + SqlStringLiteralManipulator.escapeSqlStringCharacters(newContent, SqlStringLiteralManipulator.getStringTokenType(psi)) + oldText.substring(range.getEndOffset());
        return psi.updateText(newText);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull SqlStringLiteralExpressionImpl element) {
        if (element == null) {
            SqlStringLiteralManipulator.$$$reportNull$$$0(2);
        }
        TextRange textRange = SqlStringLiteralManipulator.getStringTokenRange(element);
        if (textRange == null) {
            SqlStringLiteralManipulator.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public static String unescapeSqlStringCharacters(String text, IElementType tokenType) {
        return tokenType == SqlTokens.SQL_STRING_TOKEN ? text.replace("''", "'") : text;
    }

    public static String escapeSqlStringCharacters(String text, IElementType tokenType) {
        return tokenType == SqlTokens.SQL_STRING_TOKEN ? text.replace("'", "''") : text;
    }

    public static IElementType getStringTokenType(SqlStringLiteralExpression expression) {
        SqlStringTokenElement type = SqlStringLiteralManipulator.getStringToken(expression);
        return type == null ? SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN : type.getElementType();
    }

    @Nullable
    public static SqlStringTokenElement getStringToken(SqlStringLiteralExpression expression) {
        return (SqlStringTokenElement)PsiTreeUtil.getChildOfType((PsiElement)expression, SqlStringTokenElement.class);
    }

    public static TextRange getStringTokenRange(SqlStringLiteralExpressionImpl element) {
        SqlStringTokenElement stringToken = SqlStringLiteralManipulator.getStringToken(element);
        if (stringToken != null) {
            return stringToken.getRangeInElement().shiftRight(stringToken.getStartOffsetInParent());
        }
        ASTNode quote = element.getNode().findChildByType((IElementType)SqlTokens.SQL_CUSTOM_LQUOTE);
        assert (quote instanceof LeafPsiElement) : element.getText() + " : " + ((Object)((Object)element)).getClass().getName();
        return TextRange.from((int)(((LeafPsiElement)quote).getStartOffsetInParent() + quote.getTextLength()), (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlStringLiteralManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlStringLiteralManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

