/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SqlCteInplaceIntroducer
extends AbstractInplaceIntroducer<SqlAsExpression, PsiElement> {
    private final SqlExpression myInnerExpr;
    private SqlAsExpression myId;
    private boolean myDeleteSelf;
    private final SqlExpression myContext;

    public SqlCteInplaceIntroducer(Project project, Editor editor, @NotNull SqlExpression subquery, @NotNull SqlExpression context, FileType fileType) {
        if (subquery == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(1);
        }
        super(project, editor, (PsiElement)SqlSubqueryUtils.expanded(subquery), null, new PsiElement[]{subquery}, "Introduce CTE", fileType);
        this.myInnerExpr = subquery;
        this.myContext = context;
    }

    public PsiElement restoreExpression(PsiFile containingFile, SqlAsExpression variable, RangeMarker marker, String exprText) {
        PsiElement start = containingFile.findElementAt(marker.getStartOffset());
        PsiElement end = containingFile.findElementAt(marker.getEndOffset() - 1);
        if (start == null || end == null) {
            return null;
        }
        return PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
    }

    protected String getActionName() {
        return "Introduce CTE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected SqlAsExpression createFieldToStartTemplateOn(boolean replaceAll, String[] names) {
        SqlWithClause with = SqlSubqueryUtils.extractWithClause(this.myContext);
        StringBuilder out = new StringBuilder();
        DdlBuilder builder = new DdlBuilder(out);
        builder.applyCodeStyle(this.myProject);
        if (with != null) {
            builder.plain(with.getText()).symbol(",").space();
        } else {
            builder.keyword("with").space();
        }
        int idPos = builder.length();
        builder.identifier("cte_alias").space().keyword("as").space().symbol("(").plain(this.myInnerExpr.getText()).symbol(")").newLine().plain("SELECT * from aaa");
        SqlSelectStatement select = (SqlSelectStatement)PsiTreeUtil.findChildOfType((PsiElement)SqlPsiElementFactory.createStatementFromText(out.toString(), SqlImplUtil.getSqlDialectSafe((PsiElement)this.myContext), this.myProject, (PsiElement)this.myContext), SqlSelectStatement.class, (boolean)false);
        assert (select != null);
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)select.getQueryExpression(), SqlWithQueryExpression.class);
        assert (withEx != null);
        SqlWithClause newWith = withEx.getWithClause();
        if (with != null) {
            with = (SqlWithClause)with.replace((PsiElement)newWith);
        } else {
            SqlExpression q = withEx.getExpression();
            with = (SqlWithClause)this.myContext.addRangeBefore((PsiElement)withEx.getWithClause(), (PsiElement)(q != null ? q.getPrevSibling() : withEx.getWithClause()), this.myContext.getFirstChild());
        }
        this.myId = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)with.findElementAt(idPos), SqlAsExpression.class);
        SmartPsiElementPointer smartId = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myId);
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
            if (smartId.getElement() != null) {
                this.restoreState((SqlAsExpression)smartId.getElement());
            }
            this.myId = (SqlAsExpression)smartId.getElement();
        }
        finally {
            this.myDeleteSelf = true;
            SmartPointerManager.getInstance((Project)this.myProject).removePointer(smartId);
        }
        this.myEditor.getCaretModel().moveToOffset(this.myId.getTextRange().getStartOffset());
        return this.myId;
    }

    protected void deleteTemplateField(SqlAsExpression variable) {
        if (!this.myDeleteSelf) {
            return;
        }
        super.deleteTemplateField((PsiNameIdentifierOwner)variable);
    }

    protected int getCaretOffset() {
        PsiElement identifier;
        if (this.myId != null && (identifier = this.myId.getNameIdentifier()) != null) {
            return identifier.getTextOffset();
        }
        return super.getCaretOffset();
    }

    protected String[] suggestNames(boolean replaceAll, @Nullable SqlAsExpression variable) {
        return new String[0];
    }

    protected void performIntroduce() {
    }

    public boolean isReplaceAllOccurrences() {
        return false;
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    protected JComponent getComponent() {
        return null;
    }

    protected void saveSettings(@NotNull SqlAsExpression variable) {
        if (variable == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(2);
        }
    }

    protected SqlAsExpression getVariable() {
        return this.myId;
    }

    protected void restoreState(@NotNull SqlAsExpression psiField) {
        if (psiField == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(3);
        }
        if (this.myDeleteSelf) {
            return;
        }
        super.restoreState((PsiNameIdentifierOwner)psiField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subquery";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/refactoring/SqlCteInplaceIntroducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "saveSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

