/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

public class IntArrayAssert
extends ArrayAssert<IntArrayAssert, int[]> {
    protected IntArrayAssert(int ... actual) {
        super(IntArrayAssert.class, actual);
    }

    @Nonnull
    public IntArrayAssert contains(int ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public IntArrayAssert containsOnly(int ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public IntArrayAssert excludes(int ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    @Nonnull
    public IntArrayAssert isEqualTo(@Nullable int[] expected) {
        if (Arrays.equals((int[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    @Nonnull
    public IntArrayAssert isNotEqualTo(@Nullable int[] array) {
        if (!Arrays.equals((int[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

