/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.batch.model.scope;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringCustomBeanScope;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class SpringBatchCustomBeanScopeBase
extends SpringCustomBeanScope {
    private final String myScopeClassName;
    private final String myScopeBeanName;

    protected SpringBatchCustomBeanScopeBase(String scopeClassName, String scopeBeanName) {
        this.myScopeClassName = scopeClassName;
        this.myScopeBeanName = scopeBeanName;
    }

    public final String getScopeClassName() {
        return this.myScopeClassName;
    }

    public final boolean process(List<SpringBeanScope> scopes, Set<SpringModel> models, @NotNull PsiClass scopeClass, PsiElement psiElement) {
        PsiFile containingFile;
        if (scopeClass == null) {
            SpringBatchCustomBeanScopeBase.$$$reportNull$$$0(0);
        }
        if (!((containingFile = psiElement.getContainingFile()) instanceof XmlFile)) {
            return true;
        }
        if (XmlUtil.findNamespacePrefixByURI((XmlFile)((XmlFile)containingFile), (String)"http://www.springframework.org/schema/batch") != null) {
            scopes.add(new SpringBeanScope(this.myScopeBeanName));
            return true;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)scopeClass);
        for (SpringModel model : models) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters)) continue;
            scopes.add(new SpringBeanScope(this.myScopeBeanName));
            return true;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeClass", "com/intellij/spring/batch/model/scope/SpringBatchCustomBeanScopeBase", "process"));
    }
}

