/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.artifact.DelegatingArtifact;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.JreProxySelector;
import org.jetbrains.idea.maven.aether.ProgressConsumer;

public class ArtifactRepositoryManager {
    private static final VersionScheme ourVersioning = new GenericVersionScheme();
    private static final JreProxySelector ourProxySelector = new JreProxySelector();
    private final DefaultRepositorySystemSession mySession;
    private static final RemoteRepository MAVEN_CENTRAL_REPOSITORY = ArtifactRepositoryManager.createRemoteRepository("central", "http://repo1.maven.org/maven2/");
    private static final RemoteRepository JBOSS_COMMUNITY_REPOSITORY = ArtifactRepositoryManager.createRemoteRepository("jboss.community", "https://repository.jboss.org/nexus/content/repositories/public/");
    private static final RepositorySystem ourSystem;
    private final List<RemoteRepository> myRemoteRepositories;

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath) {
        if (localRepositoryPath == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(0);
        }
        this(localRepositoryPath, ProgressConsumer.DEAF);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, @NotNull ProgressConsumer progressConsumer) {
        if (localRepositoryPath == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(1);
        }
        if (progressConsumer == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(2);
        }
        this(localRepositoryPath, Arrays.asList(ArtifactRepositoryManager.createRemoteRepository(MAVEN_CENTRAL_REPOSITORY), ArtifactRepositoryManager.createRemoteRepository(JBOSS_COMMUNITY_REPOSITORY)), progressConsumer);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, List<RemoteRepository> remoteRepositories, final @NotNull ProgressConsumer progressConsumer) {
        if (localRepositoryPath == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(3);
        }
        if (progressConsumer == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(4);
        }
        this.myRemoteRepositories = new ArrayList<RemoteRepository>();
        this.myRemoteRepositories.addAll(remoteRepositories);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        if (progressConsumer != ProgressConsumer.DEAF) {
            session.setTransferListener((TransferListener)Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{TransferListener.class}, new InvocationHandler(){
                private final EnumSet<TransferEvent.EventType> checkCancelEvents = EnumSet.of(TransferEvent.EventType.INITIATED, TransferEvent.EventType.STARTED, TransferEvent.EventType.PROGRESSED);

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object event = args[0];
                    if (event instanceof TransferEvent) {
                        TransferEvent.EventType type = ((TransferEvent)event).getType();
                        if (this.checkCancelEvents.contains(type) && progressConsumer.isCanceled()) {
                            throw new TransferCancelledException();
                        }
                        progressConsumer.consume(event.toString());
                    }
                    return null;
                }
            }));
        }
        session.setLocalRepositoryManager(ourSystem.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepositoryPath)));
        session.setProxySelector((ProxySelector)ourProxySelector);
        session.setReadOnly();
        this.mySession = session;
    }

    public void addRemoteRepository(String id, String url) {
        this.myRemoteRepositories.add(ArtifactRepositoryManager.createRemoteRepository(id, url));
    }

    public Collection<File> resolveDependency(String groupId, String artifactId, String version, boolean includeTransitiveDependencies) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (Artifact artifact : this.resolveDependencyAsArtifact(groupId, artifactId, version, EnumSet.of(ArtifactKind.ARTIFACT), includeTransitiveDependencies)) {
            files.add(artifact.getFile());
        }
        return files;
    }

    @NotNull
    public Collection<Artifact> resolveDependencyAsArtifact(String groupId, String artifactId, String versionConstraint, Set<ArtifactKind> artifactKinds, boolean includeTransitiveDependencies) throws Exception {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        Set<VersionConstraint> constraints = Collections.singleton(ArtifactRepositoryManager.asVersionConstraint(versionConstraint));
        for (ArtifactKind kind : artifactKinds) {
            try {
                List<ArtifactRequest> requests;
                if (includeTransitiveDependencies) {
                    CollectResult collectResult = ourSystem.collectDependencies((RepositorySystemSession)this.mySession, this.createCollectRequest(groupId, artifactId, constraints, EnumSet.of(kind)));
                    ArtifactRequestBuilder builder = new ArtifactRequestBuilder(kind);
                    collectResult.getRoot().accept((DependencyVisitor)new TreeDependencyVisitor((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)builder, DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"}))));
                    requests = builder.getRequests();
                } else {
                    requests = new ArrayList<ArtifactRequest>();
                    for (Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, constraints, Collections.singleton(kind))) {
                        requests.add(new ArtifactRequest(artifact, Collections.unmodifiableList(this.myRemoteRepositories), null));
                    }
                }
                if (requests.isEmpty()) continue;
                try {
                    for (ArtifactResult result : ourSystem.resolveArtifacts((RepositorySystemSession)this.mySession, requests)) {
                        artifacts.add(result.getArtifact());
                    }
                }
                catch (ArtifactResolutionException e) {
                    if (kind != ArtifactKind.ARTIFACT) {
                        if (requests.size() <= 1) continue;
                        for (ArtifactRequest request : requests) {
                            try {
                                ArtifactResult result = ourSystem.resolveArtifact((RepositorySystemSession)this.mySession, request);
                                artifacts.add(result.getArtifact());
                            }
                            catch (ArtifactResolutionException artifactResolutionException) {}
                        }
                        continue;
                    }
                    throw e;
                }
            }
            catch (DependencyCollectionException e) {
                if (kind != ArtifactKind.ARTIFACT) continue;
                throw e;
            }
        }
        ArrayList<Artifact> arrayList = artifacts;
        if (arrayList == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public List<Version> getAvailableVersions(String groupId, String artifactId, String versionConstraint, ArtifactKind artifactKind) throws Exception {
        VersionRangeResult result = ourSystem.resolveVersionRange((RepositorySystemSession)this.mySession, this.createVersionRangeRequest(groupId, artifactId, ArtifactRepositoryManager.asVersionConstraint(versionConstraint), artifactKind));
        return result.getVersions();
    }

    public static RemoteRepository createRemoteRepository(String id, String url) {
        return new RemoteRepository.Builder(id, "default", url).setProxy(ourProxySelector.getProxy(url)).build();
    }

    public static RemoteRepository createRemoteRepository(RemoteRepository prototype) {
        String url = prototype.getUrl();
        return new RemoteRepository.Builder(prototype.getId(), prototype.getContentType(), url).setProxy(ourProxySelector.getProxy(url)).build();
    }

    private CollectRequest createCollectRequest(String groupId, String artifactId, Collection<VersionConstraint> versions, Set<ArtifactKind> kinds) {
        CollectRequest request = new CollectRequest();
        for (Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, versions, kinds)) {
            request.addDependency(new Dependency(artifact, "compile"));
        }
        return request.setRepositories(Collections.unmodifiableList(this.myRemoteRepositories));
    }

    private VersionRangeRequest createVersionRangeRequest(String groupId, String artifactId, VersionConstraint versioning, ArtifactKind artifactKind) {
        VersionRangeRequest request = new VersionRangeRequest();
        for (Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, Collections.singleton(versioning), EnumSet.of(artifactKind))) {
            request.setArtifact(artifact);
        }
        return request.setRepositories(Collections.unmodifiableList(this.myRemoteRepositories));
    }

    public static Version asVersion(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersion(str == null ? "" : str);
    }

    public static VersionRange asVersionRange(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersionRange(str == null ? "" : str);
    }

    public static VersionConstraint asVersionConstraint(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersionConstraint(str == null ? "" : str);
    }

    private static List<Artifact> toArtifacts(String groupId, String artifactId, Collection<VersionConstraint> constraints, Set<ArtifactKind> kinds) {
        if (constraints.isEmpty() || kinds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>(kinds.size() * constraints.size());
        for (ArtifactKind kind : kinds) {
            for (VersionConstraint constr : constraints) {
                result.add((Artifact)new DefaultArtifact(groupId, artifactId, kind.getClassifier(), kind.getExtension(), constr.toString()));
            }
        }
        return result;
    }

    static {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                if (exception != null) {
                    throw new RuntimeException(exception);
                }
            }
        });
        ourSystem = (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepositoryPath";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependencyAsArtifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArtifactRequestBuilder
    implements DependencyVisitor {
        private final ArtifactKind myKind;
        private final List<ArtifactRequest> myRequests = new ArrayList<ArtifactRequest>();

        public ArtifactRequestBuilder(ArtifactKind kind) {
            this.myKind = kind;
        }

        public boolean visitEnter(DependencyNode node) {
            Dependency dep = node.getDependency();
            if (dep != null) {
                this.myRequests.add(new ArtifactRequest((Artifact)new ArtifactWithChangedClassifier(node.getDependency().getArtifact(), this.myKind.getClassifier()), node.getRepositories(), node.getRequestContext()));
            }
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            return true;
        }

        @NotNull
        public List<ArtifactRequest> getRequests() {
            List<ArtifactRequest> list = this.myRequests;
            if (list == null) {
                ArtifactRequestBuilder.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager$ArtifactRequestBuilder", "getRequests"));
        }
    }

    private static class ArtifactWithChangedClassifier
    extends DelegatingArtifact {
        private final String myClassifier;

        public ArtifactWithChangedClassifier(Artifact artifact, String classifier) {
            super(artifact);
            this.myClassifier = classifier;
        }

        protected DelegatingArtifact newInstance(Artifact artifact) {
            return new ArtifactWithChangedClassifier(artifact, this.myClassifier);
        }

        public String getClassifier() {
            return this.myClassifier;
        }
    }
}

