/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.maven.model.impl.MavenEjbClientConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenIdBean;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenWebArtifactConfiguration;

public class MavenProjectConfiguration {
    public static final String CONFIGURATION_FILE_RELATIVE_PATH = "maven/configuration.xml";
    public static final String DEFAULT_ESCAPE_STRING = "\\";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(\\S+?)=(.+)");
    public static final Set<String> DEFAULT_FILTERING_EXCLUDED_EXTENSIONS;
    @Tag(value="resource-processing")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="maven-module", keyAttributeName="name")
    public Map<String, MavenModuleResourceConfiguration> moduleConfigurations = new THashMap();
    @Tag(value="web-artifact-cfg")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="artifact", keyAttributeName="name")
    public Map<String, MavenWebArtifactConfiguration> webArtifactConfigs = new THashMap();
    @Tag(value="ejb-client-artifact-cfg")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="artifact", keyAttributeName="name")
    public Map<String, MavenEjbClientConfiguration> ejbClientArtifactConfigs = new THashMap();
    @Transient
    private volatile Map<MavenIdBean, MavenModuleResourceConfiguration> myIdToModuleMap;
    private static volatile Map<String, String> ourPropertiesFromMvnOpts;
    private static volatile Properties ourSystemProperties;

    @Nullable
    public MavenModuleResourceConfiguration findProject(MavenIdBean id) {
        return this.getModuleConfigurationMap().get(id);
    }

    @NotNull
    private Map<MavenIdBean, MavenModuleResourceConfiguration> getModuleConfigurationMap() {
        THashMap map = this.myIdToModuleMap;
        if (map == null) {
            map = new THashMap();
            for (MavenModuleResourceConfiguration configuration : this.moduleConfigurations.values()) {
                if (configuration == null) continue;
                map.put(configuration.id, configuration);
            }
            this.myIdToModuleMap = map;
        }
        THashMap tHashMap = map;
        if (tHashMap == null) {
            MavenProjectConfiguration.$$$reportNull$$$0(0);
        }
        return tHashMap;
    }

    @Nullable
    public String resolveProperty(String propName, MavenModuleResourceConfiguration moduleConfig, Map<String, String> additionalProperties) {
        boolean hasPrefix = false;
        String unprefixed = propName;
        if (propName.startsWith("pom.")) {
            unprefixed = propName.substring("pom.".length());
            hasPrefix = true;
        } else if (propName.startsWith("project.")) {
            unprefixed = propName.substring("project.".length());
            hasPrefix = true;
        }
        MavenModuleResourceConfiguration selectedConfig = moduleConfig;
        while (unprefixed.startsWith("parent.")) {
            MavenIdBean parentId = selectedConfig.parentId;
            if (parentId == null) {
                return null;
            }
            if ((unprefixed = unprefixed.substring("parent.".length())).equals("groupId")) {
                return parentId.groupId;
            }
            if (unprefixed.equals("artifactId")) {
                return parentId.artifactId;
            }
            selectedConfig = this.findProject(parentId);
            if (selectedConfig != null) continue;
            return null;
        }
        if (unprefixed.equals("basedir") || hasPrefix && moduleConfig == selectedConfig && unprefixed.equals("baseUri")) {
            return selectedConfig.directory;
        }
        String result = MavenProjectConfiguration.getMavenOptsProperties().get(propName);
        if (result != null) {
            return result;
        }
        result = MavenProjectConfiguration.getSystemProperties().getProperty(propName);
        if (result != null) {
            return result;
        }
        result = selectedConfig.modelMap.get(unprefixed);
        if (result != null) {
            return result;
        }
        result = additionalProperties.get(propName);
        if (result != null) {
            return result;
        }
        return moduleConfig.properties.get(propName);
    }

    @NotNull
    private static Map<String, String> getMavenOptsProperties() {
        Map<String, String> res = ourPropertiesFromMvnOpts;
        if (res == null) {
            String mavenOpts = System.getenv("MAVEN_OPTS");
            if (mavenOpts != null) {
                String[] split;
                res = new HashMap<String, String>();
                for (String parameter : split = ParametersListUtil.parseToArray((String)mavenOpts)) {
                    Matcher matcher = PROPERTY_PATTERN.matcher(parameter);
                    if (!matcher.matches()) continue;
                    res.put(matcher.group(1), matcher.group(2));
                }
            } else {
                res = Collections.emptyMap();
            }
            ourPropertiesFromMvnOpts = res;
        }
        Map<String, String> map = res;
        if (map == null) {
            MavenProjectConfiguration.$$$reportNull$$$0(1);
        }
        return map;
    }

    public static Properties getSystemProperties() {
        Properties res = ourSystemProperties;
        if (res == null) {
            res = new Properties();
            res.putAll((Map<?, ?>)System.getProperties());
            Iterator<Object> itr = res.keySet().iterator();
            while (itr.hasNext()) {
                String propertyName = itr.next().toString();
                if (!propertyName.startsWith("idea.") && !propertyName.startsWith("jps.")) continue;
                itr.remove();
            }
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("=")) continue;
                if (SystemInfo.isWindows) {
                    key = key.toUpperCase();
                }
                res.setProperty("env." + key, entry.getValue());
            }
            ourSystemProperties = res;
        }
        return res;
    }

    static {
        THashSet set = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        set.addAll(Arrays.asList("jpg", "jpeg", "gif", "bmp", "png"));
        DEFAULT_FILTERING_EXCLUDED_EXTENSIONS = Collections.unmodifiableSet(set);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/maven/model/impl/MavenProjectConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleConfigurationMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenOptsProperties";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

