/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class InspectionMappingConsistencyInspection
extends DevKitInspectionBase {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            InspectionMappingConsistencyInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            InspectionMappingConsistencyInspection.$$$reportNull$$$0(1);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                ExtensionPoint extensionPoint;
                DomElement element = DomUtil.getDomElement((PsiElement)tag);
                if (element instanceof Extension && (extensionPoint = ((Extension)element).getExtensionPoint()) != null && InheritanceUtil.isInheritor((PsiClass)((PsiClass)extensionPoint.getBeanClass().getValue()), (String)"com.intellij.codeInspection.InspectionEP")) {
                    boolean groupKey;
                    boolean key = tag.getAttribute("key") != null;
                    boolean bl = groupKey = tag.getAttribute("groupKey") != null;
                    if (key) {
                        if (tag.getAttribute("bundle") == null) {
                            InspectionMappingConsistencyInspection.checkDefaultBundle(element, holder);
                        }
                    } else if (tag.getAttribute("displayName") == null) {
                        InspectionMappingConsistencyInspection.registerProblem(element, holder, "displayName or key should be specified", new String[]{"displayName", "key"});
                    }
                    if (groupKey) {
                        if (tag.getAttribute("bundle") == null && tag.getAttribute("groupBundle") == null) {
                            InspectionMappingConsistencyInspection.checkDefaultBundle(element, holder);
                        }
                    } else if (tag.getAttribute("groupName") == null) {
                        InspectionMappingConsistencyInspection.registerProblem(element, holder, "groupName or groupKey should be specified", new String[]{"groupName", "groupKey"});
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            InspectionMappingConsistencyInspection.$$$reportNull$$$0(2);
        }
        return xmlElementVisitor;
    }

    private static void checkDefaultBundle(DomElement element, ProblemsHolder holder) {
        IdeaPlugin plugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)element, IdeaPlugin.class, (boolean)true);
        if (plugin != null && !DomUtil.hasXml(plugin.getResourceBundle())) {
            InspectionMappingConsistencyInspection.registerProblem(element, holder, "Bundle should be specified", new String[0]);
        }
    }

    private static void registerProblem(DomElement element, ProblemsHolder holder, String message, String ... createAttrs) {
        Pair range = DomUtil.getProblemRange((XmlTag)element.getXmlTag());
        holder.registerProblem((PsiElement)range.second, (TextRange)range.first, message, holder.isOnTheFly() ? (LocalQuickFix[])ContainerUtil.map((Object[])createAttrs, s -> new InsertRequiredAttributeFix((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)range.second), XmlTag.class, (boolean)false), (String)s, new String[0], (String)s){
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
                super(arg0, arg1, arg2);
            }

            @NotNull
            public String getText() {
                String string = MessageFormat.format("Insert ''{0}'' attribute", this.val$s);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/InspectionMappingConsistencyInspection$2", "getText"));
            }
        }, (Object[])new LocalQuickFix[createAttrs.length]) : LocalQuickFix.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/InspectionMappingConsistencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/InspectionMappingConsistencyInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

