/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.text.BlockSupport;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/codeInsight/completion/OffsetsInFile;", "", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "offsets", "Lcom/intellij/codeInsight/completion/OffsetMap;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInsight/completion/OffsetMap;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffsets", "()Lcom/intellij/codeInsight/completion/OffsetMap;", "copyWithReplacement", "startOffset", "", "endOffset", "replacement", "", "reparseFile", "", "newText", "", "replaceInCopy", "fileCopy", "toInjectedIfAny", "offset", "toTopLevelFile", "intellij.platform.lang.impl"})
public final class OffsetsInFile {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final OffsetMap offsets;

    @NotNull
    public final OffsetsInFile toTopLevelFile() {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.file.getProject());
        PsiFile hostFile = manager.getTopLevelFile((PsiElement)this.file);
        if (Intrinsics.areEqual((Object)hostFile, (Object)this.file)) {
            return this;
        }
        PsiFile psiFile = hostFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"hostFile");
        FileViewProvider fileViewProvider = hostFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"hostFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        OffsetMap offsetMap = this.offsets.mapOffsets(document, (Function)new Function<Integer, Integer>(this, manager){
            final /* synthetic */ OffsetsInFile this$0;
            final /* synthetic */ InjectedLanguageManager $manager;

            public final int apply(Integer it) {
                PsiElement psiElement = (PsiElement)this.this$0.getFile();
                Integer n = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it");
                return this.$manager.injectedToHost(psiElement, n.intValue());
            }
            {
                this.this$0 = offsetsInFile;
                this.$manager = injectedLanguageManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetMap, (String)"offsets.mapOffsets(hostF\u2026njectedToHost(file, it) }");
        return new OffsetsInFile(psiFile, offsetMap);
    }

    @NotNull
    public final OffsetsInFile toInjectedIfAny(int offset) {
        PsiFile psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit(this.file, offset);
        if (psiFile == null) {
            return this;
        }
        PsiFile injected = psiFile;
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injected);
        if (documentWindow == null) {
            Intrinsics.throwNpe();
        }
        DocumentWindow documentWindow2 = documentWindow;
        PsiFile psiFile2 = injected;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"injected");
        OffsetMap offsetMap = this.offsets.mapOffsets((Document)documentWindow2, (Function)new Function<Integer, Integer>(documentWindow2){
            final /* synthetic */ DocumentWindow $documentWindow;

            public final int apply(Integer it) {
                Integer n = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it");
                return this.$documentWindow.hostToInjected(n.intValue());
            }
            {
                this.$documentWindow = documentWindow;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetMap, (String)"offsets.mapOffsets(docum\u2026ndow.hostToInjected(it) }");
        return new OffsetsInFile(psiFile2, offsetMap);
    }

    @NotNull
    public final OffsetsInFile copyWithReplacement(int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        PsiElement psiElement = this.file.copy();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        return this.replaceInCopy((PsiFile)psiElement, startOffset, endOffset, replacement);
    }

    @NotNull
    public final OffsetsInFile replaceInCopy(@NotNull PsiFile fileCopy, int startOffset, int endOffset, @NotNull String replacement) {
        OffsetMap copyOffsets;
        Intrinsics.checkParameterIsNotNull((Object)fileCopy, (String)"fileCopy");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        Document document = this.offsets.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"offsets.document");
        DocumentImpl tempDocument = new DocumentImpl(document.getImmutableCharSequence(), true);
        OffsetMap tempMap = this.offsets.copyOffsets((Document)tempDocument);
        tempDocument.replaceString(startOffset, endOffset, replacement);
        CharSequence charSequence = tempDocument.getImmutableCharSequence();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"tempDocument.immutableCharSequence");
        this.reparseFile(fileCopy, charSequence);
        FileViewProvider fileViewProvider = fileCopy.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"fileCopy.viewProvider");
        Document document2 = fileViewProvider.getDocument();
        if (document2 == null) {
            Intrinsics.throwNpe();
        }
        OffsetMap offsetMap = copyOffsets = tempMap.copyOffsets(document2);
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetMap, (String)"copyOffsets");
        return new OffsetsInFile(fileCopy, offsetMap);
    }

    private final void reparseFile(PsiFile file2, CharSequence newText) {
        FileASTNode fileASTNode = file2.getNode();
        if (fileASTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.tree.FileElement");
        }
        FileElement node = (FileElement)fileASTNode;
        TextRange textRange = ChangedPsiRangeUtil.getChangedPsiRange(file2, node, newText);
        if (textRange == null) {
            return;
        }
        TextRange range2 = textRange;
        ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        BlockSupport blockSupport = BlockSupport.getInstance(file2.getProject());
        FileASTNode fileASTNode2 = node;
        FileViewProvider fileViewProvider = file2.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"file.viewProvider");
        DiffLog log2 = blockSupport.reparseRange(file2, fileASTNode2, range2, newText, indicator, fileViewProvider.getContents());
        ProgressManager.getInstance().executeNonCancelableSection(new Runnable(log2, file2){
            final /* synthetic */ DiffLog $log;
            final /* synthetic */ PsiFile $file;

            public final void run() {
                this.$log.doActualPsiChange(this.$file);
            }
            {
                this.$log = diffLog;
                this.$file = psiFile;
            }
        });
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final OffsetMap getOffsets() {
        return this.offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file2, @NotNull OffsetMap offsets) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)offsets, (String)"offsets");
        this.file = file2;
        this.offsets = offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        FileViewProvider fileViewProvider = file2.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"file.viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        this(file2, new OffsetMap(document));
    }
}

