/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInsight.daemon.quickFix.RenameFileReferenceIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceQuickFixProvider {
    private FileReferenceQuickFixProvider() {
    }

    @NotNull
    public static List<? extends LocalQuickFix> registerQuickFix(@NotNull FileReference reference) {
        boolean isdirectory;
        PsiFile containingFile;
        if (reference == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(0);
        }
        FileReferenceSet fileReferenceSet = reference.getFileReferenceSet();
        int index = reference.getIndex();
        if (index < 0) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }
        String newFileName = reference.getFileNameToCreate();
        if (newFileName.isEmpty() || newFileName.indexOf(92) != -1 || newFileName.indexOf(42) != -1 || newFileName.indexOf(63) != -1 || SystemInfo.isWindows && newFileName.indexOf(58) != -1) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(2);
            }
            return list3;
        }
        PsiFileSystemItem context = null;
        PsiElement element = reference.getElement();
        PsiFile psiFile = containingFile = element == null ? null : element.getContainingFile();
        if (index > 0) {
            context = fileReferenceSet.getReference(index - 1).resolve();
        } else {
            Collection<PsiFileSystemItem> defaultContexts = fileReferenceSet.getDefaultContexts();
            if (defaultContexts.isEmpty()) {
                List list4 = Collections.emptyList();
                if (list4 == null) {
                    FileReferenceQuickFixProvider.$$$reportNull$$$0(3);
                }
                return list4;
            }
            Module module = containingFile == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
            for (PsiFileSystemItem defaultContext : defaultContexts) {
                VirtualFile virtualFile;
                if (defaultContext == null || (virtualFile = defaultContext.getVirtualFile()) == null || !defaultContext.isDirectory() || !virtualFile.isInLocalFileSystem()) continue;
                if (context == null) {
                    context = defaultContext;
                }
                if (module == null || module != FileReferenceQuickFixProvider.getModuleForContext(defaultContext)) continue;
                context = defaultContext;
                break;
            }
            if (context == null && ApplicationManager.getApplication().isUnitTestMode()) {
                context = defaultContexts.iterator().next();
            }
        }
        if (context == null) {
            List list5 = Collections.emptyList();
            if (list5 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(4);
            }
            return list5;
        }
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            List list6 = Collections.emptyList();
            if (list6 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(5);
            }
            return list6;
        }
        PsiDirectory directory = context.getManager().findDirectory(virtualFile);
        if (directory == null) {
            List list7 = Collections.emptyList();
            if (list7 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(6);
            }
            return list7;
        }
        if (fileReferenceSet.isCaseSensitive()) {
            PsiFileSystemItem psiElement;
            PsiFileSystemItem psiFileSystemItem = psiElement = containingFile == null ? null : reference.innerSingleResolve(false, containingFile);
            if (psiElement != null) {
                String existingElementName = ((PsiNamedElement)psiElement).getName();
                RenameFileReferenceIntentionAction renameRefAction = new RenameFileReferenceIntentionAction(existingElementName, reference);
                RenameFileFix renameFileFix = new RenameFileFix(newFileName);
                List<LocalQuickFix> list8 = Arrays.asList(renameRefAction, renameFileFix);
                if (list8 == null) {
                    FileReferenceQuickFixProvider.$$$reportNull$$$0(7);
                }
                return list8;
            }
        }
        if (!reference.isLast()) {
            try {
                directory.checkCreateSubdirectory(newFileName);
            }
            catch (IncorrectOperationException ex) {
                List list9 = Collections.emptyList();
                if (list9 == null) {
                    FileReferenceQuickFixProvider.$$$reportNull$$$0(8);
                }
                return list9;
            }
            isdirectory = true;
        } else {
            FileType ft = FileTypeManager.getInstance().getFileTypeByFileName(newFileName);
            if (ft instanceof UnknownFileType) {
                List list10 = Collections.emptyList();
                if (list10 == null) {
                    FileReferenceQuickFixProvider.$$$reportNull$$$0(9);
                }
                return list10;
            }
            try {
                directory.checkCreateFile(newFileName);
            }
            catch (IncorrectOperationException ex) {
                List list11 = Collections.emptyList();
                if (list11 == null) {
                    FileReferenceQuickFixProvider.$$$reportNull$$$0(10);
                }
                return list11;
            }
            isdirectory = false;
        }
        MyCreateFileFix action = new MyCreateFileFix(isdirectory, newFileName, directory, reference);
        List<MyCreateFileFix> list12 = Collections.singletonList(action);
        if (list12 == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(11);
        }
        return list12;
    }

    @Nullable
    private static Module getModuleForContext(@NotNull PsiFileSystemItem context) {
        VirtualFile file2;
        if (context == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(12);
        }
        return (file2 = context.getVirtualFile()) != null ? ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)context.getProject()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "registerQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerQuickFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCreateFileFix
    extends CreateFileFix {
        private final boolean isDirectory;
        private final String myNewFileTemplateName;

        public MyCreateFileFix(boolean isdirectory, String newFileName, PsiDirectory directory, FileReference reference) {
            super(isdirectory, newFileName, directory);
            this.isDirectory = isdirectory;
            this.myNewFileTemplateName = this.isDirectory ? null : reference.getNewFileTemplateName();
        }

        @Override
        protected String getFileText() {
            Project project;
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            if (!this.isDirectory && this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project = this.getStartElement().getProject()))) != null) {
                try {
                    return template.getText(fileTemplateManager.getDefaultProperties());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return super.getFileText();
        }

        private FileTemplate findTemplate(FileTemplateManager fileTemplateManager) {
            FileTemplate template = fileTemplateManager.getTemplate(this.myNewFileTemplateName);
            if (template == null) {
                template = fileTemplateManager.findInternalTemplate(this.myNewFileTemplateName);
            }
            if (template == null) {
                for (FileTemplate fileTemplate : fileTemplateManager.getAllJ2eeTemplates()) {
                    String fileTemplateWithExtension = fileTemplate.getName() + '.' + fileTemplate.getExtension();
                    if (!fileTemplateWithExtension.equals(this.myNewFileTemplateName)) continue;
                    return fileTemplate;
                }
            }
            return template;
        }

        @Override
        protected void openFile(@NotNull Project project, PsiDirectory directory, PsiFile newFile, String text) {
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            if (project == null) {
                MyCreateFileFix.$$$reportNull$$$0(0);
            }
            super.openFile(project, directory, newFile, text);
            if (!this.isDirectory && this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project))) != null && template.isLiveTemplateEnabled()) {
                CreateFromTemplateActionBase.startLiveTemplate(newFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider$MyCreateFileFix", "openFile"));
        }
    }
}

