/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFoldingInfo {
    private static final Key<EditorFoldingInfo> KEY = Key.create((String)"EditorFoldingInfo.KEY");
    private final Map<FoldRegion, SmartPsiElementPointer<?>> myFoldRegionToSmartPointerMap = new THashMap();

    @NotNull
    public static EditorFoldingInfo get(@NotNull Editor editor) {
        EditorFoldingInfo info;
        if (editor == null) {
            EditorFoldingInfo.$$$reportNull$$$0(0);
        }
        if ((info = (EditorFoldingInfo)editor.getUserData(KEY)) == null) {
            info = new EditorFoldingInfo();
            editor.putUserData(KEY, (Object)info);
        }
        EditorFoldingInfo editorFoldingInfo = info;
        if (editorFoldingInfo == null) {
            EditorFoldingInfo.$$$reportNull$$$0(1);
        }
        return editorFoldingInfo;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull FoldRegion region) {
        SmartPsiElementPointer<?> pointer;
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(2);
        }
        if ((pointer = this.myFoldRegionToSmartPointerMap.get(region)) == null) {
            return null;
        }
        PsiElement element = pointer.getElement();
        return element != null && element.isValid() ? element : null;
    }

    @Nullable
    TextRange getPsiElementRange(@NotNull FoldRegion region) {
        PsiElement element;
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(3);
        }
        if ((element = this.getPsiElement(region)) == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        boolean isInjected = injectedManager.isInjectedFragment(containingFile);
        TextRange range2 = element.getTextRange();
        if (isInjected) {
            range2 = injectedManager.injectedToHost(element, range2);
        }
        return range2;
    }

    boolean isLightRegion(@NotNull FoldRegion region) {
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(4);
        }
        return this.myFoldRegionToSmartPointerMap.get(region) == null;
    }

    void addRegion(@NotNull FoldRegion region, @NotNull SmartPsiElementPointer<?> pointer) {
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(5);
        }
        if (pointer == null) {
            EditorFoldingInfo.$$$reportNull$$$0(6);
        }
        this.myFoldRegionToSmartPointerMap.put(region, pointer);
    }

    public void removeRegion(@NotNull FoldRegion region) {
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(7);
        }
        this.myFoldRegionToSmartPointerMap.remove(region);
    }

    public void dispose() {
        this.myFoldRegionToSmartPointerMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/EditorFoldingInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/EditorFoldingInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLightRegion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRegion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeRegion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

