/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PostfixTemplatesSettings", storages={@Storage(value="postfixTemplates.xml")})
public class PostfixTemplatesSettings
implements PersistentStateComponent<Element> {
    public static final Factory<Set<String>> SET_FACTORY = () -> ContainerUtil.newHashSet();
    private Map<String, Set<String>> myProviderToDisabledTemplates = ContainerUtil.newHashMap();
    private Map<String, Set<String>> myLangToDisabledTemplates = ContainerUtil.newHashMap();
    private boolean postfixTemplatesEnabled = true;
    private boolean templatesCompletionEnabled = true;
    private int myShortcut = 9;

    public boolean isTemplateEnabled(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        Set<String> result2;
        if (template == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(1);
        }
        return (result2 = this.myProviderToDisabledTemplates.get(provider.getId())) == null || !result2.contains(template.getId());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        if (template == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(3);
        }
        this.disableTemplate(template, provider.getId());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull String providerId) {
        if (template == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(4);
        }
        if (providerId == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(5);
        }
        Set state = (Set)ContainerUtil.getOrCreate(this.myProviderToDisabledTemplates, (Object)providerId, SET_FACTORY);
        state.add(template.getId());
    }

    public boolean isPostfixTemplatesEnabled() {
        return this.postfixTemplatesEnabled;
    }

    public void setPostfixTemplatesEnabled(boolean postfixTemplatesEnabled) {
        this.postfixTemplatesEnabled = postfixTemplatesEnabled;
    }

    public boolean isTemplatesCompletionEnabled() {
        return this.templatesCompletionEnabled;
    }

    public void setTemplatesCompletionEnabled(boolean templatesCompletionEnabled) {
        this.templatesCompletionEnabled = templatesCompletionEnabled;
    }

    @MapAnnotation(entryTagName="disabled-postfix-templates", keyAttributeName="lang", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getLangDisabledTemplates() {
        Map<String, Set<String>> map = this.myLangToDisabledTemplates;
        if (map == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(6);
        }
        return map;
    }

    public void setLangDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        if (templatesState == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(7);
        }
        this.myLangToDisabledTemplates = templatesState;
    }

    @MapAnnotation(entryTagName="disabled-templates", keyAttributeName="provider", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getProviderToDisabledTemplates() {
        Map<String, Set<String>> map = this.myProviderToDisabledTemplates;
        if (map == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(8);
        }
        return map;
    }

    public void setProviderToDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        if (templatesState == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(9);
        }
        this.myProviderToDisabledTemplates = templatesState;
    }

    public int getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(int shortcut) {
        this.myShortcut = shortcut;
    }

    @NotNull
    public static PostfixTemplatesSettings getInstance() {
        PostfixTemplatesSettings postfixTemplatesSettings = (PostfixTemplatesSettings)ServiceManager.getService(PostfixTemplatesSettings.class);
        if (postfixTemplatesSettings == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(10);
        }
        return postfixTemplatesSettings;
    }

    @Nullable
    public Element getState() {
        return XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public void loadState(@NotNull Element settings) {
        if (settings == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(11);
        }
        XmlSerializer.deserializeInto((Object)this, (Element)settings);
        if (!this.myLangToDisabledTemplates.isEmpty()) {
            MultiMap<String, Language> importedLanguages = PostfixTemplatesSettings.getLanguagesToImport();
            for (Map.Entry<String, Set<String>> entry : this.myLangToDisabledTemplates.entrySet()) {
                for (Language language : importedLanguages.get((Object)entry.getKey())) {
                    for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
                        for (PostfixTemplate template : provider.getTemplates()) {
                            if (!entry.getValue().contains(template.getKey())) continue;
                            this.disableTemplate(template, provider);
                        }
                    }
                }
            }
            for (String language : importedLanguages.keySet()) {
                this.myLangToDisabledTemplates.remove(language);
            }
        }
    }

    @NotNull
    private static MultiMap<String, Language> getLanguagesToImport() {
        LanguageExtensionPoint[] extensions;
        MultiMap importedLanguages = MultiMap.create();
        for (LanguageExtensionPoint extension : extensions = (LanguageExtensionPoint[])new ExtensionPointName("com.intellij.codeInsight.template.postfixTemplateProvider").getExtensions()) {
            Language language = Language.findLanguageByID((String)extension.getKey());
            if (language == null) continue;
            importedLanguages.putValue((Object)language.getDisplayName(), (Object)language);
        }
        MultiMap multiMap = importedLanguages;
        if (multiMap == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(12);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerId";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesState";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLangDisabledTemplates";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderToDisabledTemplates";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagesToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateEnabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disableTemplate";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLangDisabledTemplates";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setProviderToDisabledTemplates";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

