/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchPopup<Repo extends Repository> {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final AbstractRepositoryManager<Repo> myRepositoryManager;
    @NotNull
    protected final DvcsSyncSettings myVcsSettings;
    @NotNull
    protected final AbstractVcs myVcs;
    @NotNull
    protected final DvcsMultiRootBranchConfig<Repo> myMultiRootBranchConfig;
    @NotNull
    protected final Repo myCurrentRepository;
    @NotNull
    protected final BranchActionGroupPopup myPopup;
    @NotNull
    protected final String myRepoTitleInfo;

    protected DvcsBranchPopup(@NotNull Repo currentRepository, @NotNull AbstractRepositoryManager<Repo> repositoryManager, @NotNull DvcsMultiRootBranchConfig<Repo> multiRootBranchConfig, @NotNull DvcsSyncSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition, @Nullable String dimensionKey) {
        if (currentRepository == null) {
            DvcsBranchPopup.$$$reportNull$$$0(0);
        }
        if (repositoryManager == null) {
            DvcsBranchPopup.$$$reportNull$$$0(1);
        }
        if (multiRootBranchConfig == null) {
            DvcsBranchPopup.$$$reportNull$$$0(2);
        }
        if (vcsSettings == null) {
            DvcsBranchPopup.$$$reportNull$$$0(3);
        }
        if (preselectActionCondition == null) {
            DvcsBranchPopup.$$$reportNull$$$0(4);
        }
        this.myProject = currentRepository.getProject();
        this.myCurrentRepository = currentRepository;
        this.myRepositoryManager = repositoryManager;
        this.myVcs = currentRepository.getVcs();
        this.myVcsSettings = vcsSettings;
        this.myMultiRootBranchConfig = multiRootBranchConfig;
        String title = this.myVcs.getDisplayName() + " Branches";
        this.myRepoTitleInfo = this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC ? " in " + DvcsUtil.getShortRepositoryName(currentRepository) : "";
        this.myPopup = new BranchActionGroupPopup(title + this.myRepoTitleInfo, this.myProject, preselectActionCondition, this.createActions(), dimensionKey);
        this.initBranchSyncPolicyIfNotInitialized();
        this.warnThatBranchesDivergedIfNeeded();
        if (this.myRepositoryManager.moreThanOneRoot()) {
            this.myPopup.addToolbarAction((AnAction)new TrackReposSynchronouslyAction(this.myVcsSettings), true);
        }
    }

    @NotNull
    public ListPopup asListPopup() {
        BranchActionGroupPopup branchActionGroupPopup = this.myPopup;
        if (branchActionGroupPopup == null) {
            DvcsBranchPopup.$$$reportNull$$$0(5);
        }
        return branchActionGroupPopup;
    }

    private void initBranchSyncPolicyIfNotInitialized() {
        if (this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.NOT_DECIDED) {
            if (!this.myMultiRootBranchConfig.diverged()) {
                this.notifyAboutSyncedBranches();
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.SYNC);
            } else {
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.DONT_SYNC);
            }
        }
    }

    private void notifyAboutSyncedBranches() {
        Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("Branch Operations Are Executed on All Roots", "", NotificationType.INFORMATION, null);
        notification.addAction((AnAction)NotificationAction.createSimple((String)"Disable...", () -> {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.myVcs.getConfigurable().getDisplayName());
            if (this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC) {
                notification.expire();
            }
        }));
        VcsNotifier.getInstance(this.myProject).notify(notification);
    }

    @NotNull
    private ActionGroup createActions() {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        AbstractRepositoryManager<Repo> repositoryManager = this.myRepositoryManager;
        if (repositoryManager.moreThanOneRoot()) {
            if (this.userWantsSyncControl()) {
                this.fillWithCommonRepositoryActions(popupGroup, repositoryManager);
            } else {
                this.fillPopupWithCurrentRepositoryActions(popupGroup, this.createRepositoriesActions());
            }
        } else {
            this.fillPopupWithCurrentRepositoryActions(popupGroup, null);
        }
        popupGroup.addSeparator();
        DefaultActionGroup defaultActionGroup = popupGroup;
        if (defaultActionGroup == null) {
            DvcsBranchPopup.$$$reportNull$$$0(6);
        }
        return defaultActionGroup;
    }

    protected boolean userWantsSyncControl() {
        return this.myVcsSettings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC;
    }

    protected abstract void fillWithCommonRepositoryActions(@NotNull DefaultActionGroup var1, @NotNull AbstractRepositoryManager<Repo> var2);

    @NotNull
    protected List<Repo> filterRepositoriesNotOnThisBranch(@NotNull String branch, @NotNull List<Repo> allRepositories) {
        if (branch == null) {
            DvcsBranchPopup.$$$reportNull$$$0(7);
        }
        if (allRepositories == null) {
            DvcsBranchPopup.$$$reportNull$$$0(8);
        }
        List list2 = ContainerUtil.filter(allRepositories, repository -> {
            if (branch == null) {
                DvcsBranchPopup.$$$reportNull$$$0(10);
            }
            return !branch.equals(repository.getCurrentBranchName());
        });
        if (list2 == null) {
            DvcsBranchPopup.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private void warnThatBranchesDivergedIfNeeded() {
        if (this.isBranchesDiverged()) {
            this.myPopup.setWarning("Branches have diverged");
        }
    }

    private boolean isBranchesDiverged() {
        return this.myRepositoryManager.moreThanOneRoot() && this.myMultiRootBranchConfig.diverged() && this.userWantsSyncControl();
    }

    @NotNull
    protected abstract DefaultActionGroup createRepositoriesActions();

    protected abstract void fillPopupWithCurrentRepositoryActions(@NotNull DefaultActionGroup var1, @Nullable DefaultActionGroup var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiRootBranchConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectActionCondition";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/branch/DvcsBranchPopup";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchPopup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asListPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRepositoriesNotOnThisBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterRepositoriesNotOnThisBranch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterRepositoriesNotOnThisBranch$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrackReposSynchronouslyAction
    extends ToggleAction
    implements DumbAware {
        private final DvcsSyncSettings myVcsSettings;

        public TrackReposSynchronouslyAction(@NotNull DvcsSyncSettings vcsSettings) {
            if (vcsSettings == null) {
                TrackReposSynchronouslyAction.$$$reportNull$$$0(0);
            }
            super(DvcsBundle.message("sync.setting", new Object[0]), DvcsBundle.message("sync.setting.description", "repository"), null);
            this.myVcsSettings = vcsSettings;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myVcsSettings.setSyncSetting(state ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsSettings", "com/intellij/dvcs/branch/DvcsBranchPopup$TrackReposSynchronouslyAction", "<init>"));
        }
    }

    public static class MyMoreIndex {
        public static final int MAX_NUM = 8;
        public static final int DEFAULT_NUM = 5;
    }
}

