/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionHelper {
    private static final Logger LOG = Logger.getInstance((String)ExecutionHelper.class.getName());

    private ExecutionHelper() {
    }

    public static void showErrors(@NotNull Project myProject, @NotNull List<? extends Exception> errors, @NotNull String tabDisplayName, @Nullable VirtualFile file2) {
        if (myProject == null) {
            ExecutionHelper.$$$reportNull$$$0(0);
        }
        if (errors == null) {
            ExecutionHelper.$$$reportNull$$$0(1);
        }
        if (tabDisplayName == null) {
            ExecutionHelper.$$$reportNull$$$0(2);
        }
        ExecutionHelper.showExceptions(myProject, errors, Collections.emptyList(), tabDisplayName, file2);
    }

    public static void showExceptions(@NotNull Project myProject, @NotNull List<? extends Exception> errors, @NotNull List<? extends Exception> warnings, @NotNull String tabDisplayName, @Nullable VirtualFile file2) {
        if (myProject == null) {
            ExecutionHelper.$$$reportNull$$$0(3);
        }
        if (errors == null) {
            ExecutionHelper.$$$reportNull$$$0(4);
        }
        if (warnings == null) {
            ExecutionHelper.$$$reportNull$$$0(5);
        }
        if (tabDisplayName == null) {
            ExecutionHelper.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !errors.isEmpty()) {
            throw new RuntimeException(errors.get(0));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (myProject == null) {
                ExecutionHelper.$$$reportNull$$$0(44);
            }
            if (errors == null) {
                ExecutionHelper.$$$reportNull$$$0(45);
            }
            if (warnings == null) {
                ExecutionHelper.$$$reportNull$$$0(46);
            }
            if (tabDisplayName == null) {
                ExecutionHelper.$$$reportNull$$$0(47);
            }
            if (myProject.isDisposed()) {
                return;
            }
            if (errors.isEmpty() && warnings.isEmpty()) {
                ContentManagerUtil.cleanupContents(null, myProject, tabDisplayName);
                return;
            }
            ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
            try {
                ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
            }
            catch (NullPointerException e) {
                StringBuilder builder = new StringBuilder();
                builder.append("Exceptions occurred:");
                for (Exception exception : errors) {
                    builder.append("\n");
                    builder.append(exception.getMessage());
                }
                builder.append("Warnings occurred:");
                for (Exception exception : warnings) {
                    builder.append("\n");
                    builder.append(exception.getMessage());
                }
                Messages.showErrorDialog((String)builder.toString(), (String)"Execution Error");
                return;
            }
            ExecutionHelper.addMessages(4, errors, errorTreeView, file2, "Unknown Error");
            ExecutionHelper.addMessages(5, warnings, errorTreeView, file2, "Unknown Warning");
            ToolWindowManager.getInstance((Project)myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
        });
    }

    private static void addMessages(int messageCategory, @NotNull List<? extends Exception> exceptions, @NotNull ErrorViewPanel errorTreeView, @Nullable VirtualFile file2, @NotNull String defaultMessage) {
        if (exceptions == null) {
            ExecutionHelper.$$$reportNull$$$0(7);
        }
        if (errorTreeView == null) {
            ExecutionHelper.$$$reportNull$$$0(8);
        }
        if (defaultMessage == null) {
            ExecutionHelper.$$$reportNull$$$0(9);
        }
        for (Exception exception : exceptions) {
            String[] messages;
            String message = exception.getMessage();
            String[] stringArray = messages = StringUtil.isNotEmpty((String)message) ? StringUtil.splitByLines((String)message) : ArrayUtil.EMPTY_STRING_ARRAY;
            if (messages.length == 0) {
                messages = new String[]{defaultMessage};
            }
            errorTreeView.addMessage(messageCategory, messages, file2, -1, -1, null);
        }
    }

    public static void showOutput(@NotNull Project myProject, @NotNull ProcessOutput output, @NotNull String tabDisplayName, @Nullable VirtualFile file2, boolean activateWindow) {
        if (myProject == null) {
            ExecutionHelper.$$$reportNull$$$0(10);
        }
        if (output == null) {
            ExecutionHelper.$$$reportNull$$$0(11);
        }
        if (tabDisplayName == null) {
            ExecutionHelper.$$$reportNull$$$0(12);
        }
        String stdout = output.getStdout();
        String stderr = output.getStderr();
        if (ApplicationManager.getApplication().isUnitTestMode() && !stdout.isEmpty() && !stderr.isEmpty()) {
            throw new RuntimeException("STDOUT:\n" + stdout + "\nSTDERR:\n" + stderr);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String[] stderrLines;
            String[] stdoutLines;
            if (myProject == null) {
                ExecutionHelper.$$$reportNull$$$0(41);
            }
            if (tabDisplayName == null) {
                ExecutionHelper.$$$reportNull$$$0(42);
            }
            if (output == null) {
                ExecutionHelper.$$$reportNull$$$0(43);
            }
            if (myProject.isDisposed()) {
                return;
            }
            String stdOutTitle = "[Stdout]:";
            String stderrTitle = "[Stderr]:";
            ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
            try {
                ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
            }
            catch (NullPointerException e) {
                Messages.showErrorDialog((String)("[Stdout]:\n" + (stdout != null ? stdout : "<empty>") + "\n" + "[Stderr]:" + "\n" + (stderr != null ? stderr : "<empty>")), (String)"Process Output");
                return;
            }
            if (!StringUtil.isEmpty((String)stdout) && (stdoutLines = StringUtil.splitByLines((String)stdout)).length > 0) {
                if (StringUtil.isEmpty((String)stderr)) {
                    errorTreeView.addMessage(1, stdoutLines, file2, -1, -1, null);
                } else if (file2 == null) {
                    errorTreeView.addMessage(1, stdoutLines, "[Stdout]:", NonNavigatable.INSTANCE, null, null, null);
                } else {
                    errorTreeView.addMessage(1, new String[]{"[Stdout]:"}, file2, -1, -1, null);
                    errorTreeView.addMessage(1, new String[]{""}, file2, -1, -1, null);
                    errorTreeView.addMessage(1, stdoutLines, file2, -1, -1, null);
                }
            }
            if (!StringUtil.isEmpty((String)stderr) && (stderrLines = StringUtil.splitByLines((String)stderr)).length > 0) {
                if (file2 == null) {
                    errorTreeView.addMessage(1, stderrLines, "[Stderr]:", NonNavigatable.INSTANCE, null, null, null);
                } else {
                    errorTreeView.addMessage(1, new String[]{"[Stderr]:"}, file2, -1, -1, null);
                    errorTreeView.addMessage(1, ArrayUtil.EMPTY_STRING_ARRAY, file2, -1, -1, null);
                    errorTreeView.addMessage(1, stderrLines, file2, -1, -1, null);
                }
            }
            errorTreeView.addMessage(1, new String[]{"Process finished with exit code " + output.getExitCode()}, null, -1, -1, null);
            if (activateWindow) {
                ToolWindowManager.getInstance((Project)myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
            }
        });
    }

    private static void openMessagesView(@NotNull ErrorViewPanel errorTreeView, @NotNull Project myProject, @NotNull String tabDisplayName) {
        if (errorTreeView == null) {
            ExecutionHelper.$$$reportNull$$$0(13);
        }
        if (myProject == null) {
            ExecutionHelper.$$$reportNull$$$0(14);
        }
        if (tabDisplayName == null) {
            ExecutionHelper.$$$reportNull$$$0(15);
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(myProject, () -> {
            if (myProject == null) {
                ExecutionHelper.$$$reportNull$$$0(38);
            }
            if (errorTreeView == null) {
                ExecutionHelper.$$$reportNull$$$0(39);
            }
            if (tabDisplayName == null) {
                ExecutionHelper.$$$reportNull$$$0(40);
            }
            MessageView messageView = (MessageView)ServiceManager.getService((Project)myProject, MessageView.class);
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, tabDisplayName, true);
            messageView.getContentManager().addContent(content);
            Disposer.register((Disposable)content, (Disposable)errorTreeView);
            messageView.getContentManager().setSelectedContent(content);
            ContentManagerUtil.cleanupContents(content, myProject, tabDisplayName);
        }, "Open message view", null);
    }

    public static Collection<RunContentDescriptor> findRunningConsoleByTitle(Project project, @NotNull NotNullFunction<String, Boolean> titleMatcher) {
        if (titleMatcher == null) {
            ExecutionHelper.$$$reportNull$$$0(16);
        }
        return ExecutionHelper.findRunningConsole(project, (NotNullFunction<RunContentDescriptor, Boolean>)((NotNullFunction)selectedContent -> {
            if (titleMatcher == null) {
                ExecutionHelper.$$$reportNull$$$0(37);
            }
            return (Boolean)titleMatcher.fun((Object)selectedContent.getDisplayName());
        }));
    }

    public static Collection<RunContentDescriptor> findRunningConsole(@NotNull Project project, @NotNull NotNullFunction<RunContentDescriptor, Boolean> descriptorMatcher) {
        ToolWindow toolWindow;
        RunContentManager contentManager;
        RunContentDescriptor selectedContent;
        if (project == null) {
            ExecutionHelper.$$$reportNull$$$0(17);
        }
        if (descriptorMatcher == null) {
            ExecutionHelper.$$$reportNull$$$0(18);
        }
        if ((selectedContent = (contentManager = ExecutionManager.getInstance((Project)project).getContentManager()).getSelectedContent()) != null && (toolWindow = contentManager.getToolWindowByDescriptor(selectedContent)) != null && toolWindow.isVisible() && ((Boolean)descriptorMatcher.fun((Object)selectedContent)).booleanValue()) {
            return Collections.singletonList(selectedContent);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (RunContentDescriptor runContentDescriptor : contentManager.getAllDescriptors()) {
            if (!((Boolean)descriptorMatcher.fun((Object)runContentDescriptor)).booleanValue()) continue;
            result2.add(runContentDescriptor);
        }
        return result2;
    }

    public static List<RunContentDescriptor> collectConsolesByDisplayName(@NotNull Project project, @NotNull NotNullFunction<String, Boolean> titleMatcher) {
        if (project == null) {
            ExecutionHelper.$$$reportNull$$$0(19);
        }
        if (titleMatcher == null) {
            ExecutionHelper.$$$reportNull$$$0(20);
        }
        SmartList result2 = new SmartList();
        for (RunContentDescriptor runContentDescriptor : ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors()) {
            if (!((Boolean)titleMatcher.fun((Object)runContentDescriptor.getDisplayName())).booleanValue()) continue;
            result2.add(runContentDescriptor);
        }
        return result2;
    }

    public static void selectContentDescriptor(@NotNull DataContext dataContext, @NotNull Project project, @NotNull Collection<RunContentDescriptor> consoles2, String selectDialogTitle, Consumer<RunContentDescriptor> descriptorConsumer) {
        if (dataContext == null) {
            ExecutionHelper.$$$reportNull$$$0(21);
        }
        if (project == null) {
            ExecutionHelper.$$$reportNull$$$0(22);
        }
        if (consoles2 == null) {
            ExecutionHelper.$$$reportNull$$$0(23);
        }
        if (consoles2.size() == 1) {
            RunContentDescriptor descriptor = consoles2.iterator().next();
            descriptorConsumer.consume((Object)descriptor);
            ExecutionHelper.descriptorToFront(project, descriptor);
        } else if (consoles2.size() > 1) {
            JBList list2 = new JBList(consoles2);
            final Icon icon = DefaultRunExecutor.getRunExecutorInstance().getIcon();
            list2.setCellRenderer(new ListCellRendererWrapper<RunContentDescriptor>(){

                public void customize(JList list2, RunContentDescriptor value, int index, boolean selected, boolean hasFocus) {
                    this.setText(value.getDisplayName());
                    this.setIcon(icon);
                }
            });
            PopupChooserBuilder builder = new PopupChooserBuilder((JList)list2);
            builder.setTitle(selectDialogTitle);
            builder.setItemChoosenCallback(() -> ExecutionHelper.lambda$selectContentDescriptor$4((JList)list2, descriptorConsumer, project)).createPopup().showInBestPositionFor(dataContext);
        }
    }

    private static void descriptorToFront(@NotNull Project project, @NotNull RunContentDescriptor descriptor) {
        if (project == null) {
            ExecutionHelper.$$$reportNull$$$0(24);
        }
        if (descriptor == null) {
            ExecutionHelper.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            RunContentManager manager;
            ToolWindow toolWindow;
            if (project == null) {
                ExecutionHelper.$$$reportNull$$$0(34);
            }
            if (descriptor == null) {
                ExecutionHelper.$$$reportNull$$$0(35);
            }
            if ((toolWindow = (manager = ExecutionManager.getInstance((Project)project).getContentManager()).getToolWindowByDescriptor(descriptor)) != null) {
                toolWindow.show(null);
                manager.selectRunContent(descriptor);
            }
        }, project.getDisposed());
    }

    public static void executeExternalProcess(@Nullable Project myProject, @NotNull ProcessHandler processHandler2, @NotNull ExecutionMode mode, @NotNull GeneralCommandLine cmdline) {
        if (processHandler2 == null) {
            ExecutionHelper.$$$reportNull$$$0(26);
        }
        if (mode == null) {
            ExecutionHelper.$$$reportNull$$$0(27);
        }
        if (cmdline == null) {
            ExecutionHelper.$$$reportNull$$$0(28);
        }
        ExecutionHelper.executeExternalProcess(myProject, processHandler2, mode, cmdline.getCommandLineString());
    }

    private static void executeExternalProcess(@Nullable Project myProject, @NotNull ProcessHandler processHandler2, @NotNull ExecutionMode mode, @NotNull String presentableCmdline) {
        String title;
        if (processHandler2 == null) {
            ExecutionHelper.$$$reportNull$$$0(29);
        }
        if (mode == null) {
            ExecutionHelper.$$$reportNull$$$0(30);
        }
        if (presentableCmdline == null) {
            ExecutionHelper.$$$reportNull$$$0(31);
        }
        String string = title = mode.getTitle() != null ? mode.getTitle() : "Please wait...";
        final Runnable process2 = mode.cancelable() ? ExecutionHelper.createCancelableExecutionProcess(processHandler2, mode.shouldCancelFun()) : (mode.getTimeout() <= 0 ? () -> {
            if (processHandler2 == null) {
                ExecutionHelper.$$$reportNull$$$0(33);
            }
            processHandler2.waitFor();
        } : ExecutionHelper.createTimeLimitedExecutionProcess(processHandler2, mode, presentableCmdline));
        if (mode.withModalProgress()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, title, mode.cancelable(), myProject, mode.getProgressParentComponent());
        } else if (mode.inBackGround()) {
            Task.Backgroundable task = new Task.Backgroundable(myProject, title, mode.cancelable()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    process2.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/ExecutionHelper$2", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)task);
        } else {
            String title2 = mode.getTitle2();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null && title2 != null) {
                indicator.setText2(title2);
            }
            process2.run();
        }
    }

    private static Runnable createCancelableExecutionProcess(final ProcessHandler processHandler2, final Function<Object, Boolean> cancelableFun) {
        return new Runnable(){
            private ProgressIndicator myProgressIndicator;
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myWaitThread = () -> {
                try {
                    processHandler2.waitFor();
                }
                finally {
                    this.mySemaphore.up();
                }
            };
            private final Runnable myCancelListener = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (myProgressIndicator != null && (myProgressIndicator.isCanceled() || !myProgressIndicator.isRunning()) || cancelableFun != null && ((Boolean)cancelableFun.fun(null)).booleanValue() || processHandler2.isProcessTerminated()) {
                            if (processHandler2.isProcessTerminated()) break;
                            try {
                                processHandler2.destroyProcess();
                                break;
                            }
                            finally {
                                mySemaphore.up();
                            }
                        }
                        try {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(1000L);
                                continue;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };

            @Override
            public void run() {
                this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (this.myProgressIndicator != null && StringUtil.isEmpty((String)this.myProgressIndicator.getText())) {
                    this.myProgressIndicator.setText("Please wait...");
                }
                LOG.assertTrue(this.myProgressIndicator != null || cancelableFun != null, (Object)"Cancelable process must have an opportunity to be canceled!");
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myWaitThread);
                ApplicationManager.getApplication().executeOnPooledThread(this.myCancelListener);
                this.mySemaphore.waitFor();
            }
        };
    }

    private static Runnable createTimeLimitedExecutionProcess(final ProcessHandler processHandler2, final ExecutionMode mode, final @NotNull String presentableCmdline) {
        if (presentableCmdline == null) {
            ExecutionHelper.$$$reportNull$$$0(32);
        }
        return new Runnable(){
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myProcessThread = () -> {
                if (presentableCmdline == null) {
                    4.$$$reportNull$$$0(0);
                }
                try {
                    boolean finished2 = processHandler2.waitFor((long)(1000 * mode.getTimeout()));
                    if (!finished2) {
                        mode.getTimeoutCallback().consume((Object)mode, (Object)presentableCmdline);
                        processHandler2.destroyProcess();
                    }
                }
                finally {
                    this.mySemaphore.up();
                }
            };

            @Override
            public void run() {
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myProcessThread);
                this.mySemaphore.waitFor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableCmdline", "com/intellij/execution/ExecutionHelper$4", "lambda$$0"));
            }
        };
    }

    private static /* synthetic */ void lambda$selectContentDescriptor$4(JList list2, Consumer descriptorConsumer, @NotNull Project project) {
        Object selectedValue;
        if (project == null) {
            ExecutionHelper.$$$reportNull$$$0(36);
        }
        if ((selectedValue = list2.getSelectedValue()) instanceof RunContentDescriptor) {
            RunContentDescriptor descriptor = (RunContentDescriptor)selectedValue;
            descriptorConsumer.consume((Object)descriptor);
            ExecutionHelper.descriptorToFront(project, descriptor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myProject";
                break;
            }
            case 1: 
            case 4: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 15: 
            case 40: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabDisplayName";
                break;
            }
            case 5: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 8: 
            case 13: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTreeView";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
            case 11: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 16: 
            case 20: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleMatcher";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorMatcher";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoles";
                break;
            }
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 26: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdline";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableCmdline";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ExecutionHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrors";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showExceptions";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addMessages";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "showOutput";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "openMessagesView";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findRunningConsoleByTitle";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "findRunningConsole";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "collectConsolesByDisplayName";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "selectContentDescriptor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "descriptorToFront";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "executeExternalProcess";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "createTimeLimitedExecutionProcess";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$executeExternalProcess$6";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$descriptorToFront$5";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$selectContentDescriptor$4";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findRunningConsoleByTitle$3";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$openMessagesView$2";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showOutput$1";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showExceptions$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ErrorViewPanel
    extends NewErrorTreeViewPanel {
        public ErrorViewPanel(Project project) {
            super(project, "reference.toolWindows.messages");
        }

        @Override
        protected boolean canHideWarnings() {
            return false;
        }
    }
}

