/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.EmptyIcon;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ShowFilePathAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ShowFilePathAction.class);
    public static final NotificationListener FILE_SELECTING_LISTENER = new NotificationListener.Adapter(){

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            URL url;
            if (notification == null) {
                1.$$$reportNull$$$0(0);
            }
            if (e == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((url = e.getURL()) != null) {
                ShowFilePathAction.openFile(new File(url.getPath()));
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/ShowFilePathAction$1";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NullableLazyValue<String> fileManagerApp = new AtomicNullableLazyValue<String>(){

        protected String compute() {
            return ShowFilePathAction.readDesktopEntryKey("Exec").map(line -> line.split(" ")[0]).filter(exec -> exec.endsWith("nautilus") || exec.endsWith("pantheon-files")).orElse(null);
        }
    };
    private static final NotNullLazyValue<String> fileManagerName = new AtomicNotNullLazyValue<String>(){

        @NotNull
        protected String compute() {
            if (SystemInfo.isMac) {
                if ("Finder" == null) {
                    3.$$$reportNull$$$0(0);
                }
                return "Finder";
            }
            if (SystemInfo.isWindows) {
                if ("Explorer" == null) {
                    3.$$$reportNull$$$0(1);
                }
                return "Explorer";
            }
            String string = ShowFilePathAction.readDesktopEntryKey("Name").orElse("File Manager");
            if (string == null) {
                3.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
        }
    };

    private static Optional<String> readDesktopEntryKey(String key) {
        String appName;
        if (SystemInfo.hasXdgMime() && (appName = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-mime", "query", "default", "inode/directory"}))) != null && appName.endsWith(".desktop")) {
            return Stream.of(ShowFilePathAction.getXdgDataDirectories().split(":")).map(dir -> new File((String)dir, "applications/" + appName)).filter(File::exists).findFirst().map(file2 -> ShowFilePathAction.readDesktopEntryKey(file2, key));
        }
        return Optional.empty();
    }

    private static String getXdgDataDirectories() {
        String dataHome = System.getenv("XDG_DATA_HOME");
        String dataDirs = System.getenv("XDG_DATA_DIRS");
        return StringUtil.defaultIfEmpty((String)dataHome, (String)(SystemProperties.getUserHome() + "/.local/share")) + ':' + StringUtil.defaultIfEmpty((String)dataDirs, (String)"/usr/local/share:/usr/share");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readDesktopEntryKey(File file2, String key) {
        LOG.debug("looking for '" + key + "' in " + file2);
        String prefix = key + '=';
        try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
            String string = reader.lines().filter(l -> l.startsWith(prefix)).map(l -> l.substring(prefix.length())).findFirst().orElse(null);
            return string;
        }
        catch (IOException | UncheckedIOException e) {
            LOG.info("Cannot read: " + file2, (Throwable)e);
            return null;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(0);
        }
        boolean visible = !SystemInfo.isMac && ShowFilePathAction.isSupported();
        e.getPresentation().setVisible(visible);
        if (visible) {
            VirtualFile file2 = ShowFilePathAction.getFile(e);
            e.getPresentation().setEnabled(file2 != null);
            e.getPresentation().setText(ActionsBundle.message((String)"action.ShowFilePath.tuned", (Object[])new Object[]{file2 != null && file2.isDirectory() ? 1 : 0}));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(1);
        }
        if ((file2 = ShowFilePathAction.getFile(e)) != null) {
            ShowFilePathAction.show(file2, (Consumer<ListPopup>)((Consumer)popup2 -> {
                DataManager dataManager = DataManager.getInstance();
                if (dataManager != null) {
                    dataManager.getDataContextFromFocus().doWhenDone(arg_0 -> ((ListPopup)popup2).showInBestPositionFor(arg_0));
                }
            }));
        }
    }

    @Nullable
    private static VirtualFile getFile(AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        return files2 == null || files2.length == 1 ? (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext()) : null;
    }

    public static void show(@NotNull VirtualFile file2, @NotNull MouseEvent e) {
        if (file2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(3);
        }
        ShowFilePathAction.show(file2, (Consumer<ListPopup>)((Consumer)popup2 -> {
            if (e == null) {
                ShowFilePathAction.$$$reportNull$$$0(13);
            }
            if (e.getComponent().isShowing()) {
                popup2.show(new RelativePoint(e));
            }
        }));
    }

    private static void show(@NotNull VirtualFile file2, @NotNull Consumer<ListPopup> action) {
        if (file2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(4);
        }
        if (action == null) {
            ShowFilePathAction.$$$reportNull$$$0(5);
        }
        if (!ShowFilePathAction.isSupported()) {
            return;
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        ArrayList<String> fileUrls = new ArrayList<String>();
        for (VirtualFile eachParent = file2; eachParent != null; eachParent = eachParent.getParent()) {
            int index = files2.size();
            files2.add(index, eachParent);
            fileUrls.add(index, ShowFilePathAction.getPresentableUrl(eachParent));
            if (eachParent.getParent() == null && eachParent.getFileSystem() instanceof JarFileSystem && (eachParent = JarFileSystem.getInstance().getVirtualFileForJar(eachParent)) == null) break;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (action == null) {
                ShowFilePathAction.$$$reportNull$$$0(11);
            }
            ArrayList<Icon> icons = new ArrayList<Icon>();
            for (String url : fileUrls) {
                File ioFile = new File(url);
                icons.add(ioFile.exists() ? FileSystemView.getFileSystemView().getSystemIcon(ioFile) : EmptyIcon.ICON_16);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (action == null) {
                    ShowFilePathAction.$$$reportNull$$$0(12);
                }
                action.consume((Object)ShowFilePathAction.createPopup(files2, icons));
            });
        });
    }

    private static String getPresentableUrl(VirtualFile file2) {
        String url = file2.getPresentableUrl();
        if (file2.getParent() == null && SystemInfo.isWindows) {
            url = url + "\\";
        }
        return url;
    }

    private static ListPopup createPopup(List<VirtualFile> files2, List<Icon> icons) {
        BaseListPopupStep<VirtualFile> step = new BaseListPopupStep<VirtualFile>(RevealFileAction.getActionName(), files2, icons){

            @NotNull
            public String getTextFor(VirtualFile value) {
                String string = value.getPresentableName();
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                File selectedFile = new File(ShowFilePathAction.getPresentableUrl(selectedValue));
                if (selectedFile.exists()) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> ShowFilePathAction.openFile(selectedFile));
                }
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$4", "getTextFor"));
            }
        };
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
    }

    public static boolean isSupported() {
        return SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.hasXdgOpen() || Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    @NotNull
    public static String getFileManagerName() {
        String string = (String)fileManagerName.getValue();
        if (string == null) {
            ShowFilePathAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void openFile(@NotNull File file2) {
        if (file2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(7);
        }
        if (!file2.exists()) {
            LOG.info("does not exist: " + file2);
            return;
        }
        try {
            file2 = file2.getAbsoluteFile();
            File parent = file2.getParentFile();
            if (parent != null) {
                ShowFilePathAction.doOpen(parent, file2);
            } else {
                ShowFilePathAction.doOpen(file2, null);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void openDirectory(@NotNull File directory) {
        if (directory == null) {
            ShowFilePathAction.$$$reportNull$$$0(8);
        }
        if (!directory.isDirectory()) {
            LOG.info("not a directory: " + directory);
            return;
        }
        try {
            ShowFilePathAction.doOpen(directory.getAbsoluteFile(), null);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void doOpen(@NotNull File _dir, @Nullable File _toSelect) throws IOException, ExecutionException {
        String toSelect2;
        if (_dir == null) {
            ShowFilePathAction.$$$reportNull$$$0(9);
        }
        String dir = FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)_dir.getPath()));
        String string = toSelect2 = _toSelect != null ? FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)_toSelect.getPath())) : null;
        if (SystemInfo.isWindows) {
            String cmd = toSelect2 != null ? "explorer /select,\"" + ShowFilePathAction.shortPath(toSelect2) + '\"' : "explorer /root,\"" + ShowFilePathAction.shortPath(dir) + '\"';
            LOG.debug(cmd);
            Process process2 = Runtime.getRuntime().exec(cmd);
            new CapturingProcessHandler(process2, null, cmd).runProcess().checkSuccess(LOG);
        } else if (SystemInfo.isMac) {
            GeneralCommandLine cmd = toSelect2 != null ? new GeneralCommandLine(new String[]{"open", "-R", toSelect2}) : new GeneralCommandLine(new String[]{"open", dir});
            LOG.debug(cmd.toString());
            ExecUtil.execAndGetOutput((GeneralCommandLine)cmd).checkSuccess(LOG);
        } else if (fileManagerApp.getValue() != null) {
            ShowFilePathAction.schedule(new GeneralCommandLine(new String[]{(String)fileManagerApp.getValue(), toSelect2 != null ? toSelect2 : dir}));
        } else if (SystemInfo.hasXdgOpen()) {
            ShowFilePathAction.schedule(new GeneralCommandLine(new String[]{"xdg-open", dir}));
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            LOG.debug("opening " + dir + " via desktop API");
            Desktop.getDesktop().open(new File(dir));
        } else {
            Messages.showErrorDialog((String)"This action isn't supported on the current platform", (String)"Cannot Open File");
        }
    }

    private static String shortPath(String path) {
        char[] result2;
        if (path.contains("  ") && Kernel32.INSTANCE.GetShortPathName(path, result2 = new char[260], result2.length) <= result2.length) {
            return Native.toString((char[])result2);
        }
        return path;
    }

    private static void schedule(GeneralCommandLine cmd) {
        PooledThreadExecutor.INSTANCE.submit(() -> {
            try {
                LOG.debug(cmd.toString());
                ExecUtil.execAndGetOutput((GeneralCommandLine)cmd).checkSuccess(LOG);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    public static void showDialog(Project project, String message, String title, @NotNull File file2, @Nullable DialogWrapper.DoNotAskOption option) {
        String cancel;
        String ok;
        if (file2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(10);
        }
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)title, (String)(ok = RevealFileAction.getActionName()), (String)(cancel = IdeBundle.message((String)"action.close", (Object[])new Object[0])), (Icon)Messages.getInformationIcon(), (DialogWrapper.DoNotAskOption)option) == 0) {
            ShowFilePathAction.openFile(file2);
        }
    }

    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file2) {
        if (file2 == null || file2.isInLocalFileSystem()) {
            return file2;
        }
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof ArchiveFileSystem && file2.getParent() == null) {
            return ((ArchiveFileSystem)fs).getLocalByEntry(file2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ShowFilePathAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ShowFilePathAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManagerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doOpen";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$show$7";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$show$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

