/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.ide.actions.TogglePresentationModeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.wm.WindowManager;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;

public class ToggleDistractionFreeModeAction
extends DumbAwareAction {
    private static final String key = "editor.distraction.free.mode";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(0);
        }
        if (e.getProject() == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String text = Registry.is((String)key) ? ActionsBundle.message((String)"action.ToggleDistractionFreeMode.exit", (Object[])new Object[0]) : ActionsBundle.message((String)"action.ToggleDistractionFreeMode.enter", (Object[])new Object[0]);
        e.getPresentation().setText(text);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        ToggleDistractionFreeModeAction.alternateCurrentDistractionFreeModeSetting();
        boolean enter = ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled();
        if (project == null) {
            return;
        }
        PropertiesComponent p = PropertiesComponent.getInstance();
        UISettings ui = UISettings.getInstance();
        EditorSettingsExternalizable.OptionSet eo = EditorSettingsExternalizable.getInstance().getOptions();
        DaemonCodeAnalyzerSettings ds = DaemonCodeAnalyzerSettings.getInstance();
        String before = "BEFORE.DISTRACTION.MODE.";
        String after = "AFTER.DISTRACTION.MODE.";
        if (enter) {
            ToggleDistractionFreeModeAction.applyAndSave(p, ui, eo, ds, before, after, false);
            TogglePresentationModeAction.storeToolWindows(project);
        } else {
            ToggleDistractionFreeModeAction.applyAndSave(p, ui, eo, ds, after, before, true);
            TogglePresentationModeAction.restoreToolWindows(project, true, false);
        }
        UISettings.getInstance().fireUISettingsChanged();
        LafManager.getInstance().updateUI();
        EditorUtil.reinitSettings();
        DaemonCodeAnalyzer.getInstance((Project)project).settingsChanged();
        EditorFactory.getInstance().refreshAllEditors();
        JFrame projectJFrame = WindowManager.getInstance().getFrame(project);
        if (projectJFrame != null) {
            projectJFrame.transferFocus();
        }
    }

    public static void applyAndSave(@NotNull PropertiesComponent p, @NotNull UISettings ui, @NotNull EditorSettingsExternalizable.OptionSet eo, @NotNull DaemonCodeAnalyzerSettings ds, String before, String after, boolean value) {
        if (p == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(2);
        }
        if (ui == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(3);
        }
        if (eo == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(4);
        }
        if (ds == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(5);
        }
        p.setValue(before + "SHOW_STATUS_BAR", String.valueOf(ui.getShowStatusBar()));
        ui.setShowStatusBar(p.getBoolean(after + "SHOW_STATUS_BAR", value));
        p.setValue(before + "SHOW_MAIN_TOOLBAR", String.valueOf(ui.getShowMainToolbar()));
        ui.setShowMainToolbar(p.getBoolean(after + "SHOW_MAIN_TOOLBAR", value));
        p.setValue(before + "SHOW_NAVIGATION_BAR", String.valueOf(ui.getShowNavigationBar()));
        ui.setShowNavigationBar(p.getBoolean(after + "SHOW_NAVIGATION_BAR", value));
        p.setValue(before + "IS_FOLDING_OUTLINE_SHOWN", String.valueOf(eo.IS_FOLDING_OUTLINE_SHOWN));
        eo.IS_FOLDING_OUTLINE_SHOWN = p.getBoolean(after + "IS_FOLDING_OUTLINE_SHOWN", value);
        p.setValue(before + "IS_WHITESPACES_SHOWN", String.valueOf(eo.IS_WHITESPACES_SHOWN));
        eo.IS_WHITESPACES_SHOWN = p.getBoolean(after + "IS_WHITESPACES_SHOWN", value);
        p.setValue(before + "ARE_LINE_NUMBERS_SHOWN", String.valueOf(eo.ARE_LINE_NUMBERS_SHOWN));
        eo.ARE_LINE_NUMBERS_SHOWN = p.getBoolean(after + "ARE_LINE_NUMBERS_SHOWN", value);
        p.setValue(before + "ARE_GUTTER_ICONS_SHOWN", String.valueOf(eo.ARE_GUTTER_ICONS_SHOWN));
        eo.ARE_GUTTER_ICONS_SHOWN = p.getBoolean(after + "ARE_GUTTER_ICONS_SHOWN", value);
        p.setValue(before + "IS_RIGHT_MARGIN_SHOWN", String.valueOf(eo.IS_RIGHT_MARGIN_SHOWN));
        eo.IS_RIGHT_MARGIN_SHOWN = p.getBoolean(after + "IS_RIGHT_MARGIN_SHOWN", value);
        p.setValue(before + "IS_INDENT_GUIDES_SHOWN", String.valueOf(eo.IS_INDENT_GUIDES_SHOWN));
        eo.IS_INDENT_GUIDES_SHOWN = p.getBoolean(after + "IS_INDENT_GUIDES_SHOWN", value);
        p.setValue(before + "SHOW_BREADCRUMBS", String.valueOf(eo.SHOW_BREADCRUMBS));
        eo.SHOW_BREADCRUMBS = p.getBoolean(after + "SHOW_BREADCRUMBS", value);
        p.setValue(before + "SHOW_METHOD_SEPARATORS", String.valueOf(ds.SHOW_METHOD_SEPARATORS));
        ds.SHOW_METHOD_SEPARATORS = p.getBoolean(after + "SHOW_METHOD_SEPARATORS", value);
        p.setValue(before + "HIDE_TOOL_STRIPES", String.valueOf(ui.getHideToolStripes()));
        ui.setHideToolStripes(p.getBoolean(after + "HIDE_TOOL_STRIPES", !value));
        p.setValue(before + "EDITOR_TAB_PLACEMENT", String.valueOf(ui.getEditorTabPlacement()));
        ui.setEditorTabPlacement(p.getInt(after + "EDITOR_TAB_PLACEMENT", value ? 1 : 0));
    }

    public static boolean isDistractionFreeModeEnabled() {
        return Registry.get((String)key).asBoolean();
    }

    private static void alternateCurrentDistractionFreeModeSetting() {
        RegistryValue value;
        value.setValue(!(value = Registry.get((String)key)).asBoolean());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/ToggleDistractionFreeModeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "applyAndSave";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

