/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultCreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultTemplatePropertiesProvider;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.VelocityWrapper;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTSetDirective;
import org.apache.velocity.runtime.parser.node.ASTStringLiteral;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplateUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.FileTemplateUtil");
    private static final CreateFromTemplateHandler DEFAULT_HANDLER = new DefaultCreateFromTemplateHandler();

    public static String[] calculateAttributes(String templateContent, Properties properties, boolean includeDummies, Project project) throws ParseException {
        HashSet<String> propertiesNames = new HashSet<String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            propertiesNames.add((String)e.nextElement());
        }
        return FileTemplateUtil.calculateAttributes(templateContent, propertiesNames, includeDummies, project);
    }

    public static String[] calculateAttributes(String templateContent, Map<String, Object> properties, boolean includeDummies, Project project) throws ParseException {
        return FileTemplateUtil.calculateAttributes(templateContent, properties.keySet(), includeDummies, project);
    }

    private static String[] calculateAttributes(String templateContent, Set<String> propertiesNames, boolean includeDummies, Project project) throws ParseException {
        LinkedHashSet<String> unsetAttributes = new LinkedHashSet<String>();
        HashSet<String> definedAttributes = new HashSet<String>();
        SimpleNode template = VelocityWrapper.parse(new StringReader(templateContent), "MyTemplate");
        FileTemplateUtil.collectAttributes(unsetAttributes, definedAttributes, (Node)template, propertiesNames, includeDummies, new HashSet<String>(), project);
        for (String definedAttribute : definedAttributes) {
            unsetAttributes.remove(definedAttribute);
        }
        return ArrayUtil.toStringArray(unsetAttributes);
    }

    private static void collectAttributes(Set<String> referenced, Set<String> defined, Node apacheNode, Set<String> propertiesNames, boolean includeDummies, Set<String> visitedIncludes, Project project) throws ParseException {
        int childCount = apacheNode.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            Token firstToken;
            Node literal;
            Node apacheChild = apacheNode.jjtGetChild(i);
            FileTemplateUtil.collectAttributes(referenced, defined, apacheChild, propertiesNames, includeDummies, visitedIncludes, project);
            if (apacheChild instanceof ASTReference) {
                ASTReference apacheReference = (ASTReference)apacheChild;
                String s = apacheReference.literal();
                if ((s = FileTemplateUtil.referenceToAttribute(s, includeDummies)) == null || s.length() <= 0 || propertiesNames.contains(s)) continue;
                referenced.add(s);
                continue;
            }
            if (apacheChild instanceof ASTSetDirective) {
                ASTReference lhs = (ASTReference)apacheChild.jjtGetChild(0);
                String attr = FileTemplateUtil.referenceToAttribute(lhs.literal(), false);
                if (attr == null) continue;
                defined.add(attr);
                continue;
            }
            if (!(apacheChild instanceof ASTDirective) || !"parse".equals(((ASTDirective)apacheChild).getDirectiveName()) || apacheChild.jjtGetNumChildren() != 1 || !((literal = apacheChild.jjtGetChild(0)) instanceof ASTStringLiteral) || literal.jjtGetNumChildren() != 0 || (firstToken = literal.getFirstToken()) == null) continue;
            String s = StringUtil.unquoteString((String)firstToken.toString());
            FileTemplate includedTemplate = FileTemplateManager.getInstance(project).getTemplate(s);
            if (includedTemplate == null || !visitedIncludes.add(s)) continue;
            SimpleNode template = VelocityWrapper.parse(new StringReader(includedTemplate.getText()), "MyTemplate");
            FileTemplateUtil.collectAttributes(referenced, defined, (Node)template, propertiesNames, includeDummies, visitedIncludes, project);
        }
    }

    @Nullable
    private static String referenceToAttribute(String attrib, boolean includeDummies) {
        while (attrib.startsWith("\\\\")) {
            attrib = attrib.substring(2);
        }
        if (attrib.startsWith("\\$")) {
            if (includeDummies) {
                attrib = attrib.substring(1);
            } else {
                return null;
            }
        }
        if (!StringUtil.startsWithChar((CharSequence)attrib, (char)'$')) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)(attrib = attrib.substring(1)), (char)'{')) {
            String cleanAttribute = null;
            for (int i = 1; i < attrib.length(); ++i) {
                char currChar = attrib.charAt(i);
                if (currChar == '{' || currChar == '.') {
                    cleanAttribute = null;
                    break;
                }
                if (currChar != '}') continue;
                cleanAttribute = attrib.substring(1, i);
                break;
            }
            attrib = cleanAttribute;
        } else {
            for (int i = 0; i < attrib.length(); ++i) {
                char currChar = attrib.charAt(i);
                if (currChar != '{' && currChar != '}' && currChar != '.') continue;
                attrib = attrib.substring(0, i);
                break;
            }
        }
        return attrib;
    }

    public static String mergeTemplate(Map attributes, String content, boolean useSystemLineSeparators) throws IOException {
        VelocityContext context = FileTemplateUtil.createVelocityContext();
        for (Object o : attributes.keySet()) {
            String name = (String)o;
            context.put(name, attributes.get(name));
        }
        return FileTemplateUtil.mergeTemplate(content, context, useSystemLineSeparators, null);
    }

    private static VelocityContext createVelocityContext() {
        VelocityContext context = new VelocityContext();
        context.put("StringUtils", StringUtils.class);
        return context;
    }

    public static String mergeTemplate(Properties attributes, String content, boolean useSystemLineSeparators) throws IOException {
        return FileTemplateUtil.mergeTemplate(attributes, content, useSystemLineSeparators, null);
    }

    public static String mergeTemplate(Properties attributes, String content, boolean useSystemLineSeparators, @Nullable Consumer<VelocityException> exceptionHandler) throws IOException {
        VelocityContext context = FileTemplateUtil.createVelocityContext();
        Enumeration<?> names = attributes.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            context.put(name, (Object)attributes.getProperty(name));
        }
        return FileTemplateUtil.mergeTemplate(content, context, useSystemLineSeparators, exceptionHandler);
    }

    private static String mergeTemplate(String templateContent, VelocityContext context, boolean useSystemLineSeparators, @Nullable Consumer<VelocityException> exceptionHandler) throws IOException {
        String newSeparator;
        StringWriter stringWriter = new StringWriter();
        try {
            Project project = null;
            Object projectName = context.get("PROJECT_NAME");
            if (projectName instanceof String) {
                Object[] projects = ProjectManager.getInstance().getOpenProjects();
                project = (Project)ContainerUtil.find((Object[])projects, project1 -> projectName.equals(project1.getName()));
            }
            VelocityWrapper.evaluate(project, (Context)context, stringWriter, templateContent);
        }
        catch (VelocityException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error((Throwable)e);
            }
            LOG.info("Error evaluating template:\n" + templateContent, (Throwable)e);
            if (exceptionHandler == null) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)IdeBundle.message((String)"error.parsing.file.template", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.velocity.error", (Object[])new Object[0])));
            }
            exceptionHandler.consume((Object)e);
        }
        String result2 = stringWriter.toString();
        if (useSystemLineSeparators && !"\n".equals(newSeparator = CodeStyleSettingsManager.getSettings((Project)ProjectManagerEx.getInstanceEx().getDefaultProject()).getLineSeparator())) {
            return StringUtil.convertLineSeparators((String)result2, (String)newSeparator);
        }
        return result2;
    }

    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @Nullable String fileName, @Nullable Properties props, @NotNull PsiDirectory directory) throws Exception {
        HashMap<String, Object> map;
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            FileTemplateUtil.$$$reportNull$$$0(1);
        }
        if (props != null) {
            map = new HashMap<String, Object>();
            FileTemplateUtil.putAll(map, props);
        } else {
            map = null;
        }
        return FileTemplateUtil.createFromTemplate(template, fileName, map, directory, null);
    }

    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @Nullable String fileName, @Nullable Properties props, @NotNull PsiDirectory directory, @Nullable ClassLoader classLoader) throws Exception {
        HashMap<String, Object> map;
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            FileTemplateUtil.$$$reportNull$$$0(3);
        }
        if (props != null) {
            map = new HashMap<String, Object>();
            FileTemplateUtil.putAll(map, props);
        } else {
            map = null;
        }
        return FileTemplateUtil.createFromTemplate(template, fileName, map, directory, classLoader);
    }

    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @Nullable String fileName, @Nullable Map<String, Object> propsMap, @NotNull PsiDirectory directory, @Nullable ClassLoader classLoader) throws Exception {
        String[] dummyRefs;
        Properties p;
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(4);
        }
        if (directory == null) {
            FileTemplateUtil.$$$reportNull$$$0(5);
        }
        Project project = directory.getProject();
        FileTemplateManager.getInstance(project).addRecentName(template.getName());
        if (propsMap == null) {
            p = FileTemplateManager.getInstance(project).getDefaultProperties();
            propsMap = new HashMap<String, Object>();
            FileTemplateUtil.putAll(propsMap, p);
        }
        p = new Properties();
        FileTemplateUtil.fillDefaultProperties(p, directory);
        FileTemplateUtil.putAll(propsMap, p);
        CreateFromTemplateHandler handler2 = FileTemplateUtil.findHandler(template);
        if (fileName != null && propsMap.get("NAME") == null) {
            propsMap.put("NAME", fileName);
        } else if (fileName == null && handler2.isNameRequired() && (fileName = (String)propsMap.get("NAME")) == null) {
            throw new Exception("File name must be specified");
        }
        for (String dummyRef : dummyRefs = FileTemplateUtil.calculateAttributes(template.getText(), propsMap, true, directory.getProject())) {
            propsMap.put(dummyRef, "");
        }
        handler2.prepareProperties(propsMap);
        Map<String, Object> props_ = propsMap;
        String fileName_ = fileName;
        String mergedText = (String)ClassLoaderUtil.runWithClassLoader((ClassLoader)(classLoader != null ? classLoader : FileTemplateUtil.class.getClassLoader()), () -> {
            if (template == null) {
                FileTemplateUtil.$$$reportNull$$$0(18);
            }
            return template.getText(props_);
        });
        String templateText = StringUtil.convertLineSeparators((String)mergedText);
        Exception[] commandException = new Exception[1];
        PsiElement[] result2 = new PsiElement[1];
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (directory == null) {
                FileTemplateUtil.$$$reportNull$$$0(14);
            }
            if (template == null) {
                FileTemplateUtil.$$$reportNull$$$0(15);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (directory == null) {
                    FileTemplateUtil.$$$reportNull$$$0(16);
                }
                if (template == null) {
                    FileTemplateUtil.$$$reportNull$$$0(17);
                }
                try {
                    result2[0] = handler2.createFromTemplate(project, directory, fileName_, template, templateText, props_);
                }
                catch (Exception ex) {
                    commandException[0] = ex;
                }
            });
        }, handler2.commandName(template), null);
        if (commandException[0] != null) {
            throw commandException[0];
        }
        return result2[0];
    }

    public static CreateFromTemplateHandler findHandler(FileTemplate template) {
        for (CreateFromTemplateHandler handler2 : (CreateFromTemplateHandler[])Extensions.getExtensions(CreateFromTemplateHandler.EP_NAME)) {
            if (!handler2.handlesTemplate(template)) continue;
            return handler2;
        }
        return DEFAULT_HANDLER;
    }

    public static void fillDefaultProperties(Properties props, PsiDirectory directory) {
        DefaultTemplatePropertiesProvider[] providers;
        for (DefaultTemplatePropertiesProvider provider : providers = (DefaultTemplatePropertiesProvider[])Extensions.getExtensions((ExtensionPointName)DefaultTemplatePropertiesProvider.EP_NAME)) {
            provider.fillProperties(directory, props);
        }
    }

    public static String indent(String methodText, Project project, FileType fileType) {
        int indent = CodeStyleSettingsManager.getSettings((Project)project).getIndentSize(fileType);
        return methodText.replaceAll("\n", "\n" + StringUtil.repeatSymbol((char)' ', (int)indent));
    }

    public static boolean canCreateFromTemplate(PsiDirectory[] dirs, FileTemplate template) {
        FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension());
        if (fileType.equals(FileTypes.UNKNOWN)) {
            return false;
        }
        CreateFromTemplateHandler handler2 = FileTemplateUtil.findHandler(template);
        return handler2.canCreate(dirs);
    }

    @Nullable
    public static Icon getIcon(@NotNull FileTemplate fileTemplate) {
        if (fileTemplate == null) {
            FileTemplateUtil.$$$reportNull$$$0(6);
        }
        return FileTypeManager.getInstance().getFileTypeByExtension(fileTemplate.getExtension()).getIcon();
    }

    public static void putAll(Map<String, Object> props, Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            props.put(s, p.getProperty(s));
        }
    }

    @NotNull
    public static FileTemplate createTemplate(@NotNull String prefName, @NotNull String extension, @NotNull String content, FileTemplate[] templates) {
        if (prefName == null) {
            FileTemplateUtil.$$$reportNull$$$0(7);
        }
        if (extension == null) {
            FileTemplateUtil.$$$reportNull$$$0(8);
        }
        if (content == null) {
            FileTemplateUtil.$$$reportNull$$$0(9);
        }
        HashSet<String> names = new HashSet<String>();
        for (FileTemplate template : templates) {
            names.add(template.getName());
        }
        String name = prefName;
        int i = 0;
        while (names.contains(name)) {
            name = prefName + " (" + ++i + ")";
        }
        CustomFileTemplate newTemplate = new CustomFileTemplate(name, extension);
        newTemplate.setText(content);
        CustomFileTemplate customFileTemplate = newTemplate;
        if (customFileTemplate == null) {
            FileTemplateUtil.$$$reportNull$$$0(10);
        }
        return customFileTemplate;
    }

    public static Pattern getTemplatePattern(@NotNull FileTemplate template, @NotNull Project project, @NotNull TIntObjectHashMap<String> offsetToProperty) {
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(11);
        }
        if (project == null) {
            FileTemplateUtil.$$$reportNull$$$0(12);
        }
        if (offsetToProperty == null) {
            FileTemplateUtil.$$$reportNull$$$0(13);
        }
        String templateText = template.getText().trim();
        String regex = FileTemplateUtil.templateToRegex(templateText, offsetToProperty, project);
        regex = StringUtil.replace((String)regex, (String)"with", (String)"(?:with|by)");
        regex = ".*(" + regex + ").*";
        return Pattern.compile(regex, 32);
    }

    private static String templateToRegex(String text, TIntObjectHashMap<String> offsetToProperty, Project project) {
        ArrayList properties = ContainerUtil.newArrayList(FileTemplateManager.getInstance(project).getDefaultProperties().keySet());
        properties.add("PACKAGE_NAME");
        String regex = FileTemplateUtil.escapeRegexChars(text);
        int groupNumber = 1;
        for (Object property : properties) {
            String name = property.toString();
            String escaped = FileTemplateUtil.escapeRegexChars("${" + name + "}");
            boolean first = true;
            int i = regex.indexOf(escaped);
            while (i != -1 && i < regex.length()) {
                int[] offs;
                String replacement = first ? "([^\\n]*)" : "\\" + groupNumber;
                int delta = escaped.length() - replacement.length();
                for (int off : offs = offsetToProperty.keys()) {
                    if (off <= i) continue;
                    String prop = (String)offsetToProperty.remove(off);
                    offsetToProperty.put(off - delta, (Object)prop);
                }
                offsetToProperty.put(i, (Object)name);
                regex = regex.substring(0, i) + replacement + regex.substring(i + escaped.length());
                if (first) {
                    ++groupNumber;
                    first = false;
                }
                i = regex.indexOf(escaped, i + 1);
            }
        }
        return regex;
    }

    private static String escapeRegexChars(String regex) {
        regex = StringUtil.replace((String)regex, (String)"|", (String)"\\|");
        regex = StringUtil.replace((String)regex, (String)".", (String)"\\.");
        regex = StringUtil.replace((String)regex, (String)"*", (String)"\\*");
        regex = StringUtil.replace((String)regex, (String)"+", (String)"\\+");
        regex = StringUtil.replace((String)regex, (String)"?", (String)"\\?");
        regex = StringUtil.replace((String)regex, (String)"$", (String)"\\$");
        regex = StringUtil.replace((String)regex, (String)"(", (String)"\\(");
        regex = StringUtil.replace((String)regex, (String)")", (String)"\\)");
        regex = StringUtil.replace((String)regex, (String)"[", (String)"\\[");
        regex = StringUtil.replace((String)regex, (String)"]", (String)"\\]");
        regex = StringUtil.replace((String)regex, (String)"{", (String)"\\{");
        regex = StringUtil.replace((String)regex, (String)"}", (String)"\\}");
        return regex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTemplate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/FileTemplateUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetToProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/FileTemplateUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTemplatePattern";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createFromTemplate$4";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createFromTemplate$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

