/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.connect.StatServiceException;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.EventLogStatisticsSettingsService;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.LogEventContent;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogStatisticsService
implements StatisticsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.eventLog.EventLogStatisticsService");
    private static final EventLogStatisticsSettingsService mySettingsService = EventLogStatisticsSettingsService.getInstance();

    @Override
    public StatisticsResult send() {
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            throw new StatServiceException("Event Log collector is not enabled");
        }
        String serviceUrl = mySettingsService.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: unknown Statistics Service URL.");
        }
        if (!mySettingsService.isTransmissionPermitted()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        try {
            int succeed = 0;
            List logs = FeatureUsageLogger.INSTANCE.getLogFiles();
            ArrayList<File> toRemove2 = new ArrayList<File>(logs.size());
            for (File file2 : logs) {
                LogEventContent session2 = LogEventContent.Companion.create(file2);
                String error = EventLogStatisticsService.validate(session2, file2);
                if (session2 != null && StringUtil.isEmpty((String)error)) {
                    HttpPost post;
                    CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                    HttpResponse response = httpClient.execute((HttpUriRequest)(post = EventLogStatisticsService.createPostRequest(serviceUrl, LogEventSerializer.INSTANCE.toString(session2))));
                    int code2 = response.getStatusLine().getStatusCode();
                    if (code2 == 200) {
                        toRemove2.add(file2);
                        ++succeed;
                    } else if (code2 == 400) {
                        toRemove2.add(file2);
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace(EventLogStatisticsService.getResponseMessage(response));
                    continue;
                }
                if (LOG.isTraceEnabled() && StringUtil.isNotEmpty((String)error)) {
                    LOG.trace(error);
                }
                toRemove2.add(file2);
            }
            this.cleanupSentFiles(toRemove2);
            UsageStatisticsPersistenceComponent.getInstance().setEventLogSentTime(System.currentTimeMillis());
            if (logs.isEmpty()) {
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
            }
            if (succeed != logs.size()) {
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, "Uploaded " + succeed + " out of " + logs.size() + " files.");
            }
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "Uploaded " + succeed + " files.");
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new StatServiceException("Error during data sending.", e);
        }
    }

    @Nullable
    private static String validate(@Nullable LogEventContent content, @NotNull File file2) {
        if (file2 == null) {
            EventLogStatisticsService.$$$reportNull$$$0(0);
        }
        if (content == null) {
            return "File is empty or has invalid format: " + file2.getName();
        }
        if (StringUtil.isEmpty((String)content.getUser())) {
            return "Cannot upload event log, user ID is empty";
        }
        if (StringUtil.isEmpty((String)content.getProduct())) {
            return "Cannot upload event log, product code is empty";
        }
        return null;
    }

    public void cleanupSentFiles(@NotNull List<File> toRemove2) {
        if (toRemove2 == null) {
            EventLogStatisticsService.$$$reportNull$$$0(1);
        }
        for (File file2 : toRemove2) {
            if (!file2.delete()) {
                LOG.warn("Failed deleting event log: " + file2.getName());
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Removed sent log: " + file2.getName());
        }
    }

    @NotNull
    public static HttpPost createPostRequest(@NotNull String serviceUrl, @NotNull String content) throws UnsupportedEncodingException {
        if (serviceUrl == null) {
            EventLogStatisticsService.$$$reportNull$$$0(2);
        }
        if (content == null) {
            EventLogStatisticsService.$$$reportNull$$$0(3);
        }
        HttpPost post = new HttpPost(serviceUrl);
        StringEntity postingString = new StringEntity(content);
        post.setEntity((HttpEntity)postingString);
        post.setHeader("Content-type", "application/json");
        HttpPost httpPost = post;
        if (httpPost == null) {
            EventLogStatisticsService.$$$reportNull$$$0(4);
        }
        return httpPost;
    }

    @Override
    public Notification createNotification(@NotNull String groupDisplayId, @Nullable NotificationListener listener2) {
        if (groupDisplayId == null) {
            EventLogStatisticsService.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    private static String getResponseMessage(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String string = StreamUtil.readText((InputStream)entity.getContent(), (String)"UTF-8");
            if (string == null) {
                EventLogStatisticsService.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = Integer.toString(response.getStatusLine().getStatusCode());
        if (string == null) {
            EventLogStatisticsService.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogStatisticsService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogStatisticsService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPostRequest";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cleanupSentFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPostRequest";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

