/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.gson.JsonSyntaxException;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventContent;", "", "events", "", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "(Ljava/util/List;)V", "getEvents", "()Ljava/util/List;", "product", "", "getProduct", "()Ljava/lang/String;", "user", "getUser", "Companion", "intellij.platform.ide.impl"})
public final class LogEventContent {
    @NotNull
    private final String product;
    @NotNull
    private final String user;
    @NotNull
    private final List<LogEvent> events;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final String getProduct() {
        return this.product;
    }

    @NotNull
    public final String getUser() {
        return this.user;
    }

    @NotNull
    public final List<LogEvent> getEvents() {
        return this.events;
    }

    public LogEventContent(@NotNull List<? extends LogEvent> events) {
        Intrinsics.checkParameterIsNotNull(events, (String)"events");
        this.events = events;
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        this.product = buildNumber.getProductCode();
        this.user = PermanentInstallationID.get();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(LogEventContent.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventContent$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/intellij/internal/statistic/eventLog/LogEventContent;", "file", "Ljava/io/File;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final LogEventContent create(@NotNull File file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            try {
                ArrayList<LogEvent> events = new ArrayList<LogEvent>();
                Closeable closeable = new BufferedReader(new FileReader(file2.getPath()));
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    String line = reader.readLine();
                    while (line != null) {
                        events.add(LogEventSerializer.INSTANCE.fromString(line));
                        line = reader.readLine();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                if (!events.isEmpty()) {
                    return new LogEventContent((List<? extends LogEvent>)events);
                }
            }
            catch (JsonSyntaxException e) {
                this.getLOG().warn((Throwable)e);
            }
            catch (IOException e) {
                this.getLOG().warn((Throwable)e);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

