/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffErrorElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.SortedList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DTree {
    private static final Comparator<DTree> COMPARATOR = (o1, o2) -> {
        boolean b1 = o1.isContainer();
        boolean b2 = o2.isContainer();
        return b1 && b2 || !b1 && !b2 ? o1.getName().compareToIgnoreCase(o2.getName()) : (b1 ? 1 : -1);
    };
    private boolean myExpanded;
    @Nullable
    private final DTree myParent;
    private HashMap<String, DTree> myChildren;
    private final String myName;
    private final boolean isContainer;
    private SortedList<DTree> myChildrenList;
    private DiffElement<?> mySource;
    private DiffElement<?> myTarget;
    private DiffType myType;
    private boolean myVisible;
    private String myPath;

    public DTree(@Nullable DTree parent, @NotNull String name, boolean container) {
        if (name == null) {
            DTree.$$$reportNull$$$0(0);
        }
        this.myExpanded = true;
        this.myVisible = true;
        this.myPath = null;
        this.myParent = parent;
        this.myName = name;
        this.isContainer = container;
    }

    @NotNull
    public Collection<DTree> getChildren() {
        this.init();
        if (this.myChildrenList == null) {
            this.myChildrenList = new SortedList(COMPARATOR);
            this.myChildrenList.addAll(this.myChildren.values());
        }
        SortedList<DTree> sortedList = this.myChildrenList;
        if (sortedList == null) {
            DTree.$$$reportNull$$$0(1);
        }
        return sortedList;
    }

    public DTree addChild(@NotNull DiffElement element, boolean source, String replacementName) {
        DTree node;
        if (element == null) {
            DTree.$$$reportNull$$$0(2);
        }
        this.init();
        this.myChildrenList = null;
        String name = element.getName();
        if (replacementName != null && this.myChildren.containsKey(replacementName)) {
            node = this.myChildren.get(replacementName);
        } else if (this.myChildren.containsKey(name)) {
            node = this.myChildren.get(name);
        } else {
            node = new DTree(this, name, element.isContainer());
            this.myChildren.put(name, node);
        }
        if (source) {
            node.setSource(element);
        } else {
            node.setTarget(element);
        }
        return node;
    }

    public DiffElement<?> getSource() {
        return this.mySource;
    }

    public void setSource(DiffElement<?> source) {
        this.mySource = source;
    }

    public DiffElement<?> getTarget() {
        return this.myTarget;
    }

    public void setTarget(DiffElement<?> target2) {
        this.myTarget = target2;
    }

    private void init() {
        if (this.myChildren == null) {
            this.myChildren = new HashMap();
        }
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public DTree getParent() {
        return this.myParent;
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public String toString() {
        return this.myName;
    }

    public void update(DirDiffSettings settings) {
        for (DTree tree : this.getChildren()) {
            DiffElement<?> src = tree.getSource();
            DiffElement<?> trg = tree.getTarget();
            if (src instanceof DiffErrorElement || trg instanceof DiffErrorElement) {
                tree.setType(DiffType.ERROR);
            } else if (src == null && trg != null) {
                tree.setType(DiffType.TARGET);
            } else if (src != null && trg == null) {
                tree.setType(DiffType.SOURCE);
            } else {
                boolean equals;
                assert (src != null);
                switch (settings.compareMode) {
                    case CONTENT: {
                        equals = DTree.isEqualContents(src, trg);
                        break;
                    }
                    case TEXT: {
                        equals = DTree.isEqualContentsAsText(src, trg);
                        break;
                    }
                    case SIZE: {
                        equals = DTree.isEqualSizes(src, trg);
                        break;
                    }
                    case TIMESTAMP: {
                        equals = DTree.isEqualTimestamps(src, trg, settings);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(settings.compareMode.name());
                    }
                }
                tree.setType(equals ? DiffType.EQUAL : DiffType.CHANGED);
            }
            tree.update(settings);
        }
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void updateVisibility(DirDiffSettings settings) {
        if (this.getChildren().isEmpty()) {
            if (this.myType == DiffType.ERROR) {
                this.myVisible = true;
                return;
            }
            if (this.myType != DiffType.SEPARATOR && !"".equals(settings.getFilter()) && !settings.getFilterPattern().matcher(this.getName()).matches()) {
                this.myVisible = false;
                return;
            }
            if (this.myType == null) {
                this.myVisible = true;
            } else {
                switch (this.myType) {
                    case SOURCE: {
                        this.myVisible = settings.showNewOnSource;
                        break;
                    }
                    case TARGET: {
                        this.myVisible = settings.showNewOnTarget;
                        break;
                    }
                    case SEPARATOR: 
                    case ERROR: {
                        this.myVisible = true;
                        break;
                    }
                    case CHANGED: {
                        this.myVisible = settings.showDifferent;
                        break;
                    }
                    case EQUAL: {
                        this.myVisible = settings.showEqual;
                    }
                }
            }
        } else {
            this.myVisible = false;
            for (DTree child : this.myChildren.values()) {
                child.updateVisibility(settings);
                this.myVisible = this.myVisible || child.isVisible();
            }
        }
    }

    public void reset() {
        this.myChildren.clear();
    }

    public void remove(DTree node) {
        this.init();
        boolean removed = this.myChildrenList.remove((Object)node);
        if (removed) {
            for (String key : this.myChildren.keySet()) {
                if (this.myChildren.get(key) != node) continue;
                this.myChildren.remove(key);
                return;
            }
        }
    }

    private static boolean isEqualSizes(DiffElement<?> file1, DiffElement<?> file2) {
        return file1.getSize() == file2.getSize();
    }

    private static boolean isEqualTimestamps(DiffElement<?> src, DiffElement<?> trg, DirDiffSettings settings) {
        if (src.getSize() != trg.getSize()) {
            return false;
        }
        return (double)Math.abs(src.getTimeStamp() - trg.getTimeStamp()) <= settings.compareTimestampAccuracy;
    }

    private static boolean isEqualContents(DiffElement<?> file1, DiffElement<?> file2) {
        if (file1.isContainer() || file2.isContainer()) {
            return false;
        }
        if (file1.getSize() != file2.getSize()) {
            return false;
        }
        try {
            return Arrays.equals(file1.getContent(), file2.getContent());
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isEqualContentsAsText(DiffElement<?> file1, DiffElement<?> file2) {
        if (file1.isContainer() || file2.isContainer()) {
            return false;
        }
        if (file1.getFileType().isBinary() || file2.getFileType().isBinary()) {
            return DTree.isEqualContents(file1, file2);
        }
        try {
            byte[] content1 = file1.getContent();
            byte[] content2 = file2.getContent();
            if (Arrays.equals(content1, content2)) {
                return true;
            }
            if (content1 == null || content2 == null) {
                return false;
            }
            String text1 = CharsetToolkit.tryDecodeString((byte[])content1, (Charset)file1.getCharset());
            if (text1 == null) {
                return false;
            }
            String text2 = CharsetToolkit.tryDecodeString((byte[])content2, (Charset)file2.getCharset());
            if (text2 == null) {
                return false;
            }
            String convertedText1 = StringUtil.convertLineSeparators((String)text1);
            String convertedText2 = StringUtil.convertLineSeparators((String)text2);
            return StringUtil.equals((CharSequence)convertedText1, (CharSequence)convertedText2);
        }
        catch (IOException e) {
            return false;
        }
    }

    public DiffType getType() {
        return this.myType;
    }

    public void setType(DiffType type) {
        this.myType = type;
    }

    public String getPath() {
        if (this.myPath == null) {
            DTree parent = this.getParent();
            this.myPath = parent != null ? parent.getPath() + this.getName() + (this.isContainer ? DiffElement.getSeparator() : "") : this.getName() + (this.isContainer ? DiffElement.getSeparator() : "");
        }
        return this.myPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/dir/DTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

