/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import gnu.trove.TIntArrayList;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorSizeManager
extends InlayModel.SimpleAdapter
implements PrioritizedDocumentListener,
Disposable,
FoldingListener,
Dumpable {
    private static final Logger LOG = Logger.getInstance(EditorSizeManager.class);
    private static final int UNKNOWN_WIDTH = Integer.MAX_VALUE;
    private final EditorView myView;
    private final EditorImpl myEditor;
    private final DocumentEx myDocument;
    private final TIntArrayList myLineWidths = new TIntArrayList();
    private int myWidthInPixels;
    private int myMaxLineWithExtensionWidth;
    private int myWidestLineWithExtension;
    private int myDocumentChangeStartOffset;
    private int myDocumentChangeEndOffset;
    private int myFoldingChangeStartOffset = Integer.MAX_VALUE;
    private int myFoldingChangeEndOffset = Integer.MIN_VALUE;
    private int myVirtualPageHeight;
    private boolean myDuringDocumentUpdate;
    private boolean myDirty;
    private final List<TextRange> myDeferredRanges = new ArrayList<TextRange>();
    private final SoftWrapAwareDocumentParsingListenerAdapter mySoftWrapChangeListener = new SoftWrapAwareDocumentParsingListenerAdapter(){

        @Override
        public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            EditorSizeManager.this.onSoftWrapRecalculationEnd(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/view/EditorSizeManager$1", "onRecalculationEnd"));
        }
    };

    EditorSizeManager(EditorView view) {
        this.myView = view;
        this.myEditor = view.getEditor();
        this.myDocument = this.myEditor.getDocument();
        this.myDocument.addDocumentListener(this, this);
        this.myEditor.getFoldingModel().addListener(this, this);
        this.myEditor.getSoftWrapModel().getApplianceManager().addListener(this.mySoftWrapChangeListener);
        this.myEditor.getInlayModel().addListener((InlayModel.Listener)this, this);
    }

    public void dispose() {
        this.myEditor.getSoftWrapModel().getApplianceManager().removeListener(this.mySoftWrapChangeListener);
    }

    @Override
    public int getPriority() {
        return 110;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDuringDocumentUpdate = true;
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.myDocumentChangeStartOffset = event.getOffset();
        this.myDocumentChangeEndOffset = event.getOffset() + event.getNewLength();
    }

    public void documentChanged(DocumentEvent event) {
        this.myDuringDocumentUpdate = false;
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.doInvalidateRange(this.myDocumentChangeStartOffset, this.myDocumentChangeEndOffset);
        this.assertValidState();
    }

    @Override
    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        if (region == null) {
            EditorSizeManager.$$$reportNull$$$0(0);
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (region.isValid()) {
            this.myFoldingChangeStartOffset = Math.min(this.myFoldingChangeStartOffset, region.getStartOffset());
            this.myFoldingChangeEndOffset = Math.max(this.myFoldingChangeEndOffset, region.getEndOffset());
        }
    }

    @Override
    public void onFoldProcessingEnd() {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myFoldingChangeStartOffset <= this.myFoldingChangeEndOffset) {
            this.doInvalidateRange(this.myFoldingChangeStartOffset, this.myFoldingChangeEndOffset);
        }
        this.myFoldingChangeStartOffset = Integer.MAX_VALUE;
        this.myFoldingChangeEndOffset = Integer.MIN_VALUE;
        for (TextRange range2 : this.myDeferredRanges) {
            this.onTextLayoutPerformed(range2.getStartOffset(), range2.getEndOffset());
        }
        this.myDeferredRanges.clear();
        this.assertValidState();
    }

    public void onUpdated(@NotNull Inlay inlay) {
        if (inlay == null) {
            EditorSizeManager.$$$reportNull$$$0(1);
        }
        if (this.myDuringDocumentUpdate || this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.doInvalidateRange(inlay.getOffset(), inlay.getOffset());
    }

    private void onSoftWrapRecalculationEnd(IncrementalCacheUpdateEvent event) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        boolean invalidate = true;
        if (this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
            this.myFoldingChangeStartOffset = Math.min(this.myFoldingChangeStartOffset, event.getStartOffset());
            this.myFoldingChangeEndOffset = Math.max(this.myFoldingChangeEndOffset, event.getActualEndOffset());
            invalidate = false;
        }
        if (this.myDuringDocumentUpdate) {
            this.myDocumentChangeStartOffset = Math.min(this.myDocumentChangeStartOffset, event.getStartOffset());
            this.myDocumentChangeEndOffset = Math.max(this.myDocumentChangeEndOffset, event.getActualEndOffset());
            invalidate = false;
        }
        if (invalidate) {
            this.doInvalidateRange(event.getStartOffset(), event.getActualEndOffset());
        }
    }

    Dimension getPreferredSize() {
        int widthWithoutCaret;
        Insets insets = this.myView.getInsets();
        int width = widthWithoutCaret = this.getTextPreferredWidth() + insets.left;
        boolean rightAligned = this.myEditor.isRightAligned();
        if (!this.myDocument.isInBulkUpdate() && !rightAligned) {
            CaretModelImpl caretModel = this.myEditor.getCaretModel();
            int caretMaxX = (caretModel.isIteratingOverCarets() ? Stream.of(caretModel.getCurrentCaret()) : caretModel.getAllCarets().stream()).filter(Caret::isUpToDate).mapToInt(c -> (int)this.myView.visualPositionToXY(c.getVisualPosition()).getX()).max().orElse(0);
            width = Math.max(width, caretMaxX);
        }
        if (this.shouldRespectAdditionalColumns(widthWithoutCaret)) {
            width = (int)((float)width + (float)this.myEditor.getSettings().getAdditionalColumnsCount() * this.myView.getPlainSpaceWidth());
        }
        return new Dimension(width + insets.right, this.getPreferredHeight());
    }

    int getPreferredWidth(int beginLine, int endLine) {
        int widthWithoutCaret;
        Insets insets = this.myView.getInsets();
        int width = widthWithoutCaret = this.getTextPreferredWidthWithoutCaret(beginLine, endLine) + insets.left;
        boolean rightAligned = this.myEditor.isRightAligned();
        if (!this.myDocument.isInBulkUpdate() && !rightAligned) {
            CaretModelImpl caretModel = this.myEditor.getCaretModel();
            int caretMaxX = (caretModel.isIteratingOverCarets() ? Stream.of(caretModel.getCurrentCaret()) : caretModel.getAllCarets().stream()).filter(Caret::isUpToDate).filter(caret -> caret.getVisualPosition().line >= beginLine && caret.getVisualPosition().line < endLine).mapToInt(c -> (int)this.myView.visualPositionToXY(c.getVisualPosition()).getX()).max().orElse(0);
            width = Math.max(width, caretMaxX);
        }
        if (this.shouldRespectAdditionalColumns(widthWithoutCaret)) {
            width = (int)((float)width + (float)this.myEditor.getSettings().getAdditionalColumnsCount() * this.myView.getPlainSpaceWidth());
        }
        return width + insets.right;
    }

    int getPreferredHeight() {
        int lineHeight = this.myView.getLineHeight();
        if (this.myEditor.isOneLineMode()) {
            return lineHeight;
        }
        int size = Math.max(this.myEditor.getVisibleLineCount(), 1) * lineHeight;
        EditorSettings settings = this.myEditor.getSettings();
        if (settings.isAdditionalPageAtBottom()) {
            int visibleAreaHeight = this.myEditor.getScrollingModel().getVisibleArea().height;
            if (visibleAreaHeight > 0 || this.myVirtualPageHeight <= 0) {
                this.myVirtualPageHeight = Math.max(visibleAreaHeight - 2 * lineHeight, lineHeight);
            }
            size += Math.max(this.myVirtualPageHeight, 0);
        } else {
            size += settings.getAdditionalLinesCount() * lineHeight;
        }
        Insets insets = this.myView.getInsets();
        return size + insets.top + insets.bottom;
    }

    private boolean shouldRespectAdditionalColumns(int widthWithoutCaret) {
        return !this.myEditor.getSoftWrapModel().isSoftWrappingEnabled() || this.myEditor.getSoftWrapModel().isRespectAdditionalColumns() || (double)widthWithoutCaret > this.myEditor.getScrollingModel().getVisibleArea().getWidth();
    }

    private int getTextPreferredWidth() {
        if (this.myWidthInPixels < 0) {
            assert (!this.myDocument.isInBulkUpdate());
            this.myWidthInPixels = this.calculateTextPreferredWidth();
        }
        this.validateMaxLineWithExtension();
        return Math.max(this.myWidthInPixels, this.myMaxLineWithExtensionWidth);
    }

    private int getTextPreferredWidthWithoutCaret(int beginLine, int endLine) {
        if (this.myWidthInPixels < 0) {
            assert (!this.myDocument.isInBulkUpdate());
            this.calculateTextPreferredWidth();
        }
        int maxWidth = beginLine == 0 && endLine == 0 ? (int)this.myView.getPrefixTextWidthInPixels() : 0;
        for (int i = beginLine; i < endLine && i < this.myLineWidths.size(); ++i) {
            maxWidth = Math.max(maxWidth, Math.abs(this.myLineWidths.get(i)));
        }
        this.validateMaxLineWithExtension();
        return Math.max(maxWidth, this.myMaxLineWithExtensionWidth);
    }

    private void validateMaxLineWithExtension() {
        boolean hasNoExtensions;
        if (this.myMaxLineWithExtensionWidth > 0 && (hasNoExtensions = this.myEditor.processLineExtensions(this.myWidestLineWithExtension, (Processor<LineExtensionInfo>)((Processor)info -> false)))) {
            this.myMaxLineWithExtensionWidth = 0;
        }
    }

    private int calculateTextPreferredWidth() {
        if (this.checkDirty()) {
            return 1;
        }
        this.assertValidState();
        VisualLinesIterator iterator = new VisualLinesIterator(this.myEditor, 0);
        int maxWidth = 0;
        if (iterator.atEnd()) {
            maxWidth = (int)((float)maxWidth + this.myView.getPrefixTextWidthInPixels());
        }
        while (!iterator.atEnd()) {
            int width = this.getVisualLineWidth(iterator, true);
            maxWidth = Math.max(maxWidth, width);
            iterator.advance();
        }
        return maxWidth;
    }

    int getVisualLineWidth(VisualLinesIterator visualLinesIterator, boolean allowQuickCalculation) {
        int cached;
        assert (!visualLinesIterator.atEnd());
        int visualLine = visualLinesIterator.getVisualLine();
        boolean useCache = this.shouldUseLineWidthCache();
        int n = cached = useCache ? this.myLineWidths.get(visualLine) : Integer.MAX_VALUE;
        if (cached != Integer.MAX_VALUE && (cached >= 0 || allowQuickCalculation)) {
            return Math.abs(cached);
        }
        Ref evaluatedQuick = Ref.create((Object)Boolean.FALSE);
        int width = this.calculateLineWidth(visualLinesIterator, allowQuickCalculation ? () -> evaluatedQuick.set((Object)Boolean.TRUE) : null);
        if (useCache) {
            this.myLineWidths.set(visualLine, (Boolean)evaluatedQuick.get() != false ? -width : width);
        }
        return width;
    }

    private int calculateLineWidth(@NotNull VisualLinesIterator iterator, @Nullable Runnable quickEvaluationListener) {
        if (iterator == null) {
            EditorSizeManager.$$$reportNull$$$0(2);
        }
        int visualLine = iterator.getVisualLine();
        FoldRegion[] topLevelRegions = this.myEditor.getFoldingModel().fetchTopLevel();
        if (quickEvaluationListener != null && (topLevelRegions == null || topLevelRegions.length == 0) && this.myEditor.getSoftWrapModel().getRegisteredSoftWraps().isEmpty() && !this.myView.getTextLayoutCache().hasCachedLayoutFor(visualLine)) {
            quickEvaluationListener.run();
            return this.myView.getLogicalPositionCache().offsetToLogicalColumn(visualLine, this.myDocument.getLineEndOffset(visualLine) - this.myDocument.getLineStartOffset(visualLine)) * this.myView.getMaxCharWidth();
        }
        float x = 0.0f;
        int maxOffset = iterator.getVisualLineStartOffset();
        int leftInset = this.myView.getInsets().left;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, iterator, quickEvaluationListener, false)) {
            x = fragment.getEndX() - (float)leftInset;
            maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
        }
        if (this.myEditor.getSoftWrapModel().getSoftWrap(maxOffset) != null) {
            x += (float)this.myEditor.getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
        }
        return (int)x;
    }

    void reset() {
        assert (!this.myDocument.isInBulkUpdate());
        this.doInvalidateRange(0, this.myDocument.getTextLength());
    }

    void invalidateRange(int startOffset, int endOffset) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myDuringDocumentUpdate) {
            this.myDocumentChangeStartOffset = Math.min(this.myDocumentChangeStartOffset, startOffset);
            this.myDocumentChangeEndOffset = Math.max(this.myDocumentChangeEndOffset, endOffset);
        } else if (this.myFoldingChangeEndOffset != Integer.MIN_VALUE) {
            this.myFoldingChangeStartOffset = Math.min(this.myFoldingChangeStartOffset, startOffset);
            this.myFoldingChangeEndOffset = Math.max(this.myFoldingChangeEndOffset, endOffset);
        } else {
            this.doInvalidateRange(startOffset, endOffset);
        }
    }

    private boolean shouldUseLineWidthCache() {
        FoldRegion[] regions;
        if (this.myView.getEditor().isPurePaintingMode()) {
            return false;
        }
        FoldingModelImpl model = this.myView.getEditor().getFoldingModel();
        if (model.isFoldingEnabled()) {
            return true;
        }
        model.setFoldingEnabled(true);
        try {
            regions = model.fetchTopLevel();
        }
        finally {
            model.setFoldingEnabled(false);
        }
        return regions == null || regions.length == 0;
    }

    private void doInvalidateRange(int startOffset, int endOffset) {
        if (this.checkDirty()) {
            return;
        }
        this.myWidthInPixels = -1;
        int startVisualLine = this.myView.offsetToVisualLine(startOffset, false);
        int endVisualLine = this.myView.offsetToVisualLine(endOffset, true);
        int lineDiff = this.myEditor.getVisibleLineCount() - this.myLineWidths.size();
        if (lineDiff > 0) {
            int[] newEntries = new int[lineDiff];
            this.myLineWidths.insert(startVisualLine, newEntries);
        } else if (lineDiff < 0) {
            this.myLineWidths.remove(startVisualLine, -lineDiff);
        }
        for (int i = startVisualLine; i <= endVisualLine && i < this.myLineWidths.size(); ++i) {
            this.myLineWidths.set(i, Integer.MAX_VALUE);
        }
    }

    int getMaxLineWithExtensionWidth() {
        return this.myMaxLineWithExtensionWidth;
    }

    void setMaxLineWithExtensionWidth(int lineNumber, int width) {
        this.myWidestLineWithExtension = lineNumber;
        this.myMaxLineWithExtensionWidth = width;
    }

    void textLayoutPerformed(int startOffset, int endOffset) {
        assert (0 <= startOffset && startOffset < endOffset && endOffset <= this.myDocument.getTextLength()) : "startOffset=" + startOffset + ", endOffset=" + endOffset;
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
            this.myDeferredRanges.add(new TextRange(startOffset, endOffset));
        } else {
            this.onTextLayoutPerformed(startOffset, endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTextLayoutPerformed(int startOffset, int endOffset) {
        if (this.checkDirty()) {
            return;
        }
        boolean purePaintingMode = this.myEditor.isPurePaintingMode();
        boolean foldingEnabled = this.myEditor.getFoldingModel().isFoldingEnabled();
        this.myEditor.setPurePaintingMode(false);
        this.myEditor.getFoldingModel().setFoldingEnabled(true);
        try {
            int startVisualLine = this.myView.offsetToVisualLine(startOffset, false);
            int endVisualLine = this.myView.offsetToVisualLine(endOffset, true);
            boolean sizeInvalidated = false;
            for (int i = startVisualLine; i <= endVisualLine; ++i) {
                if (this.myLineWidths.get(i) >= 0) continue;
                this.myLineWidths.set(i, Integer.MAX_VALUE);
                sizeInvalidated = true;
            }
            if (sizeInvalidated) {
                this.myWidthInPixels = -1;
                this.myEditor.getContentComponent().revalidate();
            }
        }
        finally {
            this.myEditor.setPurePaintingMode(purePaintingMode);
            this.myEditor.getFoldingModel().setFoldingEnabled(foldingEnabled);
        }
    }

    private boolean checkDirty() {
        if (this.myEditor.getSoftWrapModel().isDirty()) {
            this.myDirty = true;
            return true;
        }
        if (this.myDirty) {
            int visibleLineCount = this.myEditor.getVisibleLineCount();
            int lineDiff = visibleLineCount - this.myLineWidths.size();
            if (lineDiff > 0) {
                this.myLineWidths.add(new int[lineDiff]);
            } else if (lineDiff < 0) {
                this.myLineWidths.remove(visibleLineCount, -lineDiff);
            }
            for (int i = 0; i < visibleLineCount; ++i) {
                this.myLineWidths.set(i, Integer.MAX_VALUE);
            }
            this.myDirty = false;
        }
        return false;
    }

    @NotNull
    public String dumpState() {
        String string = "[cached width: " + this.myWidthInPixels + ", max line with extension width: " + this.myMaxLineWithExtensionWidth + ", line widths: " + this.myLineWidths + "]";
        if (string == null) {
            EditorSizeManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void assertValidState() {
        if (this.myDocument.isInBulkUpdate() || this.myDirty) {
            return;
        }
        if (this.myLineWidths.size() != this.myEditor.getVisibleLineCount()) {
            LOG.error("Inconsistent state", new Attachment[]{new Attachment("editor.txt", this.myEditor.dumpState())});
            this.reset();
        }
        assert (this.myLineWidths.size() == this.myEditor.getVisibleLineCount());
    }

    void validateState() {
        this.assertValidState();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/EditorSizeManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorSizeManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onFoldRegionStateChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onUpdated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateLineWidth";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

