/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.newEditor.CopyAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.components.labels.SwingActionLink;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

final class Banner
extends JPanel {
    private final JLabel myProjectIcon = new JLabel();
    private final Breadcrumbs myBreadcrumbs = new Breadcrumbs(){

        protected int getFontStyle(Crumb crumb) {
            return 1;
        }
    };

    Banner(Action action) {
        super(new BorderLayout(10, 0));
        this.myProjectIcon.setMinimumSize(new Dimension(0, 0));
        this.myProjectIcon.setIcon(AllIcons.General.ProjectConfigurableBanner);
        this.myProjectIcon.setForeground((Color)JBColor.GRAY);
        this.myProjectIcon.setVisible(false);
        this.add("West", (Component)this.myBreadcrumbs);
        this.add("Center", this.myProjectIcon);
        this.add("East", RelativeFont.BOLD.install((Component)new SwingActionLink(action)));
        Banner.setComponentPopupMenuTo(this.myBreadcrumbs);
    }

    void setText(Collection<String> names) {
        ArrayList<Crumb.Impl> crumbs = new ArrayList<Crumb.Impl>();
        if (names != null) {
            for (String name : names) {
                crumbs.add(new Crumb.Impl(null, name, null));
            }
        }
        this.myBreadcrumbs.setCrumbs(crumbs);
    }

    void setProject(Project project) {
        if (project == null) {
            this.myProjectIcon.setVisible(false);
        } else {
            this.myProjectIcon.setVisible(true);
            this.myProjectIcon.setText(OptionsBundle.message((String)(project.isDefault() ? "configurable.default.project.tooltip" : "configurable.current.project.tooltip"), (Object[])new Object[0]));
        }
    }

    private static void setComponentPopupMenuTo(final Breadcrumbs breadcrumbs) {
        breadcrumbs.setComponentPopupMenu(new JPopupMenu(){
            {
                this.add(new CopyAction(() -> CopyAction.createTransferable(breadcrumbs.getCrumbs())));
            }

            @Override
            public void show(Component invoker, int x, int y) {
                if (invoker != breadcrumbs) {
                    return;
                }
                super.show(invoker, x, invoker.getHeight());
            }
        });
    }
}

