/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectRootManagerComponent
extends ProjectRootManagerImpl
implements ProjectComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectRootManagerComponent.class);
    private boolean myPointerChangesDetected;
    private int myInsideRefresh;
    private final BatchUpdateListener myHandler;
    private final MessageBusConnection myConnection;
    private Set<LocalFileSystem.WatchRequest> myRootsToWatch = new THashSet();
    private final boolean myDoLogCachesUpdate;
    private Disposable myRootPointersDisposable = Disposer.newDisposable();
    private final VirtualFilePointerListener myRootsChangedListener = new VirtualFilePointerListener(){

        public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                4.$$$reportNull$$$0(0);
            }
            if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                return;
            }
            if (ProjectRootManagerComponent.this.myInsideRefresh == 0) {
                ProjectRootManagerComponent.this.beforeRootsChange(false);
                if (ProjectRootManagerComponent.this.myDoLogCachesUpdate) {
                    LOG.debug(new Throwable(pointers.length > 0 ? pointers[0].getPresentableUrl() : ""));
                }
            } else if (!ProjectRootManagerComponent.this.myPointerChangesDetected) {
                ProjectRootManagerComponent.this.myPointerChangesDetected = true;
                ((ModuleRootListener)ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                if (ProjectRootManagerComponent.this.myDoLogCachesUpdate) {
                    LOG.debug(new Throwable(pointers.length > 0 ? pointers[0].getPresentableUrl() : ""));
                }
            }
        }

        public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                4.$$$reportNull$$$0(1);
            }
            if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                return;
            }
            if (ProjectRootManagerComponent.this.myInsideRefresh > 0) {
                ProjectRootManagerComponent.this.clearScopesCaches();
            } else {
                ProjectRootManagerComponent.this.rootsChanged(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "pointers";
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeValidityChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validityChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public ProjectRootManagerComponent(Project project, StartupManager startupManager) {
        super(project);
        this.myConnection = project.getMessageBus().connect((Disposable)project);
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProjectRootManagerComponent.this.beforeRootsChange(true);
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProjectRootManagerComponent.this.rootsChanged(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileTypesChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        VirtualFileManager.getInstance().addVirtualFileManagerListener((VirtualFileManagerListener)new VirtualFileManagerAdapter(){

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                ProjectRootManagerComponent.this.doUpdateOnRefresh();
            }
        }, (Disposable)project);
        if (!this.myProject.isDefault()) {
            startupManager.registerStartupActivity(() -> {
                this.myStartupActivityPerformed = true;
            });
        }
        this.myHandler = new BatchUpdateListener(){

            @Override
            public void onBatchUpdateStarted() {
                ProjectRootManagerComponent.this.myRootsChanged.levelUp();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelUp();
            }

            @Override
            public void onBatchUpdateFinished() {
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelDown();
            }
        };
        this.myDoLogCachesUpdate = ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public void initComponent() {
        this.myConnection.subscribe(BatchUpdateListener.TOPIC, (Object)this.myHandler);
    }

    public void projectOpened() {
        this.addRootsToWatch();
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new AppListener(), (Disposable)this.myProject);
    }

    public void projectClosed() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRootsToWatch);
    }

    @Override
    protected void addRootsToWatch() {
        Pair<Set<String>, Set<String>> roots = this.getAllRoots();
        if (roots == null) {
            return;
        }
        this.myRootsToWatch = LocalFileSystem.getInstance().replaceWatchedRoots(this.myRootsToWatch, (Collection)roots.first, (Collection)roots.second);
    }

    private void beforeRootsChange(boolean fileTypes) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.getBatchSession(fileTypes).beforeRootsChanged();
    }

    private void rootsChanged(boolean fileTypes) {
        this.getBatchSession(fileTypes).rootsChanged();
    }

    private void doUpdateOnRefresh() {
        if (ApplicationManager.getApplication().isUnitTestMode() && (!this.myStartupActivityPerformed || this.myProject.isDisposed())) {
            return;
        }
        if (this.myProject.isDefault()) {
            return;
        }
        if (this.myDoLogCachesUpdate) {
            LOG.debug("refresh");
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        DumbModeTask task = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject);
        if (task != null) {
            dumbService.queueTask(task);
        }
    }

    @Override
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    @Override
    protected void fireRootsChangedEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    @Nullable
    private Pair<Set<String>, Set<String>> getAllRoots() {
        File projectDirFile;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDefault()) {
            return null;
        }
        THashSet recursive = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        THashSet flat = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        String projectFilePath = this.myProject.getProjectFilePath();
        File file2 = projectDirFile = projectFilePath == null ? null : new File(projectFilePath).getParentFile();
        if (projectDirFile != null && projectDirFile.getName().equals(".idea")) {
            recursive.add(projectDirFile.getAbsolutePath());
        } else {
            flat.add(projectFilePath);
            ContainerUtil.addIfNotNull((Collection)flat, (Object)ProjectKt.getStateStore(this.myProject).getWorkspaceFilePath());
        }
        for (AdditionalLibraryRootsProvider additionalLibraryRootsProvider : (AdditionalLibraryRootsProvider[])AdditionalLibraryRootsProvider.EP_NAME.getExtensions()) {
            recursive.addAll(ContainerUtil.map(additionalLibraryRootsProvider.getRootsToWatch(this.myProject), VirtualFile::getPath));
        }
        for (AdditionalLibraryRootsProvider additionalLibraryRootsProvider : (WatchedRootsProvider[])Extensions.getExtensions((ExtensionPointName)WatchedRootsProvider.EP_NAME, (AreaInstance)this.myProject)) {
            recursive.addAll(additionalLibraryRootsProvider.getRootsToWatch());
        }
        Disposable oldDisposable = this.myRootPointersDisposable;
        this.myRootPointersDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this, (Disposable)this.myRootPointersDisposable);
        VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer(this.myRootPointersDisposable, this.getRootsValidityChangedListener());
        recursive.forEach(path -> container.addJarDirectory(VfsUtilCore.pathToUrl((String)path), true));
        flat.forEach(path -> container.add(VfsUtilCore.pathToUrl((String)path)));
        Disposer.dispose((Disposable)oldDisposable);
        this.addRootsFromModulesTo((Set<String>)recursive, (Set<String>)flat);
        return Pair.create((Object)recursive, (Object)flat);
    }

    private void addRootsFromModulesTo(@NotNull Set<String> recursive, @NotNull Set<String> flat) {
        if (recursive == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(0);
        }
        if (flat == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(1);
        }
        THashSet urls = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ContainerUtil.addAll((Collection)urls, (Object[])rootManager.getContentRootUrls());
            rootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().forEach(arg_0 -> ProjectRootManagerComponent.lambda$addRootsFromModulesTo$3((Set)urls, arg_0));
        }
        for (String url : urls) {
            String protocol = VirtualFileManager.extractProtocol((String)url);
            if (protocol == null || "file".equals(protocol)) {
                recursive.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if ("jar".equals(protocol)) {
                flat.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if (!"jrt".equals(protocol)) continue;
            recursive.add(ProjectRootManagerComponent.extractLocalPath(url));
        }
    }

    @Override
    protected void doSynchronizeRoots() {
        if (!this.myStartupActivityPerformed) {
            return;
        }
        if (this.myDoLogCachesUpdate || LOG.isDebugEnabled()) {
            LOG.debug(new Throwable("sync roots"));
        } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("project roots have changed");
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        if (FileBasedIndex.getInstance() instanceof FileBasedIndexImpl) {
            dumbService.queueTask(new UnindexedFilesUpdater(this.myProject));
        }
    }

    @Override
    protected void clearScopesCaches() {
        super.clearScopesCaches();
        LibraryScopeCache.getInstance(this.myProject).clear();
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules;
        super.clearScopesCachesForModules();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ((ModuleEx)module).clearScopesCache();
        }
    }

    @Override
    public void markRootsForRefresh() {
        THashSet paths = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        this.addRootsFromModulesTo((Set<String>)paths, (Set<String>)paths);
        LocalFileSystem fs = LocalFileSystem.getInstance();
        for (String path : paths) {
            VirtualFile root = fs.findFileByPath(path);
            if (!(root instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)root).markDirtyRecursively();
        }
    }

    public void dispose() {
        this.assertListenersAreDisposed();
    }

    @Override
    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        VirtualFilePointerListener virtualFilePointerListener = this.myRootsChangedListener;
        if (virtualFilePointerListener == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(2);
        }
        return virtualFilePointerListener;
    }

    private static /* synthetic */ boolean lambda$addRootsFromModulesTo$3(Set urls, OrderEntry entry) {
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            ContainerUtil.addAll((Collection)urls, (Object[])entry.getUrls(type));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsValidityChangedListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRootsFromModulesTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AppListener
    extends ApplicationAdapter {
        private AppListener() {
        }

        public void beforeWriteActionStart(@NotNull Object action) {
            if (action == null) {
                AppListener.$$$reportNull$$$0(0);
            }
            ProjectRootManagerComponent.this.myInsideRefresh++;
        }

        public void writeActionFinished(@NotNull Object action) {
            if (action == null) {
                AppListener.$$$reportNull$$$0(1);
            }
            if (--ProjectRootManagerComponent.this.myInsideRefresh == 0 && ProjectRootManagerComponent.this.myPointerChangesDetected) {
                ProjectRootManagerComponent.this.myPointerChangesDetected = false;
                ((ModuleRootListener)ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                ProjectRootManagerComponent.this.doSynchronizeRoots();
                ProjectRootManagerComponent.this.addRootsToWatch();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "action";
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$AppListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeWriteActionStart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeActionFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

