/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.IdeaApplication;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.apache.http.client.utils.URIBuilder;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginsAdvertiser
implements StartupActivity {
    @NonNls
    public static final String IGNORE_ULTIMATE_EDITION = "ignoreUltimateEdition";
    private static final Logger LOG = Logger.getInstance(PluginsAdvertiser.class);
    private static final String CASHED_EXTENSIONS = "extensions.xml";
    public static final String IDEA_ULTIMATE_EDITION = "IntelliJ IDEA Ultimate Edition";
    public static final String ULTIMATE_EDITION_SUGGESTION = "Do not suggest Ultimate Edition";
    public static final String CHECK_ULTIMATE_EDITION_TITLE = "Check IntelliJ IDEA Ultimate Edition";
    public static final String DISPLAY_ID = "Plugins Suggestion";
    public static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Plugins Suggestion", NotificationDisplayType.STICKY_BALLOON, true);
    private static SoftReference<KnownExtensions> ourKnownExtensions = new SoftReference(null);

    @Nullable
    public static List<Plugin> retrieve(UnknownFeature unknownFeature) {
        String featureType = unknownFeature.getFeatureType();
        String implementationName = unknownFeature.getImplementationName();
        String buildNumber = ApplicationInfo.getInstance().getApiVersion();
        return PluginsAdvertiser.processFeatureRequest((Map<String, String>)ImmutableMap.of((Object)"featureType", (Object)featureType, (Object)"implementationName", (Object)implementationName, (Object)"build", (Object)buildNumber), new HttpRequests.RequestProcessor<List<Plugin>>(){

            public List<Plugin> process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                JsonReader jsonReader = new JsonReader((Reader)request.getReader());
                jsonReader.setLenient(true);
                JsonElement jsonRootElement = new JsonParser().parse(jsonReader);
                ArrayList<Plugin> result2 = new ArrayList<Plugin>();
                for (JsonElement jsonElement : jsonRootElement.getAsJsonArray()) {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    JsonElement pluginId = jsonObject.get("pluginId");
                    JsonElement pluginName = jsonObject.get("pluginName");
                    JsonElement bundled = jsonObject.get("bundled");
                    result2.add(new Plugin(PluginId.getId((String)StringUtil.unquoteString((String)pluginId.toString())), pluginName != null ? StringUtil.unquoteString((String)pluginName.toString()) : null, Boolean.parseBoolean(StringUtil.unquoteString((String)bundled.toString()))));
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$1", "process"));
            }
        }, null, LOG);
    }

    @Nullable
    private static Map<String, Set<Plugin>> loadSupportedExtensions(@NotNull List<IdeaPluginDescriptor> allPlugins) {
        if (allPlugins == null) {
            PluginsAdvertiser.$$$reportNull$$$0(0);
        }
        final HashMap<String, IdeaPluginDescriptor> availableIds = new HashMap<String, IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor plugin : allPlugins) {
            availableIds.put(plugin.getPluginId().getIdString(), plugin);
        }
        return PluginsAdvertiser.processFeatureRequest((Map<String, String>)ImmutableMap.of((Object)"featureType", (Object)FileTypeFactory.FILE_TYPE_FACTORY_EP.getName()), new HttpRequests.RequestProcessor<Map<String, Set<Plugin>>>(){

            public Map<String, Set<Plugin>> process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    2.$$$reportNull$$$0(0);
                }
                JsonReader jsonReader = new JsonReader((Reader)request.getReader());
                jsonReader.setLenient(true);
                JsonElement jsonRootElement = new JsonParser().parse(jsonReader);
                HashMap<String, Set<Plugin>> result2 = new HashMap<String, Set<Plugin>>();
                for (JsonElement jsonElement : jsonRootElement.getAsJsonArray()) {
                    IdeaPluginDescriptor loadedPlugin;
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    String pluginId = StringUtil.unquoteString((String)jsonObject.get("pluginId").toString());
                    JsonElement bundledExt = jsonObject.get("bundled");
                    boolean isBundled = Boolean.parseBoolean(bundledExt.toString());
                    IdeaPluginDescriptor fromServerPluginDescription = (IdeaPluginDescriptor)availableIds.get(pluginId);
                    if (fromServerPluginDescription == null && !isBundled || (loadedPlugin = PluginManager.getPlugin(PluginId.getId((String)pluginId))) != null && loadedPlugin.isEnabled() || loadedPlugin != null && fromServerPluginDescription != null && StringUtil.compareVersionNumbers((String)loadedPlugin.getVersion(), (String)fromServerPluginDescription.getVersion()) >= 0 || fromServerPluginDescription != null && PluginManagerCore.isBrokenPlugin(fromServerPluginDescription)) continue;
                    JsonElement ext = jsonObject.get("implementationName");
                    String extension = StringUtil.unquoteString((String)ext.toString());
                    HashSet<Plugin> pluginIds = (HashSet<Plugin>)result2.get(extension);
                    if (pluginIds == null) {
                        pluginIds = new HashSet<Plugin>();
                        result2.put(extension, pluginIds);
                    }
                    JsonElement pluginNameElement = jsonObject.get("pluginName");
                    pluginIds.add(new Plugin(PluginId.getId((String)pluginId), pluginNameElement != null ? StringUtil.unquoteString((String)pluginNameElement.toString()) : null, isBundled));
                }
                PluginsAdvertiser.saveExtensions(result2);
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$2", "process"));
            }
        }, null, LOG);
    }

    private static <K> K processFeatureRequest(Map<String, String> params, HttpRequests.RequestProcessor<K> requestProcessor, K errorValue, Logger log2) {
        URIBuilder uriBuilder;
        String baseUrl = ApplicationInfoImpl.getShadowInstance().getPluginManagerUrl() + "/feature/getImplementations?";
        try {
            uriBuilder = new URIBuilder(baseUrl);
        }
        catch (URISyntaxException e) {
            log2.error(baseUrl, (Throwable)e);
            return errorValue;
        }
        params.forEach((key, value) -> uriBuilder.addParameter(key, value));
        boolean forceHttps = IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
        return (K)HttpRequests.request((String)uriBuilder.toString()).forceHttps(forceHttps).productNameAsUserAgent().connect(requestProcessor, errorValue, LOG);
    }

    public static void ensureDeleted() {
        FileUtil.delete((File)PluginsAdvertiser.getExtensionsFile());
    }

    public static KnownExtensions loadExtensions() {
        KnownExtensions knownExtensions = (KnownExtensions)ourKnownExtensions.get();
        if (knownExtensions != null) {
            return knownExtensions;
        }
        try {
            File file2 = PluginsAdvertiser.getExtensionsFile();
            if (file2.isFile()) {
                knownExtensions = (KnownExtensions)XmlSerializer.deserialize((Element)JDOMUtil.load((File)file2), KnownExtensions.class);
                ourKnownExtensions = new SoftReference((Object)knownExtensions);
                return knownExtensions;
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    private static File getExtensionsFile() {
        return new File(PathManager.getPluginsPath(), CASHED_EXTENSIONS);
    }

    private static void saveExtensions(Map<String, Set<Plugin>> extensions) throws IOException {
        File plugins2 = PluginsAdvertiser.getExtensionsFile();
        if (!plugins2.isFile()) {
            FileUtil.ensureCanCreateFile((File)plugins2);
        }
        JDOMUtil.write((Parent)XmlSerializer.serialize((Object)new KnownExtensions(extensions)), (File)plugins2);
    }

    public static void openDownloadPage() {
        BrowserUtil.browse((String)ApplicationInfo.getInstance().getCompanyURL());
    }

    static void enablePlugins(Project project, Collection<IdeaPluginDescriptor> disabledPlugins) {
        PluginManagerConfigurable managerConfigurable = new PluginManagerConfigurable(PluginManagerUISettings.getInstance());
        PluginManagerMain createPanel = managerConfigurable.getOrCreatePanel();
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)managerConfigurable, () -> {
            InstalledPluginsTableModel pluginsModel = (InstalledPluginsTableModel)createPanel.getPluginsModel();
            IdeaPluginDescriptor[] descriptors = disabledPlugins.toArray(new IdeaPluginDescriptor[0]);
            pluginsModel.enableRows(descriptors, Boolean.TRUE);
            createPanel.getPluginTable().select(descriptors);
        });
    }

    @Nullable
    static IdeaPluginDescriptor getDisabledPlugin(Set<Plugin> plugins2) {
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        for (Plugin plugin : plugins2) {
            if (!disabledPlugins.contains(plugin.myPluginId)) continue;
            return PluginManager.getPlugin(PluginId.getId((String)plugin.myPluginId));
        }
        return null;
    }

    static List<String> hasBundledPluginToInstall(Collection<Plugin> plugins2) {
        if (PlatformUtils.isIdeaUltimate()) {
            return null;
        }
        ArrayList<String> bundled = new ArrayList<String>();
        for (Plugin plugin : plugins2) {
            if (!plugin.myBundled || PluginManager.getPlugin(PluginId.getId((String)plugin.myPluginId)) != null) continue;
            bundled.add(plugin.myPluginName != null ? plugin.myPluginName : plugin.myPluginId);
        }
        return bundled.isEmpty() ? null : bundled;
    }

    public static void installAndEnablePlugins(final @NotNull Set<String> pluginIds, final @NotNull Runnable onSuccess) {
        if (pluginIds == null) {
            PluginsAdvertiser.$$$reportNull$$$0(1);
        }
        if (onSuccess == null) {
            PluginsAdvertiser.$$$reportNull$$$0(2);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(null, "Search for Plugins in Repository", true){
            private final Set<PluginDownloader> myPlugins;
            private List<IdeaPluginDescriptor> myAllPlugins;
            {
                super(arg0, arg1, arg2);
                this.myPlugins = new HashSet<PluginDownloader>();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    this.myAllPlugins = RepositoryHelper.loadPluginsFromAllRepositories(indicator);
                    for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                        if (descriptor.isEnabled() || !pluginIds.contains(descriptor.getPluginId().getIdString())) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(descriptor));
                    }
                    for (IdeaPluginDescriptor loadedPlugin : this.myAllPlugins) {
                        if (!pluginIds.contains(loadedPlugin.getPluginId().getIdString())) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(loadedPlugin));
                    }
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }

            public void onSuccess() {
                PluginsAdvertiserDialog advertiserDialog;
                if (this.myAllPlugins != null && (advertiserDialog = new PluginsAdvertiserDialog(null, this.myPlugins.toArray(new PluginDownloader[0]), this.myAllPlugins)).showAndGet()) {
                    onSuccess.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$3", "run"));
            }
        });
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            PluginsAdvertiser.$$$reportNull$$$0(3);
        }
        if (!UpdateSettings.getInstance().isCheckNeeded()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        application.executeOnPooledThread(new Runnable(){
            private final Set<PluginDownloader> myPlugins = new HashSet<PluginDownloader>();
            private List<IdeaPluginDescriptor> myAllPlugins;
            private final Map<Plugin, IdeaPluginDescriptor> myDisabledPlugins = new HashMap<Plugin, IdeaPluginDescriptor>();
            private List<String> myBundledPlugin;
            private final MultiMap<String, UnknownFeature> myFeatures = new MultiMap();
            private Set<UnknownFeature> unknownFeatures;

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                this.unknownFeatures = UnknownFeaturesCollector.getInstance(project).getUnknownFeatures();
                KnownExtensions extensions = PluginsAdvertiser.loadExtensions();
                if (extensions != null && this.unknownFeatures.isEmpty()) {
                    return;
                }
                try {
                    this.myAllPlugins = RepositoryHelper.loadPluginsFromAllRepositories(null);
                    if (project.isDisposed()) {
                        return;
                    }
                    if (extensions == null) {
                        PluginsAdvertiser.loadSupportedExtensions(this.myAllPlugins);
                        if (project.isDisposed()) {
                            return;
                        }
                        EditorNotifications.getInstance((Project)project).updateAllNotifications();
                    }
                    HashMap<String, Plugin> ids = new HashMap<String, Plugin>();
                    for (UnknownFeature feature : this.unknownFeatures) {
                        ProgressManager.checkCanceled();
                        List<Plugin> pluginId = PluginsAdvertiser.retrieve(feature);
                        if (pluginId == null) continue;
                        for (Plugin plugin : pluginId) {
                            ids.put(plugin.myPluginId, plugin);
                            this.myFeatures.putValue((Object)plugin.myPluginId, (Object)feature);
                        }
                    }
                    List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
                    for (String id : ids.keySet()) {
                        IdeaPluginDescriptor pluginDescriptor;
                        Plugin plugin = (Plugin)ids.get(id);
                        if (!disabledPlugins.contains(id) || (pluginDescriptor = PluginManager.getPlugin(PluginId.getId((String)id))) == null) continue;
                        this.myDisabledPlugins.put(plugin, pluginDescriptor);
                    }
                    this.myBundledPlugin = PluginsAdvertiser.hasBundledPluginToInstall(ids.values());
                    for (IdeaPluginDescriptor loadedPlugin : this.myAllPlugins) {
                        PluginId pluginId = loadedPlugin.getPluginId();
                        if (!ids.containsKey(pluginId.getIdString()) || disabledPlugins.contains(pluginId.getIdString()) || PluginManagerCore.isBrokenPlugin(loadedPlugin)) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(loadedPlugin));
                    }
                    ApplicationManager.getApplication().invokeLater(this::onSuccess, ModalityState.NON_MODAL);
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }

            private void onSuccess() {
                String message = null;
                if (!this.myPlugins.isEmpty() || !this.myDisabledPlugins.isEmpty()) {
                    message = this.getAddressedMessagePresentation();
                    message = !this.myDisabledPlugins.isEmpty() ? message + "<a href=\"enable\">Enable plugins...</a><br>" : message + "<a href=\"configure\">Configure plugins...</a><br>";
                    message = message + "<a href=\"ignore\">Ignore Unknown Features</a>";
                } else if (this.myBundledPlugin != null && !PropertiesComponent.getInstance().isTrueValue(PluginsAdvertiser.IGNORE_ULTIMATE_EDITION)) {
                    message = "Features covered by IntelliJ IDEA Ultimate Edition (" + StringUtil.join(this.myBundledPlugin, (String)", ") + ") are detected.<br><a href=\"open\">" + PluginsAdvertiser.CHECK_ULTIMATE_EDITION_TITLE + "</a><br><a href=\"ignoreUltimate\">" + PluginsAdvertiser.ULTIMATE_EDITION_SUGGESTION + "</a>";
                }
                if (message != null) {
                    ConfigurePluginsListener notificationListener = new ConfigurePluginsListener(this.unknownFeatures, project, this.myAllPlugins, this.myPlugins, this.myDisabledPlugins);
                    NOTIFICATION_GROUP.createNotification(PluginsAdvertiser.DISPLAY_ID, message, NotificationType.INFORMATION, (NotificationListener)notificationListener).notify(project);
                }
            }

            @NotNull
            private String getAddressedMessagePresentation() {
                MultiMap addressedFeatures = MultiMap.createSet();
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                for (PluginDownloader pluginDownloader : this.myPlugins) {
                    ids.add(pluginDownloader.getPluginId());
                }
                for (Plugin plugin : this.myDisabledPlugins.keySet()) {
                    ids.add(plugin.myPluginId);
                }
                for (String string : ids) {
                    for (UnknownFeature feature : this.myFeatures.get((Object)string)) {
                        addressedFeatures.putValue((Object)feature.getFeatureDisplayName(), (Object)feature.getImplementationDisplayName());
                    }
                }
                String addressedFeaturesPresentation = StringUtil.join((Collection)addressedFeatures.entrySet(), entry -> (String)entry.getKey() + "[" + StringUtil.join((Collection)((Collection)entry.getValue()), (String)", ") + "]", (String)", ");
                int n = addressedFeatures.keySet().size();
                int pluginsNumber = ids.size();
                String string = StringUtil.pluralize((String)"Plugin", (int)pluginsNumber) + " supporting " + StringUtil.pluralize((String)"feature", (int)n) + " (" + addressedFeaturesPresentation + ") " + (pluginsNumber == 1 ? "is" : "are") + " currently " + (this.myPlugins.isEmpty() ? "disabled" : "not installed") + ".<br>";
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$4", "getAddressedMessagePresentation"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPlugins";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSupportedExtensions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installAndEnablePlugins";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConfigurePluginsListener
    implements NotificationListener {
        private final Set<UnknownFeature> myUnknownFeatures;
        private final Project myProject;
        private final List<IdeaPluginDescriptor> myAllPlugins;
        private final Set<PluginDownloader> myPlugins;
        private final Map<Plugin, IdeaPluginDescriptor> myDisabledPlugins;

        public ConfigurePluginsListener(Set<UnknownFeature> unknownFeatures, Project project, List<IdeaPluginDescriptor> allPlugins, Set<PluginDownloader> plugins2, Map<Plugin, IdeaPluginDescriptor> disabledPlugins) {
            this.myUnknownFeatures = unknownFeatures;
            this.myProject = project;
            this.myAllPlugins = allPlugins;
            this.myPlugins = plugins2;
            this.myDisabledPlugins = disabledPlugins;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                ConfigurePluginsListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                ConfigurePluginsListener.$$$reportNull$$$0(1);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = event.getDescription();
                if ("ignore".equals(description)) {
                    UnknownFeaturesCollector featuresCollector = UnknownFeaturesCollector.getInstance(this.myProject);
                    for (UnknownFeature feature : this.myUnknownFeatures) {
                        featuresCollector.ignoreFeature(feature);
                    }
                    notification.expire();
                } else if ("configure".equals(description)) {
                    LOG.assertTrue(this.myAllPlugins != null);
                    notification.expire();
                    new PluginsAdvertiserDialog(this.myProject, this.myPlugins.toArray(new PluginDownloader[0]), this.myAllPlugins).show();
                } else if ("enable".equals(description)) {
                    PluginsAdvertiser.enablePlugins(this.myProject, this.myDisabledPlugins.values());
                    notification.expire();
                } else if ("ignoreUltimate".equals(description)) {
                    PropertiesComponent.getInstance().setValue(PluginsAdvertiser.IGNORE_ULTIMATE_EDITION, "true");
                    notification.expire();
                } else if ("open".equals(description)) {
                    PluginsAdvertiser.openDownloadPage();
                    notification.expire();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$ConfigurePluginsListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Tag(value="plugin")
    public static class Plugin
    implements Comparable<Plugin> {
        public String myPluginId;
        public String myPluginName;
        public boolean myBundled;

        public Plugin(PluginId pluginId, String pluginName, boolean bundled) {
            this.myPluginId = pluginId.getIdString();
            this.myBundled = bundled;
            this.myPluginName = pluginName;
        }

        public Plugin() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plugin plugin = (Plugin)o;
            if (this.myBundled != plugin.myBundled) {
                return false;
            }
            if (!this.myPluginId.equals(plugin.myPluginId)) {
                return false;
            }
            return this.myPluginName == null || this.myPluginName.equals(plugin.myPluginName);
        }

        public int hashCode() {
            int result2 = this.myPluginId.hashCode();
            result2 = 31 * result2 + (this.myBundled ? 1 : 0);
            result2 = 31 * result2 + (this.myPluginName != null ? this.myPluginName.hashCode() : 0);
            return result2;
        }

        @Override
        public int compareTo(@NotNull Plugin other) {
            if (other == null) {
                Plugin.$$$reportNull$$$0(0);
            }
            if (this.myBundled && !other.myBundled) {
                return -1;
            }
            if (!this.myBundled && other.myBundled) {
                return 1;
            }
            return Comparing.compare((Comparable)((Object)this.myPluginId), (Comparable)((Object)other.myPluginId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$Plugin", "compareTo"));
        }
    }

    @Tag(value="plugins")
    public static class PluginSet {
        public Set<Plugin> myPlugins = new HashSet<Plugin>();

        public PluginSet() {
        }

        public PluginSet(Set<Plugin> plugins2) {
            for (Plugin plugin : plugins2) {
                this.myPlugins.add(plugin);
            }
        }
    }

    @Tag(value="exts")
    public static class KnownExtensions {
        @OptionTag
        @XMap
        public Map<String, PluginSet> myExtensions = new HashMap<String, PluginSet>();

        public KnownExtensions() {
        }

        public KnownExtensions(Map<String, Set<Plugin>> extensions) {
            for (String ext : extensions.keySet()) {
                this.myExtensions.put(ext, new PluginSet(extensions.get(ext)));
            }
        }

        public Set<Plugin> find(String extension) {
            PluginSet pluginSet = this.myExtensions.get(extension);
            if (pluginSet != null) {
                return pluginSet.myPlugins;
            }
            return null;
        }
    }
}

