/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.util.WaitForProgressToShow;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ShelveChangesCommitExecutor
extends LocalCommitExecutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelveChangesCommitExecutor");
    private final Project myProject;

    public ShelveChangesCommitExecutor(Project project) {
        this.myProject = project;
    }

    @Nls
    public String getActionText() {
        return VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]);
    }

    @NotNull
    public CommitSession createCommitSession() {
        ShelveChangesCommitSession shelveChangesCommitSession = new ShelveChangesCommitSession();
        if (shelveChangesCommitSession == null) {
            ShelveChangesCommitExecutor.$$$reportNull$$$0(0);
        }
        return shelveChangesCommitSession;
    }

    public String getHelpId() {
        return "reference.dialogs.vcs.shelve";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesCommitExecutor", "createCommitSession"));
    }

    private class ShelveChangesCommitSession
    implements CommitSession,
    CommitSessionContextAware {
        private ShelveChangesCommitSession() {
        }

        public void setContext(CommitContext context) {
        }

        public boolean canExecute(Collection<Change> changes, String commitMessage) {
            return changes.size() > 0;
        }

        public void execute(Collection<Change> changes, String commitMessage) {
            if (changes.size() > 0 && !ChangesUtil.hasFileChanges(changes)) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message((String)"shelve.changes.only.directories", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0])), null, (Project)ShelveChangesCommitExecutor.this.myProject);
                return;
            }
            try {
                ShelvedChangeList list2 = ShelveChangesManager.getInstance(ShelveChangesCommitExecutor.this.myProject).shelveChanges(changes, commitMessage, true);
                ShelvedChangesViewManager.getInstance(ShelveChangesCommitExecutor.this.myProject).activateView(list2);
                Change[] changesArray = changes.toArray(new Change[0]);
                LocalChangeList changeList = ChangesUtil.getChangeListIfOnlyOne((Project)ShelveChangesCommitExecutor.this.myProject, (Change[])changesArray);
                if (changeList != null) {
                    ChangeListManager.getInstance((Project)ShelveChangesCommitExecutor.this.myProject).scheduleAutomaticEmptyChangeListDeletion(changeList, true);
                }
            }
            catch (Exception ex) {
                LOG.info((Throwable)ex);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{ex.getMessage()}), (String)CommonBundle.getErrorTitle()), (ModalityState)ModalityState.NON_MODAL, (Project)ShelveChangesCommitExecutor.this.myProject);
            }
        }

        public String getHelpId() {
            return null;
        }
    }
}

