/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.MemoryUsagePanel;
import com.intellij.openapi.wm.impl.status.StatusBarUI;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.openapi.wm.impl.status.ToolWindowsWidget;
import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.NotificationPopup;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeStatusBarImpl
extends JComponent
implements Accessible,
StatusBarEx {
    private static final int MIN_ICON_HEIGHT = 20;
    private final InfoAndProgressPanel myInfoAndProgressPanel;
    private IdeFrame myFrame;
    private static final String uiClassID = "IdeStatusBarUI";
    private final Map<String, WidgetBean> myWidgetMap = new HashMap<String, WidgetBean>();
    private final List<String> myOrderedWidgets = new ArrayList<String>();
    private JPanel myLeftPanel;
    private JPanel myRightPanel;
    private JPanel myCenterPanel;
    private String myInfo;
    private final List<String> myCustomComponentIds = new ArrayList<String>();
    private final Set<IdeStatusBarImpl> myChildren = new HashSet<IdeStatusBarImpl>();

    public StatusBar findChild(Component c) {
        IdeFrame frame = null;
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof IdeFrame)) continue;
            frame = (IdeFrame)eachParent;
        }
        return frame != null ? frame.getStatusBar() : this;
    }

    public void install(IdeFrame frame) {
        this.myFrame = frame;
    }

    private void updateChildren(ChildAction action) {
        for (IdeStatusBarImpl child : this.myChildren) {
            action.update(child);
        }
    }

    public StatusBar createChild() {
        IdeStatusBarImpl bar = new IdeStatusBarImpl(this);
        this.myChildren.add(bar);
        Disposer.register((Disposable)bar, () -> this.myChildren.remove(bar));
        for (String eachId : this.myOrderedWidgets) {
            WidgetBean eachBean = this.myWidgetMap.get(eachId);
            if (!(eachBean.widget instanceof StatusBarWidget.Multiframe)) continue;
            StatusBarWidget copy = ((StatusBarWidget.Multiframe)eachBean.widget).copy();
            UIUtil.invokeLaterIfNeeded(() -> bar.addWidget(copy, eachBean.position, eachBean.anchor));
        }
        return bar;
    }

    public JComponent getComponent() {
        return this;
    }

    private IdeStatusBarImpl(@Nullable IdeStatusBarImpl master) {
        this.setLayout(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty());
        this.myInfoAndProgressPanel = new InfoAndProgressPanel();
        this.addWidget((StatusBarWidget)this.myInfoAndProgressPanel, Position.CENTER);
        this.setOpaque(true);
        this.updateUI();
        if (master == null) {
            this.addWidget((StatusBarWidget)new ToolWindowsWidget((Disposable)this), Position.LEFT);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
    }

    public IdeStatusBarImpl() {
        this(null);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size == null) {
            return null;
        }
        Insets insets = this.getInsets();
        int minHeight = insets.top + insets.bottom + 20;
        return new Dimension(size.width, Math.max(size.height, minHeight));
    }

    public void addWidget(@NotNull StatusBarWidget widget) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(0);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (widget == null) {
                IdeStatusBarImpl.$$$reportNull$$$0(42);
            }
            this.addWidget(widget, Position.RIGHT, "__AUTODETECT__");
        });
    }

    public void addWidget(@NotNull StatusBarWidget widget, @NotNull String anchor2) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(1);
        }
        if (anchor2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(2);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (widget == null) {
                IdeStatusBarImpl.$$$reportNull$$$0(40);
            }
            if (anchor2 == null) {
                IdeStatusBarImpl.$$$reportNull$$$0(41);
            }
            this.addWidget(widget, Position.RIGHT, anchor2);
        });
    }

    private void addWidget(@NotNull StatusBarWidget widget, @NotNull Position pos) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(3);
        }
        if (pos == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(4);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (widget == null) {
                IdeStatusBarImpl.$$$reportNull$$$0(38);
            }
            if (pos == null) {
                IdeStatusBarImpl.$$$reportNull$$$0(39);
            }
            this.addWidget(widget, pos, "__IGNORED__");
        });
    }

    public void addWidget(@NotNull StatusBarWidget widget, @NotNull Disposable parentDisposable) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(6);
        }
        this.addWidget(widget);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (widget == null) {
                IdeStatusBarImpl.$$$reportNull$$$0(37);
            }
            this.removeWidget(widget.ID());
        });
    }

    public void addWidget(@NotNull StatusBarWidget widget, @NotNull String anchor2, @NotNull Disposable parentDisposable) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(7);
        }
        if (anchor2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(9);
        }
        this.addWidget(widget, anchor2);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (widget == null) {
                IdeStatusBarImpl.$$$reportNull$$$0(36);
            }
            this.removeWidget(widget.ID());
        });
    }

    @Override
    public void removeCustomIndicationComponents() {
        for (String id : this.myCustomComponentIds) {
            this.removeWidget(id);
        }
        this.myCustomComponentIds.clear();
    }

    public void addCustomIndicationComponent(final @NotNull JComponent c) {
        if (c == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(10);
        }
        final String customId = c.getClass().getName() + new Random().nextLong();
        this.addWidget((StatusBarWidget)new CustomStatusBarWidget(){

            @NotNull
            public String ID() {
                String string = customId;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                return null;
            }

            public void install(@NotNull StatusBar statusBar) {
                if (statusBar == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void dispose() {
            }

            public JComponent getComponent() {
                return c;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statusBar";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "ID";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentation";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "install";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myCustomComponentIds.add(customId);
    }

    public void removeCustomIndicationComponent(@NotNull JComponent c) {
        String[] keys;
        if (c == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(11);
        }
        Set<String> keySet = this.myWidgetMap.keySet();
        for (String key : keys = ArrayUtil.toStringArray(keySet)) {
            WidgetBean value = this.myWidgetMap.get(key);
            if (!(value.widget instanceof CustomStatusBarWidget) || value.component != c) continue;
            this.removeWidget(key);
            this.myCustomComponentIds.remove(key);
        }
    }

    public void dispose() {
        this.myWidgetMap.clear();
        this.myChildren.clear();
        if (this.myLeftPanel != null) {
            this.myLeftPanel.removeAll();
        }
        if (this.myRightPanel != null) {
            this.myRightPanel.removeAll();
        }
        if (this.myCenterPanel != null) {
            this.myCenterPanel.removeAll();
        }
    }

    private void addWidget(@NotNull StatusBarWidget widget, @NotNull Position pos, @NotNull String anchor2) {
        JPanel panel2;
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(12);
        }
        if (pos == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(13);
        }
        if (anchor2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(14);
        }
        this.myOrderedWidgets.add(widget.ID());
        if (pos == Position.RIGHT) {
            if (this.myRightPanel == null) {
                this.myRightPanel = new JPanel();
                this.myRightPanel.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)0, (int)(SystemInfo.isMac ? 2 : 0)));
                this.myRightPanel.setLayout(new BoxLayout(this.myRightPanel, 0){

                    @Override
                    public void layoutContainer(Container target2) {
                        super.layoutContainer(target2);
                        for (Component component : target2.getComponents()) {
                            if (!(component instanceof MemoryUsagePanel)) continue;
                            Rectangle r = component.getBounds();
                            r.y = 0;
                            r.width = r.width + (SystemInfo.isMac ? 4 : 0);
                            r.height = target2.getHeight();
                            component.setBounds(r);
                        }
                    }
                });
                this.myRightPanel.setOpaque(false);
                this.add((Component)this.myRightPanel, "East");
            }
            panel2 = this.myRightPanel;
        } else if (pos == Position.LEFT) {
            if (this.myLeftPanel == null) {
                this.myLeftPanel = new JPanel();
                this.myLeftPanel.setBorder((Border)JBUI.Borders.empty((int)1, (int)4, (int)0, (int)1));
                this.myLeftPanel.setLayout(new BoxLayout(this.myLeftPanel, 0));
                this.myLeftPanel.setOpaque(false);
                this.add((Component)this.myLeftPanel, "West");
            }
            panel2 = this.myLeftPanel;
        } else {
            if (this.myCenterPanel == null) {
                this.myCenterPanel = JBUI.Panels.simplePanel().andTransparent();
                this.myCenterPanel.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)0, (int)1));
                this.add((Component)this.myCenterPanel, "Center");
            }
            panel2 = this.myCenterPanel;
        }
        JComponent c = IdeStatusBarImpl.wrap(widget);
        if (Position.RIGHT == pos && panel2.getComponentCount() > 0) {
            boolean before;
            String wid;
            if (!anchor2.equals("__AUTODETECT__")) {
                List parts = StringUtil.split((String)anchor2, (String)" ");
                if (parts.size() < 2 || !this.myWidgetMap.keySet().contains(parts.get(1))) {
                    wid = "Notifications";
                    before = true;
                } else {
                    wid = (String)parts.get(1);
                    before = "before".equalsIgnoreCase((String)parts.get(0));
                }
            } else {
                wid = "Notifications";
                before = true;
            }
            for (String id : this.myWidgetMap.keySet()) {
                if (!id.equalsIgnoreCase(wid)) continue;
                WidgetBean bean = this.myWidgetMap.get(id);
                int i = 0;
                for (Component component : this.myRightPanel.getComponents()) {
                    if (component == bean.component) {
                        if (before) {
                            panel2.add((Component)c, i);
                            this.updateBorder(i);
                        } else {
                            int ndx = i + 1;
                            panel2.add((Component)c, i + 1);
                            this.updateBorder(ndx);
                        }
                        this.installWidget(widget, pos, c, anchor2);
                        return;
                    }
                    ++i;
                }
            }
        }
        if (Position.LEFT == pos && panel2.getComponentCount() == 0) {
            c.setBorder((Border)(SystemInfo.isMac ? JBUI.Borders.empty((int)2, (int)0, (int)2, (int)4) : JBUI.Borders.empty()));
        }
        panel2.add(c);
        this.installWidget(widget, pos, c, anchor2);
        if (widget instanceof StatusBarWidget.Multiframe) {
            StatusBarWidget.Multiframe mfw = (StatusBarWidget.Multiframe)widget;
            this.updateChildren(child -> {
                if (pos == null) {
                    IdeStatusBarImpl.$$$reportNull$$$0(32);
                }
                if (anchor2 == null) {
                    IdeStatusBarImpl.$$$reportNull$$$0(33);
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (pos == null) {
                        IdeStatusBarImpl.$$$reportNull$$$0(34);
                    }
                    if (anchor2 == null) {
                        IdeStatusBarImpl.$$$reportNull$$$0(35);
                    }
                    StatusBarWidget widgetCopy = mfw.copy();
                    child.addWidget(widgetCopy, pos, anchor2);
                });
            });
        }
        this.repaint();
    }

    private void updateBorder(int ndx) {
        JComponent self;
        if (this.myRightPanel.getComponentCount() == 0) {
            return;
        }
        if (ndx >= this.myRightPanel.getComponentCount()) {
            --ndx;
        }
        if (ndx < 0) {
            ++ndx;
        }
        if ((self = (JComponent)this.myRightPanel.getComponent(ndx)) instanceof IconPresentationWrapper || self instanceof IconLikeCustomStatusBarWidget) {
            int prev2 = ndx - 1;
            int next = ndx + 1;
            JComponent p = prev2 >= 0 ? (JComponent)this.myRightPanel.getComponent(prev2) : null;
            JComponent n = next < this.myRightPanel.getComponentCount() ? (JComponent)this.myRightPanel.getComponent(next) : null;
            boolean prevIcon = p instanceof IconPresentationWrapper || p instanceof IconLikeCustomStatusBarWidget;
            boolean nextIcon = n instanceof IconPresentationWrapper || n instanceof IconLikeCustomStatusBarWidget;
            self.setBorder(prevIcon ? JBUI.Borders.empty((int)2) : StatusBarWidget.WidgetBorder.INSTANCE);
            if (nextIcon) {
                n.setBorder(JBUI.Borders.empty((int)2));
            }
        }
    }

    public void setInfo(@Nullable String s) {
        this.setInfo(s, null);
    }

    public void setInfo(@Nullable String s, @Nullable String requestor) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myInfoAndProgressPanel != null) {
                Couple<String> pair = this.myInfoAndProgressPanel.setText(s, requestor);
                this.myInfo = (String)pair.first;
            }
        });
    }

    public String getInfo() {
        return this.myInfo;
    }

    @Override
    public void addProgress(@NotNull ProgressIndicatorEx indicator, @NotNull TaskInfo info) {
        if (indicator == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(15);
        }
        if (info == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(16);
        }
        this.myInfoAndProgressPanel.addProgress(indicator, info);
    }

    @Override
    public List<Pair<TaskInfo, ProgressIndicator>> getBackgroundProcesses() {
        return this.myInfoAndProgressPanel.getBackgroundProcesses();
    }

    @Override
    public void setProcessWindowOpen(boolean open2) {
        this.myInfoAndProgressPanel.setProcessWindowOpen(open2);
    }

    @Override
    public boolean isProcessWindowOpen() {
        return this.myInfoAndProgressPanel.isProcessWindowOpen();
    }

    @Override
    public void startRefreshIndication(String tooltipText) {
        this.myInfoAndProgressPanel.setRefreshToolTipText(tooltipText);
        this.myInfoAndProgressPanel.setRefreshVisible(true);
        this.updateChildren(child -> child.startRefreshIndication(tooltipText));
    }

    @Override
    public void stopRefreshIndication() {
        this.myInfoAndProgressPanel.setRefreshVisible(false);
        this.updateChildren(IdeStatusBarImpl::stopRefreshIndication);
    }

    @Override
    public BalloonHandler notifyProgressByBalloon(@NotNull MessageType type, @NotNull String htmlBody) {
        if (type == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(17);
        }
        if (htmlBody == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(18);
        }
        return this.notifyProgressByBalloon(type, htmlBody, null, null);
    }

    @Override
    public BalloonHandler notifyProgressByBalloon(@NotNull MessageType type, @NotNull String htmlBody, @Nullable Icon icon, @Nullable HyperlinkListener listener2) {
        if (type == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(19);
        }
        if (htmlBody == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(20);
        }
        return this.myInfoAndProgressPanel.notifyByBalloon(type, htmlBody, icon, listener2);
    }

    public void fireNotificationPopup(@NotNull JComponent content, Color backgroundColor) {
        if (content == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(21);
        }
        new NotificationPopup(this, content, backgroundColor);
    }

    private void installWidget(@NotNull StatusBarWidget widget, @NotNull Position pos, @NotNull JComponent c, String anchor2) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(22);
        }
        if (pos == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(23);
        }
        if (c == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(24);
        }
        this.myWidgetMap.put(widget.ID(), WidgetBean.create(widget, pos, c, anchor2));
        widget.install((StatusBar)this);
        Disposer.register((Disposable)this, (Disposable)widget);
    }

    private static JComponent wrap(@NotNull StatusBarWidget widget) {
        StatusBarWrapper wrapper;
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(25);
        }
        if (widget instanceof CustomStatusBarWidget) {
            return ((CustomStatusBarWidget)widget).getComponent();
        }
        StatusBarWidget.WidgetPresentation presentation = widget.getPresentation(SystemInfo.isMac ? StatusBarWidget.PlatformType.MAC : StatusBarWidget.PlatformType.DEFAULT);
        assert (presentation != null) : "Presentation should not be null!";
        if (presentation instanceof StatusBarWidget.IconPresentation) {
            wrapper = new IconPresentationWrapper((StatusBarWidget.IconPresentation)presentation);
        } else if (presentation instanceof StatusBarWidget.TextPresentation) {
            wrapper = new TextPresentationWrapper((StatusBarWidget.TextPresentation)presentation);
            ((JComponent)((Object)wrapper)).setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        } else if (presentation instanceof StatusBarWidget.MultipleTextValuesPresentation) {
            wrapper = new MultipleTextValuesPresentationWrapper((StatusBarWidget.MultipleTextValuesPresentation)presentation);
            ((JComponent)((Object)wrapper)).setBorder(StatusBarWidget.WidgetBorder.WIDE);
        } else {
            throw new IllegalArgumentException("Unable to find a wrapper for presentation: " + presentation.getClass().getSimpleName());
        }
        return wrapper;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected void setUI(StatusBarUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((StatusBarUI)UIManager.getUI(this));
        } else {
            this.setUI(new StatusBarUI());
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
    }

    @Override
    public StatusBarUI getUI() {
        return (StatusBarUI)this.ui;
    }

    public void removeWidget(@NotNull String id) {
        if (id == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(26);
        }
        assert (EventQueue.isDispatchThread()) : "Must be EDT";
        WidgetBean bean = this.myWidgetMap.get(id);
        if (bean != null) {
            if (Position.LEFT == bean.position) {
                this.myLeftPanel.remove(bean.component);
            } else if (Position.RIGHT == bean.position) {
                Component[] components = this.myRightPanel.getComponents();
                int i = 0;
                for (Component c : components) {
                    if (c == bean.component) break;
                    ++i;
                }
                this.myRightPanel.remove(bean.component);
                this.updateBorder(i);
            } else {
                this.myCenterPanel.remove(bean.component);
            }
            this.myWidgetMap.remove(bean.widget.ID());
            Disposer.dispose((Disposable)bean.widget);
            this.repaint();
        }
        this.updateChildren(child -> {
            if (id == null) {
                IdeStatusBarImpl.$$$reportNull$$$0(31);
            }
            child.removeWidget(id);
        });
        this.myOrderedWidgets.remove(id);
    }

    @Override
    public void updateWidgets() {
        for (String s : this.myWidgetMap.keySet()) {
            this.updateWidget(s);
        }
        this.updateChildren(IdeStatusBarImpl::updateWidgets);
    }

    public void updateWidget(@NotNull String id) {
        if (id == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(27);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            WidgetBean bean;
            if (id == null) {
                IdeStatusBarImpl.$$$reportNull$$$0(29);
            }
            if ((bean = this.myWidgetMap.get(id)) != null) {
                if (bean.component instanceof StatusBarWrapper) {
                    ((StatusBarWrapper)((Object)bean.component)).beforeUpdate();
                }
                bean.component.repaint();
            }
            this.updateChildren(child -> {
                if (id == null) {
                    IdeStatusBarImpl.$$$reportNull$$$0(30);
                }
                child.updateWidget(id);
            });
        });
    }

    @Nullable
    public StatusBarWidget getWidget(String id) {
        WidgetBean bean = this.myWidgetMap.get(id);
        return bean == null ? null : bean.widget;
    }

    @Nullable
    public JComponent getWidgetComponent(@NotNull String id) {
        WidgetBean bean;
        if (id == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(28);
        }
        return (bean = this.myWidgetMap.get(id)) == null ? null : bean.component;
    }

    public IdeFrame getFrame() {
        return this.myFrame;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIdeStatusBarImpl();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 33: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: 
            case 13: 
            case 23: 
            case 32: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 10: 
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlBody";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addWidget";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomIndicationComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCustomIndicationComponent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addProgress";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyProgressByBalloon";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "fireNotificationPopup";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "installWidget";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "removeWidget";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "updateWidget";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "getWidgetComponent";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateWidget$13";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$12";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$removeWidget$11";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addWidget$8";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$7";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addWidget$6";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addWidget$5";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addWidget$4";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addWidget$3";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addWidget$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class AccessibleIdeStatusBarImpl
    extends JComponent.AccessibleJComponent {
        protected AccessibleIdeStatusBarImpl() {
            super(IdeStatusBarImpl.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private static final class IconPresentationWrapper
    extends JLabel
    implements StatusBarWrapper {
        private final StatusBarWidget.IconPresentation myPresentation;
        private final Consumer<MouseEvent> myClickConsumer;
        private Icon myIcon;

        private IconPresentationWrapper(@NotNull StatusBarWidget.IconPresentation presentation) {
            if (presentation == null) {
                IconPresentationWrapper.$$$reportNull$$$0(0);
            }
            this.myPresentation = presentation;
            this.myClickConsumer = this.myPresentation.getClickConsumer();
            this.myIcon = this.myPresentation.getIcon();
            this.setIcon(this.myIcon);
            this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
            this.setToolTipText(presentation.getTooltipText());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (myClickConsumer != null && !e.isPopupTrigger() && 1 == e.getButton()) {
                        myClickConsumer.consume((Object)e);
                    }
                }
            });
            this.setOpaque(false);
        }

        @Override
        public void beforeUpdate() {
            this.myIcon = this.myPresentation.getIcon();
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myPresentation.getTooltipText();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle bounds = this.getBounds();
            JBInsets insets = JBUI.insets((Insets)this.getInsets());
            if (this.myIcon != null) {
                int iconWidth = this.myIcon.getIconWidth();
                int iconHeight = this.myIcon.getIconHeight();
                this.myIcon.paintIcon(this, g, insets.left + (bounds.width - insets.left - insets.right - iconWidth) / 2, insets.top + (bounds.height - insets.top - insets.bottom - iconHeight) / 2);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.size((int)24, (int)20);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$IconPresentationWrapper", "<init>"));
        }
    }

    private static final class TextPresentationWrapper
    extends TextPanel
    implements StatusBarWrapper {
        private final StatusBarWidget.TextPresentation myPresentation;
        private final Consumer<MouseEvent> myClickConsumer;

        private TextPresentationWrapper(@NotNull StatusBarWidget.TextPresentation presentation) {
            if (presentation == null) {
                TextPresentationWrapper.$$$reportNull$$$0(0);
            }
            this.myPresentation = presentation;
            this.myClickConsumer = this.myPresentation.getClickConsumer();
            this.setTextAlignment(presentation.getAlignment());
            this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
            this.setToolTipText(presentation.getTooltipText());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (myClickConsumer != null && !e.isPopupTrigger() && 1 == e.getButton()) {
                        myClickConsumer.consume((Object)e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.setOpaque(false);
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myPresentation.getTooltipText();
        }

        @Override
        public void beforeUpdate() {
            this.setText(this.myPresentation.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$TextPresentationWrapper", "<init>"));
        }
    }

    private static final class MultipleTextValuesPresentationWrapper
    extends SimpleColoredComponent
    implements StatusBarWrapper {
        private final StatusBarWidget.MultipleTextValuesPresentation myPresentation;

        private MultipleTextValuesPresentationWrapper(@NotNull StatusBarWidget.MultipleTextValuesPresentation presentation) {
            if (presentation == null) {
                MultipleTextValuesPresentationWrapper.$$$reportNull$$$0(0);
            }
            this.myPresentation = presentation;
            this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
            this.setToolTipText(presentation.getTooltipText());
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    ListPopup popup2;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((popup2 = myPresentation.getPopupStep()) == null) {
                        return false;
                    }
                    Dimension dimension = popup2.getContent().getPreferredSize();
                    Point at = new Point(0, -dimension.height);
                    popup2.show(new RelativePoint(e.getComponent(), at));
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$MultipleTextValuesPresentationWrapper$1", "onClick"));
                }
            }.installOn((Component)((Object)this));
            this.setIconOnTheRight(true);
        }

        public Font getFont() {
            return SystemInfo.isMac ? JBUI.Fonts.label((float)11.0f) : JBUI.Fonts.label();
        }

        @Override
        public void beforeUpdate() {
            this.clear();
            String value = this.myPresentation.getSelectedValue();
            if (value != null) {
                this.append(value);
                this.setIcon(AllIcons.Ide.Statusbar_arrows);
            }
        }

        @Nullable
        public String getToolTipText() {
            return this.myPresentation.getTooltipText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$MultipleTextValuesPresentationWrapper", "<init>"));
        }
    }

    @FunctionalInterface
    private static interface StatusBarWrapper {
        public void beforeUpdate();
    }

    @FunctionalInterface
    static interface ChildAction {
        public void update(IdeStatusBarImpl var1);
    }

    private static class WidgetBean {
        JComponent component;
        Position position;
        StatusBarWidget widget;
        String anchor;

        private WidgetBean() {
        }

        static WidgetBean create(@NotNull StatusBarWidget widget, @NotNull Position position, @NotNull JComponent component, @NotNull String anchor2) {
            if (widget == null) {
                WidgetBean.$$$reportNull$$$0(0);
            }
            if (position == null) {
                WidgetBean.$$$reportNull$$$0(1);
            }
            if (component == null) {
                WidgetBean.$$$reportNull$$$0(2);
            }
            if (anchor2 == null) {
                WidgetBean.$$$reportNull$$$0(3);
            }
            WidgetBean bean = new WidgetBean();
            bean.widget = widget;
            bean.position = position;
            bean.component = component;
            bean.anchor = anchor2;
            return bean;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "widget";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "position";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$WidgetBean";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Position {
        LEFT,
        RIGHT,
        CENTER;

    }
}

