/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.renameProject;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.platform.renameProject.RenameProjectHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;

public class RenameProjectAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(RenameProjectAction.class);

    public RenameProjectAction() {
        super(RefactoringBundle.message((String)"rename.project.action.title"), RefactoringBundle.message((String)"renames.project"), null);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        e.getPresentation().setEnabled(project != null && !project.isDefault());
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        LOG.assertTrue(project instanceof ProjectEx);
        Object[] modules = ModuleManager.getInstance((Project)project).getModules();
        Module module = (Module)ContainerUtil.find((Object[])modules, module1 -> project.getName().equals(module1.getName()));
        Messages.showInputDialog((Project)project, (String)RefactoringBundle.message((String)"enter.new.project.name"), (String)RefactoringBundle.message((String)"rename.project"), (Icon)Messages.getQuestionIcon(), (String)project.getName(), (InputValidator)new RenameProjectHandler.MyInputValidator((ProjectEx)project, module));
    }
}

