/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.components.JBList;
import icons.SpellcheckerIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SaveTo
implements SpellCheckerQuickFix,
LowPriorityAction {
    private static final SaveTo SAVE_TO_APP_FIX = new SaveTo(SpellCheckerManager.DictionaryLevel.APP);
    private static final SaveTo SAVE_TO_PROJECT_FIX = new SaveTo(SpellCheckerManager.DictionaryLevel.PROJECT);
    private static final String DICTIONARY = " dictionary";
    private static final String DOTS = "...";
    private SpellCheckerManager.DictionaryLevel myLevel = SpellCheckerManager.DictionaryLevel.NOT_SPECIFIED;
    private String myWord;
    public static final String FIX_NAME = SpellCheckerBundle.message("save.0.to.1", "", "...");

    private SaveTo(SpellCheckerManager.DictionaryLevel level) {
        this.myLevel = level;
    }

    public SaveTo(String word) {
        this.myWord = word;
    }

    public SaveTo(String word, SpellCheckerManager.DictionaryLevel level) {
        this.myWord = word;
        this.myLevel = level;
    }

    @NotNull
    public String getName() {
        String dictionary = this.myLevel != SpellCheckerManager.DictionaryLevel.NOT_SPECIFIED ? this.myLevel.getName() + DICTIONARY : DOTS;
        String word = this.myWord != null ? SpellCheckerBundle.message("0.in.qoutes", this.myWord) : "";
        String string = SpellCheckerBundle.message("save.0.to.1", word, dictionary);
        if (string == null) {
            SaveTo.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String dictionary = this.myLevel != SpellCheckerManager.DictionaryLevel.NOT_SPECIFIED ? this.myLevel.getName() + DICTIONARY : DOTS;
        String string = SpellCheckerBundle.message("save.0.to.1", "", dictionary);
        if (string == null) {
            SaveTo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        Anchor anchor2 = Anchor.LAST;
        if (anchor2 == null) {
            SaveTo.$$$reportNull$$$0(2);
        }
        return anchor2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            SaveTo.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            SaveTo.$$$reportNull$$$0(4);
        }
        AsyncResult asyncResult = DataManager.getInstance().getDataContextFromFocus();
        asyncResult.doWhenDone(context -> {
            if (project == null) {
                SaveTo.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                SaveTo.$$$reportNull$$$0(6);
            }
            SpellCheckerManager spellCheckerManager = SpellCheckerManager.getInstance(project);
            String wordToSave = this.myWord != null ? this.myWord : ProblemDescriptorUtil.extractHighlightedText((CommonProblemDescriptor)descriptor, descriptor.getPsiElement());
            VirtualFile file2 = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            if (this.myLevel == SpellCheckerManager.DictionaryLevel.NOT_SPECIFIED) {
                List<String> dictionaryList = Arrays.asList(SpellCheckerManager.DictionaryLevel.PROJECT.getName(), SpellCheckerManager.DictionaryLevel.APP.getName());
                JBList dictList = new JBList(dictionaryList);
                JBPopupFactory.getInstance().createListPopupBuilder((JList)dictList).setTitle(SpellCheckerBundle.message("select.dictionary.title", new Object[0])).setItemChoosenCallback(() -> {
                    if (project == null) {
                        SaveTo.$$$reportNull$$$0(7);
                    }
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        if (project == null) {
                            SaveTo.$$$reportNull$$$0(8);
                        }
                        spellCheckerManager.acceptWordAsCorrect(wordToSave, file2, project, SpellCheckerManager.DictionaryLevel.getLevelByName((String)dictList.getSelectedValue()));
                    }, this.getName(), null);
                }).createPopup().showInBestPositionFor(context);
            } else {
                spellCheckerManager.acceptWordAsCorrect(wordToSave, file2, project, this.myLevel);
            }
        });
    }

    public static SaveTo getSaveToLevelFix(SpellCheckerManager.DictionaryLevel level) {
        return SpellCheckerManager.DictionaryLevel.PROJECT == level ? SAVE_TO_PROJECT_FIX : SAVE_TO_APP_FIX;
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/SaveTo";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupActionAnchor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/SaveTo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

