/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class PopupListElementRenderer<E>
extends GroupedItemsListRenderer<E> {
    private final ListPopupImpl myPopup;
    private JLabel myShortcutLabel;

    public PopupListElementRenderer(final ListPopupImpl aPopup) {
        super(new ListItemDescriptorAdapter<E>(){

            public String getTextFor(E value) {
                return aPopup.getListStep().getTextFor(value);
            }

            public Icon getIconFor(E value) {
                return aPopup.getListStep().getIconFor(value);
            }

            public Icon getSelectedIconFor(E value) {
                return aPopup.getListStep().getSelectedIconFor(value);
            }

            public boolean hasSeparatorAboveOf(E value) {
                return aPopup.getListModel().isSeparatorAboveOf(value);
            }

            public String getCaptionAboveOf(E value) {
                return aPopup.getListModel().getCaptionAboveOf(value);
            }

            @Nullable
            public String getTooltipFor(E value) {
                ListPopupStep<Object> listStep = aPopup.getListStep();
                if (!(listStep instanceof ListPopupStepEx)) {
                    return null;
                }
                return ((ListPopupStepEx)listStep).getTooltipTextFor(value);
            }
        });
        this.myPopup = aPopup;
    }

    @Override
    protected JComponent createItemComponent() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.createLabel();
        panel2.add((Component)this.myTextLabel, "Center");
        this.myShortcutLabel = new JLabel();
        this.myShortcutLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)3));
        Color color = UIManager.getColor("MenuItem.acceleratorForeground");
        this.myShortcutLabel.setForeground(color);
        panel2.add((Component)this.myShortcutLabel, "East");
        return this.layoutComponent(panel2);
    }

    @Override
    protected void customizeComponent(JList<? extends E> list2, E value, boolean isSelected) {
        ListPopupStep<Object> step = this.myPopup.getListStep();
        boolean isSelectable = step.isSelectable(value);
        this.myTextLabel.setEnabled(isSelectable);
        if (!isSelected && step instanceof BaseListPopupStep) {
            Color bg = ((BaseListPopupStep)step).getBackgroundFor(value);
            Color fg = ((BaseListPopupStep)step).getForegroundFor(value);
            if (fg != null) {
                this.myTextLabel.setForeground(fg);
            }
            if (bg != null) {
                UIUtil.setBackgroundRecursively((Component)this.myComponent, (Color)bg);
            }
        }
        if (step.isMnemonicsNavigationEnabled()) {
            int pos = step.getMnemonicNavigationFilter().getMnemonicPos(value);
            if (pos != -1) {
                String text = this.myTextLabel.getText();
                text = text.substring(0, pos) + text.substring(pos + 1);
                this.myTextLabel.setText(text);
                this.myTextLabel.setDisplayedMnemonicIndex(pos);
            }
        } else {
            this.myTextLabel.setDisplayedMnemonicIndex(-1);
        }
        if (step.hasSubstep(value) && isSelectable) {
            this.myNextStepLabel.setVisible(true);
            boolean isDark = ColorUtil.isDark((Color)UIUtil.getListSelectionBackground());
            this.myNextStepLabel.setIcon(isSelected ? (isDark ? AllIcons.Icons.Ide.NextStepInverted : AllIcons.Icons.Ide.NextStep) : AllIcons.Icons.Ide.NextStepGrayed);
        } else {
            this.myNextStepLabel.setVisible(false);
        }
        this.setSelected(this.myNextStepLabel, isSelected);
        if (this.myShortcutLabel != null) {
            Shortcut shortcut;
            ShortcutSet set2;
            this.myShortcutLabel.setEnabled(isSelectable);
            this.myShortcutLabel.setText("");
            if (value instanceof ShortcutProvider && (set2 = ((ShortcutProvider)value).getShortcut()) != null && (shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])set2.getShortcuts())) != null) {
                this.myShortcutLabel.setText("     " + KeymapUtil.getShortcutText((Shortcut)shortcut));
            }
            this.setSelected(this.myShortcutLabel, isSelected);
            this.myShortcutLabel.setForeground(isSelected ? UIManager.getColor("MenuItem.acceleratorSelectionForeground") : UIManager.getColor("MenuItem.acceleratorForeground"));
        }
    }
}

