/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actions.AbstractToggleUseSoftWrapsAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ClickListener;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ErrorStripeEditorCustomization;
import com.intellij.ui.Expandable;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerEditorBase
implements Expandable {
    private final Project myProject;
    private final XDebuggerEditorsProvider myDebuggerEditorsProvider;
    @NotNull
    private final EvaluationMode myMode;
    @Nullable
    private final String myHistoryId;
    @Nullable
    private XSourcePosition mySourcePosition;
    private int myHistoryIndex;
    @Nullable
    private PsiElement myContext;
    private final LanguageChooser myLanguageChooser;
    private final JLabel myExpandButton;
    private JBPopup myExpandedPopup;
    private Runnable myExpandHandler;
    private WeakReference<ListPopup> myPopup;
    private static final String SOFT_WRAPS_KEY = "XDebuggerExpressionEditor_Use_Soft_Wraps";

    protected XDebuggerEditorBase(Project project, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @NotNull EvaluationMode mode, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition) {
        if (debuggerEditorsProvider == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(0);
        }
        if (mode == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(1);
        }
        this.myHistoryIndex = -1;
        this.myLanguageChooser = new LanguageChooser();
        this.myExpandButton = new JLabel(AllIcons.General.ExpandComponent);
        this.myProject = project;
        this.myDebuggerEditorsProvider = debuggerEditorsProvider;
        this.myMode = mode;
        this.myHistoryId = historyId;
        this.mySourcePosition = sourcePosition;
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (XDebuggerEditorBase.this.myLanguageChooser.isEnabled()) {
                    ListPopup oldPopup = (ListPopup)SoftReference.dereference((Reference)XDebuggerEditorBase.this.myPopup);
                    if (oldPopup != null && !oldPopup.isDisposed()) {
                        oldPopup.cancel();
                        XDebuggerEditorBase.this.myPopup = null;
                        return true;
                    }
                    ListPopup popup2 = XDebuggerEditorBase.this.createLanguagePopup();
                    popup2.showUnderneathOf((Component)XDebuggerEditorBase.this.myLanguageChooser);
                    XDebuggerEditorBase.this.myPopup = new WeakReference<ListPopup>(popup2);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$1", "onClick"));
            }
        }.installOn((Component)this.myLanguageChooser);
        this.myExpandButton.setToolTipText(KeymapUtil.createTooltipText((String)"Expand", (String)"ExpandExpandableComponent"));
        this.myExpandButton.setCursor(Cursor.getPredefinedCursor(12));
        this.myExpandButton.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        this.myExpandButton.setDisabledIcon(AllIcons.General.ExpandComponent);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                XDebuggerEditorBase.this.expand();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$2", "onClick"));
            }
        }.installOn((Component)this.myExpandButton);
        this.myExpandButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                XDebuggerEditorBase.this.myExpandButton.setIcon(AllIcons.General.ExpandComponentHover);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                XDebuggerEditorBase.this.myExpandButton.setIcon(AllIcons.General.ExpandComponent);
            }
        });
    }

    private ListPopup createLanguagePopup() {
        DefaultActionGroup actions = new DefaultActionGroup();
        for (final Language language : this.getSupportedLanguages()) {
            actions.add(new AnAction(language.getDisplayName(), null, language.getAssociatedFileType().getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    XExpression currentExpression = XDebuggerEditorBase.this.getExpression();
                    XDebuggerEditorBase.this.setExpression(new XExpressionImpl(currentExpression.getExpression(), language, currentExpression.getCustomInfo()));
                    XDebuggerEditorBase.this.requestFocusInEditor();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$4", "actionPerformed"));
                }
            });
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.getComponent());
        return JBPopupFactory.getInstance().createActionGroupPopup("Choose Language", (ActionGroup)actions, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    @NotNull
    private Collection<Language> getSupportedLanguages() {
        XDebuggerEditorsProvider editorsProvider = this.getEditorsProvider();
        if (this.myContext != null && editorsProvider instanceof XDebuggerEditorsProviderBase) {
            Collection collection = ((XDebuggerEditorsProviderBase)editorsProvider).getSupportedLanguages(this.myContext);
            if (collection == null) {
                XDebuggerEditorBase.$$$reportNull$$$0(2);
            }
            return collection;
        }
        Collection collection = editorsProvider.getSupportedLanguages(this.myProject, this.mySourcePosition);
        if (collection == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(3);
        }
        return collection;
    }

    protected JComponent decorate(JComponent component, boolean multiline, boolean showEditor) {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel();
        BorderLayoutPanel factoryPanel = JBUI.Panels.simplePanel();
        factoryPanel.add((Component)this.myLanguageChooser, multiline ? "North" : "Center");
        panel2.add((Component)factoryPanel, (Object)"West");
        if (!multiline && showEditor) {
            component = this.addExpand(component, false);
        }
        panel2.addToCenter((Component)component);
        if (multiline) {
            JBLabel adLabel = new JBLabel(XDebuggerEditorBase.getAdText(), 4);
            adLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            adLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
            panel2.addToBottom((Component)adLabel);
        }
        return panel2;
    }

    protected JComponent addChooser(JComponent component) {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)component);
        panel2.setBackground(component.getBackground());
        panel2.addToRight((Component)this.myLanguageChooser);
        return panel2;
    }

    protected JComponent addExpand(final JComponent component, boolean inheritBackground) {
        BorderLayoutPanel panel2;
        if (inheritBackground) {
            panel2 = new BorderLayoutPanel(){

                public Color getBackground() {
                    return component.getBackground();
                }
            };
        } else {
            panel2 = JBUI.Panels.simplePanel();
            panel2.setOpaque(false);
        }
        panel2.addToCenter((Component)component);
        panel2.addToRight((Component)this.myExpandButton);
        return panel2;
    }

    public JComponent getLanguageChooser() {
        return this.myLanguageChooser;
    }

    public void setContext(@Nullable PsiElement context) {
        if (this.myContext != context) {
            this.myContext = context;
            this.setExpression(this.getExpression());
        }
    }

    public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
        if (this.mySourcePosition != sourcePosition) {
            this.mySourcePosition = sourcePosition;
            this.setExpression(this.getExpression());
        }
    }

    @NotNull
    public EvaluationMode getMode() {
        EvaluationMode evaluationMode = this.myMode;
        if (evaluationMode == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(4);
        }
        return evaluationMode;
    }

    @Nullable
    public abstract Editor getEditor();

    public abstract JComponent getComponent();

    public JComponent getEditorComponent() {
        return this.getComponent();
    }

    protected abstract void doSetText(XExpression var1);

    public void setExpression(@Nullable XExpression text) {
        Collection<Language> languages;
        boolean many;
        Language language;
        if (text == null) {
            XExpression xExpression = text = this.getMode() == EvaluationMode.EXPRESSION ? XExpressionImpl.EMPTY_EXPRESSION : XExpressionImpl.EMPTY_CODE_FRAGMENT;
        }
        if ((language = text.getLanguage()) == null) {
            if (this.myContext != null) {
                language = this.myContext.getLanguage();
            }
            if (language == null && this.mySourcePosition != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)this.mySourcePosition.getFile());
            }
            if (language == null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)this.getEditorsProvider().getFileType());
            }
            text = new XExpressionImpl(text.getExpression(), language, text.getCustomInfo(), text.getMode());
        }
        boolean bl = many = (languages = this.getSupportedLanguages()).size() > 1;
        if (language != null) {
            this.myLanguageChooser.setVisible(many);
        }
        this.myLanguageChooser.setVisible(this.myLanguageChooser.isVisible() || many);
        if (language != null && language.getAssociatedFileType() != null) {
            this.myLanguageChooser.setText(language.getDisplayName());
        }
        this.doSetText(text);
    }

    public void setEnabled(boolean enable) {
        this.myLanguageChooser.setEnabled(enable);
    }

    public abstract XExpression getExpression();

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    public void requestFocusInEditor() {
        JComponent preferredFocusedComponent = this.getPreferredFocusedComponent();
        if (preferredFocusedComponent != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)preferredFocusedComponent, true);
        }
    }

    public abstract void selectAll();

    protected void onHistoryChanged() {
    }

    public List<XExpression> getRecentExpressions() {
        if (this.myHistoryId != null) {
            return XDebuggerHistoryManager.getInstance(this.myProject).getRecentExpressions(this.myHistoryId);
        }
        return Collections.emptyList();
    }

    public void saveTextInHistory() {
        this.saveTextInHistory(this.getExpression());
    }

    private void saveTextInHistory(XExpression text) {
        if (this.myHistoryId != null) {
            boolean update = XDebuggerHistoryManager.getInstance(this.myProject).addRecentExpression(this.myHistoryId, text);
            this.myHistoryIndex = -1;
            if (update) {
                this.onHistoryChanged();
            }
        }
    }

    @NotNull
    protected FileType getFileType(@NotNull XExpression expression) {
        FileType fileType;
        if (expression == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(5);
        }
        if ((fileType = LanguageUtil.getLanguageFileType((Language)expression.getLanguage())) != null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                XDebuggerEditorBase.$$$reportNull$$$0(6);
            }
            return fileType2;
        }
        FileType fileType3 = this.getEditorsProvider().getFileType();
        if (fileType3 == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(7);
        }
        return fileType3;
    }

    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myDebuggerEditorsProvider;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected Document createDocument(XExpression text) {
        XDebuggerEditorsProvider provider = this.getEditorsProvider();
        if (this.myContext != null && provider instanceof XDebuggerEditorsProviderBase) {
            return ((XDebuggerEditorsProviderBase)provider).createDocument(this.getProject(), text, this.myContext, this.myMode);
        }
        return provider.createDocument(this.getProject(), text, this.mySourcePosition, this.myMode);
    }

    public boolean canGoBackward() {
        return this.myHistoryIndex < this.getRecentExpressions().size() - 1;
    }

    public boolean canGoForward() {
        return this.myHistoryIndex > 0;
    }

    public void goBackward() {
        List<XExpression> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex < expressions.size() - 1) {
            ++this.myHistoryIndex;
            this.setExpression(expressions.get(this.myHistoryIndex));
        }
    }

    public void goForward() {
        List<XExpression> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex > 0) {
            --this.myHistoryIndex;
            this.setExpression(expressions.get(this.myHistoryIndex));
        }
    }

    protected static void foldNewLines(EditorEx editor) {
        editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
        editor.reinitSettings();
        FoldingModelEx foldingModel = editor.getFoldingModel();
        CharSequence text = editor.getDocument().getCharsSequence();
        foldingModel.runBatchFoldingOperation(() -> {
            foldingModel.clearFoldRegions();
            for (int i = 0; i < text.length(); ++i) {
                FoldRegion region;
                if (text.charAt(i) != '\n' || (region = foldingModel.createFoldRegion(i, i + 1, "\u23ce", null, true)) == null) continue;
                region.setExpanded(false);
            }
        });
    }

    protected void prepareEditor(Editor editor) {
    }

    protected final void setExpandable(Editor editor) {
        editor.getContentComponent().putClientProperty(Expandable.class, this);
    }

    public void expand() {
        if (this.myExpandedPopup != null || !this.getComponent().isEnabled()) {
            return;
        }
        if (this.myExpandHandler != null) {
            this.myExpandHandler.run();
            return;
        }
        XDebuggerExpressionEditor expressionEditor = new XDebuggerExpressionEditor(this.myProject, this.myDebuggerEditorsProvider, this.myHistoryId, this.mySourcePosition, this.getExpression(), true, true, false){

            @Override
            protected JComponent decorate(JComponent component, boolean multiline, boolean showEditor) {
                return component;
            }
        };
        EditorTextField editorTextField = (EditorTextField)((Object)expressionEditor.getEditorComponent());
        editorTextField.addSettingsProvider(this::prepareEditor);
        editorTextField.addSettingsProvider(this::setExpandable);
        editorTextField.setFont(editorTextField.getFont().deriveFont((float)this.getEditor().getColorsScheme().getEditorFontSize()));
        JComponent component = expressionEditor.getComponent();
        component.setPreferredSize(new Dimension(this.getComponent().getWidth(), 100));
        this.myExpandedPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(component, expressionEditor.getPreferredFocusedComponent()).setFocusable(true).setResizable(true).setRequestFocus(true).setLocateByContent(true).setCancelOnWindowDeactivation(false).setAdText(XDebuggerEditorBase.getAdText()).setKeyboardActions(Collections.singletonList(Pair.create(event -> {
            this.collapse();
            Window window = UIUtil.getWindow((Component)this.getComponent());
            if (window != null) {
                window.dispatchEvent(new KeyEvent(this.getComponent(), 401, System.currentTimeMillis(), 2, 10, '\r'));
            }
        }, (Object)KeyStroke.getKeyStroke(10, 2)))).setCancelCallback(() -> {
            Editor baseEditor = this.getEditor();
            if (baseEditor != null) {
                WriteAction.run(() -> baseEditor.getDocument().setText((CharSequence)expressionEditor.getExpression().getExpression()));
                XDebuggerEditorBase.foldNewLines((EditorEx)baseEditor);
                Editor newEditor = expressionEditor.getEditor();
                if (newEditor != null) {
                    XDebuggerEditorBase.copyCaretPosition(newEditor, baseEditor);
                    PropertiesComponent.getInstance().setValue(SOFT_WRAPS_KEY, newEditor.getSoftWrapModel().isSoftWrappingEnabled());
                }
            }
            this.myExpandedPopup = null;
            return true;
        }).createPopup();
        this.myExpandedPopup.show(new RelativePoint((Component)this.getComponent(), new Point(0, 0)));
        EditorEx editor = (EditorEx)expressionEditor.getEditor();
        XDebuggerEditorBase.copyCaretPosition(this.getEditor(), editor);
        editor.getSettings().setUseSoftWraps(this.isUseSoftWraps());
        XDebuggerEditorBase.addCollapseButton(editor, this::collapse);
        expressionEditor.requestFocusInEditor();
    }

    public void setExpandHandler(Runnable handler2) {
        this.myExpandHandler = handler2;
    }

    public void addCollapseButton(final Runnable handler2) {
        JComponent component = this.getEditorComponent();
        if (component instanceof EditorTextField) {
            ((EditorTextField)((Object)component)).addSettingsProvider(editor -> {
                editor.getContentComponent().putClientProperty(Expandable.class, new Expandable(){

                    public void expand() {
                    }

                    public void collapse() {
                        handler2.run();
                    }

                    public boolean isExpanded() {
                        return true;
                    }
                });
                XDebuggerEditorBase.addCollapseButton(editor, handler2);
            });
        }
    }

    private static void addCollapseButton(EditorEx editor, final Runnable handler2) {
        ErrorStripeEditorCustomization.DISABLED.customize(editor);
        JScrollPane pane = editor.getScrollPane();
        pane.setVerticalScrollBarPolicy(22);
        pane.getVerticalScrollBar().add("JB_SCROLL_BAR_LEADING_COMPONENT", new JLabel(AllIcons.General.CollapseComponent){
            {
                super(x0);
                this.setToolTipText(KeymapUtil.createTooltipText((String)"Collapse", (String)"CollapseExpandableComponent"));
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent event) {
                        this.setIcon(AllIcons.General.CollapseComponentHover);
                    }

                    @Override
                    public void mouseExited(MouseEvent event) {
                        this.setIcon(AllIcons.General.CollapseComponent);
                    }

                    @Override
                    public void mousePressed(MouseEvent event) {
                        handler2.run();
                    }
                });
            }
        });
    }

    @NotNull
    private static String getAdText() {
        String string = XDebuggerBundle.message((String)"xdebugger.evaluate.history.navigate.ad", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.MOVE_DOWN)) + ", " + KeymapUtil.getKeystrokeText((KeyStroke)KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.MOVE_UP))});
        if (string == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void copyCaretPosition(@Nullable Editor source, @Nullable Editor destination) {
        if (source != null && destination != null) {
            destination.getCaretModel().moveToOffset(source.getCaretModel().getOffset());
        }
    }

    public void collapse() {
        if (this.myExpandedPopup != null) {
            this.myExpandedPopup.cancel();
        }
    }

    public boolean isExpanded() {
        return this.myExpandedPopup != null;
    }

    public boolean isUseSoftWraps() {
        return PropertiesComponent.getInstance().getBoolean(SOFT_WRAPS_KEY, true);
    }

    public void setUseSoftWraps(boolean use) {
        PropertiesComponent.getInstance().setValue(SOFT_WRAPS_KEY, use);
        Editor editor = this.getEditor();
        if (editor != null) {
            AbstractToggleUseSoftWrapsAction.toggleSoftWraps(editor, null, use);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerEditorsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LanguageChooser
    extends JLabel {
        static final Color ENABLED_COLOR = new Color(0x787878);
        static final Color DISABLED_COLOR = new JBColor(0xB2B2B2, 6053215);

        public LanguageChooser() {
            this.setHorizontalTextPosition(2);
            this.setIconTextGap(0);
            this.setToolTipText(XDebuggerBundle.message((String)"xdebugger.evaluate.language.hint", (Object[])new Object[0]));
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setBorder((Border)JBUI.Borders.emptyRight((int)2));
            Icon dropdownIcon = AllIcons.General.Dropdown;
            int width = dropdownIcon.getIconWidth();
            dropdownIcon = IconUtil.cropIcon((Icon)dropdownIcon, (Rectangle)new Rectangle(width / 2, 0, width - width / 2, dropdownIcon.getIconHeight()));
            LayeredIcon icon = (LayeredIcon)JBUI.scale((JBUI.JBIcon)new LayeredIcon(1));
            icon.setIcon(dropdownIcon, 0, 0, -5);
            this.setIcon((Icon)icon);
            this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        }

        @Override
        public Color getForeground() {
            return this.isEnabled() ? ENABLED_COLOR : DISABLED_COLOR;
        }
    }
}

