/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, true);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, false);
    }

    @Nullable
    private static String findSchemaAndGenerateDoc(PsiElement element, @Nullable PsiElement originalElement, boolean preferShort) {
        PsiFile containingFile = (element = (PsiElement)ObjectUtils.coalesce((Object)originalElement, (Object)element)).getContainingFile();
        if (containingFile == null) {
            return null;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(element.getProject());
        JsonSchemaObject rootSchema = service.getSchemaObject(containingFile.getViewProvider().getVirtualFile());
        if (rootSchema == null) {
            return null;
        }
        return JsonSchemaDocumentationProvider.generateDoc(element, rootSchema, preferShort);
    }

    @Nullable
    public static String generateDoc(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema, boolean preferShort) {
        JsonLikePsiWalker walker;
        if (element == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (rootSchema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((walker = JsonLikePsiWalker.getWalker(element, rootSchema)) == null) {
            return null;
        }
        PsiElement checkable = walker.goUpToCheckable(element);
        if (checkable == null) {
            return null;
        }
        List<JsonSchemaVariantsTreeBuilder.Step> position = walker.findPosition(checkable, true, true);
        if (position == null) {
            return null;
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(rootSchema, true, position).resolve();
        for (JsonSchemaObject schema : schemas) {
            String htmlDescription = JsonSchemaDocumentationProvider.getBestDocumentation(preferShort, schema);
            if (htmlDescription == null) continue;
            return htmlDescription;
        }
        return null;
    }

    @Nullable
    public static String getBestDocumentation(boolean preferShort, @NotNull JsonSchemaObject schema) {
        if (schema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(2);
        }
        String htmlDescription = schema.getHtmlDescription();
        String description = schema.getDescription();
        String title = schema.getTitle();
        if (preferShort && !StringUtil.isEmptyOrSpaces((String)title)) {
            return JsonSchemaDocumentationProvider.plainTextPostProcess(title);
        }
        if (!StringUtil.isEmptyOrSpaces((String)htmlDescription)) {
            return htmlDescription;
        }
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            return JsonSchemaDocumentationProvider.plainTextPostProcess(description);
        }
        return null;
    }

    @NotNull
    private static String plainTextPostProcess(String text) {
        String string = StringUtil.escapeXml((String)text).replace("\\n", "<br/>");
        if (string == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSchema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "plainTextPostProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBestDocumentation";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

