/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.tooling.util.DependencyResolver;
import org.jetbrains.plugins.gradle.tooling.util.DependencyTraverser;
import org.jetbrains.plugins.gradle.tooling.util.ModuleComponentIdentifierImpl;
import org.jetbrains.plugins.gradle.tooling.util.SourceSetCachedFinder;

public class DependencyResolverImpl
implements DependencyResolver {
    private static final boolean is4OrBetter = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"4.0")) >= 0;
    private static final boolean isJavaLibraryPluginSupported = is4OrBetter || GradleVersion.current().compareTo(GradleVersion.version((String)"3.4")) >= 0;
    private static final boolean isDependencySubstitutionsSupported = isJavaLibraryPluginSupported || GradleVersion.current().compareTo(GradleVersion.version((String)"2.5")) > 0;
    private static final boolean isArtifactResolutionQuerySupported = isDependencySubstitutionsSupported || GradleVersion.current().compareTo(GradleVersion.version((String)"2.0")) >= 0;
    @NotNull
    private final Project myProject;
    private final boolean myIsPreview;
    private final boolean myDownloadJavadoc;
    private final boolean myDownloadSources;
    private final SourceSetCachedFinder mySourceSetFinder;

    public DependencyResolverImpl(@NotNull Project project, boolean isPreview) {
        if (project == null) {
            DependencyResolverImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myIsPreview = isPreview;
        this.myDownloadJavadoc = false;
        this.myDownloadSources = false;
        this.mySourceSetFinder = new SourceSetCachedFinder(project);
    }

    public DependencyResolverImpl(@NotNull Project project, boolean isPreview, boolean downloadJavadoc, boolean downloadSources, SourceSetCachedFinder sourceSetFinder) {
        if (project == null) {
            DependencyResolverImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myIsPreview = isPreview;
        this.myDownloadJavadoc = downloadJavadoc;
        this.myDownloadSources = downloadSources;
        this.mySourceSetFinder = sourceSetFinder;
    }

    @Override
    public Collection<ExternalDependency> resolveDependencies(@Nullable String configurationName) {
        return this.resolveDependencies(configurationName, null);
    }

    Collection<ExternalDependency> resolveDependencies(@Nullable String configurationName, @Nullable String scope) {
        if (configurationName == null) {
            return Collections.emptyList();
        }
        return this.resolveDependencies((Configuration)this.myProject.getConfigurations().findByName(configurationName), scope).getExternalDeps();
    }

    @Override
    public Collection<ExternalDependency> resolveDependencies(@Nullable Configuration configuration) {
        return this.resolveDependencies(configuration, null).getExternalDeps();
    }

    ExternalDepsResolutionResult resolveDependencies(@Nullable Configuration configuration, @Nullable String scope) {
        if (configuration == null) {
            return ExternalDepsResolutionResult.EMPTY;
        }
        if (configuration.getAllDependencies().isEmpty()) {
            return ExternalDepsResolutionResult.EMPTY;
        }
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        ArrayList<File> resolvedFileDependencies = new ArrayList<File>();
        if (!this.myIsPreview && isArtifactResolutionQuerySupported) {
            Class<?> jvmLibrary = null;
            try {
                jvmLibrary = Class.forName("org.gradle.jvm.JvmLibrary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (jvmLibrary == null) {
                try {
                    jvmLibrary = Class.forName("org.gradle.runtime.jvm.JvmLibrary");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (jvmLibrary != null) {
                ArrayList<Class> artifactTypes = new ArrayList<Class>();
                if (this.myDownloadSources) {
                    artifactTypes.add(SourcesArtifact.class);
                }
                if (this.myDownloadJavadoc) {
                    artifactTypes.add(JavadocArtifact.class);
                }
                Set resolvedArtifacts = configuration.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.SATISFIES_ALL);
                ArrayListMultimap artifactMap = ArrayListMultimap.create();
                for (ResolvedArtifact artifact : resolvedArtifacts) {
                    artifactMap.put((Object)artifact.getModuleVersion().getId(), (Object)artifact);
                }
                boolean isBuildScriptConfiguration = this.myProject.getBuildscript().getConfigurations().contains((Object)configuration);
                DependencyHandler dependencyHandler = isBuildScriptConfiguration ? this.myProject.getBuildscript().getDependencies() : this.myProject.getDependencies();
                ArrayList<ModuleComponentIdentifier> components = new ArrayList<ModuleComponentIdentifier>();
                for (ResolvedArtifact artifact : resolvedArtifacts) {
                    if (DependencyResolverImpl.isProjectDependencyArtifact(artifact)) continue;
                    components.add(this.toComponentIdentifier(artifact.getModuleVersion().getId()));
                }
                Set componentResults = dependencyHandler.createArtifactResolutionQuery().forComponents(components).withArtifacts(jvmLibrary, artifactTypes.toArray(new Class[0])).execute().getResolvedComponents();
                HashMap<ComponentIdentifier, ComponentArtifactsResult> componentResultsMap = new HashMap<ComponentIdentifier, ComponentArtifactsResult>();
                for (ComponentArtifactsResult artifactsResult : componentResults) {
                    componentResultsMap.put(artifactsResult.getId(), artifactsResult);
                }
                HashSet<Configuration> processedConfigurations = new HashSet<Configuration>();
                Multimap<ModuleComponentIdentifier, ProjectDependency> configurationProjectDependencies = this.projectDeps(configuration, (Multimap<ModuleComponentIdentifier, ProjectDependency>)ArrayListMultimap.create(), processedConfigurations);
                ResolutionResult resolutionResult = configuration.getIncoming().getResolutionResult();
                if (!configuration.getResolvedConfiguration().hasError()) {
                    LinkedHashSet fileDeps = new LinkedHashSet(configuration.getIncoming().getFiles().getFiles());
                    for (ResolvedArtifact artifact : artifactMap.values()) {
                        fileDeps.remove(artifact.getFile());
                    }
                    for (ProjectDependency dep : configurationProjectDependencies.values()) {
                        Set depFiles = DependencyResolverImpl.getTargetConfiguration(dep).getAllArtifacts().getFiles().getFiles();
                        HashSet<File> intersection = new HashSet<File>((Collection<File>)Sets.intersection(fileDeps, (Set)depFiles));
                        if (intersection.isEmpty()) continue;
                        DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(intersection);
                        fileCollectionDependency.setScope(scope);
                        result.add(fileCollectionDependency);
                        fileDeps.removeAll(intersection);
                    }
                    for (File file : fileDeps) {
                        DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(Collections.singleton(file));
                        fileCollectionDependency.setScope(scope);
                        result.add(fileCollectionDependency);
                    }
                }
                DependencyResultsTransformer dependencyResultsTransformer = new DependencyResultsTransformer((Multimap<ModuleVersionIdentifier, ResolvedArtifact>)artifactMap, componentResultsMap, configurationProjectDependencies, scope);
                result.addAll(dependencyResultsTransformer.transform(resolutionResult.getRoot().getDependencies()));
                resolvedFileDependencies.addAll(dependencyResultsTransformer.resolvedDepsFiles);
            }
        }
        if (this.myIsPreview || !isArtifactResolutionQuerySupported) {
            Set<ExternalDependency> projectDependencies = this.findDependencies(configuration, (Collection<Dependency>)configuration.getAllDependencies(), scope);
            result.addAll(projectDependencies);
        }
        Set<ExternalDependency> fileDependencies = DependencyResolverImpl.findAllFileDependencies((Collection<Dependency>)configuration.getAllDependencies(), scope);
        fileDependencies.removeAll(resolvedFileDependencies);
        result.addAll(fileDependencies);
        return new ExternalDepsResolutionResult(new ArrayList(result), resolvedFileDependencies);
    }

    Multimap<ModuleComponentIdentifier, ProjectDependency> projectDeps(Configuration conf, Multimap<ModuleComponentIdentifier, ProjectDependency> map, Set<Configuration> processedConfigurations) {
        if (!processedConfigurations.add(conf)) {
            return map;
        }
        for (Dependency dep : conf.getIncoming().getDependencies()) {
            if (!(dep instanceof ProjectDependency)) continue;
            map.put((Object)this.toComponentIdentifier(dep.getGroup(), dep.getName(), dep.getVersion()), (Object)((ProjectDependency)dep));
            this.projectDeps(DependencyResolverImpl.getTargetConfiguration((ProjectDependency)dep), map, processedConfigurations);
        }
        return map;
    }

    boolean containsAll(Configuration cfg, Collection<File> files) {
        for (File file : files) {
            if (cfg.contains(file)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<ExternalDependency> resolveDependencies(@NotNull SourceSet sourceSet) {
        Map map;
        Map map2;
        IdeaPlugin ideaPlugin;
        if (sourceSet == null) {
            DependencyResolverImpl.$$$reportNull$$$0(2);
        }
        ArrayList result = new ArrayList();
        boolean isMainSourceSet = sourceSet.getName().equals("main");
        String deprecatedCompileConfigurationName = isMainSourceSet ? "compile" : GUtil.toCamelCase((CharSequence)sourceSet.getName()) + "Compile";
        Configuration deprecatedCompileConfiguration = (Configuration)this.myProject.getConfigurations().findByName(deprecatedCompileConfigurationName);
        String compileConfigurationName = sourceSet.getCompileConfigurationName();
        Configuration compileClasspathConfiguration = (Configuration)this.myProject.getConfigurations().findByName(compileConfigurationName + "Classpath");
        Configuration originCompileConfiguration = (Configuration)this.myProject.getConfigurations().findByName(compileConfigurationName);
        Configuration compileConfiguration = compileClasspathConfiguration != null ? compileClasspathConfiguration : originCompileConfiguration;
        Configuration compileOnlyConfiguration = isJavaLibraryPluginSupported ? (Configuration)this.myProject.getConfigurations().findByName(sourceSet.getCompileOnlyConfigurationName()) : null;
        String compileScope = "COMPILE";
        ExternalDepsResolutionResult externalDepsResolutionResult = this.resolveDependencies(compileConfiguration, compileScope);
        Collection<ExternalDependency> compileDependencies = externalDepsResolutionResult.getExternalDeps();
        Collection<File> resolvedCompileFileDependencies = externalDepsResolutionResult.getResolvedFiles();
        String runtimeConfigurationName = sourceSet.getRuntimeConfigurationName();
        Configuration runtimeClasspathConfiguration = (Configuration)this.myProject.getConfigurations().findByName(runtimeConfigurationName + "Classpath");
        Configuration originRuntimeConfiguration = (Configuration)this.myProject.getConfigurations().findByName(runtimeConfigurationName);
        Configuration runtimeConfiguration = runtimeClasspathConfiguration != null ? runtimeClasspathConfiguration : originRuntimeConfiguration;
        String runtimeScope = "RUNTIME";
        externalDepsResolutionResult = this.resolveDependencies(runtimeConfiguration, runtimeScope);
        Collection<ExternalDependency> runtimeDependencies = externalDepsResolutionResult.getExternalDeps();
        Collection<File> resolvedRuntimeFileDependencies = externalDepsResolutionResult.getResolvedFiles();
        String providedScope = "PROVIDED";
        ArrayListMultimap resolvedMap = ArrayListMultimap.create();
        boolean checkCompileOnlyDeps = compileClasspathConfiguration != null && !originCompileConfiguration.getResolvedConfiguration().hasError();
        for (Object dep : new DependencyTraverser(compileDependencies)) {
            Collection<File> resolvedFiles = DependencyResolverImpl.resolve((ExternalDependency)dep);
            resolvedMap.put(resolvedFiles, dep);
            if (isJavaLibraryPluginSupported) {
                if (compileOnlyConfiguration == null || !this.containsAll(compileOnlyConfiguration, resolvedFiles) || deprecatedCompileConfiguration != null && this.containsAll(deprecatedCompileConfiguration, resolvedFiles)) continue;
                ((AbstractExternalDependency)dep).setScope(providedScope);
                continue;
            }
            if (!checkCompileOnlyDeps || this.containsAll(originCompileConfiguration, resolvedFiles) || this.containsAll(runtimeConfiguration, resolvedFiles)) continue;
            ((AbstractExternalDependency)dep).setScope(providedScope);
        }
        ArrayListMultimap resolvedRuntimeMap = ArrayListMultimap.create();
        for (ExternalDependency dep : new DependencyTraverser(runtimeDependencies)) {
            Collection dependencies = resolvedMap.get(DependencyResolverImpl.resolve(dep));
            if (dependencies != null && !dependencies.isEmpty() && dep.getDependencies().isEmpty()) {
                runtimeDependencies.remove(dep);
                ((AbstractExternalDependency)dep).setScope(compileScope);
                for (ExternalDependency dependency : dependencies) {
                    ((AbstractExternalDependency)dependency).setScope(compileScope);
                }
                continue;
            }
            if (dependencies != null && !dependencies.isEmpty()) {
                ((AbstractExternalDependency)dep).setScope(compileScope);
            }
            resolvedRuntimeMap.put(DependencyResolverImpl.resolve(dep), (Object)dep);
        }
        resolvedMap.putAll((Multimap)resolvedRuntimeMap);
        result.addAll(compileDependencies);
        result.addAll(runtimeDependencies);
        result = Lists.newArrayList((Iterable)Iterables.filter(result, (Predicate)Predicates.not((Predicate)Predicates.isNull())));
        ArrayList jvmLanguages = Lists.newArrayList((Object[])new String[]{"Java", "Groovy", "Scala"});
        final String sourceSetCompileTaskPrefix = sourceSet.getName() == "main" ? "" : sourceSet.getName();
        List compileTasks = Lists.transform((List)jvmLanguages, (Function)new Function<String, String>(){

            public String apply(String s) {
                return "compile" + StringGroovyMethods.capitalize((String)sourceSetCompileTaskPrefix) + s;
            }
        });
        LinkedHashMap<File, Integer> compileClasspathOrder = new LinkedHashMap<File, Integer>();
        LinkedHashSet<File> compileClasspathFiles = new LinkedHashSet<File>();
        for (Object task : compileTasks) {
            Task compileTask = (Task)this.myProject.getTasks().findByName((String)task);
            if (!(compileTask instanceof AbstractCompile)) continue;
            try {
                ArrayList files2 = new ArrayList(((AbstractCompile)compileTask).getClasspath().getFiles());
                files2.removeAll(compileClasspathFiles);
                compileClasspathFiles.addAll(files2);
            }
            catch (Exception files2) {}
        }
        try {
            compileClasspathFiles = compileClasspathFiles.isEmpty() ? sourceSet.getCompileClasspath().getFiles() : compileClasspathFiles;
        }
        catch (Exception exception) {
            // empty catch block
        }
        int order = 0;
        for (File file : compileClasspathFiles) {
            compileClasspathOrder.put(file, order++);
        }
        LinkedHashMap<File, Integer> runtimeClasspathOrder = new LinkedHashMap<File, Integer>();
        order = 0;
        LinkedHashSet<File> runtimeClasspathFiles = new LinkedHashSet<File>();
        try {
            Set files3 = sourceSet.getRuntimeClasspath().getFiles();
            for (Object file : files3) {
                runtimeClasspathOrder.put((File)file, order++);
            }
            runtimeClasspathFiles.addAll(files3);
        }
        catch (Exception files3) {
            // empty catch block
        }
        runtimeClasspathFiles.removeAll(compileClasspathFiles);
        runtimeClasspathFiles.removeAll(sourceSet.getOutput().getFiles());
        compileClasspathFiles.removeAll(sourceSet.getOutput().getFiles());
        ArrayListMultimap resolvedDependenciesMap = ArrayListMultimap.create();
        resolvedDependenciesMap.putAll((Object)compileScope, resolvedCompileFileDependencies);
        resolvedDependenciesMap.putAll((Object)runtimeScope, resolvedRuntimeFileDependencies);
        Project rootProject = this.myProject.getRootProject();
        for (Object dependency : new DependencyTraverser(result)) {
            block46: {
                String string;
                block47: {
                    LinkedHashMap<File, Integer> linkedHashMap;
                    block45: {
                        string = dependency.getScope();
                        order = -1;
                        if (!(dependency instanceof ExternalProjectDependency)) break block45;
                        ExternalProjectDependency externalProjectDependency = (ExternalProjectDependency)dependency;
                        Project project = rootProject.findProject(externalProjectDependency.getProjectPath());
                        if (project == null) break block46;
                        Configuration configuration = (Configuration)project.getConfigurations().findByName(externalProjectDependency.getConfigurationName());
                        if (configuration != null) {
                            for (File file : configuration.getAllArtifacts().getFiles().getFiles()) {
                                Integer fileOrder3;
                                resolvedDependenciesMap.put((Object)string, (Object)file);
                                LinkedHashMap<File, Integer> classpathOrderMap2 = string == compileScope ? compileClasspathOrder : (string == runtimeScope ? runtimeClasspathOrder : null);
                                if (classpathOrderMap2 == null || (fileOrder3 = (Integer)classpathOrderMap2.get(file)) == null || order != -1 && fileOrder3 >= order) continue;
                                order = fileOrder3;
                            }
                        }
                        if (project.hasProperty("sourceSets") && project.property("sourceSets") instanceof SourceSetContainer && ((SourceSetContainer)project.property("sourceSets")).findByName("main") != null) {
                            DependencyResolverImpl.addSourceSetOutputDirsAsSingleEntryLibraries(result, (SourceSet)((SourceSetContainer)project.property("sourceSets")).findByName("main"), runtimeClasspathOrder, string);
                        }
                        break block46;
                    }
                    if (!(dependency instanceof ExternalLibraryDependency)) break block47;
                    File file = ((ExternalLibraryDependency)dependency).getFile();
                    resolvedDependenciesMap.put((Object)string, (Object)file);
                    LinkedHashMap<File, Integer> linkedHashMap2 = string == compileScope ? compileClasspathOrder : (linkedHashMap = string == runtimeScope ? runtimeClasspathOrder : null);
                    if (linkedHashMap == null) break block46;
                    Integer fileOrder2 = (Integer)linkedHashMap.get(file);
                    order = fileOrder2 != null ? fileOrder2 : -1;
                    break block46;
                }
                if (dependency instanceof FileCollectionDependency) {
                    for (File file : ((FileCollectionDependency)dependency).getFiles()) {
                        resolvedDependenciesMap.put((Object)string, (Object)file);
                        LinkedHashMap<File, Integer> classpathOrderMap3 = string == compileScope ? compileClasspathOrder : (string == runtimeScope ? runtimeClasspathOrder : null);
                        if (classpathOrderMap3 == null) continue;
                        Integer fileOrder4 = (Integer)classpathOrderMap3.get(file);
                        if (fileOrder4 != null && (order == -1 || fileOrder4 < order)) {
                            order = fileOrder4;
                        }
                        if (order != 0) continue;
                        break;
                    }
                }
            }
            if (!(dependency instanceof AbstractExternalDependency)) continue;
            ((AbstractExternalDependency)dependency).setClasspathOrder(order);
        }
        compileClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)compileScope));
        compileClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)providedScope));
        runtimeClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)runtimeScope));
        runtimeClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)compileScope));
        runtimeClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)providedScope));
        ArrayList<ExternalDependency> fileDependencies = new ArrayList<ExternalDependency>();
        this.mapFileDependencies(runtimeClasspathFiles, runtimeScope, fileDependencies);
        this.mapFileDependencies(compileClasspathFiles, compileScope, fileDependencies);
        for (ExternalDependency externalDependency : fileDependencies) {
            String string = externalDependency.getScope();
            order = -1;
            if (externalDependency instanceof ExternalLibraryDependency) {
                LinkedHashMap<File, Integer> linkedHashMap;
                LinkedHashMap<File, Integer> linkedHashMap3 = string == compileScope ? compileClasspathOrder : (linkedHashMap = string == runtimeScope ? runtimeClasspathOrder : null);
                if (linkedHashMap != null) {
                    Integer fileOrder = (Integer)linkedHashMap.get(((ExternalLibraryDependency)externalDependency).getFile());
                    int n = order = fileOrder != null ? fileOrder : -1;
                }
            }
            if (!(externalDependency instanceof AbstractExternalDependency)) continue;
            ((AbstractExternalDependency)externalDependency).setClasspathOrder(order);
        }
        result.addAll(fileDependencies);
        if (!compileClasspathFiles.isEmpty()) {
            DefaultFileCollectionDependency compileClasspathFilesDependency = new DefaultFileCollectionDependency(compileClasspathFiles);
            compileClasspathFilesDependency.setScope(compileScope);
            order = -1;
            for (File file : compileClasspathFiles) {
                Integer n = (Integer)compileClasspathOrder.get(file);
                if (n != null && (order == -1 || n < order)) {
                    order = n;
                }
                if (order != 0) continue;
                break;
            }
            if (order != -1) {
                compileClasspathFilesDependency.setClasspathOrder(order);
            }
            result.add(compileClasspathFilesDependency);
            for (File file : compileClasspathFiles) {
                SourceSet sourceSet2 = this.mySourceSetFinder.findByArtifact(file.getPath());
                if (sourceSet2 == null) continue;
                DependencyResolverImpl.addSourceSetOutputDirsAsSingleEntryLibraries(result, sourceSet2, compileClasspathOrder, compileScope);
            }
        }
        if (!runtimeClasspathFiles.isEmpty()) {
            DefaultFileCollectionDependency runtimeClasspathFilesDependency = new DefaultFileCollectionDependency(runtimeClasspathFiles);
            runtimeClasspathFilesDependency.setScope(runtimeScope);
            order = -1;
            for (File file : runtimeClasspathFiles) {
                Integer n = (Integer)runtimeClasspathOrder.get(file);
                if (n != null && (order == -1 || n < order)) {
                    order = n;
                }
                if (order != 0) continue;
                break;
            }
            runtimeClasspathFilesDependency.setClasspathOrder(order);
            result.add(runtimeClasspathFilesDependency);
            for (File file : runtimeClasspathFiles) {
                SourceSet sourceSet3 = this.mySourceSetFinder.findByArtifact(file.getPath());
                if (sourceSet3 == null) continue;
                DependencyResolverImpl.addSourceSetOutputDirsAsSingleEntryLibraries(result, sourceSet3, runtimeClasspathOrder, runtimeScope);
            }
        }
        DependencyResolverImpl.addSourceSetOutputDirsAsSingleEntryLibraries(result, sourceSet, runtimeClasspathOrder, runtimeScope);
        final LinkedHashSet<Object> providedConfigurations = new LinkedHashSet<Object>();
        resolvedMap = ArrayListMultimap.create();
        for (ExternalDependency externalDependency : new DependencyTraverser(result)) {
            resolvedMap.put(DependencyResolverImpl.resolve(externalDependency), (Object)externalDependency);
        }
        if (sourceSet.getName().equals("main") && this.myProject.getPlugins().findPlugin(WarPlugin.class) != null) {
            providedConfigurations.add(this.myProject.getConfigurations().findByName("providedCompile"));
            providedConfigurations.add(this.myProject.getConfigurations().findByName("providedRuntime"));
        }
        if ((ideaPlugin = (IdeaPlugin)this.myProject.getPlugins().findPlugin(IdeaPlugin.class)) != null && (map2 = (Map)(map = ideaPlugin.getModel().getModule().getScopes()).get(providedScope)) != null && map2.get("plus") != null) {
            Iterable ideaPluginProvidedConfigurations = Iterables.filter((Iterable)((Iterable)map2.get("plus")), (Predicate)new Predicate<Configuration>(){

                public boolean apply(Configuration cfg) {
                    return !cfg.getName().equals("compileClasspath") && !providedConfigurations.contains(cfg);
                }
            });
            for (Configuration configuration : ideaPluginProvidedConfigurations) {
                Collection<ExternalDependency> providedDependencies = this.resolveDependencies(configuration, providedScope).getExternalDeps();
                for (ExternalDependency it : new DependencyTraverser(providedDependencies)) {
                    resolvedMap.put(DependencyResolverImpl.resolve(it), (Object)it);
                }
                result.addAll(providedDependencies);
            }
        }
        for (Configuration configuration : providedConfigurations) {
            Collection<ExternalDependency> providedDependencies = this.resolveDependencies(configuration, providedScope).getExternalDeps();
            for (ExternalDependency dep : new DependencyTraverser(providedDependencies)) {
                Collection dependencies = resolvedMap.get(DependencyResolverImpl.resolve(dep));
                if (!dependencies.isEmpty()) {
                    if (dep.getDependencies().isEmpty()) {
                        providedDependencies.remove(dep);
                    }
                    for (ExternalDependency depForScope : dependencies) {
                        ((AbstractExternalDependency)depForScope).setScope(providedScope);
                    }
                    continue;
                }
                resolvedMap.put(DependencyResolverImpl.resolve(dep), (Object)dep);
            }
            result.addAll(providedDependencies);
        }
        return DependencyResolverImpl.removeDuplicates((Multimap<Object, ExternalDependency>)resolvedMap, result);
    }

    private static List<ExternalDependency> removeDuplicates(Multimap<Object, ExternalDependency> resolvedMap, Collection<ExternalDependency> result) {
        for (Collection val : resolvedMap.asMap().values()) {
            ExternalDependency retainedDependency;
            List<Object> toRemove = new ArrayList<ExternalDependency>();
            boolean isCompileScope = false;
            boolean isProvidedScope = false;
            for (ExternalDependency dep : val) {
                if (!dep.getDependencies().isEmpty()) continue;
                toRemove.add(dep);
                if (dep.getScope().equals("COMPILE")) {
                    isCompileScope = true;
                    continue;
                }
                if (!dep.getScope().equals("PROVIDED")) continue;
                isProvidedScope = true;
            }
            if (toRemove.size() != val.size()) {
                result.removeAll(toRemove);
            } else if (toRemove.size() > 1) {
                toRemove = toRemove.subList(1, toRemove.size());
                result.removeAll(toRemove);
            }
            if (toRemove.isEmpty()) continue;
            ArrayList retained = new ArrayList(val);
            retained.removeAll(toRemove);
            if (retained.isEmpty() || !((retainedDependency = (ExternalDependency)retained.iterator().next()) instanceof AbstractExternalDependency) || retainedDependency.getScope().equals("COMPILE")) continue;
            if (isCompileScope) {
                ((AbstractExternalDependency)retainedDependency).setScope("COMPILE");
                continue;
            }
            if (!isProvidedScope) continue;
            ((AbstractExternalDependency)retainedDependency).setScope("PROVIDED");
        }
        return Lists.newArrayList((Iterable)Iterables.filter(result, (Predicate)Predicates.not((Predicate)Predicates.isNull())));
    }

    @NotNull
    static Collection<File> resolve(ExternalDependency dependency) {
        if (dependency instanceof ExternalLibraryDependency) {
            Set<File> set = Collections.singleton(((ExternalLibraryDependency)dependency).getFile());
            if (set == null) {
                DependencyResolverImpl.$$$reportNull$$$0(3);
            }
            return set;
        }
        if (dependency instanceof FileCollectionDependency) {
            Collection collection = ((FileCollectionDependency)dependency).getFiles();
            if (collection == null) {
                DependencyResolverImpl.$$$reportNull$$$0(4);
            }
            return collection;
        }
        if (dependency instanceof ExternalMultiLibraryDependency) {
            Collection collection = ((ExternalMultiLibraryDependency)dependency).getFiles();
            if (collection == null) {
                DependencyResolverImpl.$$$reportNull$$$0(5);
            }
            return collection;
        }
        if (dependency instanceof ExternalProjectDependency) {
            Collection collection = ((ExternalProjectDependency)dependency).getProjectDependencyArtifacts();
            if (collection == null) {
                DependencyResolverImpl.$$$reportNull$$$0(6);
            }
            return collection;
        }
        Set<File> set = Collections.emptySet();
        if (set == null) {
            DependencyResolverImpl.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static void addSourceSetOutputDirsAsSingleEntryLibraries(Collection<ExternalDependency> dependencies, SourceSet sourceSet, Map<File, Integer> classpathOrder, String scope) {
        Set runtimeOutputDirs = sourceSet.getOutput().getDirs().getFiles();
        for (File dir : runtimeOutputDirs) {
            DefaultFileCollectionDependency runtimeOutputDirsDependency = new DefaultFileCollectionDependency(Collections.singleton(dir));
            runtimeOutputDirsDependency.setScope(scope);
            Integer fileOrder = classpathOrder.get(dir);
            runtimeOutputDirsDependency.setClasspathOrder(fileOrder != null ? fileOrder : -1);
            dependencies.add(runtimeOutputDirsDependency);
        }
    }

    @Nullable
    ExternalLibraryDependency resolveLibraryByPath(File file, String scope) {
        File modules2Dir = new File(this.myProject.getGradle().getGradleUserHomeDir(), "caches/modules-2/files-2.1");
        return DependencyResolverImpl.resolveLibraryByPath(file, modules2Dir, scope);
    }

    @Nullable
    static ExternalLibraryDependency resolveLibraryByPath(File file, File modules2Dir, String scope) {
        File sourcesFile = null;
        try {
            String modules2Path = modules2Dir.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            if (filePath.startsWith(modules2Path)) {
                File[] hashDirs;
                ArrayList<File> parents = new ArrayList<File>();
                for (File parent = file.getParentFile(); parent != null && !parent.getName().equals(modules2Dir.getName()); parent = parent.getParentFile()) {
                    parents.add(parent);
                }
                File groupDir = (File)parents.get(parents.size() - 1);
                File artifactDir = (File)parents.get(parents.size() - 2);
                File versionDir = (File)parents.get(parents.size() - 3);
                File parentFile = versionDir;
                if (parentFile != null && (hashDirs = parentFile.listFiles()) != null) {
                    for (File hashDir : hashDirs) {
                        File[] sourcesJars = hashDir.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith("sources.jar");
                            }
                        });
                        if (sourcesJars == null || sourcesJars.length <= 0) continue;
                        sourcesFile = sourcesJars[0];
                        break;
                    }
                    String packaging = DependencyResolverImpl.resolvePackagingType(file);
                    String classifier = DependencyResolverImpl.resolveClassifier(artifactDir.getName(), versionDir.getName(), file);
                    DefaultExternalLibraryDependency defaultDependency = new DefaultExternalLibraryDependency();
                    defaultDependency.setName(artifactDir.getName());
                    defaultDependency.setGroup(groupDir.getName());
                    defaultDependency.setPackaging(packaging);
                    defaultDependency.setClassifier(classifier);
                    defaultDependency.setVersion(versionDir.getName());
                    defaultDependency.setFile(file);
                    defaultDependency.setSource(sourcesFile);
                    defaultDependency.setScope(scope);
                    return defaultDependency;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    void mapFileDependencies(Set<File> fileDependencies, String scope, Collection<ExternalDependency> dependencies) {
        File modules2Dir = new File(this.myProject.getGradle().getGradleUserHomeDir(), "caches/modules-2/files-2.1");
        ArrayList<File> toRemove = new ArrayList<File>();
        for (File file : fileDependencies) {
            ExternalLibraryDependency libraryDependency = DependencyResolverImpl.resolveLibraryByPath(file, modules2Dir, scope);
            if (libraryDependency != null) {
                dependencies.add((ExternalDependency)libraryDependency);
                toRemove.add(file);
                continue;
            }
            String name = DependencyResolverImpl.getNameWithoutExtension(file);
            File sourcesFile = new File(file.getParentFile(), name + "-sources.jar");
            if (!sourcesFile.exists()) continue;
            libraryDependency = new DefaultExternalLibraryDependency();
            DefaultExternalLibraryDependency defLD = (DefaultExternalLibraryDependency)libraryDependency;
            defLD.setFile(file);
            defLD.setSource(sourcesFile);
            defLD.setScope(scope);
            dependencies.add((ExternalDependency)libraryDependency);
            toRemove.add(file);
        }
        fileDependencies.removeAll(toRemove);
    }

    @NotNull
    static String resolvePackagingType(File file) {
        if (file == null) {
            if ("jar" == null) {
                DependencyResolverImpl.$$$reportNull$$$0(8);
            }
            return "jar";
        }
        String path = file.getPath();
        int index = path.lastIndexOf(46);
        if (index < 0) {
            if ("jar" == null) {
                DependencyResolverImpl.$$$reportNull$$$0(9);
            }
            return "jar";
        }
        String string = path.substring(index + 1);
        if (string == null) {
            DependencyResolverImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    static String resolveClassifier(String name, String version, File file) {
        Matcher matcher;
        String libraryFileName = DependencyResolverImpl.getNameWithoutExtension(file);
        String mavenLibraryFileName = name + "-" + version;
        if (!mavenLibraryFileName.equals(libraryFileName) && (matcher = Pattern.compile(name + "-" + version + "-(.*)").matcher(libraryFileName)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    static String getNameWithoutExtension(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public ModuleComponentIdentifier toComponentIdentifier(ModuleVersionIdentifier id) {
        return new ModuleComponentIdentifierImpl(id.getGroup(), id.getName(), id.getVersion());
    }

    public ModuleComponentIdentifier toComponentIdentifier(@NotNull String group, @NotNull String module, @NotNull String version) {
        if (group == null) {
            DependencyResolverImpl.$$$reportNull$$$0(11);
        }
        if (module == null) {
            DependencyResolverImpl.$$$reportNull$$$0(12);
        }
        if (version == null) {
            DependencyResolverImpl.$$$reportNull$$$0(13);
        }
        return new ModuleComponentIdentifierImpl(group, module, version);
    }

    private static Set<ExternalDependency> findAllFileDependencies(Collection<Dependency> dependencies, String scope) {
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        for (Dependency dep : dependencies) {
            try {
                Set files;
                if (!(dep instanceof SelfResolvingDependency) || dep instanceof ProjectDependency || (files = ((SelfResolvingDependency)dep).resolve()) == null || files.isEmpty()) continue;
                DefaultFileCollectionDependency dependency = new DefaultFileCollectionDependency(files);
                dependency.setScope(scope);
                result.add(dependency);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private Set<ExternalDependency> findDependencies(Configuration configuration, Collection<Dependency> dependencies, String scope) {
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        HashSet resolvedArtifacts = this.myIsPreview ? new HashSet() : configuration.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.SATISFIES_ALL);
        ArrayListMultimap artifactMap = ArrayListMultimap.create();
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            artifactMap.put((Object)DependencyResolverImpl.toMyModuleIdentifier(artifact.getModuleVersion().getId()), (Object)artifact);
        }
        for (Dependency it : dependencies) {
            try {
                if (it instanceof ProjectDependency) {
                    Project project = ((ProjectDependency)it).getDependencyProject();
                    Configuration targetConfiguration = DependencyResolverImpl.getTargetConfiguration((ProjectDependency)it);
                    DefaultExternalProjectDependency projectDependency = new DefaultExternalProjectDependency();
                    projectDependency.setName(project.getName());
                    projectDependency.setGroup(project.getGroup().toString());
                    projectDependency.setVersion(project.getVersion().toString());
                    projectDependency.setScope(scope);
                    projectDependency.setProjectPath(project.getPath());
                    projectDependency.setConfigurationName(targetConfiguration.getName());
                    projectDependency.setProjectDependencyArtifacts(targetConfiguration.getAllArtifacts().getFiles().getFiles());
                    result.add(projectDependency);
                    continue;
                }
                if (it == null) continue;
                Collection artifactsResult = artifactMap.get((Object)DependencyResolverImpl.toMyModuleIdentifier(it.getName(), it.getGroup()));
                if (artifactsResult != null && !artifactsResult.isEmpty()) {
                    ResolvedArtifact artifact = (ResolvedArtifact)artifactsResult.iterator().next();
                    String packaging = artifact.getExtension() != null ? artifact.getExtension() : "jar";
                    String classifier = artifact.getClassifier();
                    ExternalLibraryDependency resolvedDep = this.resolveLibraryByPath(artifact.getFile(), scope);
                    File sourcesFile = resolvedDep == null ? null : resolvedDep.getSource();
                    DefaultExternalLibraryDependency libraryDependency = new DefaultExternalLibraryDependency();
                    libraryDependency.setName(it.getName());
                    libraryDependency.setGroup(it.getGroup());
                    libraryDependency.setPackaging(packaging);
                    libraryDependency.setClassifier(classifier);
                    libraryDependency.setVersion(artifact.getModuleVersion().getId().getVersion());
                    libraryDependency.setScope(scope);
                    libraryDependency.setFile(artifact.getFile());
                    libraryDependency.setSource(sourcesFile);
                    result.add(libraryDependency);
                    continue;
                }
                if (it instanceof SelfResolvingDependency || this.myIsPreview) continue;
                DefaultUnresolvedExternalDependency dependency = new DefaultUnresolvedExternalDependency();
                dependency.setName(it.getName());
                dependency.setGroup(it.getGroup());
                dependency.setVersion(it.getVersion());
                dependency.setScope(scope);
                dependency.setFailureMessage("Could not find " + it.getGroup() + ":" + it.getName() + ":" + it.getVersion());
                result.add(dependency);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private static Configuration getTargetConfiguration(ProjectDependency projectDependency) {
        try {
            return !is4OrBetter ? (Configuration)projectDependency.getClass().getMethod("getProjectConfiguration", new Class[0]).invoke((Object)projectDependency, new Object[0]) : projectDependency.getDependencyProject().getConfigurations().getByName(projectDependency.getTargetConfiguration() != null ? projectDependency.getTargetConfiguration() : "default");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static ResolvedArtifactResult findMatchingArtifact(ResolvedArtifact artifact, ComponentArtifactsResult componentArtifacts, Class<? extends Artifact> artifactType) {
        String baseName = Files.getNameWithoutExtension((String)artifact.getFile().getName());
        Set artifactResults = componentArtifacts.getArtifacts(artifactType);
        if (artifactResults.size() == 1) {
            ArtifactResult artifactResult = (ArtifactResult)artifactResults.iterator().next();
            return artifactResult instanceof ResolvedArtifactResult ? (ResolvedArtifactResult)artifactResult : null;
        }
        for (ArtifactResult result : artifactResults) {
            if (!(result instanceof ResolvedArtifactResult) || !((ResolvedArtifactResult)result).getFile().getName().startsWith(baseName)) continue;
            return (ResolvedArtifactResult)result;
        }
        return null;
    }

    private static boolean isProjectDependencyArtifact(ResolvedArtifact artifact) {
        return isDependencySubstitutionsSupported && artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier;
    }

    private static MyModuleIdentifier toMyModuleIdentifier(ModuleVersionIdentifier id) {
        return new MyModuleIdentifier(id.getName(), id.getGroup());
    }

    private static MyModuleIdentifier toMyModuleIdentifier(String name, String group) {
        return new MyModuleIdentifier(name, group);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/util/DependencyResolverImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/util/DependencyResolverImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePackagingType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveDependencies";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toComponentIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyModuleIdentifier {
        String name;
        String group;

        public MyModuleIdentifier(String name, String group) {
            this.name = name;
            this.group = group;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyModuleIdentifier that = (MyModuleIdentifier)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.group != null ? !this.group.equals(that.group) : that.group != null);
        }

        public int hashCode() {
            int result = this.group != null ? this.group.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.group + ":" + this.name;
        }
    }

    class DependencyResultsTransformer {
        Collection<DependencyResult> handledDependencyResults;
        Multimap<ModuleVersionIdentifier, ResolvedArtifact> artifactMap;
        Map<ComponentIdentifier, ComponentArtifactsResult> componentResultsMap;
        Multimap<ModuleComponentIdentifier, ProjectDependency> configurationProjectDependencies;
        String scope;
        Set<File> resolvedDepsFiles = new HashSet<File>();

        DependencyResultsTransformer(Multimap<ModuleVersionIdentifier, ResolvedArtifact> artifactMap, Map<ComponentIdentifier, ComponentArtifactsResult> componentResultsMap, Multimap<ModuleComponentIdentifier, ProjectDependency> configurationProjectDependencies, String scope) {
            this.handledDependencyResults = Lists.newArrayList();
            this.artifactMap = artifactMap;
            this.componentResultsMap = componentResultsMap;
            this.configurationProjectDependencies = configurationProjectDependencies;
            this.scope = scope;
        }

        Set<ExternalDependency> transform(Collection<? extends DependencyResult> dependencyResults) {
            LinkedHashSet<ExternalDependency> dependencies = new LinkedHashSet<ExternalDependency>();
            for (DependencyResult dependencyResult : dependencyResults) {
                ComponentSelector attempted;
                if (this.handledDependencyResults.contains(dependencyResult)) continue;
                this.handledDependencyResults.add(dependencyResult);
                if (dependencyResult instanceof ResolvedDependencyResult) {
                    ResolvedComponentResult componentResult = ((ResolvedDependencyResult)dependencyResult).getSelected();
                    ComponentSelector componentSelector = dependencyResult.getRequested();
                    ModuleComponentIdentifier componentIdentifier = DependencyResolverImpl.this.toComponentIdentifier(componentResult.getModuleVersion());
                    String name = componentResult.getModuleVersion().getName();
                    String group = componentResult.getModuleVersion().getGroup();
                    String version = componentResult.getModuleVersion().getVersion();
                    String selectionReason = componentResult.getSelectionReason().getDescription();
                    boolean resolveFromArtifacts = componentSelector instanceof ModuleComponentSelector;
                    if (componentSelector instanceof ProjectComponentSelector) {
                        Collection<Object> dependencyConfigurations;
                        Collection projectDependencies = this.configurationProjectDependencies.get((Object)componentIdentifier);
                        if (projectDependencies.isEmpty()) {
                            Project dependencyProject = DependencyResolverImpl.this.myProject.findProject(((ProjectComponentSelector)componentSelector).getProjectPath());
                            if (dependencyProject != null) {
                                Configuration dependencyProjectConfiguration = dependencyProject.getConfigurations().getByName("default");
                                dependencyConfigurations = Collections.singleton(dependencyProjectConfiguration);
                            } else {
                                dependencyConfigurations = Collections.emptySet();
                                resolveFromArtifacts = true;
                                selectionReason = "composite build substitution";
                            }
                        } else {
                            dependencyConfigurations = new ArrayList();
                            for (ProjectDependency dependency : projectDependencies) {
                                dependencyConfigurations.add(DependencyResolverImpl.getTargetConfiguration(dependency));
                            }
                        }
                        for (Configuration it : dependencyConfigurations) {
                            PublishArtifact artifact;
                            MetaProperty taskProperty;
                            PublishArtifact publishArtifact;
                            DefaultExternalProjectDependency dependency;
                            if (it.getName().equals("default")) {
                                dependency = new DefaultExternalProjectDependency();
                                dependency.setName(name);
                                dependency.setGroup(group);
                                dependency.setVersion(version);
                                dependency.setScope(this.scope);
                                dependency.setSelectionReason(selectionReason);
                                dependency.setProjectPath(((ProjectComponentSelector)componentSelector).getProjectPath());
                                dependency.setConfigurationName(it.getName());
                                dependency.setProjectDependencyArtifacts(it.getAllArtifacts().getFiles().getFiles());
                                this.resolvedDepsFiles.addAll(dependency.getProjectDependencyArtifacts());
                                if (it.getArtifacts().size() == 1) {
                                    publishArtifact = (PublishArtifact)it.getAllArtifacts().iterator().next();
                                    dependency.setClassifier(publishArtifact.getClassifier());
                                    dependency.setPackaging(publishArtifact.getExtension() != null ? publishArtifact.getExtension() : "jar");
                                }
                                if (!componentResult.equals(dependencyResult.getFrom())) {
                                    dependency.getDependencies().addAll(this.transform(componentResult.getDependencies()));
                                }
                                dependencies.add(dependency);
                                continue;
                            }
                            dependency = new DefaultExternalProjectDependency();
                            dependency.setName(name);
                            dependency.setGroup(group);
                            dependency.setVersion(version);
                            dependency.setScope(this.scope);
                            dependency.setSelectionReason(selectionReason);
                            dependency.setProjectPath(((ProjectComponentSelector)componentSelector).getProjectPath());
                            dependency.setConfigurationName(it.getName());
                            dependency.setProjectDependencyArtifacts(it.getAllArtifacts().getFiles().getFiles());
                            this.resolvedDepsFiles.addAll(dependency.getProjectDependencyArtifacts());
                            if (it.getArtifacts().size() == 1) {
                                publishArtifact = (PublishArtifact)it.getAllArtifacts().iterator().next();
                                dependency.setClassifier(publishArtifact.getClassifier());
                                dependency.setPackaging(publishArtifact.getExtension() != null ? publishArtifact.getExtension() : "jar");
                            }
                            if (!componentResult.equals(dependencyResult.getFrom())) {
                                dependency.getDependencies().addAll(this.transform(componentResult.getDependencies()));
                            }
                            dependencies.add(dependency);
                            ArrayList<File> files = new ArrayList<File>();
                            PublishArtifactSet artifacts = it.getArtifacts();
                            if (artifacts != null && !artifacts.isEmpty() && (taskProperty = DefaultGroovyMethods.hasProperty((Object)(artifact = (PublishArtifact)artifacts.iterator().next()), (String)"archiveTask")) != null && taskProperty.getProperty((Object)artifact) instanceof AbstractArchiveTask) {
                                AbstractArchiveTask archiveTask = (AbstractArchiveTask)taskProperty.getProperty((Object)artifact);
                                this.resolvedDepsFiles.add(new File(archiveTask.getDestinationDir(), archiveTask.getArchiveName()));
                                try {
                                    Set sourcePaths;
                                    Method mainSpecGetter = AbstractCopyTask.class.getDeclaredMethod("getMainSpec", new Class[0]);
                                    mainSpecGetter.setAccessible(true);
                                    Object mainSpec = mainSpecGetter.invoke((Object)archiveTask, new Object[0]);
                                    List sourcePathGetters = DefaultGroovyMethods.respondsTo((Object)mainSpec, (String)"getSourcePaths", (Object[])new Object[0]);
                                    if (!sourcePathGetters.isEmpty() && (sourcePaths = (Set)((MetaMethod)sourcePathGetters.get(0)).doMethodInvoke(mainSpec, new Object[0])) != null) {
                                        for (Object path : sourcePaths) {
                                            if (path instanceof String) {
                                                File file = new File((String)path);
                                                if (!file.isAbsolute()) continue;
                                                files.add(file);
                                                continue;
                                            }
                                            if (!(path instanceof SourceSetOutput)) continue;
                                            files.addAll(((SourceSetOutput)path).getFiles());
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            if (files.isEmpty()) continue;
                            DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(files);
                            fileCollectionDependency.setScope(this.scope);
                            dependencies.add(fileCollectionDependency);
                            this.resolvedDepsFiles.addAll(files);
                        }
                    }
                    if (resolveFromArtifacts) {
                        Collection artifacts = this.artifactMap.get((Object)componentResult.getModuleVersion());
                        if (artifacts != null && artifacts.isEmpty()) {
                            dependencies.addAll(this.transform(componentResult.getDependencies()));
                        }
                        boolean first = true;
                        if (artifacts != null) {
                            for (ResolvedArtifact artifact : artifacts) {
                                AbstractExternalDependency dependency;
                                String packaging = artifact.getExtension() != null ? artifact.getExtension() : "jar";
                                String classifier = artifact.getClassifier();
                                if (DependencyResolverImpl.isProjectDependencyArtifact(artifact)) {
                                    ProjectComponentIdentifier artifactComponentIdentifier = (ProjectComponentIdentifier)artifact.getId().getComponentIdentifier();
                                    dependency = new DefaultExternalProjectDependency();
                                    DefaultExternalProjectDependency dDep = (DefaultExternalProjectDependency)dependency;
                                    dDep.setName(name);
                                    dDep.setGroup(group);
                                    dDep.setVersion(version);
                                    dDep.setScope(this.scope);
                                    dDep.setSelectionReason(selectionReason);
                                    dDep.setProjectPath(artifactComponentIdentifier.getProjectPath());
                                    dDep.setConfigurationName("default");
                                    ArrayList<File> files = new ArrayList<File>();
                                    for (ResolvedArtifact resolvedArtifact : this.artifactMap.get((Object)componentResult.getModuleVersion())) {
                                        files.add(resolvedArtifact.getFile());
                                    }
                                    dDep.setProjectDependencyArtifacts(files);
                                    this.resolvedDepsFiles.addAll(dDep.getProjectDependencyArtifacts());
                                } else {
                                    dependency = new DefaultExternalLibraryDependency();
                                    DefaultExternalLibraryDependency dDep = dependency;
                                    dDep.setName(name);
                                    dDep.setGroup(group);
                                    dDep.setPackaging(packaging);
                                    dDep.setClassifier(classifier);
                                    dDep.setVersion(version);
                                    dDep.setScope(this.scope);
                                    dDep.setSelectionReason(selectionReason);
                                    dDep.setFile(artifact.getFile());
                                    ComponentArtifactsResult artifactsResult = this.componentResultsMap.get(componentIdentifier);
                                    if (artifactsResult != null) {
                                        ResolvedArtifactResult javadocResult;
                                        ResolvedArtifactResult sourcesResult = DependencyResolverImpl.findMatchingArtifact(artifact, artifactsResult, SourcesArtifact.class);
                                        if (sourcesResult != null) {
                                            ((DefaultExternalLibraryDependency)dependency).setSource(sourcesResult.getFile());
                                        }
                                        if ((javadocResult = DependencyResolverImpl.findMatchingArtifact(artifact, artifactsResult, JavadocArtifact.class)) != null) {
                                            ((DefaultExternalLibraryDependency)dependency).setJavadoc(javadocResult.getFile());
                                        }
                                    }
                                }
                                if (first) {
                                    dependency.getDependencies().addAll(this.transform(componentResult.getDependencies()));
                                    first = false;
                                }
                                dependencies.add(dependency);
                                this.resolvedDepsFiles.add(artifact.getFile());
                            }
                        }
                    }
                }
                if (!(dependencyResult instanceof UnresolvedDependencyResult) || !((attempted = ((UnresolvedDependencyResult)dependencyResult).getAttempted()) instanceof ModuleComponentSelector)) continue;
                ModuleComponentSelector attemptedMCSelector = (ModuleComponentSelector)attempted;
                DefaultUnresolvedExternalDependency dependency = new DefaultUnresolvedExternalDependency();
                dependency.setName(attemptedMCSelector.getModule());
                dependency.setGroup(attemptedMCSelector.getGroup());
                dependency.setVersion(attemptedMCSelector.getVersion());
                dependency.setScope(this.scope);
                dependency.setFailureMessage(((UnresolvedDependencyResult)dependencyResult).getFailure().getMessage());
                dependencies.add(dependency);
            }
            return dependencies;
        }
    }

    private static class ExternalDepsResolutionResult {
        public static ExternalDepsResolutionResult EMPTY = new ExternalDepsResolutionResult(Collections.<ExternalDependency>emptySet(), Collections.<File>emptySet());
        private final Collection<ExternalDependency> externalDeps;
        private final Collection<File> resolvedFiles;

        private ExternalDepsResolutionResult(Collection<ExternalDependency> deps, Collection<File> files) {
            this.externalDeps = deps;
            this.resolvedFiles = files;
        }

        public Collection<File> getResolvedFiles() {
            return this.resolvedFiles;
        }

        public Collection<ExternalDependency> getExternalDeps() {
            return this.externalDeps;
        }
    }
}

