/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiType
implements PsiAnnotationOwner,
Cloneable,
JvmType {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType("byte", "java.lang.Byte");
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType("char", "java.lang.Character");
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType("double", "java.lang.Double");
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType("float", "java.lang.Float");
    public static final PsiPrimitiveType INT = new PsiPrimitiveType("int", "java.lang.Integer");
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType("long", "java.lang.Long");
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType("short", "java.lang.Short");
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType("boolean", "java.lang.Boolean");
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType("void", "java.lang.Void");
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType("null", (String)null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    public static final ArrayFactory<PsiType> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiType[count];
    private TypeAnnotationProvider myAnnotationProvider;

    @NotNull
    public static PsiType[] createArray(int count) {
        PsiType[] psiTypeArray = (PsiType[])ARRAY_FACTORY.create(count);
        if (psiTypeArray == null) {
            PsiType.$$$reportNull$$$0(0);
        }
        return psiTypeArray;
    }

    protected PsiType(@NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            PsiType.$$$reportNull$$$0(1);
        }
        this(TypeAnnotationProvider.Static.create(annotations));
    }

    protected PsiType(@NotNull TypeAnnotationProvider annotations) {
        if (annotations == null) {
            PsiType.$$$reportNull$$$0(2);
        }
        this.myAnnotationProvider = annotations;
    }

    @NotNull
    public PsiType annotate(@NotNull TypeAnnotationProvider provider) {
        PsiType psiType;
        if (provider == null) {
            PsiType.$$$reportNull$$$0(3);
        }
        if (provider == this.myAnnotationProvider) {
            PsiType psiType2 = this;
            if (psiType2 == null) {
                PsiType.$$$reportNull$$$0(4);
            }
            return psiType2;
        }
        try {
            PsiType copy = (PsiType)this.clone();
            copy.myAnnotationProvider = provider;
            psiType = copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (psiType == null) {
            PsiType.$$$reportNull$$$0(5);
        }
        return psiType;
    }

    @NotNull
    public PsiArrayType createArrayType() {
        PsiArrayType psiArrayType = new PsiArrayType(this);
        if (psiArrayType == null) {
            PsiType.$$$reportNull$$$0(6);
        }
        return psiArrayType;
    }

    public PsiArrayType createArrayType(PsiAnnotation ... annotations) {
        if (annotations == null) {
            PsiType.$$$reportNull$$$0(7);
        }
        return new PsiArrayType(this, annotations);
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getPresentableText();
        if (string == null) {
            PsiType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public abstract String getPresentableText();

    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getCanonicalText();
        if (string == null) {
            PsiType.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public abstract String getCanonicalText();

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText();
        if (string == null) {
            PsiType.$$$reportNull$$$0(10);
        }
        return string;
    }

    public abstract boolean isValid();

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            PsiType.$$$reportNull$$$0(11);
        }
        return TypeConversionUtil.isAssignable(this, type);
    }

    public boolean isConvertibleFrom(@NotNull PsiType type) {
        if (type == null) {
            PsiType.$$$reportNull$$$0(12);
        }
        return TypeConversionUtil.areTypesConvertible(type, this);
    }

    public abstract boolean equalsToText(@NotNull String var1);

    public static PsiClassType getTypeByName(String qName, Project project, GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(project).getElementFactory();
        return factory.createTypeByFQClassName(qName, resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(13);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(14);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Object", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(15);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangClass(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(16);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(17);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Class", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(18);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangThrowable(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(19);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(20);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Throwable", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(21);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangString(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(22);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(23);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.String", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(24);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangError(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(25);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(26);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Error", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(27);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangRuntimeException(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(28);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(29);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.RuntimeException", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(30);
        }
        return psiClassType;
    }

    public abstract <A> A accept(@NotNull PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type = this;
        int dims = 0;
        while (type instanceof PsiArrayType) {
            ++dims;
            type = ((PsiArrayType)type).getComponentType();
        }
        return dims;
    }

    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type = this;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        PsiType psiType = type;
        if (psiType == null) {
            PsiType.$$$reportNull$$$0(31);
        }
        return psiType;
    }

    @Nullable
    public abstract GlobalSearchScope getResolveScope();

    @NotNull
    public abstract PsiType[] getSuperTypes();

    @NotNull
    public final TypeAnnotationProvider getAnnotationProvider() {
        TypeAnnotationProvider typeAnnotationProvider = this.myAnnotationProvider;
        if (typeAnnotationProvider == null) {
            PsiType.$$$reportNull$$$0(32);
        }
        return typeAnnotationProvider;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.myAnnotationProvider.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiType.$$$reportNull$$$0(33);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiType.$$$reportNull$$$0(34);
        }
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiType.$$$reportNull$$$0(35);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiType.$$$reportNull$$$0(36);
        }
        return psiAnnotationArray;
    }

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiType";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createArray";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangObject";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangClass";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangThrowable";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangString";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangError";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangRuntimeException";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepComponentType";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProvider";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleFrom";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangObject";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangClass";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangThrowable";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangString";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangError";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangRuntimeException";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class Stub
    extends PsiType {
        protected Stub(@NotNull PsiAnnotation[] annotations) {
            if (annotations == null) {
                Stub.$$$reportNull$$$0(0);
            }
            super(annotations);
        }

        protected Stub(@NotNull TypeAnnotationProvider annotations) {
            if (annotations == null) {
                Stub.$$$reportNull$$$0(1);
            }
            super(annotations);
        }

        @Override
        @NotNull
        public final String getPresentableText() {
            String string = this.getPresentableText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getPresentableText(boolean var1);

        @Override
        @NotNull
        public final String getCanonicalText() {
            String string = this.getCanonicalText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotations";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/PsiType$Stub";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/PsiType$Stub";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

