/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.editors;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.module.view.common.attributes.JavaeeTreeTableView;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.model.persistence.FieldMap;
import com.intellij.javaee.weblogic.model.persistence.TableMap;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsBean;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ui.ComboControl;
import com.intellij.util.xml.ui.ComboTableCellEditor;
import com.intellij.util.xml.ui.CommitAdapter;
import com.intellij.util.xml.ui.CommitListener;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CompositeCommittable;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.ErrorableTableCellRenderer;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WLEjbDataSourcePropertiesPanel
extends CompositeCommittable
implements CommittablePanel {
    private JPanel myPanel;
    private JComboBox myDataSource;
    private final WeblogicRdbmsBean myWeblogicBean;
    private final EntityBean myEjb;
    private final Project myProject;
    private JPanel myTablesPanel;
    private JButton myConfigureButton;
    private final JavaeeTreeTableView myMappingsEditor;

    protected WLEjbDataSourcePropertiesPanel(WeblogicRdbmsBean weblogicEjb, EntityBean ejb) {
        this.myWeblogicBean = weblogicEjb;
        this.myEjb = ejb;
        this.$$$setupUI$$$();
        this.myTablesPanel.setLayout(new BorderLayout());
        this.myProject = weblogicEjb.getManager().getProject();
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)this.myProject);
        GenericDomValue stableDataSourceName = (GenericDomValue)weblogicEjb.getManager().createStableValue(() -> weblogicEjb.getRightDataSourceName());
        ComboControl comboControl = (ComboControl)this.addComponent((Committable)new ComboControl(stableDataSourceName, () -> ContainerUtil.map2List((Collection)facade.getDataSources(), s -> Pair.create((Object)s.getName(), (Object)s.getIcon()))));
        comboControl.bind((JComponent)this.myDataSource);
        comboControl.addCommitListener((CommitListener)new CommitAdapter(){

            public void afterCommit(DomUIControl control) {
                WLEjbDataSourcePropertiesPanel.this.resetTableList();
            }
        });
        this.myMappingsEditor = (JavaeeTreeTableView)this.addComponent((Committable)new MyJavaeeTreeTableView());
        facade.addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(DbPsiFacade source) {
                WLEjbDataSourcePropertiesPanel.this.reset();
            }
        }, (Disposable)this);
        this.myConfigureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceManagerDialog.showDialog((Project)WLEjbDataSourcePropertiesPanel.this.myProject, null);
            }
        });
        this.myTablesPanel.add(this.myMappingsEditor.getComponent());
    }

    private void saveCMPMapping(String cmpField, DasColumn fieldData) {
        TableMap tableMap2;
        List<TableMap> list = this.myWeblogicBean.getTableMaps();
        if (!StringUtil.isEmpty((String)cmpField)) {
            for (TableMap tableMap2 : list) {
                for (FieldMap map : tableMap2.getFieldMaps()) {
                    if (!cmpField.equals(map.getCmpField().getStringValue())) continue;
                    map.undefine();
                }
            }
        }
        String tableName = fieldData.getTable().getName();
        tableMap2 = null;
        if (tableName != null) {
            tableMap2 = (TableMap)ContainerUtil.find(list, object -> tableName.equals(object.getTableName().getValue()));
        }
        if (tableMap2 == null) {
            if (cmpField == null) {
                return;
            }
            tableMap2 = this.myWeblogicBean.addTableMap();
            tableMap2.getTableName().setValue((Object)tableName);
        }
        FieldMap fieldMap = (FieldMap)ContainerUtil.find(tableMap2.getFieldMaps(), fieldMap1 -> fieldData.getName().equals(fieldMap1.getDbmsColumn().getValue()));
        if (cmpField != null) {
            if (fieldMap == null) {
                fieldMap = tableMap2.addFieldMap();
                fieldMap.getDbmsColumn().setValue((Object)fieldData.getName());
            }
            fieldMap.getCmpField().setStringValue(cmpField);
        } else if (fieldMap != null) {
            fieldMap.undefine();
        }
    }

    @Nullable
    private String getSelectedDataSourceName() {
        Pair pair = (Pair)this.myDataSource.getSelectedItem();
        return pair == null ? null : (String)pair.first;
    }

    private void resetTableList() {
        this.myMappingsEditor.reset();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(5, 5, 5, 5), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.configure.module.data.source"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDataSource = jComboBox = new JComboBox();
        jComboBox.setEditable(false);
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myTablesPanel = jPanel = new JPanel();
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("border.configure.ejbs.cmp.mappings"), (int)0, (int)0, null, null));
        this.myConfigureButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("button.configure"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyJavaeeTreeTableView
    extends JavaeeTreeTableView {
        public MyJavaeeTreeTableView() {
            super(WLEjbDataSourcePropertiesPanel.this.myProject, new MyNodeDescriptor<Boolean>(null, Boolean.TRUE));
            this.getTreeTableView().setShowVerticalLines(true);
            this.getTreeTableView().setIntercellSpacing(new Dimension(1, 0));
            this.init();
        }

        protected boolean isShowTree() {
            return DbUtil.getDataSources((Project)WLEjbDataSourcePropertiesPanel.this.myProject).filter(DasUtil.byName((String)WLEjbDataSourcePropertiesPanel.this.getSelectedDataSourceName())).isNotEmpty();
        }

        @NotNull
        protected String getEmptyPaneText() {
            String dataSourceName = WLEjbDataSourcePropertiesPanel.this.getSelectedDataSourceName();
            if (dataSourceName == null) {
                String string = WeblogicBundle.message("label.text.no.data.source.selected", new Object[0]);
                if (string == null) {
                    MyJavaeeTreeTableView.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = WeblogicBundle.message("label.text.unknown.data.source", dataSourceName);
            if (string == null) {
                MyJavaeeTreeTableView.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected ColumnInfo[] createColumnInfos() {
            return new ColumnInfo[]{new TreeColumnInfo(WeblogicBundle.message("column.name.configure.ejbs.table.column", new Object[0])), new ColumnInfo<JavaeeNodeDescriptor, String>(WeblogicBundle.message("column.name.configure.ejbs.cmp.field", new Object[0])){

                public void setValue(final JavaeeNodeDescriptor o, final String aValue) {
                    new WriteCommandAction(MyJavaeeTreeTableView.this.getProject(), new PsiFile[0]){

                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            WLEjbDataSourcePropertiesPanel.this.saveCMPMapping(aValue, (DasColumn)o.getElement());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/weblogic/editors/WLEjbDataSourcePropertiesPanel$MyJavaeeTreeTableView$1$1", "run"));
                        }
                    }.execute();
                }

                public boolean isCellEditable(JavaeeNodeDescriptor o) {
                    return o.getElement() instanceof DasColumn;
                }

                public TableCellRenderer getCustomizedRenderer(JavaeeNodeDescriptor o, TableCellRenderer renderer) {
                    DasColumn DatabaseColumnInfo;
                    GenericDomValue<CmpField> reference;
                    Object element = o.getElement();
                    if (element instanceof DasColumn && (reference = this.getCmpFieldReference(DatabaseColumnInfo = (DasColumn)element)) != null) {
                        return new ErrorableTableCellRenderer(reference, super.getCustomizedRenderer((Object)o, renderer), reference.getParent());
                    }
                    return super.getCustomizedRenderer((Object)o, renderer);
                }

                public TableCellEditor getEditor(JavaeeNodeDescriptor item) {
                    return new ComboTableCellEditor(ComboControl.createPresentationFunction(() -> WLEjbDataSourcePropertiesPanel.this.myEjb.getCmpFields()), true);
                }

                @Nullable
                private GenericDomValue<CmpField> getCmpFieldReference(DasColumn fieldData) {
                    FieldMap fieldMap;
                    String fieldName;
                    TableMap tableMap;
                    String tableName = fieldData.getTable().getName();
                    if (tableName != null && (tableMap = (TableMap)ContainerUtil.find(WLEjbDataSourcePropertiesPanel.this.myWeblogicBean.getTableMaps(), object -> tableName.equals(object.getTableName().getValue()))) != null && (fieldName = fieldData.getName()) != null && (fieldMap = (FieldMap)ContainerUtil.find(tableMap.getFieldMaps(), object -> fieldName.equals(object.getDbmsColumn().getValue()))) != null) {
                        return fieldMap.getCmpField();
                    }
                    return null;
                }

                public String valueOf(JavaeeNodeDescriptor object) {
                    GenericDomValue<CmpField> reference;
                    Object element = object.getElement();
                    if (element instanceof DasColumn && (reference = this.getCmpFieldReference((DasColumn)element)) != null) {
                        return reference.getStringValue();
                    }
                    return null;
                }
            }};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/editors/WLEjbDataSourcePropertiesPanel$MyJavaeeTreeTableView", "getEmptyPaneText"));
        }
    }

    private class MyNodeDescriptor<T>
    extends JavaeeNodeDescriptor<T> {
        public MyNodeDescriptor(JavaeeNodeDescriptor parent, T element) {
            super(WLEjbDataSourcePropertiesPanel.this.myProject, (NodeDescriptor)parent, null, element);
        }

        protected String getNewNodeText() {
            return null;
        }

        public JavaeeNodeDescriptor[] getChildren() {
            DbDataSource dataSource = (DbDataSource)DbUtil.getDataSources((Project)this.myProject).filter(DasUtil.byName((String)WLEjbDataSourcePropertiesPanel.this.getSelectedDataSourceName())).first();
            if (dataSource == null) {
                return EMPTY_ARRAY;
            }
            return (JavaeeNodeDescriptor[])ContainerUtil.map2Array((Collection)DasUtil.getTables((DatabaseSystem)dataSource).toList(), JavaeeNodeDescriptor.class, table -> new TableNodeDescriptor(this, (DasTable)table));
        }

        private class TableNodeDescriptor
        extends MyNodeDescriptor<DasTable> {
            public TableNodeDescriptor(MyNodeDescriptor<T> nodeDescriptor, DasTable table) {
                super(nodeDescriptor, table);
                this.setIcon(DatabaseIcons.Table);
            }

            @Override
            protected String getNewNodeText() {
                return ((DasTable)this.getElement()).getName();
            }

            @Override
            public JavaeeNodeDescriptor[] getChildren() {
                List map = ContainerUtil.map((Iterable)DasUtil.getColumns((DasObject)((DasObject)this.getElement())), s -> new MyNodeDescriptor<DasColumn>((JavaeeNodeDescriptor)this, s){
                    {
                        this.setIcon(DatabaseIcons.Table);
                    }

                    @Override
                    protected String getNewNodeText() {
                        return ((DasColumn)this.getElement()).getName();
                    }

                    @Override
                    public JavaeeNodeDescriptor[] getChildren() {
                        return JavaeeNodeDescriptor.EMPTY_ARRAY;
                    }
                });
                return map.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
            }
        }
    }
}

