/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el.scopes.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.webflow.el.scopes.WebflowScope;
import com.intellij.spring.webflow.el.scopes.providers.FakeScopePsiVariable;
import com.intellij.spring.webflow.el.scopes.providers.WebflowScopeProvider;
import com.intellij.spring.webflow.model.xml.Evaluate;
import com.intellij.spring.webflow.model.xml.EvaluatesOwner;
import com.intellij.spring.webflow.model.xml.SetsOwner;
import com.intellij.spring.webflow.model.xml.Transition;
import com.intellij.spring.webflow.model.xml.ViewState;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewScopeProvider
extends WebflowScopeProvider {
    public ViewScopeProvider() {
        super(WebflowScope.VIEW, WebflowBundle.message("view.scope.type.name", new Object[0]));
    }

    @Override
    @NotNull
    public Set<DomElement> getScopes(@Nullable DomElement domElement) {
        if (domElement == null) {
            Set<DomElement> set = Collections.emptySet();
            if (set == null) {
                ViewScopeProvider.$$$reportNull$$$0(0);
            }
            return set;
        }
        ViewState state = (ViewState)domElement.getParentOfType(ViewState.class, false);
        if (state == null) {
            Set<DomElement> set = Collections.emptySet();
            if (set == null) {
                ViewScopeProvider.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<DomElement> set = Collections.singleton(DomUtil.getOriginalElement((DomElement)state));
        if (set == null) {
            ViewScopeProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @Nullable
    public PsiElement getOrCreateScopeVariable(XmlFile psiFile, String varName, PsiElement host) {
        ViewState state = ViewScopeProvider.getViewState(host);
        if (state == null || !state.isValid()) {
            return null;
        }
        XmlTag tag = state.getXmlTag();
        if (tag == null) {
            return null;
        }
        CachedValuesManager.getManager((Project)psiFile.getProject());
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)tag, () -> new CachedValueProvider.Result(this.collectViewScopeVariables(state), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        return (PsiElement)map.get(varName);
    }

    @Nullable
    private static ViewState getViewState(PsiElement host) {
        DomElement domElement = DomUtil.getDomElement((PsiElement)host);
        if (domElement == null) {
            return null;
        }
        return (ViewState)domElement.getParentOfType(ViewState.class, false);
    }

    private Map<String, PsiElement> collectViewScopeVariables(ViewState viewState) {
        String varName;
        HashMap<String, PsiElement> map = new HashMap<String, PsiElement>();
        SmartList evaluates = new SmartList();
        SmartList sets = new SmartList();
        ViewScopeProvider.collectEvaluates(viewState, (List<Evaluate>)evaluates);
        ViewScopeProvider.collectSets(viewState, (List<com.intellij.spring.webflow.model.xml.Set>)sets);
        XmlFile xmlFile = DomUtil.getFile((DomElement)viewState);
        for (Evaluate evaluate : evaluates) {
            if (!viewState.equals(evaluate.getParentOfType(ViewState.class, false)) || StringUtil.isEmptyOrSpaces((String)(varName = this.getVariableName(evaluate.getResult().getStringValue())))) continue;
            map.put(varName, (PsiElement)new FakeScopePsiVariable(xmlFile, (PsiElement)evaluate.getResult().getXmlAttributeValue(), varName, this.getTypeName()));
        }
        for (com.intellij.spring.webflow.model.xml.Set set : sets) {
            if (!viewState.equals(set.getParentOfType(ViewState.class, false)) || StringUtil.isEmptyOrSpaces((String)(varName = this.getVariableName(set.getName().getStringValue())))) continue;
            map.put(varName, (PsiElement)new FakeScopePsiVariable(xmlFile, (PsiElement)set.getName().getXmlAttributeValue(), varName, this.getTypeName()));
        }
        return map;
    }

    private static void collectSets(ViewState viewState, List<com.intellij.spring.webflow.model.xml.Set> sets) {
        ViewScopeProvider.addSets(sets, viewState.getOnEntry());
        ViewScopeProvider.addSets(sets, viewState.getOnRender());
        ViewScopeProvider.addSets(sets, viewState.getOnExit());
    }

    private static void collectEvaluates(ViewState viewState, List<Evaluate> evaluates) {
        ViewScopeProvider.addEvaluates(evaluates, viewState.getOnEntry());
        ViewScopeProvider.addEvaluates(evaluates, viewState.getOnRender());
        ViewScopeProvider.addEvaluates(evaluates, viewState.getOnExit());
        for (Transition transition : viewState.getTransitions()) {
            ViewScopeProvider.addEvaluates(evaluates, transition);
        }
    }

    private static void addEvaluates(List<Evaluate> evaluates, EvaluatesOwner evaluatesOwner) {
        evaluates.addAll(evaluatesOwner.getEvaluates());
    }

    private static void addSets(List<com.intellij.spring.webflow.model.xml.Set> sets, SetsOwner evaluatesOwner) {
        sets.addAll(evaluatesOwner.getSets());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/scopes/providers/ViewScopeProvider", "getScopes"));
    }
}

