/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.inspections;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.webflow.config.model.xml.version1_0.Registry;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowRegistry;
import com.intellij.spring.webflow.model.WebflowVersion;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowConfigUtil;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.spring.webflow.util.WebflowVersionDetector;
import com.intellij.util.Function;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebflowSetupInspection
extends BasicDomElementsInspection<Flow> {
    public WebflowSetupInspection() {
        super(Flow.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Flow> domFileElement, DomElementAnnotationHolder holder) {
        ArrayList<Object> configurationBeans;
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        Flow flow = (Flow)domFileElement.getRootElement();
        XmlFile psiElement = WebflowUtil.resolveFlow(flow);
        if (psiElement != null) {
            return;
        }
        if (WebflowVersionDetector.detect(module).isAtLeast(WebflowVersion.Webflow_2_0)) {
            configurationBeans = new ArrayList<FlowRegistry>(WebflowConfigUtil.getFlowRegistries(module));
            configurationBeans.addAll(ContainerUtil.map(WebflowConfigUtil.getCodeFlowRegistries(module), (Function)SpringBeanPointer.TO_BEAN));
        } else {
            configurationBeans = new ArrayList<Registry>(WebflowConfigUtil.getFlowRegistries10(module));
            List<SpringProperty> additionalConfigProperties = WebflowConfigUtil.getAdditionalConfigProperties(module);
            configurationBeans.addAll(ContainerUtil.map(additionalConfigProperties, SpringElementsHolder::getBean));
        }
        if (configurationBeans.isEmpty()) {
            holder.createProblem(domFileElement, WebflowBundle.message("setup.inspection.no.flow.registry", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        holder.createProblem(domFileElement, WebflowBundle.message("setup.inspection.flow.not.configured", new Object[0]), new LocalQuickFix[]{new OpenFlowRegistryFix(configurationBeans)});
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("WebflowSetupInspection" == null) {
            WebflowSetupInspection.$$$reportNull$$$0(0);
        }
        return "WebflowSetupInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/inspections/WebflowSetupInspection", "getShortName"));
    }

    private static class OpenFlowRegistryFix
    implements LocalQuickFix {
        private final List<CommonSpringBean> myConfigurations;

        private OpenFlowRegistryFix(List<CommonSpringBean> configurationBeans) {
            this.myConfigurations = configurationBeans;
        }

        @NotNull
        public String getFamilyName() {
            String string = WebflowBundle.message("setup.inspection.quickfix.open.flow.registry", new Object[0]);
            if (string == null) {
                OpenFlowRegistryFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                OpenFlowRegistryFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                OpenFlowRegistryFix.$$$reportNull$$$0(2);
            }
            if (this.myConfigurations.size() == 1) {
                PsiNavigateUtil.navigate((PsiElement)this.myConfigurations.get(0).getIdentifyingPsiElement());
                return;
            }
            PsiElement[] beanPsiElements = (PsiElement[])ContainerUtil.map2Array(this.myConfigurations, PsiElement.class, bean -> bean.getIdentifyingPsiElement());
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])beanPsiElements, (PsiElementListCellRenderer)SpringBeansPsiElementCellRenderer.INSTANCE, (String)WebflowBundle.message("setup.inspection.quickfix.open.flow.registry.popup.title", new Object[0]));
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/webflow/inspections/WebflowSetupInspection$OpenFlowRegistryFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/webflow/inspections/WebflowSetupInspection$OpenFlowRegistryFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

