/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrCreateFromUsageBaseFix
extends Intention {
    protected final SmartPsiElementPointer<GrReferenceExpression> myRefExpression;

    public GrCreateFromUsageBaseFix(@NotNull GrReferenceExpression refExpression) {
        if (refExpression == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(0);
        }
        this.myRefExpression = SmartPointerManager.getInstance((Project)refExpression.getProject()).createSmartPsiElementPointer((PsiElement)refExpression);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.from.usage.family.name", new Object[0]);
        if (string == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected GrReferenceExpression getRefExpr() {
        return (GrReferenceExpression)this.myRefExpression.getElement();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        GrReferenceExpression element;
        if (project == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(2);
        }
        if ((element = (GrReferenceExpression)this.myRefExpression.getElement()) == null || !element.isValid()) {
            return false;
        }
        List<PsiClass> targetClasses = this.getTargetClasses();
        return !targetClasses.isEmpty();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        List<PsiClass> classes2;
        if (element == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(4);
        }
        if ((classes2 = this.getTargetClasses()).size() == 1) {
            this.invokeImpl(project, classes2.get(0));
        } else if (!classes2.isEmpty()) {
            this.chooseClass(classes2, editor);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element instanceof GrReferenceExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix$1", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(5);
        }
        return psiElementPredicate;
    }

    private void chooseClass(List<PsiClass> classes2, Editor editor) {
        Project project = classes2.get(0).getProject();
        JBList list = new JBList(classes2);
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        list.setSelectionMode(0);
        list.setCellRenderer(renderer);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        renderer.installSpeedSearch(builder);
        Runnable runnable = () -> this.lambda$chooseClass$2((JList)list, project);
        builder.setTitle(QuickFixBundle.message((String)"target.class.chooser.title", (Object[])new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
    }

    protected abstract void invokeImpl(Project var1, @NotNull PsiClass var2);

    private List<PsiClass> getTargetClasses() {
        GrReferenceExpression ref;
        boolean compileStatic = PsiUtil.isCompileStatic(ref = this.getRefExpr()) || GrStaticChecker.isPropertyAccessInStaticMethod(ref);
        PsiClass targetClass = QuickfixUtil.findTargetClass(ref, compileStatic);
        if (targetClass == null || !this.canBeTargetClass(targetClass)) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>();
        this.collectSupers(targetClass, classes2);
        return classes2;
    }

    private void collectSupers(PsiClass psiClass, ArrayList<PsiClass> classes2) {
        PsiClass[] supers;
        classes2.add(psiClass);
        for (PsiClass aSuper : supers = psiClass.getSupers()) {
            if (classes2.contains(aSuper) || !this.canBeTargetClass(aSuper)) continue;
            this.collectSupers(aSuper, classes2);
        }
    }

    protected boolean canBeTargetClass(PsiClass psiClass) {
        return psiClass.getManager().isInProject((PsiElement)psiClass);
    }

    private /* synthetic */ void lambda$chooseClass$2(JList list, Project project) {
        int index = list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        PsiClass aClass = (PsiClass)list.getSelectedValue();
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> this.invokeImpl(project, aClass)), this.getText(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpression";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

