/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import icons.JetgroovyIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyFacetUtil {
    public static final String PLUGIN_MODULE_ID = "PLUGIN_MODULE";

    public static boolean tryToSetUpGroovyFacetOnTheFly(Module module) {
        Project project = module.getProject();
        GroovyConfigUtils utils = GroovyConfigUtils.getInstance();
        Library[] libraries = utils.getAllSDKLibraries(project);
        if (libraries.length > 0) {
            Library library = libraries[0];
            int result = Messages.showOkCancelDialog((String)GroovyBundle.message("groovy.like.library.found.text", module.getName(), library.getName(), utils.getSDKLibVersion(library)), (String)GroovyBundle.message("groovy.like.library.found", new Object[0]), (Icon)JetgroovyIcons.Groovy.Groovy_32x32);
            if (result == 0) {
                WriteAction.run(() -> {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    LibraryOrderEntry entry = model.addLibraryEntry(libraries[0]);
                    LibrariesUtil.placeEntryToCorrectPlace(model, entry);
                    model.commit();
                });
                return true;
            }
        }
        return false;
    }

    public static boolean isSuitableModule(Module module) {
        if (module == null) {
            return false;
        }
        return GroovyFacetUtil.isAcceptableModuleType(ModuleType.get((Module)module));
    }

    public static boolean isAcceptableModuleType(ModuleType type) {
        return type instanceof JavaModuleType || PLUGIN_MODULE_ID.equals(type.getId()) || "ANDROID_MODULE".equals(type.getId());
    }

    @Deprecated
    @NotNull
    public static File getBundledGroovyJar() {
        File file = BundledGroovy.getBundledGroovyFile();
        if (file == null) {
            GroovyFacetUtil.$$$reportNull$$$0(0);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyFacetUtil", "getBundledGroovyJar"));
    }
}

