/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.GeeseUtil;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.ParameterListBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.SyntheticGroovyBlock;
import org.jetbrains.plugins.groovy.formatter.models.spacing.SpacingTokens;
import org.jetbrains.plugins.groovy.formatter.processors.GroovySpacingProcessorBasic;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocFieldReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParameter;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrArrayTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GroovySpacingProcessor
extends GroovyElementVisitor {
    private PsiElement myParent;
    private final GroovyCodeStyleSettings myGroovySettings;
    private final CommonCodeStyleSettings mySettings;
    private Spacing myResult;
    private ASTNode myChild1;
    private ASTNode myChild2;
    private IElementType myType1;
    private IElementType myType2;

    public GroovySpacingProcessor(GroovyBlock block1, GroovyBlock block2, FormattingContext context) {
        this.mySettings = context.getSettings();
        this.myGroovySettings = context.getGroovySettings();
        ASTNode node = block2.getNode();
        if (this.init(node)) {
            return;
        }
        if (this.manageComments()) {
            return;
        }
        if (this.manageMethodParameterList(block2)) {
            return;
        }
        if (this.myParent instanceof GroovyPsiElement) {
            ((GroovyPsiElement)this.myParent).accept(this);
        }
    }

    private boolean init(ASTNode node) {
        this._init(node);
        if (this.myChild1 == null || this.myChild2 == null) {
            return true;
        }
        PsiElement psi1 = this.myChild1.getPsi();
        PsiElement psi2 = this.myChild2.getPsi();
        if (psi1 == null || psi2 == null) {
            return true;
        }
        return psi1.getLanguage() != GroovyLanguage.INSTANCE || psi2.getLanguage() != GroovyLanguage.INSTANCE;
    }

    private void _init(@Nullable ASTNode child) {
        ASTNode treePrev;
        if (child == null) {
            return;
        }
        for (treePrev = child.getTreePrev(); treePrev != null && GroovySpacingProcessor.isWhiteSpace(treePrev); treePrev = treePrev.getTreePrev()) {
        }
        if (treePrev == null) {
            this._init(child.getTreeParent());
        } else {
            this.myChild2 = child;
            this.myType2 = this.myChild2.getElementType();
            this.myChild1 = treePrev;
            this.myType1 = this.myChild1.getElementType();
            CompositeElement parent = (CompositeElement)treePrev.getTreeParent();
            this.myParent = SourceTreeToPsiMap.treeElementToPsi((ASTNode)parent);
        }
    }

    private boolean manageMethodParameterList(GroovyBlock block2) {
        if (block2 instanceof ParameterListBlock) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
            return true;
        }
        return false;
    }

    private boolean manageComments() {
        if (this.mySettings.KEEP_FIRST_COLUMN_COMMENT && TokenSets.COMMENT_SET.contains(this.myType2)) {
            if (!this.isAfterElementOrSemi((IElementType)GroovyElementTypes.IMPORT_STATEMENT)) {
                this.myResult = Spacing.createKeepingFirstColumnSpacing((int)0, (int)Integer.MAX_VALUE, (boolean)true, (int)1);
                return true;
            }
            return false;
        }
        ASTNode prev = FormatterUtil.getPreviousNonWhitespaceLeaf((ASTNode)this.myChild2);
        if (prev != null && prev.getElementType() == GroovyTokenTypes.mNLS) {
            prev = FormatterUtil.getPreviousNonWhitespaceLeaf((ASTNode)prev);
        }
        if (prev != null && prev.getElementType() == GroovyTokenTypes.mSL_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
            return true;
        }
        return false;
    }

    @Override
    public void visitLiteralExpression(@NotNull GrLiteral literal) {
        if (literal == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(0);
        }
        this.createSpaceInCode(false);
    }

    @Override
    public void visitGStringInjection(@NotNull GrStringInjection injection) {
        if (injection == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(1);
        }
        this.createSpaceInCode(false);
    }

    @Override
    public void visitLabeledStatement(@NotNull GrLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(2);
        }
        if (this.myType1 == GroovyTokenTypes.mCOLON) {
            if (this.myGroovySettings.INDENT_LABEL_BLOCKS && this.myType2 != GroovyElementTypes.LITERAL) {
                this.createLF(true);
            } else {
                this.createSpaceInCode(true);
            }
        }
    }

    @Override
    public void visitAnnotation(@NotNull GrAnnotation annotation) {
        if (annotation == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(3);
        }
        if (this.myType2 == GroovyElementTypes.ANNOTATION_ARGUMENTS) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ANOTATION_PARAMETER_LIST);
        }
    }

    @Override
    public void visitAnnotationArgumentList(@NotNull GrAnnotationArgumentList annotationArgumentList) {
        if (annotationArgumentList == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(4);
        }
        if (this.myType1 == GroovyTokenTypes.mLPAREN || this.myType2 == GroovyTokenTypes.mRPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_ANNOTATION_PARENTHESES);
        }
    }

    @Override
    public void visitArgumentList(@NotNull GrArgumentList list) {
        if (list == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(5);
        }
        if (this.myType1 == GroovyTokenTypes.mLBRACK || this.myType2 == GroovyTokenTypes.mRBRACK) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_BRACKETS);
        } else {
            this.processParentheses(GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mRPAREN, this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, this.mySettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES, this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE);
        }
    }

    private void createDependentLFSpacing(boolean isLineFeed, boolean isSpace, @NotNull TextRange range) {
        if (range == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(6);
        }
        if (isLineFeed) {
            this.myResult = Spacing.createDependentLFSpacing((int)(isSpace ? 1 : 0), (int)(isSpace ? 1 : 0), (TextRange)range, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
        } else {
            this.createSpaceInCode(isSpace);
        }
    }

    @Override
    public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
        if (expression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(7);
        }
        if (this.myType2 == GroovyTokenTypes.mQUESTION) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_QUEST);
        } else if (this.myType1 == GroovyTokenTypes.mQUESTION) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_QUEST);
        } else if (this.myType2 == GroovyTokenTypes.mCOLON) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COLON);
        } else if (this.myType1 == GroovyTokenTypes.mCOLON) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COLON);
        }
    }

    @Override
    public void visitElvisExpression(@NotNull GrElvisExpression expression) {
        if (expression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(8);
        }
        if (this.myType1 == GroovyTokenTypes.mELVIS) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COLON);
        } else if (this.myType2 == GroovyTokenTypes.mELVIS) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_QUEST);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(9);
        }
        if (this.myType2 == GroovyElementTypes.ARGUMENTS) {
            this.manageSpaceBeforeCallLParenth();
        } else if (this.myType2 == GroovyElementTypes.CLOSABLE_BLOCK) {
            this.createSpaceInCode(this.myGroovySettings.SPACE_BEFORE_CLOSURE_LBRACE);
        }
    }

    private void manageSpaceBeforeCallLParenth() {
        this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
    }

    @Override
    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
        if (applicationStatement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(10);
        }
        if (this.myType2 == GroovyElementTypes.ARGUMENTS) {
            this.manageSpaceBeforeCallLParenth();
        }
    }

    @Override
    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        if (expression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(11);
        }
        if (this.myType2 == GroovyElementTypes.ARGUMENTS) {
            this.manageSpaceBeforeCallLParenth();
        }
    }

    @Override
    public void visitConstructorInvocation(@NotNull GrConstructorInvocation invocation) {
        if (invocation == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(12);
        }
        if (this.myType2 == GroovyElementTypes.ARGUMENTS) {
            this.manageSpaceBeforeCallLParenth();
        }
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        if (newExpression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(13);
        }
        if (this.myType1 == GroovyTokenTypes.kNEW) {
            this.createSpaceInCode(true);
        } else if (this.myType2 == GroovyElementTypes.ARGUMENTS) {
            this.manageSpaceBeforeCallLParenth();
        } else if (this.myType2 == GroovyElementTypes.ARRAY_DECLARATOR) {
            this.createSpaceInCode(false);
        }
    }

    @Override
    public void visitArrayDeclaration(@NotNull GrArrayDeclaration arrayDeclaration) {
        if (arrayDeclaration == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(14);
        }
        this.createSpaceInCode(false);
    }

    @Override
    public void visitArrayTypeElement(@NotNull GrArrayTypeElement typeElement) {
        if (typeElement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(15);
        }
        this.createSpaceInCode(false);
    }

    private void manageSpaceInTuple() {
        if (this.myType1 == GroovyTokenTypes.mLPAREN || this.myType2 == GroovyTokenTypes.mRPAREN) {
            this.createSpaceInCode(this.myGroovySettings.SPACE_WITHIN_TUPLE_EXPRESSION);
        }
    }

    @Override
    public void visitEnumConstant(@NotNull GrEnumConstant enumConstant) {
        if (enumConstant == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(16);
        }
        if (this.myType1 == GroovyElementTypes.MODIFIERS) {
            this.createSpaceInCode(true);
        } else {
            this.manageSpaceBeforeCallLParenth();
        }
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        if (variableDeclaration == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(17);
        }
        this.manageSpaceInTuple();
    }

    @Override
    public void visitTuple(@NotNull GrTuple tuple) {
        if (tuple == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(18);
        }
        this.manageSpaceInTuple();
    }

    @Override
    public void visitSpreadArgument(@NotNull GrSpreadArgument spreadArgument) {
        if (spreadArgument == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(19);
        }
        if (this.myType1 == GroovyTokenTypes.mSTAR) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
        }
    }

    @Override
    public void visitFile(@NotNull GroovyFileBase file) {
        if (file == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(20);
        }
        if (this.isAfterElementOrSemi((IElementType)GroovyElementTypes.PACKAGE_DEFINITION)) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_PACKAGE + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
        } else if (this.myType2 == GroovyElementTypes.PACKAGE_DEFINITION) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_BEFORE_PACKAGE + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
        } else if (this.isLeftOrRight(TokenSets.TYPE_DEFINITIONS)) {
            if (this.myType1 == GroovyDocElementTypes.GROOVY_DOC_COMMENT) {
                this.createLF(true);
            } else {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AROUND_CLASS + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
            }
        } else if (this.isAfterElementOrSemi((IElementType)GroovyElementTypes.IMPORT_STATEMENT) && this.myType2 != GroovyElementTypes.IMPORT_STATEMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_IMPORTS + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
        } else if (this.myType1 != GroovyElementTypes.IMPORT_STATEMENT && !this.isSemiAfter((IElementType)GroovyElementTypes.IMPORT_STATEMENT) && this.myType2 == GroovyElementTypes.IMPORT_STATEMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)this.mySettings.BLANK_LINES_BEFORE_IMPORTS, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
        } else if (this.isAfterElementOrSemi((IElementType)GroovyElementTypes.IMPORT_STATEMENT) && this.myType2 == GroovyElementTypes.IMPORT_STATEMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
        } else {
            this.processClassMembers(null);
        }
    }

    private boolean isAfterElementOrSemi(IElementType elementType) {
        return this.myType1 == elementType && this.myType2 != GroovyTokenTypes.mSEMI || this.isSemiAfter(elementType);
    }

    private boolean isSemiAfter(@NotNull IElementType statement) {
        if (statement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(21);
        }
        return this.myType1 == GroovyTokenTypes.mSEMI && GroovySpacingProcessor.getStatementTypeBySemi(this.myChild1) == statement;
    }

    private boolean isSemiAfter(@NotNull TokenSet set) {
        if (set == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(22);
        }
        return this.myType1 == GroovyTokenTypes.mSEMI && set.contains(GroovySpacingProcessor.getStatementTypeBySemi(this.myChild1));
    }

    @Nullable
    private static IElementType getStatementTypeBySemi(@NotNull ASTNode semi) {
        GrTopStatement statement;
        if (semi == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(23);
        }
        if ((statement = GroovySpacingProcessor.getStatementBySemicolon(semi.getPsi())) == null) {
            return null;
        }
        return statement.getNode().getElementType();
    }

    @Nullable
    private static GrTopStatement getStatementBySemicolon(@NotNull PsiElement semi) {
        PsiElement prev;
        if (semi == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(24);
        }
        for (prev = semi.getPrevSibling(); prev != null && TokenSets.WHITE_SPACES_OR_COMMENTS.contains(prev.getNode().getElementType()) && prev.getText().indexOf(10) < 0; prev = prev.getPrevSibling()) {
        }
        if (prev instanceof GrTopStatement) {
            return (GrTopStatement)prev;
        }
        return null;
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(25);
        }
        ASTNode rBraceAtTheEnd = GeeseUtil.getClosureRBraceAtTheEnd(this.myChild1);
        if (this.myGroovySettings.USE_FLYING_GEESE_BRACES && this.myType2 == GroovyTokenTypes.mRCURLY && rBraceAtTheEnd != null) {
            String text = rBraceAtTheEnd.getTreeParent().getText();
            this.myResult = text.indexOf(10) < 0 ? Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)false, (int)1) : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)100, (int)0);
        } else if (this.myType1 == GroovyTokenTypes.mLCURLY && this.myType2 == GroovyTokenTypes.mRCURLY) {
            this.createSpaceInCode(false);
        } else if (this.myType1 == GroovyTokenTypes.mLCURLY && this.myType2 != GroovyElementTypes.PARAMETERS_LIST && this.myType2 != GroovyTokenTypes.mCLOSABLE_BLOCK_OP || this.myType2 == GroovyTokenTypes.mRCURLY) {
            boolean spacesWithinBraces = closure.getParent() instanceof GrStringInjection ? this.myGroovySettings.SPACE_WITHIN_GSTRING_INJECTION_BRACES : this.mySettings.SPACE_WITHIN_BRACES;
            this.createDependentLFSpacing(true, spacesWithinBraces, closure.getTextRange());
        } else if (this.myType1 == GroovyTokenTypes.mCLOSABLE_BLOCK_OP) {
            this.myResult = GroovySpacingProcessorBasic.createDependentSpacingForClosure(this.mySettings, this.myGroovySettings, closure, true);
        } else if (this.myType1 == GroovyTokenTypes.mLCURLY && (this.myType2 == GroovyElementTypes.PARAMETERS_LIST || this.myType2 == GroovyTokenTypes.mCLOSABLE_BLOCK_OP)) {
            boolean spacesWithinBraces = closure.getParent() instanceof GrStringInjection ? this.myGroovySettings.SPACE_WITHIN_GSTRING_INJECTION_BRACES : this.mySettings.SPACE_WITHIN_BRACES;
            this.createSpaceInCode(spacesWithinBraces);
        }
    }

    @Override
    public void visitOpenBlock(@NotNull GrOpenBlock block) {
        boolean isMethod;
        boolean keepInOneLine;
        if (block == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(26);
        }
        boolean bl = keepInOneLine = (isMethod = block.getParent() instanceof GrMethod) ? this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE : this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
        if (this.myType1 == GroovyTokenTypes.mLCURLY && this.myType2 == GroovyTokenTypes.mRCURLY) {
            this.createLF(!keepInOneLine);
        } else if (this.myType1 == GroovyTokenTypes.mLCURLY) {
            if (keepInOneLine) {
                this.createDependentLFSpacing(true, this.mySettings.SPACE_WITHIN_BRACES, block.getTextRange());
            } else {
                int lineFeedsCount = isMethod ? this.mySettings.BLANK_LINES_BEFORE_METHOD_BODY + 1 : 1;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lineFeedsCount, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
            }
        } else if (this.myType2 == GroovyTokenTypes.mRCURLY) {
            if (keepInOneLine) {
                this.createDependentLFSpacing(true, this.mySettings.SPACE_WITHIN_BRACES, block.getTextRange());
            } else {
                this.createLF(true);
            }
        }
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(27);
        }
        if (this.myType2 == GroovyElementTypes.CLASS_BODY) {
            if (typeDefinition instanceof GrAnonymousClassDefinition) {
                this.createSpaceProperty(this.mySettings.SPACE_BEFORE_CLASS_LBRACE, true, 100);
            } else {
                PsiElement nameIdentifier = typeDefinition.getNameIdentifierGroovy();
                int dependenceStart = nameIdentifier.getTextRange().getStartOffset();
                TextRange range = new TextRange(dependenceStart, this.myChild1.getTextRange().getEndOffset());
                this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.CLASS_BRACE_STYLE, range, false);
            }
        } else if (this.myType2 == GroovyElementTypes.TYPE_PARAMETER_LIST) {
            this.createSpaceInCode(false);
        } else if (this.myType2 == GroovyElementTypes.ARGUMENTS) {
            this.manageSpaceBeforeCallLParenth();
        }
    }

    @Override
    public void visitTypeDefinitionBody(@NotNull GrTypeDefinitionBody typeDefinitionBody) {
        if (typeDefinitionBody == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(28);
        }
        if (this.myType1 == GroovyTokenTypes.mLCURLY && this.myType2 == GroovyTokenTypes.mRCURLY) {
            if (this.mySettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE) {
                this.createSpaceInCode(false);
            } else {
                this.createLF(true);
            }
        } else if (this.myType1 == GroovyTokenTypes.mLCURLY) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_CLASS_HEADER + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
        } else if (this.myType2 == GroovyTokenTypes.mRCURLY) {
            this.createLF(true);
        } else {
            this.processClassMembers(typeDefinitionBody);
        }
    }

    private void processClassMembers(@Nullable GrTypeDefinitionBody typeDefinitionBody) {
        boolean isInterface;
        boolean bl = isInterface = typeDefinitionBody != null && ((GrTypeDefinition)typeDefinitionBody.getParent()).isInterface();
        if (this.myType2 == GroovyTokenTypes.mSEMI) {
            return;
        }
        if (typeDefinitionBody != null) {
            if ((this.myType1 == GroovyElementTypes.VARIABLE_DEFINITION || this.isSemiAfter((IElementType)GroovyElementTypes.VARIABLE_DEFINITION)) && TokenSets.METHOD_DEFS.contains(this.myType2)) {
                int minBlankLines = Math.max(isInterface ? this.mySettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE : this.mySettings.BLANK_LINES_AROUND_METHOD, isInterface ? this.mySettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE : this.mySettings.BLANK_LINES_AROUND_FIELD);
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(minBlankLines + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
                return;
            }
            if (this.myType1 == GroovyElementTypes.VARIABLE_DEFINITION || this.isSemiAfter((IElementType)GroovyElementTypes.VARIABLE_DEFINITION) || this.myType2 == GroovyElementTypes.VARIABLE_DEFINITION) {
                int minBlankLines = isInterface ? this.mySettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE : this.mySettings.BLANK_LINES_AROUND_FIELD;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(minBlankLines + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
                return;
            }
        }
        if (TokenSets.METHOD_DEFS.contains(this.myType1) || this.isSemiAfter(TokenSets.METHOD_DEFS) || TokenSets.METHOD_DEFS.contains(this.myType2)) {
            if (this.myType1 == GroovyDocElementTypes.GROOVY_DOC_COMMENT) {
                this.createLF(true);
                return;
            }
            int minBlankLines = isInterface ? this.mySettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE : this.mySettings.BLANK_LINES_AROUND_METHOD;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(minBlankLines + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
            return;
        }
        if (TokenSets.TYPE_DEFINITIONS.contains(this.myType1) || this.isSemiAfter(TokenSets.TYPE_DEFINITIONS) || TokenSets.TYPE_DEFINITIONS.contains(this.myType2)) {
            if (this.myType1 == GroovyDocElementTypes.GROOVY_DOC_COMMENT) {
                this.createLF(true);
            } else {
                int minBlankLines = this.mySettings.BLANK_LINES_AROUND_CLASS;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(minBlankLines + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
            }
        }
    }

    @Override
    public void visitTypeArgumentList(@NotNull GrTypeArgumentList typeArgumentList) {
        if (typeArgumentList == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(29);
        }
        if (this.myType1 == GroovyTokenTypes.mLT || this.myType2 == GroovyTokenTypes.mGT) {
            this.createSpaceInCode(false);
        }
    }

    @Override
    public void visitTypeParameterList(@NotNull GrTypeParameterList list) {
        if (list == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(30);
        }
        if (this.myType1 == GroovyTokenTypes.mCOMMA) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS);
        } else if (this.myType1 == GroovyTokenTypes.mLT && this.myType2 == GroovyElementTypes.TYPE_PARAMETER || this.myType1 == GroovyElementTypes.TYPE_PARAMETER && this.myType2 == GroovyTokenTypes.mGT) {
            this.createSpaceInCode(false);
        }
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        if (forInClause == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(31);
        }
        if (this.myType1 == GroovyElementTypes.PARAMETER && this.myType2 == GroovyTokenTypes.mCOLON) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitCastExpression(@NotNull GrTypeCastExpression typeCastExpression) {
        if (typeCastExpression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(32);
        }
        if (SpacingTokens.LEFT_BRACES.contains(this.myType1) || SpacingTokens.RIGHT_BRACES.contains(this.myType2)) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_CAST_PARENTHESES);
        } else if (this.myType1 == GroovyTokenTypes.mRPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_TYPE_CAST);
        }
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (method == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(33);
        }
        if (this.myType1 == GroovyTokenTypes.mRPAREN && this.myType2 == GroovyElementTypes.THROW_CLAUSE) {
            if (this.mySettings.THROWS_KEYWORD_WRAP == 2) {
                this.createLF(true);
            } else {
                this.createSpaceInCode(true);
            }
        } else if (GroovySpacingProcessor.isOpenBlock(this.myType2)) {
            PsiIdentifier methodName = method.getNameIdentifier();
            int dependencyStart = methodName == null ? this.myParent.getTextRange().getStartOffset() : methodName.getTextRange().getStartOffset();
            this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.METHOD_BRACE_STYLE, new TextRange(dependencyStart, this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE);
        } else if (this.myType2 == GroovyElementTypes.TYPE_PARAMETER_LIST) {
            this.createSpaceInCode(true);
        } else {
            this.processParentheses(GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mRPAREN, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, this.mySettings.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES, this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE);
        }
    }

    private boolean processParentheses(@NotNull IElementType left, @NotNull IElementType right, @NotNull Boolean spaceWithin, @Nullable Boolean spaceWithinEmpty, @Nullable Boolean leftLF, @Nullable Boolean rightLF) {
        if (left == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(34);
        }
        if (right == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(35);
        }
        if (spaceWithin == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(36);
        }
        if (this.myType1 == left && this.myType2 == right && spaceWithinEmpty != null) {
            this.createSpaceInCode(spaceWithinEmpty);
            return true;
        }
        if (this.myType1 == left) {
            ASTNode rparenth = GroovySpacingProcessor.findFrom(this.myChild1, right, true);
            if (rparenth == null || leftLF == null) {
                this.createSpaceInCode(spaceWithin);
            } else {
                TextRange range = new TextRange(this.myChild1.getStartOffset(), rparenth.getTextRange().getEndOffset());
                this.createDependentLFSpacing(leftLF, spaceWithin, range);
            }
            return true;
        }
        if (this.myType2 == right) {
            ASTNode lparenth = GroovySpacingProcessor.findFrom(this.myChild1, left, false);
            if (lparenth == null || rightLF == null) {
                this.createSpaceInCode(spaceWithin);
            } else {
                TextRange range = new TextRange(lparenth.getStartOffset(), this.myChild2.getTextRange().getEndOffset());
                this.createDependentLFSpacing(rightLF, spaceWithin, range);
            }
            return true;
        }
        return false;
    }

    @Override
    public void visitAnnotationMethod(@NotNull GrAnnotationMethod annotationMethod) {
        if (annotationMethod == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(37);
        }
        if (this.myType2 == GroovyTokenTypes.kDEFAULT) {
            this.createSpaceInCode(true);
        } else {
            super.visitAnnotationMethod(annotationMethod);
        }
    }

    @Override
    public void visitDocMethodReference(@NotNull GrDocMethodReference reference) {
        if (reference == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(38);
        }
        this.visitDocMember();
    }

    @Override
    public void visitDocFieldReference(@NotNull GrDocFieldReference reference) {
        if (reference == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(39);
        }
        this.visitDocMember();
    }

    private void visitDocMember() {
        this.createSpaceProperty(false, false, 0);
    }

    @Override
    public void visitDocMethodParameterList(@NotNull GrDocMethodParams params) {
        if (params == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(40);
        }
        if (this.myType1 == GroovyDocTokenTypes.mGDOC_TAG_VALUE_LPAREN || this.myType2 == GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN || this.myType2 == GroovyDocTokenTypes.mGDOC_TAG_VALUE_COMMA) {
            this.createSpaceProperty(false, false, 0);
        } else {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitDocMethodParameter(@NotNull GrDocMethodParameter parameter) {
        if (parameter == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(41);
        }
        if (this.myChild1.getTreePrev() == null) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement statement) {
        if (statement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(42);
        }
        if (this.myType2 == GroovyTokenTypes.mLPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.myType1 == GroovyTokenTypes.mLPAREN || this.myType2 == GroovyTokenTypes.mRPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        } else if (this.myChild2.getPsi() instanceof GrBlockStatement) {
            this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_WHILE_LBRACE, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else {
            this.createSpacingBeforeElementInsideControlStatement();
        }
    }

    @Override
    public void visitCatchClause(@NotNull GrCatchClause catchClause) {
        if (catchClause == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(43);
        }
        if (GroovySpacingProcessor.isOpenBlock(this.myType2)) {
            this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_CATCH_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.myType2 == GroovyTokenTypes.mLPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_CATCH_PARENTHESES);
        } else if (this.myType1 == GroovyTokenTypes.mLPAREN || this.myType2 == GroovyTokenTypes.mRPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_CATCH_PARENTHESES);
        }
    }

    @Override
    public void visitFinallyClause(@NotNull GrFinallyClause catchClause) {
        if (catchClause == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(44);
        }
        if (GroovySpacingProcessor.isOpenBlock(this.myType2)) {
            this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_FINALLY_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        }
    }

    @Override
    public void visitTryStatement(@NotNull GrTryCatchStatement tryCatchStatement) {
        if (tryCatchStatement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(45);
        }
        if (this.myType2 == GroovyElementTypes.FINALLY_CLAUSE) {
            this.processTryOnNewLineCondition(this.mySettings.FINALLY_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_FINALLY_KEYWORD);
        } else if (GroovySpacingProcessor.isOpenBlock(this.myType2)) {
            this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_TRY_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.myType2 == GroovyElementTypes.CATCH_CLAUSE) {
            this.processTryOnNewLineCondition(this.mySettings.CATCH_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_CATCH_KEYWORD);
        }
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        if (expression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(46);
        }
        if (TokenSets.ASSIGNMENTS.contains(this.myType1) || TokenSets.ASSIGNMENTS.contains(this.myType2)) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        boolean spaceAround;
        if (expression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(47);
        }
        boolean bl = this.isLeftOrRight(SpacingTokens.LOGICAL_OPERATORS) ? this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS : (this.isLeftOrRight(SpacingTokens.EQUALITY_OPERATORS) ? this.mySettings.SPACE_AROUND_EQUALITY_OPERATORS : (this.isLeftOrRight(SpacingTokens.RELATIONAL_OPERATORS) ? this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS : (this.isLeftOrRight(SpacingTokens.BITWISE_OPERATORS) ? this.mySettings.SPACE_AROUND_BITWISE_OPERATORS : (this.isLeftOrRight(SpacingTokens.ADDITIVE_OPERATORS) ? this.mySettings.SPACE_AROUND_ADDITIVE_OPERATORS : (this.isLeftOrRight(SpacingTokens.MULTIPLICATIVE_OPERATORS) ? this.mySettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS : (this.isLeftOrRight(SpacingTokens.SHIFT_OPERATORS) ? this.mySettings.SPACE_AROUND_SHIFT_OPERATORS : (spaceAround = this.isLeftOrRight(SpacingTokens.REGEX_OPERATORS) ? this.myGroovySettings.SPACE_AROUND_REGEX_OPERATORS : this.isLeftOrRight(GroovyTokenTypes.kIN))))))));
        if (TokenSets.BINARY_OP_SET.contains(this.myType2)) {
            this.createDependentLFSpacing(this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE, spaceAround, expression.getTextRange());
        } else {
            this.createSpaceInCode(spaceAround);
        }
    }

    private boolean isLeftOrRight(TokenSet operators) {
        return operators.contains(this.myType1) || operators.contains(this.myType2);
    }

    private boolean isLeftOrRight(IElementType type) {
        return this.myType1 == type || this.myType2 == type;
    }

    @Override
    public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
        if (expression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(48);
        }
        if (!expression.isPostfix() && expression.getOperationToken() == this.myChild1 || expression.isPostfix() && expression.getOperationToken() == this.myChild2) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
        }
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
        if (switchStatement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(49);
        }
        if (this.myType1 == GroovyTokenTypes.kSWITCH && this.myType2 == GroovyTokenTypes.mLPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES);
        } else if (this.myType1 == GroovyTokenTypes.mLPAREN || this.myType2 == GroovyTokenTypes.mRPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
        } else if (this.myType2 == GroovyTokenTypes.mLCURLY) {
            this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.myType1 == GroovyTokenTypes.mLCURLY || this.myType2 == GroovyTokenTypes.mRCURLY) {
            this.createLF(true);
        }
    }

    @Override
    public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement synchronizedStatement) {
        if (synchronizedStatement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(50);
        }
        if (this.myType1 == GroovyTokenTypes.kSYNCHRONIZED || this.myType2 == GroovyTokenTypes.mLPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES);
        } else if (this.myType1 == GroovyTokenTypes.mLPAREN || this.myType2 == GroovyTokenTypes.mRPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SYNCHRONIZED_PARENTHESES);
        } else if (GroovySpacingProcessor.isOpenBlock(this.myType2)) {
            this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_SYNCHRONIZED_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        }
    }

    @Override
    public void visitDocComment(@NotNull GrDocComment comment) {
        IElementType type;
        if (comment == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(51);
        }
        if (this.myType1 == GroovyDocElementTypes.GDOC_TAG && this.myType2 == GroovyDocElementTypes.GDOC_TAG && this.mySettings.getRootSettings().JD_LEADING_ASTERISKS_ARE_ENABLED && (type = this.myChild1.getLastChildNode().getElementType()) == GroovyDocTokenTypes.mGDOC_ASTERISKS) {
            this.createSpaceInCode(true);
        }
        if (this.myType1 == GroovyDocTokenTypes.mGDOC_COMMENT_START && this.myType2 == GroovyDocTokenTypes.mGDOC_COMMENT_DATA || this.myType1 == GroovyDocTokenTypes.mGDOC_COMMENT_DATA && this.myType2 == GroovyDocTokenTypes.mGDOC_COMMENT_END || this.myType1 == GroovyDocTokenTypes.mGDOC_ASTERISKS && this.myType2 == GroovyDocTokenTypes.mGDOC_COMMENT_END) {
            this.createLazySpace();
        }
    }

    private void createLazySpace() {
        this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
    }

    @Override
    public void visitDocTag(@NotNull GrDocTag docTag) {
        if (docTag == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(52);
        }
        if (this.myType1 == GroovyDocTokenTypes.mGDOC_INLINE_TAG_START || this.myType2 == GroovyDocTokenTypes.mGDOC_INLINE_TAG_END) {
            this.createSpaceInCode(false);
        }
    }

    @Override
    public void visitNamedArgument(@NotNull GrNamedArgument argument) {
        if (argument == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(53);
        }
        if (this.myType1 == GroovyElementTypes.ARGUMENT_LABEL && this.myType2 == GroovyTokenTypes.mCOLON) {
            this.createSpaceInCode(this.myGroovySettings.SPACE_IN_NAMED_ARGUMENT_BEFORE_COLON);
        } else if (this.myType1 == GroovyTokenTypes.mCOLON) {
            this.createSpaceInCode(this.myGroovySettings.SPACE_IN_NAMED_ARGUMENT);
        }
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        if (listOrMap == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(54);
        }
        if (this.myType1 == GroovyTokenTypes.mLBRACK || this.myType2 == GroovyTokenTypes.mRBRACK) {
            this.createSpaceInCode(this.myGroovySettings.SPACE_WITHIN_LIST_OR_MAP);
        }
    }

    @Override
    public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
        if (expression == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(55);
        }
        this.processParentheses(GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mRPAREN, this.mySettings.SPACE_WITHIN_PARENTHESES, null, this.mySettings.PARENTHESES_EXPRESSION_LPAREN_WRAP, this.mySettings.PARENTHESES_EXPRESSION_RPAREN_WRAP);
    }

    @Override
    public void visitAnnotationArrayInitializer(@NotNull GrAnnotationArrayInitializer arrayInitializer) {
        if (arrayInitializer == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(56);
        }
        if (this.myType1 == GroovyTokenTypes.mLBRACK || this.myType2 == GroovyTokenTypes.mRBRACK) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
        if (ifStatement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(57);
        }
        if (this.myType2 == GroovyTokenTypes.kELSE) {
            if (!GroovySpacingProcessor.isOpenBlock(this.myType1) && this.myType1 != GroovyElementTypes.BLOCK_STATEMENT) {
                this.createSpaceInCode(true);
            } else if (this.mySettings.ELSE_ON_NEW_LINE) {
                this.createLF(true);
            } else {
                this.createSpaceProperty(this.mySettings.SPACE_BEFORE_ELSE_KEYWORD, false, 0);
            }
        } else if (this.myType1 == GroovyTokenTypes.kELSE) {
            if (this.myType2 == GroovyElementTypes.IF_STATEMENT) {
                if (this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.createSpaceProperty(true, false, 0);
                } else {
                    this.createLF(true);
                }
            } else if (this.myType2 == GroovyElementTypes.BLOCK_STATEMENT || GroovySpacingProcessor.isOpenBlock(this.myType2)) {
                this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_ELSE_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        } else if (this.myType2 == GroovyElementTypes.BLOCK_STATEMENT || GroovySpacingProcessor.isOpenBlock(this.myType2)) {
            boolean space = this.myChild2.getPsi() == ((GrIfStatement)this.myParent).getElseBranch() ? this.mySettings.SPACE_BEFORE_ELSE_LBRACE : this.mySettings.SPACE_BEFORE_IF_LBRACE;
            this.createSpaceBeforeLBrace(space, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.myType2 == GroovyTokenTypes.mLPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
        } else if (this.myType1 == GroovyTokenTypes.mLPAREN || this.myType2 == GroovyTokenTypes.mRPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
        } else if (((GrIfStatement)this.myParent).getThenBranch() == this.myChild2.getPsi()) {
            this.createSpacingBeforeElementInsideControlStatement();
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement forStatement) {
        if (forStatement == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(58);
        }
        if (this.myType2 == GroovyTokenTypes.mLPAREN) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.myType2 == GroovyElementTypes.BLOCK_STATEMENT || GroovySpacingProcessor.isOpenBlock(this.myType2)) {
            if (this.myType2 == GroovyElementTypes.BLOCK_STATEMENT) {
                this.createSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            } else if (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE) {
                this.createDependentLFSpacing(true, true, this.myParent.getTextRange());
            } else {
                this.createLF(true);
            }
        } else if (this.myType1 == GroovyTokenTypes.mRPAREN) {
            this.createSpacingBeforeElementInsideControlStatement();
        } else {
            this.processParentheses(GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mRPAREN, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, null, this.mySettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE, this.mySettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE);
        }
    }

    private static boolean isOpenBlock(IElementType type) {
        return type == GroovyElementTypes.OPEN_BLOCK || type == GroovyElementTypes.CONSTRUCTOR_BODY;
    }

    @Nullable
    private static ASTNode findFrom(ASTNode current, IElementType expected, boolean forward) {
        while (current != null) {
            if (current.getElementType() == expected) {
                return current;
            }
            current = forward ? current.getTreeNext() : current.getTreePrev();
        }
        return null;
    }

    private void processTryOnNewLineCondition(boolean onNewLine, boolean spaceIfNotNewLine) {
        if (onNewLine) {
            if (this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                this.myResult = Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
            } else {
                this.createLF(true);
            }
        } else {
            this.createSpaceInCode(spaceIfNotNewLine);
        }
    }

    private void createSpacingBeforeElementInsideControlStatement() {
        if (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE && this.myType1 != GroovyTokenTypes.mSL_COMMENT) {
            this.createSpaceInCode(true);
        } else {
            this.createLF(true);
        }
    }

    public Spacing getSpacing() {
        return this.myResult;
    }

    private void createSpaceInCode(boolean space) {
        this.createSpaceProperty(space, this.mySettings.KEEP_LINE_BREAKS, this.keepBlankLines());
    }

    private void createSpaceProperty(boolean space, boolean keepLineBreaks, int keepBlankLines) {
        this.myResult = Spacing.createSpacing((int)(space ? 1 : 0), (int)(space ? 1 : 0), (int)0, (boolean)keepLineBreaks, (int)keepBlankLines);
    }

    private void createSpaceBeforeLBrace(boolean spaceBeforeLbrace, int braceStyle, @Nullable TextRange dependantRange, boolean keepOneLine) {
        if (dependantRange != null && braceStyle == 5) {
            int space = spaceBeforeLbrace ? 1 : 0;
            this.myResult = this.createNonLFSpace(space, dependantRange, false);
        } else if (braceStyle == 1 || braceStyle == 5) {
            int space = spaceBeforeLbrace ? 1 : 0;
            this.myResult = this.createNonLFSpace(space, null, false);
        } else if (keepOneLine) {
            int space = spaceBeforeLbrace ? 1 : 0;
            this.myResult = Spacing.createDependentLFSpacing((int)space, (int)space, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
        } else {
            this.createLF(true);
        }
    }

    private void createLF(boolean lf) {
        this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(lf ? 1 : 0), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.keepBlankLines());
    }

    private Spacing createNonLFSpace(int spaces, @Nullable TextRange dependantRange, boolean keepLineBreaks) {
        ASTNode prev = FormatterUtil.getPreviousNonWhitespaceLeaf((ASTNode)this.myChild2);
        if (prev != null && prev.getElementType() == GroovyTokenTypes.mSL_COMMENT) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)keepLineBreaks, (int)this.keepBlankLines());
        }
        if (dependantRange != null) {
            return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependantRange, (boolean)keepLineBreaks, (int)this.keepBlankLines());
        }
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.keepBlankLines());
    }

    private int keepBlankLines() {
        if (this.myType2 == GroovyTokenTypes.mRCURLY) {
            return this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE;
        }
        if (this.myParent instanceof GrTypeDefinitionBody) {
            return this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS;
        }
        return this.mySettings.KEEP_BLANK_LINES_IN_CODE;
    }

    static boolean isWhiteSpace(ASTNode node) {
        return node != null && (PsiImplUtil.isWhiteSpaceOrNls(node) || node.getTextLength() == 0);
    }

    public static Spacing getSpacing(@Nullable Block child1, @NotNull Block child2, FormattingContext context) {
        if (child2 == null) {
            GroovySpacingProcessor.$$$reportNull$$$0(59);
        }
        if (child1 instanceof SyntheticGroovyBlock) {
            return GroovySpacingProcessor.getSpacing(((SyntheticGroovyBlock)child1).getLastChild(), child2, context);
        }
        if (child2 instanceof SyntheticGroovyBlock) {
            return GroovySpacingProcessor.getSpacing(child1, ((SyntheticGroovyBlock)child2).getFirstChild(), context);
        }
        if (child1 instanceof GroovyBlock && child2 instanceof GroovyBlock) {
            if (((GroovyBlock)child1).getNode() == ((GroovyBlock)child2).getNode()) {
                return Spacing.getReadOnlySpacing();
            }
            Spacing spacing = new GroovySpacingProcessor((GroovyBlock)child1, (GroovyBlock)child2, context).getSpacing();
            if (spacing != null) {
                return spacing;
            }
            return GroovySpacingProcessorBasic.getSpacing((GroovyBlock)child1, (GroovyBlock)child2, context);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationArgumentList";
                break;
            }
            case 5: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 46: 
            case 47: 
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayDeclaration";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDeclaration";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tuple";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spreadArgument";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semi";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinitionBody";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentList";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forInClause";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCastExpression";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spaceWithin";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMethod";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchClause";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryCatchStatement";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "synchronizedStatement";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOrMap";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializer";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/formatter/processors/GroovySpacingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteralExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGStringInjection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLabeledStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnnotationArgumentList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArgumentList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createDependentLFSpacing";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditionalExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElvisExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitApplicationStatement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIndexProperty";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstructorInvocation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayDeclaration";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayTypeElement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEnumConstant";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariableDeclaration";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTuple";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSpreadArgument";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isSemiAfter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatementTypeBySemi";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatementBySemicolon";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClosure";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "visitOpenBlock";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeDefinition";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeDefinitionBody";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeArgumentList";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeParameterList";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForInClause";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCastExpression";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethod";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "processParentheses";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnnotationMethod";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocMethodReference";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocFieldReference";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocMethodParameterList";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocMethodParameter";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhileStatement";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCatchClause";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFinallyClause";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTryStatement";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryExpression";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchStatement";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSynchronizedStatement";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocComment";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocTag";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNamedArgument";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[2] = "visitListOrMap";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParenthesizedExpression";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnnotationArrayInitializer";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIfStatement";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForStatement";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

